/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorResources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class RetrieveFormTest {
    private static final String FORM_PREFIX = "testForm_";
    private static final Locale CANADA_FRENCH_XXX = new Locale("fr", "CA", "XXX");
    private ValidatorResources resources;

    RetrieveFormTest() {
    }

    private void checkForm(Locale locale, String formKey, String expectedVarValue) {
        Form testForm = this.resources.getForm(locale, formKey);
        Assertions.assertNotNull((Object)testForm, (String)("Form '" + formKey + "' null for locale " + locale));
        Field testField = testForm.getField("testProperty");
        Assertions.assertEquals((Object)expectedVarValue, (Object)testField.getVarValue("localeVar"), (String)("Incorrect Form '" + formKey + "' for locale '" + locale + "'"));
    }

    private void checkFormNotFound(Locale locale, String formKey) {
        Form testForm = this.resources.getForm(locale, formKey);
        Assertions.assertNull((Object)testForm, (String)("Form '" + formKey + "' not null for locale " + locale));
    }

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        InputStream[] streams = new InputStream[]{this.getClass().getResourceAsStream("RetrieveFormTest-config.xml")};
        this.resources = new ValidatorResources(streams);
        for (InputStream stream : streams) {
            stream.close();
        }
    }

    @Test
    void testDefaultForm() {
        String formKey = "testForm_default";
        this.checkForm(Locale.US, "testForm_default", "default");
        this.checkForm(Locale.FRENCH, "testForm_default", "default");
        this.checkForm(Locale.FRANCE, "testForm_default", "default");
        this.checkForm(Locale.CANADA, "testForm_default", "default");
        this.checkForm(Locale.CANADA_FRENCH, "testForm_default", "default");
        this.checkForm(CANADA_FRENCH_XXX, "testForm_default", "default");
    }

    @Test
    void testFormNotFound() {
        String formKey = "INVALID_NAME";
        this.checkFormNotFound(Locale.US, "INVALID_NAME");
        this.checkFormNotFound(Locale.FRENCH, "INVALID_NAME");
        this.checkFormNotFound(Locale.FRANCE, "INVALID_NAME");
        this.checkFormNotFound(Locale.CANADA, "INVALID_NAME");
        this.checkFormNotFound(Locale.CANADA_FRENCH, "INVALID_NAME");
        this.checkFormNotFound(CANADA_FRENCH_XXX, "INVALID_NAME");
    }

    @Test
    void testLanguageCountryForm() {
        String formKey = "testForm_language_country";
        this.checkForm(Locale.US, "testForm_language_country", "default");
        this.checkForm(Locale.FRENCH, "testForm_language_country", "fr");
        this.checkForm(Locale.FRANCE, "testForm_language_country", "fr_FR");
        this.checkForm(Locale.CANADA, "testForm_language_country", "default");
        this.checkForm(Locale.CANADA_FRENCH, "testForm_language_country", "fr_CA");
        this.checkForm(CANADA_FRENCH_XXX, "testForm_language_country", "fr_CA");
    }

    @Test
    void testLanguageCountryVariantForm() {
        String formKey = "testForm_language_country_variant";
        this.checkForm(Locale.US, "testForm_language_country_variant", "default");
        this.checkForm(Locale.FRENCH, "testForm_language_country_variant", "fr");
        this.checkForm(Locale.FRANCE, "testForm_language_country_variant", "fr_FR");
        this.checkForm(Locale.CANADA, "testForm_language_country_variant", "default");
        this.checkForm(Locale.CANADA_FRENCH, "testForm_language_country_variant", "fr_CA");
        this.checkForm(CANADA_FRENCH_XXX, "testForm_language_country_variant", "fr_CA_XXX");
    }

    @Test
    void testLanguageForm() {
        String formKey = "testForm_language";
        this.checkForm(Locale.US, "testForm_language", "default");
        this.checkForm(Locale.FRENCH, "testForm_language", "fr");
        this.checkForm(Locale.FRANCE, "testForm_language", "fr");
        this.checkForm(Locale.CANADA, "testForm_language", "default");
        this.checkForm(Locale.CANADA_FRENCH, "testForm_language", "fr");
        this.checkForm(CANADA_FRENCH_XXX, "testForm_language", "fr");
    }
}

