/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimplePointChecker;
import org.apache.commons.math3.optimization.direct.AbstractSimplex;
import org.apache.commons.math3.optimization.direct.MultivariateFunctionPenaltyAdapter;
import org.apache.commons.math3.optimization.direct.NelderMeadSimplex;
import org.apache.commons.math3.optimization.direct.SimplexOptimizer;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class MultivariateFunctionPenaltyAdapterTest {
    @Test
    public void testStartSimplexInsideRange() {
        BiQuadratic biQuadratic = new BiQuadratic(2.0, 2.5, 1.0, 3.0, 2.0, 3.0);
        MultivariateFunctionPenaltyAdapter wrapped = new MultivariateFunctionPenaltyAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper(), 1000.0, new double[]{100.0, 100.0});
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{1.0, 0.5}));
        PointValuePair optimum = optimizer.optimize(300, (MultivariateFunction)wrapped, GoalType.MINIMIZE, new double[]{1.5, 2.25});
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)optimum.getPoint()[1], (double)2.0E-7);
    }

    @Test
    public void testStartSimplexOutsideRange() {
        BiQuadratic biQuadratic = new BiQuadratic(2.0, 2.5, 1.0, 3.0, 2.0, 3.0);
        MultivariateFunctionPenaltyAdapter wrapped = new MultivariateFunctionPenaltyAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper(), 1000.0, new double[]{100.0, 100.0});
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{1.0, 0.5}));
        PointValuePair optimum = optimizer.optimize(300, (MultivariateFunction)wrapped, GoalType.MINIMIZE, new double[]{-1.5, 4.0});
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)optimum.getPoint()[1], (double)2.0E-7);
    }

    @Test
    public void testOptimumOutsideRange() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 0.0, 1.0, 3.0, 2.0, 3.0);
        MultivariateFunctionPenaltyAdapter wrapped = new MultivariateFunctionPenaltyAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper(), 1000.0, new double[]{100.0, 100.0});
        SimplexOptimizer optimizer = new SimplexOptimizer((ConvergenceChecker)new SimplePointChecker(1.0E-11, 1.0E-20));
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{1.0, 0.5}));
        PointValuePair optimum = optimizer.optimize(600, (MultivariateFunction)wrapped, GoalType.MINIMIZE, new double[]{-1.5, 4.0});
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)optimum.getPoint()[1], (double)2.0E-7);
    }

    @Test
    public void testUnbounded() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        MultivariateFunctionPenaltyAdapter wrapped = new MultivariateFunctionPenaltyAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper(), 1000.0, new double[]{100.0, 100.0});
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{1.0, 0.5}));
        PointValuePair optimum = optimizer.optimize(300, (MultivariateFunction)wrapped, GoalType.MINIMIZE, new double[]{-1.5, 4.0});
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)optimum.getPoint()[1], (double)2.0E-7);
    }

    @Test
    public void testHalfBounded() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 4.0, 1.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 3.0);
        MultivariateFunctionPenaltyAdapter wrapped = new MultivariateFunctionPenaltyAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper(), 1000.0, new double[]{100.0, 100.0});
        SimplexOptimizer optimizer = new SimplexOptimizer((ConvergenceChecker)new SimplePointChecker(1.0E-10, 1.0E-20));
        optimizer.setSimplex((AbstractSimplex)new NelderMeadSimplex(new double[]{1.0, 0.5}));
        PointValuePair optimum = optimizer.optimize(400, (MultivariateFunction)wrapped, GoalType.MINIMIZE, new double[]{-1.5, 4.0});
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)optimum.getPoint()[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)optimum.getPoint()[1], (double)2.0E-7);
    }

    private static class BiQuadratic
    implements MultivariateFunction {
        private final double xOptimum;
        private final double yOptimum;
        private final double xMin;
        private final double xMax;
        private final double yMin;
        private final double yMax;

        public BiQuadratic(double xOptimum, double yOptimum, double xMin, double xMax, double yMin, double yMax) {
            this.xOptimum = xOptimum;
            this.yOptimum = yOptimum;
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMin = yMin;
            this.yMax = yMax;
        }

        public double value(double[] point) {
            Assert.assertTrue((point[0] >= this.xMin ? 1 : 0) != 0);
            Assert.assertTrue((point[0] <= this.xMax ? 1 : 0) != 0);
            Assert.assertTrue((point[1] >= this.yMin ? 1 : 0) != 0);
            Assert.assertTrue((point[1] <= this.yMax ? 1 : 0) != 0);
            double dx = point[0] - this.xOptimum;
            double dy = point[1] - this.yOptimum;
            return dx * dx + dy * dy;
        }

        public double[] getLower() {
            return new double[]{this.xMin, this.yMin};
        }

        public double[] getUpper() {
            return new double[]{this.xMax, this.yMax};
        }

        public double getBoundedXOptimum() {
            return this.xOptimum < this.xMin ? this.xMin : (this.xOptimum > this.xMax ? this.xMax : this.xOptimum);
        }

        public double getBoundedYOptimum() {
            return this.yOptimum < this.yMin ? this.yMin : (this.yOptimum > this.yMax ? this.yMax : this.yOptimum);
        }
    }
}

