/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PassTestException;
import org.apache.commons.beanutils.ThrowExceptionConverter;
import org.apache.commons.beanutils.converters.DateConverter;

public class ConvertUtilsTestCase
extends TestCase {
    public static Test suite() {
        return new TestSuite(ConvertUtilsTestCase.class);
    }

    public ConvertUtilsTestCase(String name) {
        super(name);
    }

    private void checkIntegerArray(Object value, int[] intArray) {
        ConvertUtilsTestCase.assertNotNull((String)"Returned value is not null", (Object)value);
        ConvertUtilsTestCase.assertEquals((String)"Returned value is int[]", intArray.getClass(), value.getClass());
        int[] results = (int[])value;
        ConvertUtilsTestCase.assertEquals((String)"Returned array length", (int)intArray.length, (int)results.length);
        for (int i = 0; i < intArray.length; ++i) {
            ConvertUtilsTestCase.assertEquals((String)("Returned array value " + i), (int)intArray[i], (int)results[i]);
        }
    }

    private void checkStringArray(Object value, String[] stringArray) {
        ConvertUtilsTestCase.assertNotNull((String)"Returned value is not null", (Object)value);
        ConvertUtilsTestCase.assertEquals((String)"Returned value is String[]", stringArray.getClass(), value.getClass());
        String[] results = (String[])value;
        ConvertUtilsTestCase.assertEquals((String)"Returned array length", (int)stringArray.length, (int)results.length);
        for (int i = 0; i < stringArray.length; ++i) {
            ConvertUtilsTestCase.assertEquals((String)("Returned array value " + i), (String)stringArray[i], (String)results[i]);
        }
    }

    public void setUp() {
        ConvertUtils.deregister();
    }

    public void tearDown() {
    }

    public void testConvertToString() throws Exception {
        Converter dummyConverter = new Converter(){

            public Object convert(Class type, Object value) {
                return value;
            }
        };
        Converter fooConverter = new Converter(){

            public Object convert(Class type, Object value) {
                return "Foo-Converter";
            }
        };
        DateConverter dateConverter = new DateConverter();
        dateConverter.setLocale(Locale.US);
        ConvertUtilsBean utils = new ConvertUtilsBean();
        utils.register((Converter)dateConverter, java.util.Date.class);
        utils.register(fooConverter, String.class);
        java.util.Date today = new java.util.Date();
        SimpleDateFormat fmt = new SimpleDateFormat("M/d/yy");
        String expected = fmt.format(today);
        ConvertUtilsTestCase.assertEquals((String)"DateConverter M/d/yy", (Object)expected, (Object)utils.convert((Object)today, String.class));
        utils.register(dummyConverter, java.util.Date.class);
        ConvertUtilsTestCase.assertEquals((String)"Date Converter doesn't do String conversion", (Object)"Foo-Converter", (Object)utils.convert((Object)today, String.class));
        utils.deregister(java.util.Date.class);
        ConvertUtilsTestCase.assertEquals((String)"No registered Date converter", (Object)"Foo-Converter", (Object)utils.convert((Object)today, String.class));
        utils.register(dummyConverter, String.class);
        ConvertUtilsTestCase.assertEquals((String)"String Converter doesn't do Strings!!!", (Object)today.toString(), (Object)utils.convert((Object)today, String.class));
        utils.deregister(String.class);
        ConvertUtilsTestCase.assertEquals((String)"Object's toString()", (Object)today.toString(), (Object)utils.convert((Object)today, String.class));
    }

    public void testConvertUnsupportedTargetType() {
        ConvertUtilsBean utils = new ConvertUtilsBean();
        String value = "A test value";
        ConvertUtilsTestCase.assertSame((String)"Got different object", (Object)value, (Object)utils.convert((Object)value, ((Object)((Object)this)).getClass()));
    }

    public void testDeregisteringSingleConverter() throws Exception {
        Object value = ConvertUtils.convert((String)"true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((String)"Standard conversion failed (1)", (boolean)((Boolean)value), (boolean)true);
        ConvertUtils.deregister(Boolean.TYPE);
        ConvertUtilsTestCase.assertNull((String)"Converter should be null", (Object)ConvertUtils.lookup(Boolean.TYPE));
    }

    public void testNegativeIntegerArray() {
        Object value = null;
        int[] intArray = new int[]{};
        value = ConvertUtils.convert((String)null, intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"a", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ a }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"0,1a3", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"{ 0, 1a3 }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
    }

    public void testNegativeScalar() {
        Object value = null;
        value = ConvertUtils.convert((String)"foo", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"foo", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"foo", Byte.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        ConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)0);
        value = ConvertUtils.convert((String)"foo", Byte.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        ConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)0);
        try {
            value = ConvertUtils.convert((String)"org.apache.commons.beanutils.Undefined", Class.class);
            ConvertUtilsTestCase.fail((String)"Should have thrown conversion exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        value = ConvertUtils.convert((String)"foo", Double.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        ConvertUtilsTestCase.assertEquals((double)((Double)value), (double)0.0, (double)0.005);
        value = ConvertUtils.convert((String)"foo", Double.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        ConvertUtilsTestCase.assertEquals((double)((Double)value), (double)0.0, (double)0.005);
        value = ConvertUtils.convert((String)"foo", Float.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        ConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)0.0f, (float)0.005f);
        value = ConvertUtils.convert((String)"foo", Float.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        ConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)0.0f, (float)0.005f);
        value = ConvertUtils.convert((String)"foo", Integer.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        ConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)0);
        value = ConvertUtils.convert((String)"foo", Integer.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        ConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)0);
        value = ConvertUtils.convert((String)"foo", Byte.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        ConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)0);
        value = ConvertUtils.convert((String)"foo", Long.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Long));
        ConvertUtilsTestCase.assertEquals((long)((Long)value), (long)0L);
        value = ConvertUtils.convert((String)"foo", Short.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Short));
        ConvertUtilsTestCase.assertEquals((short)((Short)value), (short)0);
        value = ConvertUtils.convert((String)"foo", Short.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Short));
        ConvertUtilsTestCase.assertEquals((short)((Short)value), (short)0);
    }

    public void testNegativeStringArray() {
        Object value = null;
        String[] stringArray = new String[]{};
        value = ConvertUtils.convert((String)null, stringArray.getClass());
        this.checkStringArray(value, stringArray);
    }

    public void testObjectToStringArray() {
        int[] intArray0 = new int[]{};
        int[] intArray1 = new int[]{123};
        int[] intArray2 = new int[]{123, 456};
        String[] stringArray0 = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "def"};
        ConvertUtilsTestCase.assertEquals((String)"intArray0", null, (String)ConvertUtils.convert((Object)intArray0));
        ConvertUtilsTestCase.assertEquals((String)"intArray1", (String)"123", (String)ConvertUtils.convert((Object)intArray1));
        ConvertUtilsTestCase.assertEquals((String)"intArray2", (String)"123", (String)ConvertUtils.convert((Object)intArray2));
        ConvertUtilsTestCase.assertEquals((String)"stringArray0", null, (String)ConvertUtils.convert((Object)stringArray0));
        ConvertUtilsTestCase.assertEquals((String)"stringArray1", (String)"abc", (String)ConvertUtils.convert((Object)stringArray1));
        ConvertUtilsTestCase.assertEquals((String)"stringArray2", (String)"abc", (String)ConvertUtils.convert((Object)stringArray2));
    }

    public void testObjectToStringScalar() {
        ConvertUtilsTestCase.assertEquals((String)"Boolean->String", (String)"false", (String)ConvertUtils.convert((Object)Boolean.FALSE));
        ConvertUtilsTestCase.assertEquals((String)"Boolean->String", (String)"true", (String)ConvertUtils.convert((Object)Boolean.TRUE));
        ConvertUtilsTestCase.assertEquals((String)"Byte->String", (String)"123", (String)ConvertUtils.convert((Object)123));
        ConvertUtilsTestCase.assertEquals((String)"Character->String", (String)"a", (String)ConvertUtils.convert((Object)Character.valueOf('a')));
        ConvertUtilsTestCase.assertEquals((String)"Double->String", (String)"123.0", (String)ConvertUtils.convert((Object)123.0));
        ConvertUtilsTestCase.assertEquals((String)"Float->String", (String)"123.0", (String)ConvertUtils.convert((Object)Float.valueOf(123.0f)));
        ConvertUtilsTestCase.assertEquals((String)"Integer->String", (String)"123", (String)ConvertUtils.convert((Object)123));
        ConvertUtilsTestCase.assertEquals((String)"Long->String", (String)"123", (String)ConvertUtils.convert((Object)123L));
        ConvertUtilsTestCase.assertEquals((String)"Short->String", (String)"123", (String)ConvertUtils.convert((Object)123));
        ConvertUtilsTestCase.assertEquals((String)"String->String", (String)"abc", (String)ConvertUtils.convert((Object)"abc"));
        ConvertUtilsTestCase.assertEquals((String)"String->String null", null, (String)ConvertUtils.convert(null));
    }

    public void testPositiveArray() {
        String[] values1 = new String[]{"10", "20", "30"};
        Object value = ConvertUtils.convert((String[])values1, Integer.TYPE);
        int[] shape = new int[]{};
        ConvertUtilsTestCase.assertEquals(shape.getClass(), value.getClass());
        int[] results1 = (int[])value;
        ConvertUtilsTestCase.assertEquals((int)results1[0], (int)10);
        ConvertUtilsTestCase.assertEquals((int)results1[1], (int)20);
        ConvertUtilsTestCase.assertEquals((int)results1[2], (int)30);
        String[] values2 = new String[]{"100", "200", "300"};
        value = ConvertUtils.convert((String[])values2, shape.getClass());
        ConvertUtilsTestCase.assertEquals(shape.getClass(), value.getClass());
        int[] results2 = (int[])value;
        ConvertUtilsTestCase.assertEquals((int)results2[0], (int)100);
        ConvertUtilsTestCase.assertEquals((int)results2[1], (int)200);
        ConvertUtilsTestCase.assertEquals((int)results2[2], (int)300);
    }

    public void testPositiveIntegerArray() {
        Object value = null;
        int[] intArray = new int[]{};
        int[] intArray1 = new int[]{0};
        int[] intArray2 = new int[]{0, 10};
        value = ConvertUtils.convert((String)"{  }", intArray.getClass());
        this.checkIntegerArray(value, intArray);
        value = ConvertUtils.convert((String)"0", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)" 0 ", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)"{ 0 }", intArray.getClass());
        this.checkIntegerArray(value, intArray1);
        value = ConvertUtils.convert((String)"0,10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"0 10", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{0,10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{0 10}", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{ 0, 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
        value = ConvertUtils.convert((String)"{ 0 10 }", intArray.getClass());
        this.checkIntegerArray(value, intArray2);
    }

    public void testPositiveScalar() {
        Object value = null;
        value = ConvertUtils.convert((String)"true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"true", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"yes", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"yes", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"y", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"y", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"on", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"on", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)true);
        value = ConvertUtils.convert((String)"false", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"false", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"no", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"no", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"n", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"n", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"off", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"off", Boolean.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((boolean)((Boolean)value), (boolean)false);
        value = ConvertUtils.convert((String)"123", Byte.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        ConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)123);
        value = ConvertUtils.convert((String)"123", Byte.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Byte));
        ConvertUtilsTestCase.assertEquals((byte)((Byte)value), (byte)123);
        value = ConvertUtils.convert((String)"a", Character.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Character));
        ConvertUtilsTestCase.assertEquals((char)((Character)value).charValue(), (char)'a');
        value = ConvertUtils.convert((String)"a", Character.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Character));
        ConvertUtilsTestCase.assertEquals((char)((Character)value).charValue(), (char)'a');
        value = ConvertUtils.convert((String)"java.lang.String", Class.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Class));
        ConvertUtilsTestCase.assertEquals(String.class, (Object)value);
        value = ConvertUtils.convert((String)"123.456", Double.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        ConvertUtilsTestCase.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = ConvertUtils.convert((String)"123.456", Double.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Double));
        ConvertUtilsTestCase.assertEquals((double)((Double)value), (double)123.456, (double)0.005);
        value = ConvertUtils.convert((String)"123.456", Float.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        ConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = ConvertUtils.convert((String)"123.456", Float.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Float));
        ConvertUtilsTestCase.assertEquals((float)((Float)value).floatValue(), (float)123.456f, (float)0.005f);
        value = ConvertUtils.convert((String)"123", Integer.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        ConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)123);
        value = ConvertUtils.convert((String)"123", Integer.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Integer));
        ConvertUtilsTestCase.assertEquals((int)((Integer)value), (int)123);
        value = ConvertUtils.convert((String)"123", Long.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Long));
        ConvertUtilsTestCase.assertEquals((long)((Long)value), (long)123L);
        value = ConvertUtils.convert((String)"123", Long.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Long));
        ConvertUtilsTestCase.assertEquals((long)((Long)value), (long)123L);
        value = ConvertUtils.convert((String)"123", Short.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Short));
        ConvertUtilsTestCase.assertEquals((short)((Short)value), (short)123);
        value = ConvertUtils.convert((String)"123", Short.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Short));
        ConvertUtilsTestCase.assertEquals((short)((Short)value), (short)123);
        String input = null;
        input = "2002-03-17";
        value = ConvertUtils.convert((String)input, Date.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Date));
        ConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
        input = "20:30:40";
        value = ConvertUtils.convert((String)input, Time.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Time));
        ConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
        input = "2002-03-17 20:30:40.0";
        value = ConvertUtils.convert((String)input, Timestamp.class);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Timestamp));
        ConvertUtilsTestCase.assertEquals((String)input, (String)value.toString());
    }

    public void testPositiveStringArray() {
        Object value = null;
        String[] stringArray = new String[]{};
        String[] stringArray1 = new String[]{"abc"};
        String[] stringArray2 = new String[]{"abc", "de,f"};
        value = ConvertUtils.convert((String)"", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)" ", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"{}", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"{  }", stringArray.getClass());
        this.checkStringArray(value, stringArray);
        value = ConvertUtils.convert((String)"abc", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{abc}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"\"abc\"", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{\"abc\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"'abc'", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"{'abc'}", stringArray.getClass());
        this.checkStringArray(value, stringArray1);
        value = ConvertUtils.convert((String)"abc 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{abc, 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"\"abc\",\"de,f\"", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{\"abc\" 'de,f'}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"'abc' 'de,f'", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
        value = ConvertUtils.convert((String)"{'abc', \"de,f\"}", stringArray.getClass());
        this.checkStringArray(value, stringArray2);
    }

    public void testSeparateConvertInstances() throws Exception {
        ConvertUtilsBean utilsOne = new ConvertUtilsBean();
        ConvertUtilsBean utilsTwo = new ConvertUtilsBean();
        Object value = utilsOne.convert("true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((String)"Standard conversion failed (1)", (boolean)((Boolean)value), (boolean)true);
        value = utilsTwo.convert("true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((String)"Standard conversion failed (2)", (boolean)((Boolean)value), (boolean)true);
        utilsOne.register((Converter)new ThrowExceptionConverter(), Boolean.TYPE);
        try {
            utilsOne.convert("true", Boolean.TYPE);
            ConvertUtilsTestCase.fail((String)"Register converter failed.");
        }
        catch (PassTestException passTestException) {
            // empty catch block
        }
        try {
            value = utilsTwo.convert("true", Boolean.TYPE);
            ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
            ConvertUtilsTestCase.assertEquals((String)"Standard conversion failed (3)", (boolean)((Boolean)value), (boolean)true);
        }
        catch (PassTestException e) {
            ConvertUtilsTestCase.fail((String)"Registering a converter for an instance should not effect another instance.");
        }
        utilsOne.deregister();
        value = utilsOne.convert("true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((String)"Instance deregister failed.", (boolean)((Boolean)value), (boolean)true);
        value = utilsTwo.convert("true", Boolean.TYPE);
        ConvertUtilsTestCase.assertTrue((boolean)(value instanceof Boolean));
        ConvertUtilsTestCase.assertEquals((String)"Standard conversion failed (4)", (boolean)((Boolean)value), (boolean)true);
    }
}

