/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.EditorManager;
import org.scopemvc.core.Selector;
import org.scopemvc.core.View;
import org.scopemvc.util.convertor.StringConvertor;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SComboBoxEditor;
import org.scopemvc.view.swing.SComboBoxModel;
import org.scopemvc.view.swing.SListCellRenderer;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.ValidationHelper;

public class SComboBox
extends JComboBox
implements View,
Refreshable {
    public static final String VIEW_TYPE = "scombobox";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SComboBox == null ? (class$org$scopemvc$view$swing$SComboBox = SComboBox.class$("org.scopemvc.view.swing.SComboBox")) : class$org$scopemvc$view$swing$SComboBox);
    private String selectionControlID;
    private ValidationHelper validationHelper = new ValidationHelper(this);
    private boolean readOnly = false;
    private boolean userEnabled = true;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SComboBox;

    public SComboBox() {
        super(new SComboBoxModel(null));
        SComboBoxModel sComboBoxModel = (SComboBoxModel)this.getModel();
        sComboBoxModel.setComboBox(this);
        this.setRenderer((ListCellRenderer)new SListCellRenderer());
        this.setEditor(new SComboBoxEditor());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SComboBox.this.issueChangeSelectionControl();
            }
        });
        this.setReadOnly(!Beans.isDesignTime());
        this.updateUI();
    }

    public final Object getBoundModel() {
        return ((SComboBoxModel)this.getModel()).getBoundModel();
    }

    public final Selector getSelector() {
        return ((SComboBoxModel)this.getModel()).getSelector();
    }

    public final Selector getSelectionSelector() {
        return ((SComboBoxModel)this.getModel()).getSelectionSelector();
    }

    public final Selector getRendererSelector() {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        return sListCellRenderer.getTextSelector();
    }

    public final Selector getRendererIconSelector() {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        return sListCellRenderer.getIconSelector();
    }

    public final Selector getSizeSelector() {
        return ((SComboBoxModel)this.getModel()).getSizeSelector();
    }

    public final String getChangeSelectionControlID() {
        return this.selectionControlID;
    }

    public Controller getController() {
        return null;
    }

    public void issueChangeSelectionControl() {
        if (this.selectionControlID != null) {
            Control control = new Control(this.selectionControlID);
            this.issueControl(control);
        }
    }

    public void issueControl(Control control) {
        SwingUtil.issueControl(this, control);
    }

    public final void setBoundModel(Object object) {
        SComboBoxModel sComboBoxModel = (SComboBoxModel)this.getModel();
        sComboBoxModel.setBoundModel(object);
        if (object != null) {
            EditorManager editorManager = EditorManager.getInstance(object);
            View view = editorManager.getEditor(VIEW_TYPE, sComboBoxModel.getBoundSelectionModel(), sComboBoxModel.getSelectionSelector());
            if (view == null) {
                LOG.warn("Combobox editor not found for property " + Selector.asString(sComboBoxModel.getSelectionSelector()));
            } else if (!(view instanceof ComboBoxEditor)) {
                LOG.warn("Editor of class " + view.getClass() + " doesn't implement ComboBoxEditor");
            } else {
                this.setEditor((ComboBoxEditor)((Object)view));
            }
        } else {
            this.setEditor(null);
        }
    }

    public final void setSelector(Selector selector) {
        ((SComboBoxModel)this.getModel()).setSelector(selector);
    }

    public final void setSelector(String string) {
        ((SComboBoxModel)this.getModel()).setSelector(string);
    }

    public final void setSelectorString(String string) {
        this.setSelector(string);
    }

    public final void setSelectionSelector(Selector selector) {
        ((SComboBoxModel)this.getModel()).setSelectionSelector(selector);
    }

    public final void setSelectionSelector(String string) {
        ((SComboBoxModel)this.getModel()).setSelectionSelectorString(string);
    }

    public final void setSelectionSelectorString(String string) {
        this.setSelectionSelector(string);
    }

    public final void setSizeSelector(Selector selector) {
        ((SComboBoxModel)this.getModel()).setSizeSelector(selector);
    }

    public final void setSizeSelector(String string) {
        ((SComboBoxModel)this.getModel()).setSizeSelector(string);
    }

    public final void setSizeSelectorString(String string) {
        this.setSizeSelector(string);
    }

    public final void setRendererSelector(Selector selector) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        sListCellRenderer.setTextSelector(selector);
    }

    public final void setRendererSelector(String string) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        sListCellRenderer.setTextSelector(string);
    }

    public final void setRendererSelectorString(String string) {
        this.setRendererSelector(string);
    }

    public final void setRendererIconSelector(Selector selector) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        sListCellRenderer.setIconSelector(selector);
    }

    public final void setRendererIconSelector(String string) {
        SListCellRenderer sListCellRenderer = (SListCellRenderer)this.getRenderer();
        sListCellRenderer.setIconSelector(string);
    }

    public final void setRendererIconSelectorString(String string) {
        this.setRendererIconSelector(string);
    }

    public final void setChangeSelectionControlID(String string) {
        this.selectionControlID = string;
    }

    public void setEnabled(boolean bl) {
        this.userEnabled = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        if (this.getRenderer() == null) {
            this.setRenderer((ListCellRenderer)new SListCellRenderer());
        }
        super.setUI(comboBoxUI);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        if (!(listCellRenderer instanceof SListCellRenderer)) {
            throw new IllegalArgumentException("Renderer must be an instance of SListCellRenderer");
        }
        super.setRenderer(listCellRenderer);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        if (!(comboBoxModel instanceof SComboBoxModel)) {
            throw new IllegalArgumentException("Model must be an instance of SComboBoxModel");
        }
        SComboBoxModel sComboBoxModel = (SComboBoxModel)comboBoxModel;
        sComboBoxModel.setJdk13FixIgnoreSetSelectedItem(true);
        super.setModel(sComboBoxModel);
        sComboBoxModel.setJdk13FixIgnoreSetSelectedItem(false);
    }

    public void setStringConvertor(StringConvertor stringConvertor) {
        if (this.getEditor() instanceof SComboBoxEditor) {
            SComboBoxEditor sComboBoxEditor = (SComboBoxEditor)this.getEditor();
            sComboBoxEditor.setStringConvertor(stringConvertor);
        }
    }

    public void setListModel(Object object) {
        ((SComboBoxModel)this.getModel()).setListModel(object);
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void refresh() {
        ((SComboBoxModel)this.getModel()).refresh();
    }

    public void validationFailed(Exception exception) {
        this.validationHelper.validationFailed(exception);
    }

    public void validationSuccess() {
        this.validationHelper.validationSuccess();
    }

    public JToolTip createToolTip() {
        return this.validationHelper.createToolTip(super.createToolTip());
    }

    void setReadOnly(boolean bl) {
        this.readOnly = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

