/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.util.RelationshipFault;

public class PersistentObjectMap
extends RelationshipFault
implements Map,
ValueHolder {
    protected Map objectMap;
    protected Accessor mapKeyAccessor;

    private PersistentObjectMap() {
    }

    public PersistentObjectMap(Persistent relationshipOwner, String relationshipName, Accessor mapKeyAccessor) {
        super(relationshipOwner, relationshipName);
        this.mapKeyAccessor = mapKeyAccessor;
    }

    public Object getValue() throws CayenneRuntimeException {
        return this.resolvedObjectMap();
    }

    public Object getValueDirectly() throws CayenneRuntimeException {
        return this.objectMap;
    }

    public void invalidate() {
        this.setObjectMap(null);
    }

    public boolean isFault() {
        if (this.objectMap != null) {
            return false;
        }
        if (this.isTransientParent()) {
            this.objectMap = new HashMap();
            return false;
        }
        return true;
    }

    public Object setValue(Object value) throws CayenneRuntimeException {
        this.resolvedObjectMap();
        return this.setValueDirectly(this.objectMap);
    }

    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        Map old = this.objectMap;
        if (value == null || value instanceof Map) {
            this.setObjectMap((Map)value);
        } else if (value instanceof Collection) {
            this.setObjectMap(this.indexCollection((Collection)value));
        } else {
            throw new CayenneRuntimeException("Value must be a Map, a Collection or null, got: " + value.getClass().getName());
        }
        return old;
    }

    public void setObjectMap(Map objectMap) {
        this.objectMap = objectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map resolvedObjectMap() {
        if (this.isFault()) {
            PersistentObjectMap persistentObjectMap = this;
            synchronized (persistentObjectMap) {
                if (this.isFault()) {
                    Map localMap;
                    List localList = this.resolveFromDB();
                    this.objectMap = localMap = this.indexCollection(localList);
                }
            }
        }
        return this.objectMap;
    }

    protected Map indexCollection(Collection collection) {
        HashMap map = new HashMap((int)((double)collection.size() * 1.33) + 1);
        if (collection.size() > 0) {
            for (Object next : collection) {
                Object key = this.mapKeyAccessor.getValue(next);
                Object previous = map.put(key, next);
                if (previous == null || previous == next) continue;
                throw new CayenneRuntimeException("Duplicate key '" + key + "' in relationship map. Relationship: " + this.relationshipName + ", source object: " + this.relationshipOwner.getObjectId());
            }
        }
        return map;
    }

    public String toString() {
        return this.objectMap != null ? this.objectMap.toString() : "{<unresolved>}";
    }

    void postprocessAdd(Object addedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, null, addedObject);
        }
    }

    void postprocessAdd(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.postprocessAdd(it.next());
        }
    }

    void postprocessRemove(Object removedObject) {
        if (this.relationshipOwner.getObjectContext() != null) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, removedObject, null);
        }
    }

    void postprocessRemove(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.postprocessRemove(it.next());
        }
    }

    public void clear() {
        Map resolved = this.resolvedObjectMap();
        this.postprocessRemove(resolved.values());
        resolved.clear();
    }

    public boolean containsKey(Object key) {
        return this.resolvedObjectMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.resolvedObjectMap().containsValue(value);
    }

    public Set entrySet() {
        return this.resolvedObjectMap().entrySet();
    }

    public Object get(Object key) {
        return this.resolvedObjectMap().get(key);
    }

    public boolean isEmpty() {
        return this.resolvedObjectMap().isEmpty();
    }

    public Set keySet() {
        return this.resolvedObjectMap().keySet();
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.resolvedObjectMap().put(key, value);
        this.postprocessAdd(value);
        this.postprocessRemove(oldValue);
        return oldValue;
    }

    public void putAll(Map map) {
        this.resolvedObjectMap().putAll(map);
        this.postprocessAdd(map.values());
    }

    public Object remove(Object key) {
        Object removed = this.resolvedObjectMap().remove(key);
        this.postprocessRemove(removed);
        return removed;
    }

    public int size() {
        return this.resolvedObjectMap().size();
    }

    public Collection values() {
        return this.resolvedObjectMap().values();
    }
}

