/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.remote.ClientMessage;

public class SyncMessage
implements ClientMessage {
    protected transient ObjectContext source;
    protected int type;
    protected GraphDiff senderChanges;

    private SyncMessage() {
    }

    public SyncMessage(ObjectContext source, int syncType, GraphDiff senderChanges) {
        if (syncType != 1 && syncType != 2 && syncType != 3) {
            throw new IllegalArgumentException("'type' is invalid: " + syncType);
        }
        this.source = source;
        this.type = syncType;
        this.senderChanges = senderChanges;
    }

    public ObjectContext getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public GraphDiff getSenderChanges() {
        return this.senderChanges;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "flush-sync";
            }
            case 2: {
                return "flush-cascade-sync";
            }
            case 3: {
                return "rollback-cascade-sync";
            }
        }
        return "unknown-sync";
    }
}

