/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.dialog.db.DbLoaderHelper;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.PanelFactory;

public class DbLoaderMergeDialog
extends CayenneDialog {
    protected DbLoaderHelper helper;
    protected JCheckBox rememberSelection;
    protected JLabel message;
    protected JButton overwriteButton;
    protected JButton skipButton;
    protected JButton stopButton;

    public DbLoaderMergeDialog(CayenneModelerFrame owner) {
        super(owner);
        this.init();
        this.initController();
    }

    private void init() {
        this.rememberSelection = new JCheckBox("Remember my decision for other entities.");
        this.rememberSelection.setSelected(true);
        this.overwriteButton = new JButton("Overwrite");
        this.skipButton = new JButton("Skip");
        this.stopButton = new JButton("Stop");
        this.message = new JLabel("DataMap already contains this table. Overwrite?");
        JPanel messagePanel = new JPanel(new FlowLayout(1, 20, 20));
        messagePanel.add(this.message);
        JPanel checkPanel = new JPanel(new FlowLayout(0, 20, 5));
        checkPanel.add(this.rememberSelection);
        JPanel buttons = PanelFactory.createButtonPanel(new JButton[]{this.skipButton, this.overwriteButton, this.stopButton});
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)messagePanel, "North");
        contentPane.add((Component)checkPanel, "Center");
        contentPane.add((Component)buttons, "South");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(250, 150);
        this.setTitle("DbEntity Already Exists");
        this.setDefaultCloseOperation(0);
    }

    private void initController() {
        this.overwriteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbLoaderMergeDialog.this.updateModel(true, false);
            }
        });
        this.skipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbLoaderMergeDialog.this.updateModel(false, false);
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbLoaderMergeDialog.this.updateModel(false, true);
            }
        });
    }

    private void updateModel(boolean overwrite2, boolean stop) {
        if (this.helper != null) {
            this.helper.setOverwritePreferenceSet(this.rememberSelection.isSelected());
            this.helper.setOverwritingEntities(overwrite2);
            this.helper.setStoppingReverseEngineering(stop);
        }
        this.setVisible(false);
    }

    public void initFromModel(DbLoaderHelper helper, String tableName) {
        this.helper = helper;
        this.message.setText("DataMap already contains table '" + tableName + "'. Overwrite?");
        this.validate();
        this.pack();
    }
}

