/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesDialog;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesModel;
import org.apache.cayenne.util.Util;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;

public class PackageUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "cayenne.modeler.datamap.defaultprefs.package.radio";
    public static final String UNINIT_CONTROL = "cayenne.modeler.datamap.defaultprefs.packagenull.radio";
    protected boolean clientUpdate;

    public PackageUpdateController(ProjectController mediator, DataMap dataMap, boolean clientUpdate) {
        super(mediator, dataMap);
        this.clientUpdate = clientUpdate;
    }

    public void startup() {
        DefaultsPreferencesDialog view = new DefaultsPreferencesDialog(ALL_CONTROL, UNINIT_CONTROL);
        view.setTitle("Update ObjEntities and Embeddables Java Package");
        this.setView(view);
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID("cayenne.modeler.datamap.defaultprefs.update.button")) {
            this.updatePackage();
        } else {
            super.doHandleControl(control);
        }
    }

    protected void updatePackage() {
        String oldName;
        boolean doAll = ((DefaultsPreferencesModel)this.getModel()).isAllEntities();
        String defaultPackage = this.getDefaultPackage();
        if (Util.isEmptyString(defaultPackage)) {
            defaultPackage = "";
        } else if (!defaultPackage.endsWith(".")) {
            defaultPackage = defaultPackage + '.';
        }
        HashMap<String, String> oldNameEmbeddableToNewName = new HashMap<String, String>();
        for (Embeddable embeddable : this.dataMap.getEmbeddables()) {
            oldName = embeddable.getClassName();
            Pattern p = Pattern.compile("[.]");
            String[] tokens = p.split(oldName);
            String className = tokens[tokens.length - 1];
            if (!doAll && !Util.isEmptyString(oldName) && oldName.indexOf(46) >= 0) continue;
            EmbeddableEvent e = new EmbeddableEvent((Object)this, embeddable, embeddable.getClassName());
            String newClassName = defaultPackage + className;
            oldNameEmbeddableToNewName.put(oldName, newClassName);
            embeddable.setClassName(newClassName);
            this.mediator.fireEmbeddableEvent(e, this.mediator.getCurrentDataMap());
        }
        for (ObjEntity entity : this.dataMap.getObjEntities()) {
            oldName = this.getClassName(entity);
            if (doAll || Util.isEmptyString(oldName) || oldName.indexOf(46) < 0) {
                String className = this.extractClassName(Util.isEmptyString(oldName) ? entity.getName() : oldName);
                this.setClassName(entity, defaultPackage + className);
            }
            for (ObjAttribute attribute : entity.getAttributes()) {
                if (!(attribute instanceof EmbeddedAttribute) || oldNameEmbeddableToNewName.size() <= 0 || !oldNameEmbeddableToNewName.containsKey(attribute.getType())) continue;
                attribute.setType((String)oldNameEmbeddableToNewName.get(attribute.getType()));
                AttributeEvent ev = new AttributeEvent((Object)this, attribute, entity);
                this.mediator.fireObjAttributeEvent(ev);
            }
        }
        this.shutdown();
    }

    protected String extractClassName(String name) {
        if (name == null) {
            return "";
        }
        int dot = name.lastIndexOf(46);
        return dot < 0 ? name : (dot + 1 < name.length() ? name.substring(dot + 1) : "");
    }

    protected String getDefaultPackage() {
        return this.clientUpdate ? this.dataMap.getDefaultClientPackage() : this.dataMap.getDefaultPackage();
    }

    protected String getClassName(ObjEntity entity) {
        return this.clientUpdate ? entity.getClientClassName() : entity.getClassName();
    }

    protected void setClassName(ObjEntity entity, String newName) {
        if (!Util.nullSafeEquals(newName, this.getClassName(entity))) {
            if (this.clientUpdate) {
                entity.setClientClassName(newName);
            } else {
                entity.setClassName(newName);
            }
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }
}

