/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.autorelationship;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.modeler.dialog.autorelationship.InferRelationships;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferRelationshipsControllerBase
extends CayenneController {
    public static final String SELECTED_PROPERTY = "selected";
    protected DataMap dataMap;
    protected List<InferRelationships> ir;
    protected List<DbEntity> entities;
    protected Set<InferRelationships> selectedEntities;
    protected int index = 0;
    protected NamingStrategy strategy;
    protected transient InferRelationships currentEntity;
    protected transient Integer entityNumber;

    public InferRelationshipsControllerBase(CayenneController parent, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.entities = new ArrayList<DbEntity>(dataMap.getDbEntities());
        this.selectedEntities = new HashSet<InferRelationships>();
    }

    public void setRelationships() {
        this.ir = new ArrayList<InferRelationships>();
        for (DbEntity entity : this.entities) {
            this.createRelationships(entity);
        }
        this.createJoin();
        this.createName();
    }

    public void createRelationships(DbEntity entity) {
        for (DbAttribute attribute : entity.getAttributes()) {
            for (DbEntity targetEntity : this.entities) {
                if (targetEntity == entity || !attribute.getName().equalsIgnoreCase(targetEntity.getName() + "_ID") || attribute.isPrimaryKey() || targetEntity.getAttributes().isEmpty()) continue;
                if (!attribute.isForeignKey()) {
                    InferRelationships myir = new InferRelationships();
                    myir.setSource(entity);
                    myir.setTarget(targetEntity);
                    this.ir.add(myir);
                }
                this.createReversRelationship(targetEntity, entity);
            }
        }
    }

    public void createReversRelationship(DbEntity eSourse, DbEntity eTarget) {
        InferRelationships myir = new InferRelationships();
        for (DbRelationship relationship : eSourse.getRelationships()) {
            for (DbJoin join : relationship.getJoins()) {
                if (!((DbEntity)join.getSource().getEntity()).equals(eSourse) || !((DbEntity)join.getTarget().getEntity()).equals(eTarget)) continue;
                return;
            }
        }
        myir.setSource(eSourse);
        myir.setTarget(eTarget);
        this.ir.add(myir);
    }

    public String getJoin(InferRelationships irItem) {
        return irItem.getJoinSource().getName() + " : " + irItem.getJoinTarget().getName();
    }

    public String getToMany(InferRelationships irItem) {
        if (irItem.isToMany()) {
            return "to many";
        }
        return "to one";
    }

    public DbAttribute getJoinAttribute(DbEntity sEntity, DbEntity tEntity) {
        if (sEntity.getAttributes().size() == 1) {
            return sEntity.getAttributes().iterator().next();
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(tEntity.getName() + "_ID")) continue;
            return attr;
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(sEntity.getName() + "_ID") || attr.isPrimaryKey()) continue;
            return (DbAttribute)sEntity.getAttribute(attr.getName());
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.isPrimaryKey()) continue;
            return attr;
        }
        return null;
    }

    public void createJoin() {
        Iterator<InferRelationships> it = this.ir.iterator();
        while (it.hasNext()) {
            InferRelationships myir = it.next();
            DbAttribute src = this.getJoinAttribute(myir.getSource(), myir.getTarget());
            if (src == null) {
                it.remove();
                continue;
            }
            DbAttribute target = this.getJoinAttribute(myir.getTarget(), myir.getSource());
            if (target == null) {
                it.remove();
                continue;
            }
            myir.setJoinSource(src);
            if (src.isPrimaryKey()) {
                myir.setToMany(true);
            }
            myir.setJoinTarget(target);
        }
    }

    public void createName() {
        ExportedKey key = null;
        for (InferRelationships myir : this.ir) {
            key = myir.getJoinSource().isPrimaryKey() ? this.getExportedKey(myir.getSource().getName(), myir.getJoinSource().getName(), myir.getTarget().getName(), myir.getJoinTarget().getName()) : this.getExportedKey(myir.getTarget().getName(), myir.getJoinTarget().getName(), myir.getSource().getName(), myir.getJoinSource().getName());
            myir.setName(this.strategy.createDbRelationshipName(key, myir.isToMany()));
        }
    }

    public ExportedKey getExportedKey(String pkTable, String pkColumn, String fkTable, String fkColumn) {
        return new ExportedKey(pkTable, pkColumn, null, fkTable, fkColumn, null);
    }

    public List<InferRelationships> getSelectedEntities() {
        ArrayList<InferRelationships> selected = new ArrayList<InferRelationships>(this.selectedEntities.size());
        for (InferRelationships entity : this.ir) {
            if (!this.selectedEntities.contains(entity)) continue;
            selected.add(entity);
        }
        return selected;
    }

    public boolean updateSelection(Predicate predicate) {
        boolean modified = false;
        for (InferRelationships entity : this.ir) {
            boolean select = predicate.evaluate(entity);
            if (select) {
                if (!this.selectedEntities.add(entity)) continue;
                modified = true;
                continue;
            }
            if (!this.selectedEntities.remove(entity)) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    public boolean isSelected() {
        return this.currentEntity != null ? this.selectedEntities.contains(this.currentEntity) : false;
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentEntity == null) {
            return;
        }
        if (selectedFlag) {
            if (this.selectedEntities.add(this.currentEntity)) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        } else if (this.selectedEntities.remove(this.currentEntity)) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
    }

    public int getSelectedEntitiesSize() {
        return this.selectedEntities.size();
    }

    public List getEntities() {
        return this.ir;
    }

    public InferRelationships getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(InferRelationships currentEntity) {
        this.currentEntity = currentEntity;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Override
    public Component getView() {
        return null;
    }

    public void setNamingStrategy(NamingStrategy namestr) {
        this.strategy = namestr;
    }
}

