/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.io.Serializable;
import java.util.Collection;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.util.IDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBridge
extends EventBridge
implements MessageListener {
    static final String VM_ID = new String(IDUtil.pseudoUniqueByteSequence16());
    static final String VM_ID_PROPERRTY = "VM_ID";
    protected String topicConnectionFactoryName;
    protected TopicConnection sendConnection;
    protected TopicSession sendSession;
    protected TopicConnection receivedConnection;
    protected TopicPublisher publisher;
    protected TopicSubscriber subscriber;

    public JMSBridge(EventSubject localSubject, String externalSubject) {
        super(localSubject, externalSubject);
    }

    public JMSBridge(Collection<EventSubject> localSubjects, String externalSubject) {
        super(localSubjects, externalSubject);
    }

    public void onMessage(Message message) {
        try {
            Object vmID = message.getObjectProperty(VM_ID_PROPERRTY);
            if (VM_ID.equals(vmID)) {
                return;
            }
            if (!(message instanceof ObjectMessage)) {
                return;
            }
            ObjectMessage objectMessage = (ObjectMessage)message;
            CayenneEvent event = this.messageObjectToEvent(objectMessage.getObject());
            if (event != null) {
                this.onExternalEvent(event);
            }
        }
        catch (MessageFormatException mfex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTopicConnectionFactoryName() {
        return this.topicConnectionFactoryName;
    }

    public void setTopicConnectionFactoryName(String name) {
        this.topicConnectionFactoryName = name;
    }

    @Override
    protected void startupExternal() throws Exception {
        Topic topic;
        TopicConnectionFactory connectionFactory;
        block4: {
            InitialContext jndiContext = new InitialContext();
            connectionFactory = (TopicConnectionFactory)jndiContext.lookup(this.topicConnectionFactoryName);
            topic = null;
            try {
                topic = (Topic)jndiContext.lookup(this.externalSubject);
            }
            catch (NameNotFoundException ex) {
                topic = this.topicNotFound(jndiContext, ex);
                if (topic != null) break block4;
                throw ex;
            }
        }
        if (this.receivesLocalEvents()) {
            this.sendConnection = connectionFactory.createTopicConnection();
            this.sendSession = this.sendConnection.createTopicSession(false, 1);
            this.publisher = this.sendSession.createPublisher(topic);
        }
        if (this.receivesExternalEvents()) {
            this.receivedConnection = connectionFactory.createTopicConnection();
            this.subscriber = this.receivedConnection.createTopicSession(false, 1).createSubscriber(topic);
            this.subscriber.setMessageListener((MessageListener)this);
            this.receivedConnection.start();
        }
    }

    protected Topic topicNotFound(Context jndiContext, NamingException ex) throws Exception {
        throw ex;
    }

    @Override
    protected void shutdownExternal() throws Exception {
        Exception lastException = null;
        if (this.publisher != null) {
            try {
                this.publisher.close();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (this.subscriber != null) {
            try {
                this.subscriber.close();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (this.receivedConnection != null) {
            try {
                this.receivedConnection.close();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (this.sendSession != null) {
            try {
                this.sendSession.close();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (this.sendConnection != null) {
            try {
                this.sendConnection.close();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        this.publisher = null;
        this.subscriber = null;
        this.receivedConnection = null;
        this.sendConnection = null;
        this.sendSession = null;
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    protected void sendExternalEvent(CayenneEvent localEvent) throws Exception {
        ObjectMessage message = this.sendSession.createObjectMessage(this.eventToMessageObject(localEvent));
        message.setObjectProperty(VM_ID_PROPERRTY, (Object)VM_ID);
        this.publisher.publish((Message)message);
    }

    protected Serializable eventToMessageObject(CayenneEvent event) throws Exception {
        return event;
    }

    protected CayenneEvent messageObjectToEvent(Serializable object) throws Exception {
        return object instanceof CayenneEvent ? (CayenneEvent)object : null;
    }
}

