/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.pref._DataMapDefaults;
import org.apache.cayenne.util.Util;

public class DataMapDefaults
extends _DataMapDefaults {
    public static final String DEFAULT_SUPERCLASS_PACKAGE_SUFFIX = "auto";

    public void updateSuperclassPackage(DataMap dataMap, boolean isClient) {
        String storedPackage = super.getSuperclassPackage();
        if (Util.isEmptyString((String)storedPackage) || DEFAULT_SUPERCLASS_PACKAGE_SUFFIX.equals(storedPackage)) {
            String mapPackage;
            String string = mapPackage = isClient ? dataMap.getDefaultClientPackage() : dataMap.getDefaultPackage();
            if (!Util.isEmptyString((String)mapPackage)) {
                String newPackage;
                if (mapPackage.endsWith(".")) {
                    mapPackage = mapPackage.substring(mapPackage.length() - 1);
                }
                if (!Util.isEmptyString((String)mapPackage) && !Util.nullSafeEquals((Object)(newPackage = mapPackage + "." + DEFAULT_SUPERCLASS_PACKAGE_SUFFIX), (Object)storedPackage)) {
                    this.setSuperclassPackage(newPackage);
                }
            }
        }
        if (DEFAULT_SUPERCLASS_PACKAGE_SUFFIX.equals(this.getSuperclassPackage())) {
            this.setSuperclassPackage(null);
        }
    }

    public void prePersist() {
        this.setGeneratePairs(Boolean.TRUE);
    }

    public void setSuperclassPackage(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (suffix == null) {
            suffix = "";
        } else if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        String dot = suffix.length() > 0 && prefix.length() > 0 ? "." : "";
        this.setSuperclassPackage(prefix + dot + suffix);
    }
}

