/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTransferable;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class CopyAction
extends CayenneAction {
    public static String getActionName() {
        return "Copy";
    }

    public CopyAction(Application application) {
        this(CopyAction.getActionName(), application);
    }

    protected CopyAction(String name, Application application) {
        super(name, application);
    }

    public String getIconName() {
        return "icon-copy.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        Object content = this.copy(mediator);
        if (content != null) {
            Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            sysClip.setContents(new CayenneTransferable(content), null);
        }
        ((PasteAction)this.getApplication().getAction(PasteAction.getActionName())).updateState();
    }

    public Object copy(ProjectController mediator) {
        return mediator.getCurrentObject();
    }

    protected void print(XMLEncoder encoder, XMLSerializable object) {
        object.encodeAsXML(encoder);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Object last = path.getObject();
        return last instanceof DataMap || last instanceof Query || last instanceof DbEntity || last instanceof ObjEntity || last instanceof Embeddable || last instanceof EmbeddableAttribute || last instanceof DbAttribute || last instanceof DbRelationship || last instanceof ObjAttribute || last instanceof ObjRelationship || last instanceof Procedure || last instanceof ProcedureParameter;
    }
}

