/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.BaseToManyProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.pojo.EnhancedPojoPropertyFaultHandler;

abstract class EnhancedPojoToManyProperty
extends BaseToManyProperty {
    private EnhancedPojoPropertyFaultHandler faultHandler;

    EnhancedPojoToManyProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.faultHandler = new EnhancedPojoPropertyFaultHandler(owner.getObjectClass(), this.getName());
    }

    protected ValueHolder createCollectionValueHolder(Object object) throws PropertyException {
        if (!(object instanceof Persistent)) {
            throw new PropertyException("ValueHolders for non-persistent objects are not supported.", this, object);
        }
        ValueHolder holder = this.createValueHolder((Persistent)object);
        this.faultHandler.setFaultProperty(object, false);
        return holder;
    }

    protected abstract ValueHolder createValueHolder(Persistent var1);

    public void invalidate(Object object) {
        this.faultHandler.setFaultProperty(object, true);
    }

    public boolean isFault(Object object) {
        return this.faultHandler.isFaultProperty(object);
    }
}

