/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.osgi.framework.Bundle;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.service.packageadmin.ExportedPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageData {
    long[] exportingBundles;
    long[] importingBundles;
    String name;
    boolean removalPending;
    String version;

    public PackageData(ExportedPackage exportedPackage) {
        this(new long[]{exportedPackage.getExportingBundle().getBundleId()}, PackageData.toBundleIds(exportedPackage.getImportingBundles()), exportedPackage.getName(), exportedPackage.isRemovalPending(), exportedPackage.getVersion().toString());
    }

    public PackageData(long[] exportingBundles, long[] importingBundles, String name, boolean removalPending, String version) {
        this.exportingBundles = exportingBundles;
        this.importingBundles = importingBundles;
        this.name = name;
        this.removalPending = removalPending;
        this.version = version;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("ExportingBundles", this.toLongArray(this.exportingBundles));
            items.put("ImportingBundles", this.toLongArray(this.importingBundles));
            items.put("Name", this.name);
            items.put("RemovalPending", this.removalPending);
            items.put("Version", this.version);
            return new CompositeDataSupport(PackageStateMBean.PACKAGE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static PackageData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        long[] exportingBundle = PackageData.toLongPrimitiveArray((Long[])data.get("ExportingBundles"));
        long[] importingBundles = PackageData.toLongPrimitiveArray((Long[])data.get("ImportingBundles"));
        String name = (String)data.get("Name");
        boolean removalPending = (Boolean)data.get("RemovalPending");
        String version = (String)data.get("Version");
        return new PackageData(exportingBundle, importingBundles, name, removalPending, version);
    }

    public static TabularData tableFrom(Set<PackageData> packages) {
        TabularDataSupport table = new TabularDataSupport(PackageStateMBean.PACKAGES_TYPE);
        for (PackageData pkg : packages) {
            table.put(pkg.toCompositeData());
        }
        return table;
    }

    public static long[] toBundleIds(Bundle[] bundles) {
        if (bundles != null) {
            long[] importingBundles = new long[bundles.length];
            for (int i = 0; i < bundles.length; ++i) {
                importingBundles[i] = bundles[i].getBundleId();
            }
            return importingBundles;
        }
        return null;
    }

    protected Long[] toLongArray(long[] primitiveArray) {
        if (primitiveArray == null) {
            return null;
        }
        Long[] converted = new Long[primitiveArray.length];
        for (int i = 0; i < primitiveArray.length; ++i) {
            converted[i] = primitiveArray[i];
        }
        return converted;
    }

    protected static long[] toLongPrimitiveArray(Long[] wrapperArray) {
        if (wrapperArray == null) {
            return null;
        }
        long[] converted = new long[wrapperArray.length];
        for (int i = 0; i < wrapperArray.length; ++i) {
            converted[i] = wrapperArray[i];
        }
        return converted;
    }

    public long[] getExportingBundles() {
        return this.exportingBundles;
    }

    public long[] getImportingBundles() {
        return this.importingBundles;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRemovalPending() {
        return this.removalPending;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageData that = (PackageData)o;
        if (this.exportingBundles[0] != that.exportingBundles[0]) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = (int)(this.exportingBundles[0] ^ this.exportingBundles[0] >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

