#define ICONV_INTERNAL
#include "iconv.h"

static const iconv_ccs_convtable_8bit to_ucs_00 = { {
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
	0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
	0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
	0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
	0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
	0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
	0x0058, 0x0059, 0x005A, 0x005B, 0x00A5, 0x005D, 0x005E, 0x005F,
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
	0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
	0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0xFFFE,
	0x005C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x00A0, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65, 0xFF66, 0xFF67,
	0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F,
	0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75, 0xFF76, 0xFF77,
	0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F,
	0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87,
	0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F,
	0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97,
	0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x00A9, 0x2122, 0x2026
} };

static const iconv_ccs_convtable_8bit to_ucs_81 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3000, 0x3001, 0x3002, 0xFF0C, 0xFF0E, 0x30FB, 0xFF1A, 0xFF1B,
	0xFF1F, 0xFF01, 0x309B, 0x309C, 0x00B4, 0xFF40, 0x00A8, 0xFF3E,
	0xFFE3, 0xFF3F, 0x30FD, 0x30FE, 0x309D, 0x309E, 0x3003, 0x4EDD,
	0x3005, 0x3006, 0x3007, 0x30FC, 0x2014, 0x2010, 0xFF0F, 0xFF3C,
	0x301C, 0x2016, 0xFF5C, 0x2026, 0x2025, 0x2018, 0x2019, 0x201C,
	0x201D, 0xFF08, 0xFF09, 0x3014, 0x3015, 0xFF3B, 0xFF3D, 0xFF5B,
	0xFF5D, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E,
	0x300F, 0x3010, 0x3011, 0xFF0B, 0x2212, 0x00B1, 0x00D7, 0xFFFE,
	0x00F7, 0xFF1D, 0x2260, 0xFF1C, 0xFF1E, 0x2266, 0x2267, 0x221E,
	0x2234, 0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFFE5,
	0xFF04, 0x00A2, 0x00A3, 0xFF05, 0xFF03, 0xFF06, 0xFF0A, 0xFF20,
	0x00A7, 0x2606, 0x2605, 0x25CB, 0x25CF, 0x25CE, 0x25C7, 0x25C6,
	0x25A1, 0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x203B, 0x3012,
	0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2208, 0x220B, 0x2286, 0x2287, 0x2282, 0x2283, 0x222A, 0x2229,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2227, 0x2228, 0x00AC, 0x21D2, 0x21D4, 0x2200, 0x2203, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2220, 0x22A5, 0x2312, 0x2202, 0x2207, 0x2261,
	0x2252, 0x226A, 0x226B, 0x221A, 0x223D, 0x221D, 0x2235, 0x222B,
	0x222C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x212B, 0x2030, 0x266F, 0x266D, 0x266A, 0x2020, 0x2021, 0x00B6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x25EF, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_82 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFF10,
	0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18,
	0xFF19, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28,
	0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30,
	0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38,
	0xFF39, 0xFF3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47,
	0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F,
	0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57,
	0xFF58, 0xFF59, 0xFF5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3041,
	0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
	0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051,
	0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059,
	0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061,
	0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069,
	0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 0x3071,
	0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079,
	0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 0x3081,
	0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089,
	0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091,
	0x3092, 0x3093, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_83 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8,
	0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0,
	0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8,
	0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0,
	0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8,
	0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0,
	0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8,
	0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0xFFFE,
	0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7,
	0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF,
	0x30F0, 0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x0391,
	0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399,
	0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1,
	0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x03B1,
	0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9,
	0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1,
	0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_84 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416,
	0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E,
	0x041F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
	0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E,
	0x042F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436,
	0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0xFFFE,
	0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445,
	0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D,
	0x044E, 0x044F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2500,
	0x2502, 0x250C, 0x2510, 0x2518, 0x2514, 0x251C, 0x252C, 0x2524,
	0x2534, 0x253C, 0x2501, 0x2503, 0x250F, 0x2513, 0x251B, 0x2517,
	0x2523, 0x2533, 0x252B, 0x253B, 0x254B, 0x2520, 0x252F, 0x2528,
	0x2537, 0x253F, 0x251D, 0x2530, 0x2525, 0x2538, 0x2542, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_85 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
	0x2468, 0x2469, 0x246A, 0x246B, 0x246C, 0x246D, 0x246E, 0x246F,
	0x2470, 0x2471, 0x2472, 0x2473, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2474, 0x2475,
	0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 0x247B, 0x247C, 0x247D,
	0x247E, 0x247F, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485,
	0x2486, 0x2487, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2776, 0x2777, 0x2778, 0xFFFE,
	0x2779, 0x277A, 0x277B, 0x277C, 0x277D, 0x277E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xF860, 0x2488, 0x2489, 0x248A, 0x248B, 0x248C, 0x248D,
	0x248E, 0x248F, 0x2490, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2160,
	0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168,
	0x2169, 0x216A, 0x216B, 0xF862, 0xF861, 0xF860, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174,
	0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A, 0x217B, 0xF862,
	0xF861, 0xF860, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x249C, 0x249D, 0x249E, 0x249F, 0x24A0,
	0x24A1, 0x24A2, 0x24A3, 0x24A4, 0x24A5, 0x24A6, 0x24A7, 0x24A8,
	0x24A9, 0x24AA, 0x24AB, 0x24AC, 0x24AD, 0x24AE, 0x24AF, 0x24B0,
	0x24B1, 0x24B2, 0x24B3, 0x24B4, 0x24B5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_86 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x339C, 0x339F, 0x339D, 0x33A0, 0x33A4, 0xFF4D, 0x33A1, 0x33A5,
	0x339E, 0x33A2, 0x338E, 0xFF47, 0x338F, 0x33C4, 0x3396, 0x3397,
	0x2113, 0x3398, 0x33B3, 0x33B2, 0x33B1, 0x33B0, 0x2109, 0x33D4,
	0x33CB, 0x3390, 0x3385, 0x3386, 0x3387, 0xF860, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2116, 0x33CD, 0x2121, 0xF861, 0x2664,
	0x2667, 0x2661, 0x2662, 0x2660, 0x2663, 0x2665, 0x2666, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3020, 0x260E, 0x3004, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x261E,
	0x261C, 0x261D, 0x261F, 0x21C6, 0x21C4, 0x21C5, 0xF860, 0x21E8,
	0x21E6, 0x21E7, 0x21E9, 0x21E8, 0x21E6, 0x21E7, 0x21E9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_87 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3230, 0x322A, 0x322B, 0x322C, 0x322D, 0x322E, 0x322F, 0x3240,
	0x3237, 0x3242, 0x3243, 0x3239, 0x323A, 0x3231, 0x323E, 0x3234,
	0x3232, 0x323B, 0x3236, 0x3233, 0x3235, 0x323C, 0x323D, 0x323F,
	0x3238, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5927, 0x5C0F, 0x32A4, 0x32A5, 0x32A6, 0x32A7, 0x32A8,
	0x32A9, 0x3296, 0x329D, 0x3298, 0x329E, 0x63A7, 0x3299, 0x3349,
	0x3322, 0x334D, 0x3314, 0x3316, 0x3305, 0x3333, 0x334E, 0x3303,
	0x3336, 0x3318, 0x3315, 0x3327, 0x3351, 0x334A, 0x3339, 0x3357,
	0x330D, 0x3342, 0x3323, 0x3326, 0x333B, 0x332B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3300, 0x331E, 0x332A,
	0x3331, 0x3347, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x337E, 0x337D, 0x337C,
	0x337B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x337F, 0xF862, 0xF862, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_88 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x222E, 0x221F, 0x22BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x301D, 0x301F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3094, 0xFFFE, 0x30F7, 0x30F8, 0x30F9, 0x30FA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E9C,
	0x5516, 0x5A03, 0x963F, 0x54C0, 0x611B, 0x6328, 0x59F6, 0x9022,
	0x8475, 0x831C, 0x7A50, 0x60AA, 0x63E1, 0x6E25, 0x65ED, 0x8466,
	0x82A6, 0x9BF5, 0x6893, 0x5727, 0x65A1, 0x6271, 0x5B9B, 0x59D0,
	0x867B, 0x98F4, 0x7D62, 0x7DBE, 0x9B8E, 0x6216, 0x7C9F, 0x88B7,
	0x5B89, 0x5EB5, 0x6309, 0x6697, 0x6848, 0x95C7, 0x978D, 0x674F,
	0x4EE5, 0x4F0A, 0x4F4D, 0x4F9D, 0x5049, 0x56F2, 0x5937, 0x59D4,
	0x5A01, 0x5C09, 0x60DF, 0x610F, 0x6170, 0x6613, 0x6905, 0x70BA,
	0x754F, 0x7570, 0x79FB, 0x7DAD, 0x7DEF, 0x80C3, 0x840E, 0x8863,
	0x8B02, 0x9055, 0x907A, 0x533B, 0x4E95, 0x4EA5, 0x57DF, 0x80B2,
	0x90C1, 0x78EF, 0x4E00, 0x58F1, 0x6EA2, 0x9038, 0x7A32, 0x8328,
	0x828B, 0x9C2F, 0x5141, 0x5370, 0x54BD, 0x54E1, 0x56E0, 0x59FB,
	0x5F15, 0x98F2, 0x6DEB, 0x80E4, 0x852D, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_89 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9662, 0x9670, 0x96A0, 0x97FB, 0x540B, 0x53F3, 0x5B87, 0x70CF,
	0x7FBD, 0x8FC2, 0x96E8, 0x536F, 0x9D5C, 0x7ABA, 0x4E11, 0x7893,
	0x81FC, 0x6E26, 0x5618, 0x5504, 0x6B1D, 0x851A, 0x9C3B, 0x59E5,
	0x53A9, 0x6D66, 0x74DC, 0x958F, 0x5642, 0x4E91, 0x904B, 0x96F2,
	0x834F, 0x990C, 0x53E1, 0x55B6, 0x5B30, 0x5F71, 0x6620, 0x66F3,
	0x6804, 0x6C38, 0x6CF3, 0x6D29, 0x745B, 0x76C8, 0x7A4E, 0x9834,
	0x82F1, 0x885B, 0x8A60, 0x92ED, 0x6DB2, 0x75AB, 0x76CA, 0x99C5,
	0x60A6, 0x8B01, 0x8D8A, 0x95B2, 0x698E, 0x53AD, 0x5186, 0xFFFE,
	0x5712, 0x5830, 0x5944, 0x5BB4, 0x5EF6, 0x6028, 0x63A9, 0x63F4,
	0x6CBF, 0x6F14, 0x708E, 0x7114, 0x7159, 0x71D5, 0x733F, 0x7E01,
	0x8276, 0x82D1, 0x8597, 0x9060, 0x925B, 0x9D1B, 0x5869, 0x65BC,
	0x6C5A, 0x7525, 0x51F9, 0x592E, 0x5965, 0x5F80, 0x5FDC, 0x62BC,
	0x65FA, 0x6A2A, 0x6B27, 0x6BB4, 0x738B, 0x7FC1, 0x8956, 0x9D2C,
	0x9D0E, 0x9EC4, 0x5CA1, 0x6C96, 0x837B, 0x5104, 0x5C4B, 0x61B6,
	0x81C6, 0x6876, 0x7261, 0x4E59, 0x4FFA, 0x5378, 0x6069, 0x6E29,
	0x7A4F, 0x97F3, 0x4E0B, 0x5316, 0x4EEE, 0x4F55, 0x4F3D, 0x4FA1,
	0x4F73, 0x52A0, 0x53EF, 0x5609, 0x590F, 0x5AC1, 0x5BB6, 0x5BE1,
	0x79D1, 0x6687, 0x679C, 0x67B6, 0x6B4C, 0x6CB3, 0x706B, 0x73C2,
	0x798D, 0x79BE, 0x7A3C, 0x7B87, 0x82B1, 0x82DB, 0x8304, 0x8377,
	0x83EF, 0x83D3, 0x8766, 0x8AB2, 0x5629, 0x8CA8, 0x8FE6, 0x904E,
	0x971E, 0x868A, 0x4FC4, 0x5CE8, 0x6211, 0x7259, 0x753B, 0x81E5,
	0x82BD, 0x86FE, 0x8CC0, 0x96C5, 0x9913, 0x99D5, 0x4ECB, 0x4F1A,
	0x89E3, 0x56DE, 0x584A, 0x58CA, 0x5EFB, 0x5FEB, 0x602A, 0x6094,
	0x6062, 0x61D0, 0x6212, 0x62D0, 0x6539, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B41, 0x6666, 0x68B0, 0x6D77, 0x7070, 0x754C, 0x7686, 0x7D75,
	0x82A5, 0x87F9, 0x958B, 0x968E, 0x8C9D, 0x51F1, 0x52BE, 0x5916,
	0x54B3, 0x5BB3, 0x5D16, 0x6168, 0x6982, 0x6DAF, 0x788D, 0x84CB,
	0x8857, 0x8A72, 0x93A7, 0x9AB8, 0x6D6C, 0x99A8, 0x86D9, 0x57A3,
	0x67FF, 0x86CE, 0x920E, 0x5283, 0x5687, 0x5404, 0x5ED3, 0x62E1,
	0x64B9, 0x683C, 0x6838, 0x6BBB, 0x7372, 0x78BA, 0x7A6B, 0x899A,
	0x89D2, 0x8D6B, 0x8F03, 0x90ED, 0x95A3, 0x9694, 0x9769, 0x5B66,
	0x5CB3, 0x697D, 0x984D, 0x984E, 0x639B, 0x7B20, 0x6A2B, 0xFFFE,
	0x6A7F, 0x68B6, 0x9C0D, 0x6F5F, 0x5272, 0x559D, 0x6070, 0x62EC,
	0x6D3B, 0x6E07, 0x6ED1, 0x845B, 0x8910, 0x8F44, 0x4E14, 0x9C39,
	0x53F6, 0x691B, 0x6A3A, 0x9784, 0x682A, 0x515C, 0x7AC3, 0x84B2,
	0x91DC, 0x938C, 0x565B, 0x9D28, 0x6822, 0x8305, 0x8431, 0x7CA5,
	0x5208, 0x82C5, 0x74E6, 0x4E7E, 0x4F83, 0x51A0, 0x5BD2, 0x520A,
	0x52D8, 0x52E7, 0x5DFB, 0x559A, 0x582A, 0x59E6, 0x5B8C, 0x5B98,
	0x5BDB, 0x5E72, 0x5E79, 0x60A3, 0x611F, 0x6163, 0x61BE, 0x63DB,
	0x6562, 0x67D1, 0x6853, 0x68FA, 0x6B3E, 0x6B53, 0x6C57, 0x6F22,
	0x6F97, 0x6F45, 0x74B0, 0x7518, 0x76E3, 0x770B, 0x7AFF, 0x7BA1,
	0x7C21, 0x7DE9, 0x7F36, 0x7FF0, 0x809D, 0x8266, 0x839E, 0x89B3,
	0x8ACC, 0x8CAB, 0x9084, 0x9451, 0x9593, 0x9591, 0x95A2, 0x9665,
	0x97D3, 0x9928, 0x8218, 0x4E38, 0x542B, 0x5CB8, 0x5DCC, 0x73A9,
	0x764C, 0x773C, 0x5CA9, 0x7FEB, 0x8D0B, 0x96C1, 0x9811, 0x9854,
	0x9858, 0x4F01, 0x4F0E, 0x5371, 0x559C, 0x5668, 0x57FA, 0x5947,
	0x5B09, 0x5BC4, 0x5C90, 0x5E0C, 0x5E7E, 0x5FCC, 0x63EE, 0x673A,
	0x65D7, 0x65E2, 0x671F, 0x68CB, 0x68C4, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A5F, 0x5E30, 0x6BC5, 0x6C17, 0x6C7D, 0x757F, 0x7948, 0x5B63,
	0x7A00, 0x7D00, 0x5FBD, 0x898F, 0x8A18, 0x8CB4, 0x8D77, 0x8ECC,
	0x8F1D, 0x98E2, 0x9A0E, 0x9B3C, 0x4E80, 0x507D, 0x5100, 0x5993,
	0x5B9C, 0x622F, 0x6280, 0x64EC, 0x6B3A, 0x72A0, 0x7591, 0x7947,
	0x7FA9, 0x87FB, 0x8ABC, 0x8B70, 0x63AC, 0x83CA, 0x97A0, 0x5409,
	0x5403, 0x55AB, 0x6854, 0x6A58, 0x8A70, 0x7827, 0x6775, 0x9ECD,
	0x5374, 0x5BA2, 0x811A, 0x8650, 0x9006, 0x4E18, 0x4E45, 0x4EC7,
	0x4F11, 0x53CA, 0x5438, 0x5BAE, 0x5F13, 0x6025, 0x6551, 0xFFFE,
	0x673D, 0x6C42, 0x6C72, 0x6CE3, 0x7078, 0x7403, 0x7A76, 0x7AAE,
	0x7B08, 0x7D1A, 0x7CFE, 0x7D66, 0x65E7, 0x725B, 0x53BB, 0x5C45,
	0x5DE8, 0x62D2, 0x62E0, 0x6319, 0x6E20, 0x865A, 0x8A31, 0x8DDD,
	0x92F8, 0x6F01, 0x79A6, 0x9B5A, 0x4EA8, 0x4EAB, 0x4EAC, 0x4F9B,
	0x4FA0, 0x50D1, 0x5147, 0x7AF6, 0x5171, 0x51F6, 0x5354, 0x5321,
	0x537F, 0x53EB, 0x55AC, 0x5883, 0x5CE1, 0x5F37, 0x5F4A, 0x602F,
	0x6050, 0x606D, 0x631F, 0x6559, 0x6A4B, 0x6CC1, 0x72C2, 0x72ED,
	0x77EF, 0x80F8, 0x8105, 0x8208, 0x854E, 0x90F7, 0x93E1, 0x97FF,
	0x9957, 0x9A5A, 0x4EF0, 0x51DD, 0x5C2D, 0x6681, 0x696D, 0x5C40,
	0x66F2, 0x6975, 0x7389, 0x6850, 0x7C81, 0x50C5, 0x52E4, 0x5747,
	0x5DFE, 0x9326, 0x65A4, 0x6B23, 0x6B3D, 0x7434, 0x7981, 0x79BD,
	0x7B4B, 0x7DCA, 0x82B9, 0x83CC, 0x887F, 0x895F, 0x8B39, 0x8FD1,
	0x91D1, 0x541F, 0x9280, 0x4E5D, 0x5036, 0x53E5, 0x533A, 0x72D7,
	0x7396, 0x77E9, 0x82E6, 0x8EAF, 0x99C6, 0x99C8, 0x99D2, 0x5177,
	0x611A, 0x865E, 0x55B0, 0x7A7A, 0x5076, 0x5BD3, 0x9047, 0x9685,
	0x4E32, 0x6ADB, 0x91E7, 0x5C51, 0x5C48, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6398, 0x7A9F, 0x6C93, 0x9774, 0x8F61, 0x7AAA, 0x718A, 0x9688,
	0x7C82, 0x6817, 0x7E70, 0x6851, 0x936C, 0x52F2, 0x541B, 0x85AB,
	0x8A13, 0x7FA4, 0x8ECD, 0x90E1, 0x5366, 0x8888, 0x7941, 0x4FC2,
	0x50BE, 0x5211, 0x5144, 0x5553, 0x572D, 0x73EA, 0x578B, 0x5951,
	0x5F62, 0x5F84, 0x6075, 0x6176, 0x6167, 0x61A9, 0x63B2, 0x643A,
	0x656C, 0x666F, 0x6842, 0x6E13, 0x7566, 0x7A3D, 0x7CFB, 0x7D4C,
	0x7D99, 0x7E4B, 0x7F6B, 0x830E, 0x834A, 0x86CD, 0x8A08, 0x8A63,
	0x8B66, 0x8EFD, 0x981A, 0x9D8F, 0x82B8, 0x8FCE, 0x9BE8, 0xFFFE,
	0x5287, 0x621F, 0x6483, 0x6FC0, 0x9699, 0x6841, 0x5091, 0x6B20,
	0x6C7A, 0x6F54, 0x7A74, 0x7D50, 0x8840, 0x8A23, 0x6708, 0x4EF6,
	0x5039, 0x5026, 0x5065, 0x517C, 0x5238, 0x5263, 0x55A7, 0x570F,
	0x5805, 0x5ACC, 0x5EFA, 0x61B2, 0x61F8, 0x62F3, 0x6372, 0x691C,
	0x6A29, 0x727D, 0x72AC, 0x732E, 0x7814, 0x786F, 0x7D79, 0x770C,
	0x80A9, 0x898B, 0x8B19, 0x8CE2, 0x8ED2, 0x9063, 0x9375, 0x967A,
	0x9855, 0x9A13, 0x9E78, 0x5143, 0x539F, 0x53B3, 0x5E7B, 0x5F26,
	0x6E1B, 0x6E90, 0x7384, 0x73FE, 0x7D43, 0x8237, 0x8A00, 0x8AFA,
	0x9650, 0x4E4E, 0x500B, 0x53E4, 0x547C, 0x56FA, 0x59D1, 0x5B64,
	0x5DF1, 0x5EAB, 0x5F27, 0x6238, 0x6545, 0x67AF, 0x6E56, 0x72D0,
	0x7CCA, 0x88B4, 0x80A1, 0x80E1, 0x83F0, 0x864E, 0x8A87, 0x8DE8,
	0x9237, 0x96C7, 0x9867, 0x9F13, 0x4E94, 0x4E92, 0x4F0D, 0x5348,
	0x5449, 0x543E, 0x5A2F, 0x5F8C, 0x5FA1, 0x609F, 0x68A7, 0x6A8E,
	0x745A, 0x7881, 0x8A9E, 0x8AA4, 0x8B77, 0x9190, 0x4E5E, 0x9BC9,
	0x4EA4, 0x4F7C, 0x4FAF, 0x5019, 0x5016, 0x5149, 0x516C, 0x529F,
	0x52B9, 0x52FE, 0x539A, 0x53E3, 0x5411, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x540E, 0x5589, 0x5751, 0x57A2, 0x597D, 0x5B54, 0x5B5D, 0x5B8F,
	0x5DE5, 0x5DE7, 0x5DF7, 0x5E78, 0x5E83, 0x5E9A, 0x5EB7, 0x5F18,
	0x6052, 0x614C, 0x6297, 0x62D8, 0x63A7, 0x653B, 0x6602, 0x6643,
	0x66F4, 0x676D, 0x6821, 0x6897, 0x69CB, 0x6C5F, 0x6D2A, 0x6D69,
	0x6E2F, 0x6E9D, 0x7532, 0x7687, 0x786C, 0x7A3F, 0x7CE0, 0x7D05,
	0x7D18, 0x7D5E, 0x7DB1, 0x8015, 0x8003, 0x80AF, 0x80B1, 0x8154,
	0x818F, 0x822A, 0x8352, 0x884C, 0x8861, 0x8B1B, 0x8CA2, 0x8CFC,
	0x90CA, 0x9175, 0x9271, 0x783F, 0x92FC, 0x95A4, 0x964D, 0xFFFE,
	0x9805, 0x9999, 0x9AD8, 0x9D3B, 0x525B, 0x52AB, 0x53F7, 0x5408,
	0x58D5, 0x62F7, 0x6FE0, 0x8C6A, 0x8F5F, 0x9EB9, 0x514B, 0x523B,
	0x544A, 0x56FD, 0x7A40, 0x9177, 0x9D60, 0x9ED2, 0x7344, 0x6F09,
	0x8170, 0x7511, 0x5FFD, 0x60DA, 0x9AA8, 0x72DB, 0x8FBC, 0x6B64,
	0x9803, 0x4ECA, 0x56F0, 0x5764, 0x58BE, 0x5A5A, 0x6068, 0x61C7,
	0x660F, 0x6606, 0x6839, 0x68B1, 0x6DF7, 0x75D5, 0x7D3A, 0x826E,
	0x9B42, 0x4E9B, 0x4F50, 0x53C9, 0x5506, 0x5D6F, 0x5DE6, 0x5DEE,
	0x67FB, 0x6C99, 0x7473, 0x7802, 0x8A50, 0x9396, 0x88DF, 0x5750,
	0x5EA7, 0x632B, 0x50B5, 0x50AC, 0x518D, 0x6700, 0x54C9, 0x585E,
	0x59BB, 0x5BB0, 0x5F69, 0x624D, 0x63A1, 0x683D, 0x6B73, 0x6E08,
	0x707D, 0x91C7, 0x7280, 0x7815, 0x7826, 0x796D, 0x658E, 0x7D30,
	0x83DC, 0x88C1, 0x8F09, 0x969B, 0x5264, 0x5728, 0x6750, 0x7F6A,
	0x8CA1, 0x51B4, 0x5742, 0x962A, 0x583A, 0x698A, 0x80B4, 0x54B2,
	0x5D0E, 0x57FC, 0x7895, 0x9DFA, 0x4F5C, 0x524A, 0x548B, 0x643E,
	0x6628, 0x6714, 0x67F5, 0x7A84, 0x7B56, 0x7D22, 0x932F, 0x685C,
	0x9BAD, 0x7B39, 0x5319, 0x518A, 0x5237, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5BDF, 0x62F6, 0x64AE, 0x64E6, 0x672D, 0x6BBA, 0x85A9, 0x96D1,
	0x7690, 0x9BD6, 0x634C, 0x9306, 0x9BAB, 0x76BF, 0x6652, 0x4E09,
	0x5098, 0x53C2, 0x5C71, 0x60E8, 0x6492, 0x6563, 0x685F, 0x71E6,
	0x73CA, 0x7523, 0x7B97, 0x7E82, 0x8695, 0x8B83, 0x8CDB, 0x9178,
	0x9910, 0x65AC, 0x66AB, 0x6B8B, 0x4ED5, 0x4ED4, 0x4F3A, 0x4F7F,
	0x523A, 0x53F8, 0x53F2, 0x55E3, 0x56DB, 0x58EB, 0x59CB, 0x59C9,
	0x59FF, 0x5B50, 0x5C4D, 0x5E02, 0x5E2B, 0x5FD7, 0x601D, 0x6307,
	0x652F, 0x5B5C, 0x65AF, 0x65BD, 0x65E8, 0x679D, 0x6B62, 0xFFFE,
	0x6B7B, 0x6C0F, 0x7345, 0x7949, 0x79C1, 0x7CF8, 0x7D19, 0x7D2B,
	0x80A2, 0x8102, 0x81F3, 0x8996, 0x8A5E, 0x8A69, 0x8A66, 0x8A8C,
	0x8AEE, 0x8CC7, 0x8CDC, 0x96CC, 0x98FC, 0x6B6F, 0x4E8B, 0x4F3C,
	0x4F8D, 0x5150, 0x5B57, 0x5BFA, 0x6148, 0x6301, 0x6642, 0x6B21,
	0x6ECB, 0x6CBB, 0x723E, 0x74BD, 0x75D4, 0x78C1, 0x793A, 0x800C,
	0x8033, 0x81EA, 0x8494, 0x8F9E, 0x6C50, 0x9E7F, 0x5F0F, 0x8B58,
	0x9D2B, 0x7AFA, 0x8EF8, 0x5B8D, 0x96EB, 0x4E03, 0x53F1, 0x57F7,
	0x5931, 0x5AC9, 0x5BA4, 0x6089, 0x6E7F, 0x6F06, 0x75BE, 0x8CEA,
	0x5B9F, 0x8500, 0x7BE0, 0x5072, 0x67F4, 0x829D, 0x5C61, 0x854A,
	0x7E1E, 0x820E, 0x5199, 0x5C04, 0x6368, 0x8D66, 0x659C, 0x716E,
	0x793E, 0x7D17, 0x8005, 0x8B1D, 0x8ECA, 0x906E, 0x86C7, 0x90AA,
	0x501F, 0x52FA, 0x5C3A, 0x6753, 0x707C, 0x7235, 0x914C, 0x91C8,
	0x932B, 0x82E5, 0x5BC2, 0x5F31, 0x60F9, 0x4E3B, 0x53D6, 0x5B88,
	0x624B, 0x6731, 0x6B8A, 0x72E9, 0x73E0, 0x7A2E, 0x816B, 0x8DA3,
	0x9152, 0x9996, 0x5112, 0x53D7, 0x546A, 0x5BFF, 0x6388, 0x6A39,
	0x7DAC, 0x9700, 0x56DA, 0x53CE, 0x5468, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_8F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B97, 0x5C31, 0x5DDE, 0x4FEE, 0x6101, 0x62FE, 0x6D32, 0x79C0,
	0x79CB, 0x7D42, 0x7E4D, 0x7FD2, 0x81ED, 0x821F, 0x8490, 0x8846,
	0x8972, 0x8B90, 0x8E74, 0x8F2F, 0x9031, 0x914B, 0x916C, 0x96C6,
	0x919C, 0x4EC0, 0x4F4F, 0x5145, 0x5341, 0x5F93, 0x620E, 0x67D4,
	0x6C41, 0x6E0B, 0x7363, 0x7E26, 0x91CD, 0x9283, 0x53D4, 0x5919,
	0x5BBF, 0x6DD1, 0x795D, 0x7E2E, 0x7C9B, 0x587E, 0x719F, 0x51FA,
	0x8853, 0x8FF0, 0x4FCA, 0x5CFB, 0x6625, 0x77AC, 0x7AE3, 0x821C,
	0x99FF, 0x51C6, 0x5FAA, 0x65EC, 0x696F, 0x6B89, 0x6DF3, 0xFFFE,
	0x6E96, 0x6F64, 0x76FE, 0x7D14, 0x5DE1, 0x9075, 0x9187, 0x9806,
	0x51E6, 0x521D, 0x6240, 0x6691, 0x66D9, 0x6E1A, 0x5EB6, 0x7DD2,
	0x7F72, 0x66F8, 0x85AF, 0x85F7, 0x8AF8, 0x52A9, 0x53D9, 0x5973,
	0x5E8F, 0x5F90, 0x6055, 0x92E4, 0x9664, 0x50B7, 0x511F, 0x52DD,
	0x5320, 0x5347, 0x53EC, 0x54E8, 0x5546, 0x5531, 0x5617, 0x5968,
	0x59BE, 0x5A3C, 0x5BB5, 0x5C06, 0x5C0F, 0x5C11, 0x5C1A, 0x5E84,
	0x5E8A, 0x5EE0, 0x5F70, 0x627F, 0x6284, 0x62DB, 0x638C, 0x6377,
	0x6607, 0x660C, 0x662D, 0x6676, 0x677E, 0x68A2, 0x6A1F, 0x6A35,
	0x6CBC, 0x6D88, 0x6E09, 0x6E58, 0x713C, 0x7126, 0x7167, 0x75C7,
	0x7701, 0x785D, 0x7901, 0x7965, 0x79F0, 0x7AE0, 0x7B11, 0x7CA7,
	0x7D39, 0x8096, 0x83D6, 0x848B, 0x8549, 0x885D, 0x88F3, 0x8A1F,
	0x8A3C, 0x8A54, 0x8A73, 0x8C61, 0x8CDE, 0x91A4, 0x9266, 0x937E,
	0x9418, 0x969C, 0x9798, 0x4E0A, 0x4E08, 0x4E1E, 0x4E57, 0x5197,
	0x5270, 0x57CE, 0x5834, 0x58CC, 0x5B22, 0x5E38, 0x60C5, 0x64FE,
	0x6761, 0x6756, 0x6D44, 0x72B6, 0x7573, 0x7A63, 0x84B8, 0x8B72,
	0x91B8, 0x9320, 0x5631, 0x57F4, 0x98FE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_90 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x62ED, 0x690D, 0x6B96, 0x71ED, 0x7E54, 0x8077, 0x8272, 0x89E6,
	0x98DF, 0x8755, 0x8FB1, 0x5C3B, 0x4F38, 0x4FE1, 0x4FB5, 0x5507,
	0x5A20, 0x5BDD, 0x5BE9, 0x5FC3, 0x614E, 0x632F, 0x65B0, 0x664B,
	0x68EE, 0x699B, 0x6D78, 0x6DF1, 0x7533, 0x75B9, 0x771F, 0x795E,
	0x79E6, 0x7D33, 0x81E3, 0x82AF, 0x85AA, 0x89AA, 0x8A3A, 0x8EAB,
	0x8F9B, 0x9032, 0x91DD, 0x9707, 0x4EBA, 0x4EC1, 0x5203, 0x5875,
	0x58EC, 0x5C0B, 0x751A, 0x5C3D, 0x814E, 0x8A0A, 0x8FC5, 0x9663,
	0x976D, 0x7B25, 0x8ACF, 0x9808, 0x9162, 0x56F3, 0x53A8, 0xFFFE,
	0x9017, 0x5439, 0x5782, 0x5E25, 0x63A8, 0x6C34, 0x708A, 0x7761,
	0x7C8B, 0x7FE0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968F,
	0x745E, 0x9AC4, 0x5D07, 0x5D69, 0x6570, 0x67A2, 0x8DA8, 0x96DB,
	0x636E, 0x6749, 0x6919, 0x83C5, 0x9817, 0x96C0, 0x88FE, 0x6F84,
	0x647A, 0x5BF8, 0x4E16, 0x702C, 0x755D, 0x662F, 0x51C4, 0x5236,
	0x52E2, 0x59D3, 0x5F81, 0x6027, 0x6210, 0x653F, 0x6574, 0x661F,
	0x6674, 0x68F2, 0x6816, 0x6B63, 0x6E05, 0x7272, 0x751F, 0x76DB,
	0x7CBE, 0x8056, 0x58F0, 0x88FD, 0x897F, 0x8AA0, 0x8A93, 0x8ACB,
	0x901D, 0x9192, 0x9752, 0x9759, 0x6589, 0x7A0E, 0x8106, 0x96BB,
	0x5E2D, 0x60DC, 0x621A, 0x65A5, 0x6614, 0x6790, 0x77F3, 0x7A4D,
	0x7C4D, 0x7E3E, 0x810A, 0x8CAC, 0x8D64, 0x8DE1, 0x8E5F, 0x78A9,
	0x5207, 0x62D9, 0x63A5, 0x6442, 0x6298, 0x8A2D, 0x7A83, 0x7BC0,
	0x8AAC, 0x96EA, 0x7D76, 0x820C, 0x8749, 0x4ED9, 0x5148, 0x5343,
	0x5360, 0x5BA3, 0x5C02, 0x5C16, 0x5DDD, 0x6226, 0x6247, 0x64B0,
	0x6813, 0x6834, 0x6CC9, 0x6D45, 0x6D17, 0x67D3, 0x6F5C, 0x714E,
	0x717D, 0x65CB, 0x7A7F, 0x7BAD, 0x7DDA, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_91 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7E4A, 0x7FA8, 0x817A, 0x821B, 0x8239, 0x85A6, 0x8A6E, 0x8CCE,
	0x8DF5, 0x9078, 0x9077, 0x92AD, 0x9291, 0x9583, 0x9BAE, 0x524D,
	0x5584, 0x6F38, 0x7136, 0x5168, 0x7985, 0x7E55, 0x81B3, 0x7CCE,
	0x564C, 0x5851, 0x5CA8, 0x63AA, 0x66FE, 0x66FD, 0x695A, 0x72D9,
	0x758F, 0x758E, 0x790E, 0x7956, 0x79DF, 0x7C97, 0x7D20, 0x7D44,
	0x8607, 0x8A34, 0x963B, 0x9061, 0x9F20, 0x50E7, 0x5275, 0x53CC,
	0x53E2, 0x5009, 0x55AA, 0x58EE, 0x594F, 0x723D, 0x5B8B, 0x5C64,
	0x531D, 0x60E3, 0x60F3, 0x635C, 0x6383, 0x633F, 0x63BB, 0xFFFE,
	0x64CD, 0x65E9, 0x66F9, 0x5DE3, 0x69CD, 0x69FD, 0x6F15, 0x71E5,
	0x4E89, 0x75E9, 0x76F8, 0x7A93, 0x7CDF, 0x7DCF, 0x7D9C, 0x8061,
	0x8349, 0x8358, 0x846C, 0x84BC, 0x85FB, 0x88C5, 0x8D70, 0x9001,
	0x906D, 0x9397, 0x971C, 0x9A12, 0x50CF, 0x5897, 0x618E, 0x81D3,
	0x8535, 0x8D08, 0x9020, 0x4FC3, 0x5074, 0x5247, 0x5373, 0x606F,
	0x6349, 0x675F, 0x6E2C, 0x8DB3, 0x901F, 0x4FD7, 0x5C5E, 0x8CCA,
	0x65CF, 0x7D9A, 0x5352, 0x8896, 0x5176, 0x63C3, 0x5B58, 0x5B6B,
	0x5C0A, 0x640D, 0x6751, 0x905C, 0x4ED6, 0x591A, 0x592A, 0x6C70,
	0x8A51, 0x553E, 0x5815, 0x59A5, 0x60F0, 0x6253, 0x67C1, 0x8235,
	0x6955, 0x9640, 0x99C4, 0x9A28, 0x4F53, 0x5806, 0x5BFE, 0x8010,
	0x5CB1, 0x5E2F, 0x5F85, 0x6020, 0x614B, 0x6234, 0x66FF, 0x6CF0,
	0x6EDE, 0x80CE, 0x817F, 0x82D4, 0x888B, 0x8CB8, 0x9000, 0x902E,
	0x968A, 0x9EDB, 0x9BDB, 0x4EE3, 0x53F0, 0x5927, 0x7B2C, 0x918D,
	0x984C, 0x9DF9, 0x6EDD, 0x7027, 0x5353, 0x5544, 0x5B85, 0x6258,
	0x629E, 0x62D3, 0x6CA2, 0x6FEF, 0x7422, 0x8A17, 0x9438, 0x6FC1,
	0x8AFE, 0x8338, 0x51E7, 0x86F8, 0x53EA, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_92 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x53E9, 0x4F46, 0x9054, 0x8FB0, 0x596A, 0x8131, 0x5DFD, 0x7AEA,
	0x8FBF, 0x68DA, 0x8C37, 0x72F8, 0x9C48, 0x6A3D, 0x8AB0, 0x4E39,
	0x5358, 0x5606, 0x5766, 0x62C5, 0x63A2, 0x65E6, 0x6B4E, 0x6DE1,
	0x6E5B, 0x70AD, 0x77ED, 0x7AEF, 0x7BAA, 0x7DBB, 0x803D, 0x80C6,
	0x86CB, 0x8A95, 0x935B, 0x56E3, 0x58C7, 0x5F3E, 0x65AD, 0x6696,
	0x6A80, 0x6BB5, 0x7537, 0x8AC7, 0x5024, 0x77E5, 0x5730, 0x5F1B,
	0x6065, 0x667A, 0x6C60, 0x75F4, 0x7A1A, 0x7F6E, 0x81F4, 0x8718,
	0x9045, 0x99B3, 0x7BC9, 0x755C, 0x7AF9, 0x7B51, 0x84C4, 0xFFFE,
	0x9010, 0x79E9, 0x7A92, 0x8336, 0x5AE1, 0x7740, 0x4E2D, 0x4EF2,
	0x5B99, 0x5FE0, 0x62BD, 0x663C, 0x67F1, 0x6CE8, 0x866B, 0x8877,
	0x8A3B, 0x914E, 0x92F3, 0x99D0, 0x6A17, 0x7026, 0x732A, 0x82E7,
	0x8457, 0x8CAF, 0x4E01, 0x5146, 0x51CB, 0x558B, 0x5BF5, 0x5E16,
	0x5E33, 0x5E81, 0x5F14, 0x5F35, 0x5F6B, 0x5FB4, 0x61F2, 0x6311,
	0x66A2, 0x671D, 0x6F6E, 0x7252, 0x753A, 0x773A, 0x8074, 0x8139,
	0x8178, 0x8776, 0x8ABF, 0x8ADC, 0x8D85, 0x8DF3, 0x929A, 0x9577,
	0x9802, 0x9CE5, 0x52C5, 0x6357, 0x76F4, 0x6715, 0x6C88, 0x73CD,
	0x8CC3, 0x93AE, 0x9673, 0x6D25, 0x589C, 0x690E, 0x69CC, 0x8FFD,
	0x939A, 0x75DB, 0x901A, 0x585A, 0x6802, 0x63B4, 0x69FB, 0x4F43,
	0x6F2C, 0x67D8, 0x8FBB, 0x8526, 0x7DB4, 0x9354, 0x693F, 0x6F70,
	0x576A, 0x58F7, 0x5B2C, 0x7D2C, 0x722A, 0x540A, 0x91E3, 0x9DB4,
	0x4EAD, 0x4F4E, 0x505C, 0x5075, 0x5243, 0x8C9E, 0x5448, 0x5824,
	0x5B9A, 0x5E1D, 0x5E95, 0x5EAD, 0x5EF7, 0x5F1F, 0x608C, 0x62B5,
	0x633A, 0x63D0, 0x68AF, 0x6C40, 0x7887, 0x798E, 0x7A0B, 0x7DE0,
	0x8247, 0x8A02, 0x8AE6, 0x8E44, 0x9013, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_93 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x90B8, 0x912D, 0x91D8, 0x9F0E, 0x6CE5, 0x6458, 0x64E2, 0x6575,
	0x6EF4, 0x7684, 0x7B1B, 0x9069, 0x93D1, 0x6EBA, 0x54F2, 0x5FB9,
	0x64A4, 0x8F4D, 0x8FED, 0x9244, 0x5178, 0x586B, 0x5929, 0x5C55,
	0x5E97, 0x6DFB, 0x7E8F, 0x751C, 0x8CBC, 0x8EE2, 0x985B, 0x70B9,
	0x4F1D, 0x6BBF, 0x6FB1, 0x7530, 0x96FB, 0x514E, 0x5410, 0x5835,
	0x5857, 0x59AC, 0x5C60, 0x5F92, 0x6597, 0x675C, 0x6E21, 0x767B,
	0x83DF, 0x8CED, 0x9014, 0x90FD, 0x934D, 0x7825, 0x783A, 0x52AA,
	0x5EA6, 0x571F, 0x5974, 0x6012, 0x5012, 0x515A, 0x51AC, 0xFFFE,
	0x51CD, 0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5B95, 0x5CF6,
	0x5D8B, 0x60BC, 0x6295, 0x642D, 0x6771, 0x6843, 0x68BC, 0x68DF,
	0x76D7, 0x6DD8, 0x6E6F, 0x6D9B, 0x706F, 0x71C8, 0x5F53, 0x75D8,
	0x7977, 0x7B49, 0x7B54, 0x7B52, 0x7CD6, 0x7D71, 0x5230, 0x8463,
	0x8569, 0x85E4, 0x8A0E, 0x8B04, 0x8C46, 0x8E0F, 0x9003, 0x900F,
	0x9419, 0x9676, 0x982D, 0x9A30, 0x95D8, 0x50CD, 0x52D5, 0x540C,
	0x5802, 0x5C0E, 0x61A7, 0x649E, 0x6D1E, 0x77B3, 0x7AE5, 0x80F4,
	0x8404, 0x9053, 0x9285, 0x5CE0, 0x9D07, 0x533F, 0x5F97, 0x5FB3,
	0x6D9C, 0x7279, 0x7763, 0x79BF, 0x7BE4, 0x6BD2, 0x72EC, 0x8AAD,
	0x6803, 0x6A61, 0x51F8, 0x7A81, 0x6934, 0x5C4A, 0x9CF6, 0x82EB,
	0x5BC5, 0x9149, 0x701E, 0x5678, 0x5C6F, 0x60C7, 0x6566, 0x6C8C,
	0x8C5A, 0x9041, 0x9813, 0x5451, 0x66C7, 0x920D, 0x5948, 0x90A3,
	0x5185, 0x4E4D, 0x51EA, 0x8599, 0x8B0E, 0x7058, 0x637A, 0x934B,
	0x6962, 0x99B4, 0x7E04, 0x7577, 0x5357, 0x6960, 0x8EDF, 0x96E3,
	0x6C5D, 0x4E8C, 0x5C3C, 0x5F10, 0x8FE9, 0x5302, 0x8CD1, 0x8089,
	0x8679, 0x5EFF, 0x65E5, 0x4E73, 0x5165, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_94 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5982, 0x5C3F, 0x97EE, 0x4EFB, 0x598A, 0x5FCD, 0x8A8D, 0x6FE1,
	0x79B0, 0x7962, 0x5BE7, 0x8471, 0x732B, 0x71B1, 0x5E74, 0x5FF5,
	0x637B, 0x649A, 0x71C3, 0x7C98, 0x4E43, 0x5EFC, 0x4E4B, 0x57DC,
	0x56A2, 0x60A9, 0x6FC3, 0x7D0D, 0x80FD, 0x8133, 0x81BF, 0x8FB2,
	0x8997, 0x86A4, 0x5DF4, 0x628A, 0x64AD, 0x8987, 0x6777, 0x6CE2,
	0x6D3E, 0x7436, 0x7834, 0x5A46, 0x7F75, 0x82AD, 0x99AC, 0x4FF3,
	0x5EC3, 0x62DD, 0x6392, 0x6557, 0x676F, 0x76C3, 0x724C, 0x80CC,
	0x80BA, 0x8F29, 0x914D, 0x500D, 0x57F9, 0x5A92, 0x6885, 0xFFFE,
	0x6973, 0x7164, 0x72FD, 0x8CB7, 0x58F2, 0x8CE0, 0x966A, 0x9019,
	0x877F, 0x79E4, 0x77E7, 0x8429, 0x4F2F, 0x5265, 0x535A, 0x62CD,
	0x67CF, 0x6CCA, 0x767D, 0x7B94, 0x7C95, 0x8236, 0x8584, 0x8FEB,
	0x66DD, 0x6F20, 0x7206, 0x7E1B, 0x83AB, 0x99C1, 0x9EA6, 0x51FD,
	0x7BB1, 0x7872, 0x7BB8, 0x8087, 0x7B48, 0x6AE8, 0x5E61, 0x808C,
	0x7551, 0x7560, 0x516B, 0x9262, 0x6E8C, 0x767A, 0x9197, 0x9AEA,
	0x4F10, 0x7F70, 0x629C, 0x7B4F, 0x95A5, 0x9CE9, 0x567A, 0x5859,
	0x86E4, 0x96BC, 0x4F34, 0x5224, 0x534A, 0x53CD, 0x53DB, 0x5E06,
	0x642C, 0x6591, 0x677F, 0x6C3E, 0x6C4E, 0x7248, 0x72AF, 0x73ED,
	0x7554, 0x7E41, 0x822C, 0x85E9, 0x8CA9, 0x7BC4, 0x91C6, 0x7169,
	0x9812, 0x98EF, 0x633D, 0x6669, 0x756A, 0x76E4, 0x78D0, 0x8543,
	0x86EE, 0x532A, 0x5351, 0x5426, 0x5983, 0x5E87, 0x5F7C, 0x60B2,
	0x6249, 0x6279, 0x62AB, 0x6590, 0x6BD4, 0x6CCC, 0x75B2, 0x76AE,
	0x7891, 0x79D8, 0x7DCB, 0x7F77, 0x80A5, 0x88AB, 0x8AB9, 0x8CBB,
	0x907F, 0x975E, 0x98DB, 0x6A0B, 0x7C38, 0x5099, 0x5C3E, 0x5FAE,
	0x6787, 0x6BD8, 0x7435, 0x7709, 0x7F8E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_95 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9F3B, 0x67CA, 0x7A17, 0x5339, 0x758B, 0x9AED, 0x5F66, 0x819D,
	0x83F1, 0x8098, 0x5F3C, 0x5FC5, 0x7562, 0x7B46, 0x903C, 0x6867,
	0x59EB, 0x5A9B, 0x7D10, 0x767E, 0x8B2C, 0x4FF5, 0x5F6A, 0x6A19,
	0x6C37, 0x6F02, 0x74E2, 0x7968, 0x8868, 0x8A55, 0x8C79, 0x5EDF,
	0x63CF, 0x75C5, 0x79D2, 0x82D7, 0x9328, 0x92F2, 0x849C, 0x86ED,
	0x9C2D, 0x54C1, 0x5F6C, 0x658C, 0x6D5C, 0x7015, 0x8CA7, 0x8CD3,
	0x983B, 0x654F, 0x74F6, 0x4E0D, 0x4ED8, 0x57E0, 0x592B, 0x5A66,
	0x5BCC, 0x51A8, 0x5E03, 0x5E9C, 0x6016, 0x6276, 0x6577, 0xFFFE,
	0x65A7, 0x666E, 0x6D6E, 0x7236, 0x7B26, 0x8150, 0x819A, 0x8299,
	0x8B5C, 0x8CA0, 0x8CE6, 0x8D74, 0x961C, 0x9644, 0x4FAE, 0x64AB,
	0x6B66, 0x821E, 0x8461, 0x856A, 0x90E8, 0x5C01, 0x6953, 0x98A8,
	0x847A, 0x8557, 0x4F0F, 0x526F, 0x5FA9, 0x5E45, 0x670D, 0x798F,
	0x8179, 0x8907, 0x8986, 0x6DF5, 0x5F17, 0x6255, 0x6CB8, 0x4ECF,
	0x7269, 0x9B92, 0x5206, 0x543B, 0x5674, 0x58B3, 0x61A4, 0x626E,
	0x711A, 0x596E, 0x7C89, 0x7CDE, 0x7D1B, 0x96F0, 0x6587, 0x805E,
	0x4E19, 0x4F75, 0x5175, 0x5840, 0x5E63, 0x5E73, 0x5F0A, 0x67C4,
	0x4E26, 0x853D, 0x9589, 0x965B, 0x7C73, 0x9801, 0x50FB, 0x58C1,
	0x7656, 0x78A7, 0x5225, 0x77A5, 0x8511, 0x7B86, 0x504F, 0x5909,
	0x7247, 0x7BC7, 0x7DE8, 0x8FBA, 0x8FD4, 0x904D, 0x4FBF, 0x52C9,
	0x5A29, 0x5F01, 0x97AD, 0x4FDD, 0x8217, 0x92EA, 0x5703, 0x6355,
	0x6B69, 0x752B, 0x88DC, 0x8F14, 0x7A42, 0x52DF, 0x5893, 0x6155,
	0x620A, 0x66AE, 0x6BCD, 0x7C3F, 0x83E9, 0x5023, 0x4FF8, 0x5305,
	0x5446, 0x5831, 0x5949, 0x5B9D, 0x5CF0, 0x5CEF, 0x5D29, 0x5E96,
	0x62B1, 0x6367, 0x653E, 0x65B9, 0x670B, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_96 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6CD5, 0x6CE1, 0x70F9, 0x7832, 0x7E2B, 0x80DE, 0x82B3, 0x840C,
	0x84EC, 0x8702, 0x8912, 0x8A2A, 0x8C4A, 0x90A6, 0x92D2, 0x98FD,
	0x9CF3, 0x9D6C, 0x4E4F, 0x4EA1, 0x508D, 0x5256, 0x574A, 0x59A8,
	0x5E3D, 0x5FD8, 0x5FD9, 0x623F, 0x66B4, 0x671B, 0x67D0, 0x68D2,
	0x5192, 0x7D21, 0x80AA, 0x81A8, 0x8B00, 0x8C8C, 0x8CBF, 0x927E,
	0x9632, 0x5420, 0x982C, 0x5317, 0x50D5, 0x535C, 0x58A8, 0x64B2,
	0x6734, 0x7267, 0x7766, 0x7A46, 0x91E6, 0x52C3, 0x6CA1, 0x6B86,
	0x5800, 0x5E4C, 0x5954, 0x672C, 0x7FFB, 0x51E1, 0x76C6, 0xFFFE,
	0x6469, 0x78E8, 0x9B54, 0x9EBB, 0x57CB, 0x59B9, 0x6627, 0x679A,
	0x6BCE, 0x54E9, 0x69D9, 0x5E55, 0x819C, 0x6795, 0x9BAA, 0x67FE,
	0x9C52, 0x685D, 0x4EA6, 0x4FE3, 0x53C8, 0x62B9, 0x672B, 0x6CAB,
	0x8FC4, 0x4FAD, 0x7E6D, 0x9EBF, 0x4E07, 0x6162, 0x6E80, 0x6F2B,
	0x8513, 0x5473, 0x672A, 0x9B45, 0x5DF3, 0x7B95, 0x5CAC, 0x5BC6,
	0x871C, 0x6E4A, 0x84D1, 0x7A14, 0x8108, 0x5999, 0x7C8D, 0x6C11,
	0x7720, 0x52D9, 0x5922, 0x7121, 0x725F, 0x77DB, 0x9727, 0x9D61,
	0x690B, 0x5A7F, 0x5A18, 0x51A5, 0x540D, 0x547D, 0x660E, 0x76DF,
	0x8FF7, 0x9298, 0x9CF4, 0x59EA, 0x725D, 0x6EC5, 0x514D, 0x68C9,
	0x7DBF, 0x7DEC, 0x9762, 0x9EBA, 0x6478, 0x6A21, 0x8302, 0x5984,
	0x5B5F, 0x6BDB, 0x731B, 0x76F2, 0x7DB2, 0x8017, 0x8499, 0x5132,
	0x6728, 0x9ED9, 0x76EE, 0x6762, 0x52FF, 0x9905, 0x5C24, 0x623B,
	0x7C7E, 0x8CB0, 0x554F, 0x60B6, 0x7D0B, 0x9580, 0x5301, 0x4E5F,
	0x51B6, 0x591C, 0x723A, 0x8036, 0x91CE, 0x5F25, 0x77E2, 0x5384,
	0x5F79, 0x7D04, 0x85AC, 0x8A33, 0x8E8D, 0x9756, 0x67F3, 0x85AE,
	0x9453, 0x6109, 0x6108, 0x6CB9, 0x7652, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_97 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AED, 0x8F38, 0x552F, 0x4F51, 0x512A, 0x52C7, 0x53CB, 0x5BA5,
	0x5E7D, 0x60A0, 0x6182, 0x63D6, 0x6709, 0x67DA, 0x6E67, 0x6D8C,
	0x7336, 0x7337, 0x7531, 0x7950, 0x88D5, 0x8A98, 0x904A, 0x9091,
	0x90F5, 0x96C4, 0x878D, 0x5915, 0x4E88, 0x4F59, 0x4E0E, 0x8A89,
	0x8F3F, 0x9810, 0x50AD, 0x5E7C, 0x5996, 0x5BB9, 0x5EB8, 0x63DA,
	0x63FA, 0x64C1, 0x66DC, 0x694A, 0x69D8, 0x6D0B, 0x6EB6, 0x7194,
	0x7528, 0x7AAF, 0x7F8A, 0x8000, 0x8449, 0x84C9, 0x8981, 0x8B21,
	0x8E0A, 0x9065, 0x967D, 0x990A, 0x617E, 0x6291, 0x6B32, 0xFFFE,
	0x6C83, 0x6D74, 0x7FCC, 0x7FFC, 0x6DC0, 0x7F85, 0x87BA, 0x88F8,
	0x6765, 0x83B1, 0x983C, 0x96F7, 0x6D1B, 0x7D61, 0x843D, 0x916A,
	0x4E71, 0x5375, 0x5D50, 0x6B04, 0x6FEB, 0x85CD, 0x862D, 0x89A7,
	0x5229, 0x540F, 0x5C65, 0x674E, 0x68A8, 0x7406, 0x7483, 0x75E2,
	0x88CF, 0x88E1, 0x91CC, 0x96E2, 0x9678, 0x5F8B, 0x7387, 0x7ACB,
	0x844E, 0x63A0, 0x7565, 0x5289, 0x6D41, 0x6E9C, 0x7409, 0x7559,
	0x786B, 0x7C92, 0x9686, 0x7ADC, 0x9F8D, 0x4FB6, 0x616E, 0x65C5,
	0x865C, 0x4E86, 0x4EAE, 0x50DA, 0x4E21, 0x51CC, 0x5BEE, 0x6599,
	0x6881, 0x6DBC, 0x731F, 0x7642, 0x77AD, 0x7A1C, 0x7CE7, 0x826F,
	0x8AD2, 0x907C, 0x91CF, 0x9675, 0x9818, 0x529B, 0x7DD1, 0x502B,
	0x5398, 0x6797, 0x6DCB, 0x71D0, 0x7433, 0x81E8, 0x8F2A, 0x96A3,
	0x9C57, 0x9E9F, 0x7460, 0x5841, 0x6D99, 0x7D2F, 0x985E, 0x4EE4,
	0x4F36, 0x4F8B, 0x51B7, 0x52B1, 0x5DBA, 0x601C, 0x73B2, 0x793C,
	0x82D3, 0x9234, 0x96B7, 0x96F6, 0x970A, 0x9E97, 0x9F62, 0x66A6,
	0x6B74, 0x5217, 0x52A3, 0x70C8, 0x88C2, 0x5EC9, 0x604B, 0x6190,
	0x6F23, 0x7149, 0x7C3E, 0x7DF4, 0x806F, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_98 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x84EE, 0x9023, 0x932C, 0x5442, 0x9B6F, 0x6AD3, 0x7089, 0x8CC2,
	0x8DEF, 0x9732, 0x52B4, 0x5A41, 0x5ECA, 0x5F04, 0x6717, 0x697C,
	0x6994, 0x6D6A, 0x6F0F, 0x7262, 0x72FC, 0x7BED, 0x8001, 0x807E,
	0x874B, 0x90CE, 0x516D, 0x9E93, 0x7984, 0x808B, 0x9332, 0x8AD6,
	0x502D, 0x548C, 0x8A71, 0x6B6A, 0x8CC4, 0x8107, 0x60D1, 0x67A0,
	0x9DF2, 0x4E99, 0x4E98, 0x9C10, 0x8A6B, 0x85C1, 0x8568, 0x6900,
	0x6E7E, 0x7897, 0x8155, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F0C,
	0x4E10, 0x4E15, 0x4E2A, 0x4E31, 0x4E36, 0x4E3C, 0x4E3F, 0x4E42,
	0x4E56, 0x4E58, 0x4E82, 0x4E85, 0x8C6B, 0x4E8A, 0x8212, 0x5F0D,
	0x4E8E, 0x4E9E, 0x4E9F, 0x4EA0, 0x4EA2, 0x4EB0, 0x4EB3, 0x4EB6,
	0x4ECE, 0x4ECD, 0x4EC4, 0x4EC6, 0x4EC2, 0x4ED7, 0x4EDE, 0x4EED,
	0x4EDF, 0x4EF7, 0x4F09, 0x4F5A, 0x4F30, 0x4F5B, 0x4F5D, 0x4F57,
	0x4F47, 0x4F76, 0x4F88, 0x4F8F, 0x4F98, 0x4F7B, 0x4F69, 0x4F70,
	0x4F91, 0x4F6F, 0x4F86, 0x4F96, 0x5118, 0x4FD4, 0x4FDF, 0x4FCE,
	0x4FD8, 0x4FDB, 0x4FD1, 0x4FDA, 0x4FD0, 0x4FE4, 0x4FE5, 0x501A,
	0x5028, 0x5014, 0x502A, 0x5025, 0x5005, 0x4F1C, 0x4FF6, 0x5021,
	0x5029, 0x502C, 0x4FFE, 0x4FEF, 0x5011, 0x5006, 0x5043, 0x5047,
	0x6703, 0x5055, 0x5050, 0x5048, 0x505A, 0x5056, 0x506C, 0x5078,
	0x5080, 0x509A, 0x5085, 0x50B4, 0x50B2, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_99 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x50C9, 0x50CA, 0x50B3, 0x50C2, 0x50D6, 0x50DE, 0x50E5, 0x50ED,
	0x50E3, 0x50EE, 0x50F9, 0x50F5, 0x5109, 0x5101, 0x5102, 0x5116,
	0x5115, 0x5114, 0x511A, 0x5121, 0x513A, 0x5137, 0x513C, 0x513B,
	0x513F, 0x5140, 0x5152, 0x514C, 0x5154, 0x5162, 0x7AF8, 0x5169,
	0x516A, 0x516E, 0x5180, 0x5182, 0x56D8, 0x518C, 0x5189, 0x518F,
	0x5191, 0x5193, 0x5195, 0x5196, 0x51A4, 0x51A6, 0x51A2, 0x51A9,
	0x51AA, 0x51AB, 0x51B3, 0x51B1, 0x51B2, 0x51B0, 0x51B5, 0x51BD,
	0x51C5, 0x51C9, 0x51DB, 0x51E0, 0x8655, 0x51E9, 0x51ED, 0xFFFE,
	0x51F0, 0x51F5, 0x51FE, 0x5204, 0x520B, 0x5214, 0x520E, 0x5227,
	0x522A, 0x522E, 0x5233, 0x5239, 0x524F, 0x5244, 0x524B, 0x524C,
	0x525E, 0x5254, 0x526A, 0x5274, 0x5269, 0x5273, 0x527F, 0x527D,
	0x528D, 0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8FA8, 0x8FA7,
	0x52AC, 0x52AD, 0x52BC, 0x52B5, 0x52C1, 0x52CD, 0x52D7, 0x52DE,
	0x52E3, 0x52E6, 0x98ED, 0x52E0, 0x52F3, 0x52F5, 0x52F8, 0x52F9,
	0x5306, 0x5308, 0x7538, 0x530D, 0x5310, 0x530F, 0x5315, 0x531A,
	0x5323, 0x532F, 0x5331, 0x5333, 0x5338, 0x5340, 0x5346, 0x5345,
	0x4E17, 0x5349, 0x534D, 0x51D6, 0x535E, 0x5369, 0x536E, 0x5918,
	0x537B, 0x5377, 0x5382, 0x5396, 0x53A0, 0x53A6, 0x53A5, 0x53AE,
	0x53B0, 0x53B6, 0x53C3, 0x7C12, 0x96D9, 0x53DF, 0x66FC, 0x71EE,
	0x53EE, 0x53E8, 0x53ED, 0x53FA, 0x5401, 0x543D, 0x5440, 0x542C,
	0x542D, 0x543C, 0x542E, 0x5436, 0x5429, 0x541D, 0x544E, 0x548F,
	0x5475, 0x548E, 0x545F, 0x5471, 0x5477, 0x5470, 0x5492, 0x547B,
	0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54C7, 0x54A2, 0x54B8,
	0x54A5, 0x54AC, 0x54C4, 0x54C8, 0x54A8, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x54AB, 0x54C2, 0x54A4, 0x54BE, 0x54BC, 0x54D8, 0x54E5, 0x54E6,
	0x550F, 0x5514, 0x54FD, 0x54EE, 0x54ED, 0x54FA, 0x54E2, 0x5539,
	0x5540, 0x5563, 0x554C, 0x552E, 0x555C, 0x5545, 0x5556, 0x5557,
	0x5538, 0x5533, 0x555D, 0x5599, 0x5580, 0x54AF, 0x558A, 0x559F,
	0x557B, 0x557E, 0x5598, 0x559E, 0x55AE, 0x557C, 0x5583, 0x55A9,
	0x5587, 0x55A8, 0x55DA, 0x55C5, 0x55DF, 0x55C4, 0x55DC, 0x55E4,
	0x55D4, 0x5614, 0x55F7, 0x5616, 0x55FE, 0x55FD, 0x561B, 0x55F9,
	0x564E, 0x5650, 0x71DF, 0x5634, 0x5636, 0x5632, 0x5638, 0xFFFE,
	0x566B, 0x5664, 0x562F, 0x566C, 0x566A, 0x5686, 0x5680, 0x568A,
	0x56A0, 0x5694, 0x568F, 0x56A5, 0x56AE, 0x56B6, 0x56B4, 0x56C2,
	0x56BC, 0x56C1, 0x56C3, 0x56C0, 0x56C8, 0x56CE, 0x56D1, 0x56D3,
	0x56D7, 0x56EE, 0x56F9, 0x5700, 0x56FF, 0x5704, 0x5709, 0x5708,
	0x570B, 0x570D, 0x5713, 0x5718, 0x5716, 0x55C7, 0x571C, 0x5726,
	0x5737, 0x5738, 0x574E, 0x573B, 0x5740, 0x574F, 0x5769, 0x57C0,
	0x5788, 0x5761, 0x577F, 0x5789, 0x5793, 0x57A0, 0x57B3, 0x57A4,
	0x57AA, 0x57B0, 0x57C3, 0x57C6, 0x57D4, 0x57D2, 0x57D3, 0x580A,
	0x57D6, 0x57E3, 0x580B, 0x5819, 0x581D, 0x5872, 0x5821, 0x5862,
	0x584B, 0x5870, 0x6BC0, 0x5852, 0x583D, 0x5879, 0x5885, 0x58B9,
	0x589F, 0x58AB, 0x58BA, 0x58DE, 0x58BB, 0x58B8, 0x58AE, 0x58C5,
	0x58D3, 0x58D1, 0x58D7, 0x58D9, 0x58D8, 0x58E5, 0x58DC, 0x58E4,
	0x58DF, 0x58EF, 0x58FA, 0x58F9, 0x58FB, 0x58FC, 0x58FD, 0x5902,
	0x590A, 0x5910, 0x591B, 0x68A6, 0x5925, 0x592C, 0x592D, 0x5932,
	0x5938, 0x593E, 0x7AD2, 0x5955, 0x5950, 0x594E, 0x595A, 0x5958,
	0x5962, 0x5960, 0x5967, 0x596C, 0x5969, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5978, 0x5981, 0x599D, 0x4F5E, 0x4FAB, 0x59A3, 0x59B2, 0x59C6,
	0x59E8, 0x59DC, 0x598D, 0x59D9, 0x59DA, 0x5A25, 0x5A1F, 0x5A11,
	0x5A1C, 0x5A09, 0x5A1A, 0x5A40, 0x5A6C, 0x5A49, 0x5A35, 0x5A36,
	0x5A62, 0x5A6A, 0x5A9A, 0x5ABC, 0x5ABE, 0x5ACB, 0x5AC2, 0x5ABD,
	0x5AE3, 0x5AD7, 0x5AE6, 0x5AE9, 0x5AD6, 0x5AFA, 0x5AFB, 0x5B0C,
	0x5B0B, 0x5B16, 0x5B32, 0x5AD0, 0x5B2A, 0x5B36, 0x5B3E, 0x5B43,
	0x5B45, 0x5B40, 0x5B51, 0x5B55, 0x5B5A, 0x5B5B, 0x5B65, 0x5B69,
	0x5B70, 0x5B73, 0x5B75, 0x5B78, 0x6588, 0x5B7A, 0x5B80, 0xFFFE,
	0x5B83, 0x5BA6, 0x5BB8, 0x5BC3, 0x5BC7, 0x5BC9, 0x5BD4, 0x5BD0,
	0x5BE4, 0x5BE6, 0x5BE2, 0x5BDE, 0x5BE5, 0x5BEB, 0x5BF0, 0x5BF6,
	0x5BF3, 0x5C05, 0x5C07, 0x5C08, 0x5C0D, 0x5C13, 0x5C20, 0x5C22,
	0x5C28, 0x5C38, 0x5C39, 0x5C41, 0x5C46, 0x5C4E, 0x5C53, 0x5C50,
	0x5C4F, 0x5B71, 0x5C6C, 0x5C6E, 0x4E62, 0x5C76, 0x5C79, 0x5C8C,
	0x5C91, 0x5C94, 0x599B, 0x5CAB, 0x5CBB, 0x5CB6, 0x5CBC, 0x5CB7,
	0x5CC5, 0x5CBE, 0x5CC7, 0x5CD9, 0x5CE9, 0x5CFD, 0x5CFA, 0x5CED,
	0x5D8C, 0x5CEA, 0x5D0B, 0x5D15, 0x5D17, 0x5D5C, 0x5D1F, 0x5D1B,
	0x5D11, 0x5D14, 0x5D22, 0x5D1A, 0x5D19, 0x5D18, 0x5D4C, 0x5D52,
	0x5D4E, 0x5D4B, 0x5D6C, 0x5D73, 0x5D76, 0x5D87, 0x5D84, 0x5D82,
	0x5DA2, 0x5D9D, 0x5DAC, 0x5DAE, 0x5DBD, 0x5D90, 0x5DB7, 0x5DBC,
	0x5DC9, 0x5DCD, 0x5DD3, 0x5DD2, 0x5DD6, 0x5DDB, 0x5DEB, 0x5DF2,
	0x5DF5, 0x5E0B, 0x5E1A, 0x5E19, 0x5E11, 0x5E1B, 0x5E36, 0x5E37,
	0x5E44, 0x5E43, 0x5E40, 0x5E4E, 0x5E57, 0x5E54, 0x5E5F, 0x5E62,
	0x5E64, 0x5E47, 0x5E75, 0x5E76, 0x5E7A, 0x9EBC, 0x5E7F, 0x5EA0,
	0x5EC1, 0x5EC2, 0x5EC8, 0x5ED0, 0x5ECF, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5ED6, 0x5EE3, 0x5EDD, 0x5EDA, 0x5EDB, 0x5EE2, 0x5EE1, 0x5EE8,
	0x5EE9, 0x5EEC, 0x5EF1, 0x5EF3, 0x5EF0, 0x5EF4, 0x5EF8, 0x5EFE,
	0x5F03, 0x5F09, 0x5F5D, 0x5F5C, 0x5F0B, 0x5F11, 0x5F16, 0x5F29,
	0x5F2D, 0x5F38, 0x5F41, 0x5F48, 0x5F4C, 0x5F4E, 0x5F2F, 0x5F51,
	0x5F56, 0x5F57, 0x5F59, 0x5F61, 0x5F6D, 0x5F73, 0x5F77, 0x5F83,
	0x5F82, 0x5F7F, 0x5F8A, 0x5F88, 0x5F91, 0x5F87, 0x5F9E, 0x5F99,
	0x5F98, 0x5FA0, 0x5FA8, 0x5FAD, 0x5FBC, 0x5FD6, 0x5FFB, 0x5FE4,
	0x5FF8, 0x5FF1, 0x5FDD, 0x60B3, 0x5FFF, 0x6021, 0x6060, 0xFFFE,
	0x6019, 0x6010, 0x6029, 0x600E, 0x6031, 0x601B, 0x6015, 0x602B,
	0x6026, 0x600F, 0x603A, 0x605A, 0x6041, 0x606A, 0x6077, 0x605F,
	0x604A, 0x6046, 0x604D, 0x6063, 0x6043, 0x6064, 0x6042, 0x606C,
	0x606B, 0x6059, 0x6081, 0x608D, 0x60E7, 0x6083, 0x609A, 0x6084,
	0x609B, 0x6096, 0x6097, 0x6092, 0x60A7, 0x608B, 0x60E1, 0x60B8,
	0x60E0, 0x60D3, 0x60B4, 0x5FF0, 0x60BD, 0x60C6, 0x60B5, 0x60D8,
	0x614D, 0x6115, 0x6106, 0x60F6, 0x60F7, 0x6100, 0x60F4, 0x60FA,
	0x6103, 0x6121, 0x60FB, 0x60F1, 0x610D, 0x610E, 0x6147, 0x613E,
	0x6128, 0x6127, 0x614A, 0x613F, 0x613C, 0x612C, 0x6134, 0x613D,
	0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159, 0x615A, 0x616B,
	0x6174, 0x616F, 0x6165, 0x6171, 0x615F, 0x615D, 0x6153, 0x6175,
	0x6199, 0x6196, 0x6187, 0x61AC, 0x6194, 0x619A, 0x618A, 0x6191,
	0x61AB, 0x61AE, 0x61CC, 0x61CA, 0x61C9, 0x61F7, 0x61C8, 0x61C3,
	0x61C6, 0x61BA, 0x61CB, 0x7F79, 0x61CD, 0x61E6, 0x61E3, 0x61F6,
	0x61FA, 0x61F4, 0x61FF, 0x61FD, 0x61FC, 0x61FE, 0x6200, 0x6208,
	0x6209, 0x620D, 0x620C, 0x6214, 0x621B, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x621E, 0x6221, 0x622A, 0x622E, 0x6230, 0x6232, 0x6233, 0x6241,
	0x624E, 0x625E, 0x6263, 0x625B, 0x6260, 0x6268, 0x627C, 0x6282,
	0x6289, 0x627E, 0x6292, 0x6293, 0x6296, 0x62D4, 0x6283, 0x6294,
	0x62D7, 0x62D1, 0x62BB, 0x62CF, 0x62FF, 0x62C6, 0x64D4, 0x62C8,
	0x62DC, 0x62CC, 0x62CA, 0x62C2, 0x62C7, 0x629B, 0x62C9, 0x630C,
	0x62EE, 0x62F1, 0x6327, 0x6302, 0x6308, 0x62EF, 0x62F5, 0x6350,
	0x633E, 0x634D, 0x641C, 0x634F, 0x6396, 0x638E, 0x6380, 0x63AB,
	0x6376, 0x63A3, 0x638F, 0x6389, 0x639F, 0x63B5, 0x636B, 0xFFFE,
	0x6369, 0x63BE, 0x63E9, 0x63C0, 0x63C6, 0x63E3, 0x63C9, 0x63D2,
	0x63F6, 0x63C4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436,
	0x651D, 0x6417, 0x6428, 0x640F, 0x6467, 0x646F, 0x6476, 0x644E,
	0x652A, 0x6495, 0x6493, 0x64A5, 0x64A9, 0x6488, 0x64BC, 0x64DA,
	0x64D2, 0x64C5, 0x64C7, 0x64BB, 0x64D8, 0x64C2, 0x64F1, 0x64E7,
	0x8209, 0x64E0, 0x64E1, 0x62AC, 0x64E3, 0x64EF, 0x652C, 0x64F6,
	0x64F4, 0x64F2, 0x64FA, 0x6500, 0x64FD, 0x6518, 0x651C, 0x6505,
	0x6524, 0x6523, 0x652B, 0x6534, 0x6535, 0x6537, 0x6536, 0x6538,
	0x754B, 0x6548, 0x6556, 0x6555, 0x654D, 0x6558, 0x655E, 0x655D,
	0x6572, 0x6578, 0x6582, 0x6583, 0x8B8A, 0x659B, 0x659F, 0x65AB,
	0x65B7, 0x65C3, 0x65C6, 0x65C1, 0x65C4, 0x65CC, 0x65D2, 0x65DB,
	0x65D9, 0x65E0, 0x65E1, 0x65F1, 0x6772, 0x660A, 0x6603, 0x65FB,
	0x6773, 0x6635, 0x6636, 0x6634, 0x661C, 0x664F, 0x6644, 0x6649,
	0x6641, 0x665E, 0x665D, 0x6664, 0x6667, 0x6668, 0x665F, 0x6662,
	0x6670, 0x6683, 0x6688, 0x668E, 0x6689, 0x6684, 0x6698, 0x669D,
	0x66C1, 0x66B9, 0x66C9, 0x66BE, 0x66BC, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x66C4, 0x66B8, 0x66D6, 0x66DA, 0x66E0, 0x663F, 0x66E6, 0x66E9,
	0x66F0, 0x66F5, 0x66F7, 0x670F, 0x6716, 0x671E, 0x6726, 0x6727,
	0x9738, 0x672E, 0x673F, 0x6736, 0x6741, 0x6738, 0x6737, 0x6746,
	0x675E, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789, 0x6770, 0x67A9,
	0x677C, 0x676A, 0x678C, 0x678B, 0x67A6, 0x67A1, 0x6785, 0x67B7,
	0x67EF, 0x67B4, 0x67EC, 0x67B3, 0x67E9, 0x67B8, 0x67E4, 0x67DE,
	0x67DD, 0x67E2, 0x67EE, 0x67B9, 0x67CE, 0x67C6, 0x67E7, 0x6A9C,
	0x681E, 0x6846, 0x6829, 0x6840, 0x684D, 0x6832, 0x684E, 0xFFFE,
	0x68B3, 0x682B, 0x6859, 0x6863, 0x6877, 0x687F, 0x689F, 0x688F,
	0x68AD, 0x6894, 0x689D, 0x689B, 0x6883, 0x6AAE, 0x68B9, 0x6874,
	0x68B5, 0x68A0, 0x68BA, 0x690F, 0x688D, 0x687E, 0x6901, 0x68CA,
	0x6908, 0x68D8, 0x6922, 0x6926, 0x68E1, 0x690C, 0x68CD, 0x68D4,
	0x68E7, 0x68D5, 0x6936, 0x6912, 0x6904, 0x68D7, 0x68E3, 0x6925,
	0x68F9, 0x68E0, 0x68EF, 0x6928, 0x692A, 0x691A, 0x6923, 0x6921,
	0x68C6, 0x6979, 0x6977, 0x695C, 0x6978, 0x696B, 0x6954, 0x697E,
	0x696E, 0x6939, 0x6974, 0x693D, 0x6959, 0x6930, 0x6961, 0x695E,
	0x695D, 0x6981, 0x696A, 0x69B2, 0x69AE, 0x69D0, 0x69BF, 0x69C1,
	0x69D3, 0x69BE, 0x69CE, 0x5BE8, 0x69CA, 0x69DD, 0x69BB, 0x69C3,
	0x69A7, 0x6A2E, 0x6991, 0x69A0, 0x699C, 0x6995, 0x69B4, 0x69DE,
	0x69E8, 0x6A02, 0x6A1B, 0x69FF, 0x6B0A, 0x69F9, 0x69F2, 0x69E7,
	0x6A05, 0x69B1, 0x6A1E, 0x69ED, 0x6A14, 0x69EB, 0x6A0A, 0x6A12,
	0x6AC1, 0x6A23, 0x6A13, 0x6A44, 0x6A0C, 0x6A72, 0x6A36, 0x6A78,
	0x6A47, 0x6A62, 0x6A59, 0x6A66, 0x6A48, 0x6A38, 0x6A22, 0x6A90,
	0x6A8D, 0x6AA0, 0x6A84, 0x6AA2, 0x6AA3, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_9F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A97, 0x8617, 0x6ABB, 0x6AC3, 0x6AC2, 0x6AB8, 0x6AB3, 0x6AAC,
	0x6ADE, 0x6AD1, 0x6ADF, 0x6AAA, 0x6ADA, 0x6AEA, 0x6AFB, 0x6B05,
	0x8616, 0x6AFA, 0x6B12, 0x6B16, 0x9B31, 0x6B1F, 0x6B38, 0x6B37,
	0x76DC, 0x6B39, 0x98EE, 0x6B47, 0x6B43, 0x6B49, 0x6B50, 0x6B59,
	0x6B54, 0x6B5B, 0x6B5F, 0x6B61, 0x6B78, 0x6B79, 0x6B7F, 0x6B80,
	0x6B84, 0x6B83, 0x6B8D, 0x6B98, 0x6B95, 0x6B9E, 0x6BA4, 0x6BAA,
	0x6BAB, 0x6BAF, 0x6BB2, 0x6BB1, 0x6BB3, 0x6BB7, 0x6BBC, 0x6BC6,
	0x6BCB, 0x6BD3, 0x6BDF, 0x6BEC, 0x6BEB, 0x6BF3, 0x6BEF, 0xFFFE,
	0x9EBE, 0x6C08, 0x6C13, 0x6C14, 0x6C1B, 0x6C24, 0x6C23, 0x6C5E,
	0x6C55, 0x6C62, 0x6C6A, 0x6C82, 0x6C8D, 0x6C9A, 0x6C81, 0x6C9B,
	0x6C7E, 0x6C68, 0x6C73, 0x6C92, 0x6C90, 0x6CC4, 0x6CF1, 0x6CD3,
	0x6CBD, 0x6CD7, 0x6CC5, 0x6CDD, 0x6CAE, 0x6CB1, 0x6CBE, 0x6CBA,
	0x6CDB, 0x6CEF, 0x6CD9, 0x6CEA, 0x6D1F, 0x884D, 0x6D36, 0x6D2B,
	0x6D3D, 0x6D38, 0x6D19, 0x6D35, 0x6D33, 0x6D12, 0x6D0C, 0x6D63,
	0x6D93, 0x6D64, 0x6D5A, 0x6D79, 0x6D59, 0x6D8E, 0x6D95, 0x6FE4,
	0x6D85, 0x6DF9, 0x6E15, 0x6E0A, 0x6DB5, 0x6DC7, 0x6DE6, 0x6DB8,
	0x6DC6, 0x6DEC, 0x6DDE, 0x6DCC, 0x6DE8, 0x6DD2, 0x6DC5, 0x6DFA,
	0x6DD9, 0x6DE4, 0x6DD5, 0x6DEA, 0x6DEE, 0x6E2D, 0x6E6E, 0x6E2E,
	0x6E19, 0x6E72, 0x6E5F, 0x6E3E, 0x6E23, 0x6E6B, 0x6E2B, 0x6E76,
	0x6E4D, 0x6E1F, 0x6E43, 0x6E3A, 0x6E4E, 0x6E24, 0x6EFF, 0x6E1D,
	0x6E38, 0x6E82, 0x6EAA, 0x6E98, 0x6EC9, 0x6EB7, 0x6ED3, 0x6EBD,
	0x6EAF, 0x6EC4, 0x6EB2, 0x6ED4, 0x6ED5, 0x6E8F, 0x6EA5, 0x6EC2,
	0x6E9F, 0x6F41, 0x6F11, 0x704C, 0x6EEC, 0x6EF8, 0x6EFE, 0x6F3F,
	0x6EF2, 0x6F31, 0x6EEF, 0x6F32, 0x6ECC, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E0 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6F3E, 0x6F13, 0x6EF7, 0x6F86, 0x6F7A, 0x6F78, 0x6F81, 0x6F80,
	0x6F6F, 0x6F5B, 0x6FF3, 0x6F6D, 0x6F82, 0x6F7C, 0x6F58, 0x6F8E,
	0x6F91, 0x6FC2, 0x6F66, 0x6FB3, 0x6FA3, 0x6FA1, 0x6FA4, 0x6FB9,
	0x6FC6, 0x6FAA, 0x6FDF, 0x6FD5, 0x6FEC, 0x6FD4, 0x6FD8, 0x6FF1,
	0x6FEE, 0x6FDB, 0x7009, 0x700B, 0x6FFA, 0x7011, 0x7001, 0x700F,
	0x6FFE, 0x701B, 0x701A, 0x6F74, 0x701D, 0x7018, 0x701F, 0x7030,
	0x703E, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092, 0x70AF, 0x70F1,
	0x70AC, 0x70B8, 0x70B3, 0x70AE, 0x70DF, 0x70CB, 0x70DD, 0xFFFE,
	0x70D9, 0x7109, 0x70FD, 0x711C, 0x7119, 0x7165, 0x7155, 0x7188,
	0x7166, 0x7162, 0x714C, 0x7156, 0x716C, 0x718F, 0x71FB, 0x7184,
	0x7195, 0x71A8, 0x71AC, 0x71D7, 0x71B9, 0x71BE, 0x71D2, 0x71C9,
	0x71D4, 0x71CE, 0x71E0, 0x71EC, 0x71E7, 0x71F5, 0x71FC, 0x71F9,
	0x71FF, 0x720D, 0x7210, 0x721B, 0x7228, 0x722D, 0x722C, 0x7230,
	0x7232, 0x723B, 0x723C, 0x723F, 0x7240, 0x7246, 0x724B, 0x7258,
	0x7274, 0x727E, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296, 0x72A2,
	0x72A7, 0x72B9, 0x72B2, 0x72C3, 0x72C6, 0x72C4, 0x72CE, 0x72D2,
	0x72E2, 0x72E0, 0x72E1, 0x72F9, 0x72F7, 0x500F, 0x7317, 0x730A,
	0x731C, 0x7316, 0x731D, 0x7334, 0x732F, 0x7329, 0x7325, 0x733E,
	0x734E, 0x734F, 0x9ED8, 0x7357, 0x736A, 0x7368, 0x7370, 0x7378,
	0x7375, 0x737B, 0x737A, 0x73C8, 0x73B3, 0x73CE, 0x73BB, 0x73C0,
	0x73E5, 0x73EE, 0x73DE, 0x74A2, 0x7405, 0x746F, 0x7425, 0x73F8,
	0x7432, 0x743A, 0x7455, 0x743F, 0x745F, 0x7459, 0x7441, 0x745C,
	0x7469, 0x7470, 0x7463, 0x746A, 0x7476, 0x747E, 0x748B, 0x749E,
	0x74A7, 0x74CA, 0x74CF, 0x74D4, 0x73F1, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E1 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x74E0, 0x74E3, 0x74E7, 0x74E9, 0x74EE, 0x74F2, 0x74F0, 0x74F1,
	0x74F8, 0x74F7, 0x7504, 0x7503, 0x7505, 0x750C, 0x750E, 0x750D,
	0x7515, 0x7513, 0x751E, 0x7526, 0x752C, 0x753C, 0x7544, 0x754D,
	0x754A, 0x7549, 0x755B, 0x7546, 0x755A, 0x7569, 0x7564, 0x7567,
	0x756B, 0x756D, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758A,
	0x7589, 0x7582, 0x7594, 0x759A, 0x759D, 0x75A5, 0x75A3, 0x75C2,
	0x75B3, 0x75C3, 0x75B5, 0x75BD, 0x75B8, 0x75BC, 0x75B1, 0x75CD,
	0x75CA, 0x75D2, 0x75D9, 0x75E3, 0x75DE, 0x75FE, 0x75FF, 0xFFFE,
	0x75FC, 0x7601, 0x75F0, 0x75FA, 0x75F2, 0x75F3, 0x760B, 0x760D,
	0x7609, 0x761F, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634,
	0x7630, 0x763B, 0x7647, 0x7648, 0x7646, 0x765C, 0x7658, 0x7661,
	0x7662, 0x7668, 0x7669, 0x766A, 0x7667, 0x766C, 0x7670, 0x7672,
	0x7676, 0x7678, 0x767C, 0x7680, 0x7683, 0x7688, 0x768B, 0x768E,
	0x7696, 0x7693, 0x7699, 0x769A, 0x76B0, 0x76B4, 0x76B8, 0x76B9,
	0x76BA, 0x76C2, 0x76CD, 0x76D6, 0x76D2, 0x76DE, 0x76E1, 0x76E5,
	0x76E7, 0x76EA, 0x862F, 0x76FB, 0x7708, 0x7707, 0x7704, 0x7729,
	0x7724, 0x771E, 0x7725, 0x7726, 0x771B, 0x7737, 0x7738, 0x7747,
	0x775A, 0x7768, 0x776B, 0x775B, 0x7765, 0x777F, 0x777E, 0x7779,
	0x778E, 0x778B, 0x7791, 0x77A0, 0x779E, 0x77B0, 0x77B6, 0x77B9,
	0x77BF, 0x77BC, 0x77BD, 0x77BB, 0x77C7, 0x77CD, 0x77D7, 0x77DA,
	0x77DC, 0x77E3, 0x77EE, 0x77FC, 0x780C, 0x7812, 0x7926, 0x7820,
	0x792A, 0x7845, 0x788E, 0x7874, 0x7886, 0x787C, 0x789A, 0x788C,
	0x78A3, 0x78B5, 0x78AA, 0x78AF, 0x78D1, 0x78C6, 0x78CB, 0x78D4,
	0x78BE, 0x78BC, 0x78C5, 0x78CA, 0x78EC, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E2 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x78E7, 0x78DA, 0x78FD, 0x78F4, 0x7907, 0x7912, 0x7911, 0x7919,
	0x792C, 0x792B, 0x7940, 0x7960, 0x7957, 0x795F, 0x795A, 0x7955,
	0x7953, 0x797A, 0x797F, 0x798A, 0x799D, 0x79A7, 0x9F4B, 0x79AA,
	0x79AE, 0x79B3, 0x79B9, 0x79BA, 0x79C9, 0x79D5, 0x79E7, 0x79EC,
	0x79E1, 0x79E3, 0x7A08, 0x7A0D, 0x7A18, 0x7A19, 0x7A20, 0x7A1F,
	0x7980, 0x7A31, 0x7A3B, 0x7A3E, 0x7A37, 0x7A43, 0x7A57, 0x7A49,
	0x7A61, 0x7A62, 0x7A69, 0x9F9D, 0x7A70, 0x7A79, 0x7A7D, 0x7A88,
	0x7A97, 0x7A95, 0x7A98, 0x7A96, 0x7AA9, 0x7AC8, 0x7AB0, 0xFFFE,
	0x7AB6, 0x7AC5, 0x7AC4, 0x7ABF, 0x9083, 0x7AC7, 0x7ACA, 0x7ACD,
	0x7ACF, 0x7AD5, 0x7AD3, 0x7AD9, 0x7ADA, 0x7ADD, 0x7AE1, 0x7AE2,
	0x7AE6, 0x7AED, 0x7AF0, 0x7B02, 0x7B0F, 0x7B0A, 0x7B06, 0x7B33,
	0x7B18, 0x7B19, 0x7B1E, 0x7B35, 0x7B28, 0x7B36, 0x7B50, 0x7B7A,
	0x7B04, 0x7B4D, 0x7B0B, 0x7B4C, 0x7B45, 0x7B75, 0x7B65, 0x7B74,
	0x7B67, 0x7B70, 0x7B71, 0x7B6C, 0x7B6E, 0x7B9D, 0x7B98, 0x7B9F,
	0x7B8D, 0x7B9C, 0x7B9A, 0x7B8B, 0x7B92, 0x7B8F, 0x7B5D, 0x7B99,
	0x7BCB, 0x7BC1, 0x7BCC, 0x7BCF, 0x7BB4, 0x7BC6, 0x7BDD, 0x7BE9,
	0x7C11, 0x7C14, 0x7BE6, 0x7BE5, 0x7C60, 0x7C00, 0x7C07, 0x7C13,
	0x7BF3, 0x7BF7, 0x7C17, 0x7C0D, 0x7BF6, 0x7C23, 0x7C27, 0x7C2A,
	0x7C1F, 0x7C37, 0x7C2B, 0x7C3D, 0x7C4C, 0x7C43, 0x7C54, 0x7C4F,
	0x7C40, 0x7C50, 0x7C58, 0x7C5F, 0x7C64, 0x7C56, 0x7C65, 0x7C6C,
	0x7C75, 0x7C83, 0x7C90, 0x7CA4, 0x7CAD, 0x7CA2, 0x7CAB, 0x7CA1,
	0x7CA8, 0x7CB3, 0x7CB2, 0x7CB1, 0x7CAE, 0x7CB9, 0x7CBD, 0x7CC0,
	0x7CC5, 0x7CC2, 0x7CD8, 0x7CD2, 0x7CDC, 0x7CE2, 0x9B3B, 0x7CEF,
	0x7CF2, 0x7CF4, 0x7CF6, 0x7CFA, 0x7D06, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E3 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7D02, 0x7D1C, 0x7D15, 0x7D0A, 0x7D45, 0x7D4B, 0x7D2E, 0x7D32,
	0x7D3F, 0x7D35, 0x7D46, 0x7D73, 0x7D56, 0x7D4E, 0x7D72, 0x7D68,
	0x7D6E, 0x7D4F, 0x7D63, 0x7D93, 0x7D89, 0x7D5B, 0x7D8F, 0x7D7D,
	0x7D9B, 0x7DBA, 0x7DAE, 0x7DA3, 0x7DB5, 0x7DC7, 0x7DBD, 0x7DAB,
	0x7E3D, 0x7DA2, 0x7DAF, 0x7DDC, 0x7DB8, 0x7D9F, 0x7DB0, 0x7DD8,
	0x7DDD, 0x7DE4, 0x7DDE, 0x7DFB, 0x7DF2, 0x7DE1, 0x7E05, 0x7E0A,
	0x7E23, 0x7E21, 0x7E12, 0x7E31, 0x7E1F, 0x7E09, 0x7E0B, 0x7E22,
	0x7E46, 0x7E66, 0x7E3B, 0x7E35, 0x7E39, 0x7E43, 0x7E37, 0xFFFE,
	0x7E32, 0x7E3A, 0x7E67, 0x7E5D, 0x7E56, 0x7E5E, 0x7E59, 0x7E5A,
	0x7E79, 0x7E6A, 0x7E69, 0x7E7C, 0x7E7B, 0x7E83, 0x7DD5, 0x7E7D,
	0x8FAE, 0x7E7F, 0x7E88, 0x7E89, 0x7E8C, 0x7E92, 0x7E90, 0x7E93,
	0x7E94, 0x7E96, 0x7E8E, 0x7E9B, 0x7E9C, 0x7F38, 0x7F3A, 0x7F45,
	0x7F4C, 0x7F4D, 0x7F4E, 0x7F50, 0x7F51, 0x7F55, 0x7F54, 0x7F58,
	0x7F5F, 0x7F60, 0x7F68, 0x7F69, 0x7F67, 0x7F78, 0x7F82, 0x7F86,
	0x7F83, 0x7F88, 0x7F87, 0x7F8C, 0x7F94, 0x7F9E, 0x7F9D, 0x7F9A,
	0x7FA3, 0x7FAF, 0x7FB2, 0x7FB9, 0x7FAE, 0x7FB6, 0x7FB8, 0x8B71,
	0x7FC5, 0x7FC6, 0x7FCA, 0x7FD5, 0x7FD4, 0x7FE1, 0x7FE6, 0x7FE9,
	0x7FF3, 0x7FF9, 0x98DC, 0x8006, 0x8004, 0x800B, 0x8012, 0x8018,
	0x8019, 0x801C, 0x8021, 0x8028, 0x803F, 0x803B, 0x804A, 0x8046,
	0x8052, 0x8058, 0x805A, 0x805F, 0x8062, 0x8068, 0x8073, 0x8072,
	0x8070, 0x8076, 0x8079, 0x807D, 0x807F, 0x8084, 0x8086, 0x8085,
	0x809B, 0x8093, 0x809A, 0x80AD, 0x5190, 0x80AC, 0x80DB, 0x80E5,
	0x80D9, 0x80DD, 0x80C4, 0x80DA, 0x80D6, 0x8109, 0x80EF, 0x80F1,
	0x811B, 0x8129, 0x8123, 0x812F, 0x814B, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E4 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x968B, 0x8146, 0x813E, 0x8153, 0x8151, 0x80FC, 0x8171, 0x816E,
	0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818A, 0x8180, 0x8182,
	0x81A0, 0x8195, 0x81A4, 0x81A3, 0x815F, 0x8193, 0x81A9, 0x81B0,
	0x81B5, 0x81BE, 0x81B8, 0x81BD, 0x81C0, 0x81C2, 0x81BA, 0x81C9,
	0x81CD, 0x81D1, 0x81D9, 0x81D8, 0x81C8, 0x81DA, 0x81DF, 0x81E0,
	0x81E7, 0x81FA, 0x81FB, 0x81FE, 0x8201, 0x8202, 0x8205, 0x8207,
	0x820A, 0x820D, 0x8210, 0x8216, 0x8229, 0x822B, 0x8238, 0x8233,
	0x8240, 0x8259, 0x8258, 0x825D, 0x825A, 0x825F, 0x8264, 0xFFFE,
	0x8262, 0x8268, 0x826A, 0x826B, 0x822E, 0x8271, 0x8277, 0x8278,
	0x827E, 0x828D, 0x8292, 0x82AB, 0x829F, 0x82BB, 0x82AC, 0x82E1,
	0x82E3, 0x82DF, 0x82D2, 0x82F4, 0x82F3, 0x82FA, 0x8393, 0x8303,
	0x82FB, 0x82F9, 0x82DE, 0x8306, 0x82DC, 0x8309, 0x82D9, 0x8335,
	0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345,
	0x832F, 0x832B, 0x8317, 0x8318, 0x8385, 0x839A, 0x83AA, 0x839F,
	0x83A2, 0x8396, 0x8323, 0x838E, 0x8387, 0x838A, 0x837C, 0x83B5,
	0x8373, 0x8375, 0x83A0, 0x8389, 0x83A8, 0x83F4, 0x8413, 0x83EB,
	0x83CE, 0x83FD, 0x8403, 0x83D8, 0x840B, 0x83C1, 0x83F7, 0x8407,
	0x83E0, 0x83F2, 0x840D, 0x8422, 0x8420, 0x83BD, 0x8438, 0x8506,
	0x83FB, 0x846D, 0x842A, 0x843C, 0x855A, 0x8484, 0x8477, 0x846B,
	0x84AD, 0x846E, 0x8482, 0x8469, 0x8446, 0x842C, 0x846F, 0x8479,
	0x8435, 0x84CA, 0x8462, 0x84B9, 0x84BF, 0x849F, 0x84D9, 0x84CD,
	0x84BB, 0x84DA, 0x84D0, 0x84C1, 0x84C6, 0x84D6, 0x84A1, 0x8521,
	0x84FF, 0x84F4, 0x8517, 0x8518, 0x852C, 0x851F, 0x8515, 0x8514,
	0x84FC, 0x8540, 0x8563, 0x8558, 0x8548, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E5 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8541, 0x8602, 0x854B, 0x8555, 0x8580, 0x85A4, 0x8588, 0x8591,
	0x858A, 0x85A8, 0x856D, 0x8594, 0x859B, 0x85EA, 0x8587, 0x859C,
	0x8577, 0x857E, 0x8590, 0x85C9, 0x85BA, 0x85CF, 0x85B9, 0x85D0,
	0x85D5, 0x85DD, 0x85E5, 0x85DC, 0x85F9, 0x860A, 0x8613, 0x860B,
	0x85FE, 0x85FA, 0x8606, 0x8622, 0x861A, 0x8630, 0x863F, 0x864D,
	0x4E55, 0x8654, 0x865F, 0x8667, 0x8671, 0x8693, 0x86A3, 0x86A9,
	0x86AA, 0x868B, 0x868C, 0x86B6, 0x86AF, 0x86C4, 0x86C6, 0x86B0,
	0x86C9, 0x8823, 0x86AB, 0x86D4, 0x86DE, 0x86E9, 0x86EC, 0xFFFE,
	0x86DF, 0x86DB, 0x86EF, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703,
	0x86FB, 0x8711, 0x8709, 0x870D, 0x86F9, 0x870A, 0x8734, 0x873F,
	0x8737, 0x873B, 0x8725, 0x8729, 0x871A, 0x8760, 0x875F, 0x8778,
	0x874C, 0x874E, 0x8774, 0x8757, 0x8768, 0x876E, 0x8759, 0x8753,
	0x8763, 0x876A, 0x8805, 0x87A2, 0x879F, 0x8782, 0x87AF, 0x87CB,
	0x87BD, 0x87C0, 0x87D0, 0x96D6, 0x87AB, 0x87C4, 0x87B3, 0x87C7,
	0x87C6, 0x87BB, 0x87EF, 0x87F2, 0x87E0, 0x880F, 0x880D, 0x87FE,
	0x87F6, 0x87F7, 0x880E, 0x87D2, 0x8811, 0x8816, 0x8815, 0x8822,
	0x8821, 0x8831, 0x8836, 0x8839, 0x8827, 0x883B, 0x8844, 0x8842,
	0x8852, 0x8859, 0x885E, 0x8862, 0x886B, 0x8881, 0x887E, 0x889E,
	0x8875, 0x887D, 0x88B5, 0x8872, 0x8882, 0x8897, 0x8892, 0x88AE,
	0x8899, 0x88A2, 0x888D, 0x88A4, 0x88B0, 0x88BF, 0x88B1, 0x88C3,
	0x88C4, 0x88D4, 0x88D8, 0x88D9, 0x88DD, 0x88F9, 0x8902, 0x88FC,
	0x88F4, 0x88E8, 0x88F2, 0x8904, 0x890C, 0x890A, 0x8913, 0x8943,
	0x891E, 0x8925, 0x892A, 0x892B, 0x8941, 0x8944, 0x893B, 0x8936,
	0x8938, 0x894C, 0x891D, 0x8960, 0x895E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E6 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8966, 0x8964, 0x896D, 0x896A, 0x896F, 0x8974, 0x8977, 0x897E,
	0x8983, 0x8988, 0x898A, 0x8993, 0x8998, 0x89A1, 0x89A9, 0x89A6,
	0x89AC, 0x89AF, 0x89B2, 0x89BA, 0x89BD, 0x89BF, 0x89C0, 0x89DA,
	0x89DC, 0x89DD, 0x89E7, 0x89F4, 0x89F8, 0x8A03, 0x8A16, 0x8A10,
	0x8A0C, 0x8A1B, 0x8A1D, 0x8A25, 0x8A36, 0x8A41, 0x8A5B, 0x8A52,
	0x8A46, 0x8A48, 0x8A7C, 0x8A6D, 0x8A6C, 0x8A62, 0x8A85, 0x8A82,
	0x8A84, 0x8AA8, 0x8AA1, 0x8A91, 0x8AA5, 0x8AA6, 0x8A9A, 0x8AA3,
	0x8AC4, 0x8ACD, 0x8AC2, 0x8ADA, 0x8AEB, 0x8AF3, 0x8AE7, 0xFFFE,
	0x8AE4, 0x8AF1, 0x8B14, 0x8AE0, 0x8AE2, 0x8AF7, 0x8ADE, 0x8ADB,
	0x8B0C, 0x8B07, 0x8B1A, 0x8AE1, 0x8B16, 0x8B10, 0x8B17, 0x8B20,
	0x8B33, 0x97AB, 0x8B26, 0x8B2B, 0x8B3E, 0x8B28, 0x8B41, 0x8B4C,
	0x8B4F, 0x8B4E, 0x8B49, 0x8B56, 0x8B5B, 0x8B5A, 0x8B6B, 0x8B5F,
	0x8B6C, 0x8B6F, 0x8B74, 0x8B7D, 0x8B80, 0x8B8C, 0x8B8E, 0x8B92,
	0x8B93, 0x8B96, 0x8B99, 0x8B9A, 0x8C3A, 0x8C41, 0x8C3F, 0x8C48,
	0x8C4C, 0x8C4E, 0x8C50, 0x8C55, 0x8C62, 0x8C6C, 0x8C78, 0x8C7A,
	0x8C82, 0x8C89, 0x8C85, 0x8C8A, 0x8C8D, 0x8C8E, 0x8C94, 0x8C7C,
	0x8C98, 0x621D, 0x8CAD, 0x8CAA, 0x8CBD, 0x8CB2, 0x8CB3, 0x8CAE,
	0x8CB6, 0x8CC8, 0x8CC1, 0x8CE4, 0x8CE3, 0x8CDA, 0x8CFD, 0x8CFA,
	0x8CFB, 0x8D04, 0x8D05, 0x8D0A, 0x8D07, 0x8D0F, 0x8D0D, 0x8D10,
	0x9F4E, 0x8D13, 0x8CCD, 0x8D14, 0x8D16, 0x8D67, 0x8D6D, 0x8D71,
	0x8D73, 0x8D81, 0x8D99, 0x8DC2, 0x8DBE, 0x8DBA, 0x8DCF, 0x8DDA,
	0x8DD6, 0x8DCC, 0x8DDB, 0x8DCB, 0x8DEA, 0x8DEB, 0x8DDF, 0x8DE3,
	0x8DFC, 0x8E08, 0x8E09, 0x8DFF, 0x8E1D, 0x8E1E, 0x8E10, 0x8E1F,
	0x8E42, 0x8E35, 0x8E30, 0x8E34, 0x8E4A, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E7 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8E47, 0x8E49, 0x8E4C, 0x8E50, 0x8E48, 0x8E59, 0x8E64, 0x8E60,
	0x8E2A, 0x8E63, 0x8E55, 0x8E76, 0x8E72, 0x8E7C, 0x8E81, 0x8E87,
	0x8E85, 0x8E84, 0x8E8B, 0x8E8A, 0x8E93, 0x8E91, 0x8E94, 0x8E99,
	0x8EAA, 0x8EA1, 0x8EAC, 0x8EB0, 0x8EC6, 0x8EB1, 0x8EBE, 0x8EC5,
	0x8EC8, 0x8ECB, 0x8EDB, 0x8EE3, 0x8EFC, 0x8EFB, 0x8EEB, 0x8EFE,
	0x8F0A, 0x8F05, 0x8F15, 0x8F12, 0x8F19, 0x8F13, 0x8F1C, 0x8F1F,
	0x8F1B, 0x8F0C, 0x8F26, 0x8F33, 0x8F3B, 0x8F39, 0x8F45, 0x8F42,
	0x8F3E, 0x8F4C, 0x8F49, 0x8F46, 0x8F4E, 0x8F57, 0x8F5C, 0xFFFE,
	0x8F62, 0x8F63, 0x8F64, 0x8F9C, 0x8F9F, 0x8FA3, 0x8FAD, 0x8FAF,
	0x8FB7, 0x8FDA, 0x8FE5, 0x8FE2, 0x8FEA, 0x8FEF, 0x9087, 0x8FF4,
	0x9005, 0x8FF9, 0x8FFA, 0x9011, 0x9015, 0x9021, 0x900D, 0x901E,
	0x9016, 0x900B, 0x9027, 0x9036, 0x9035, 0x9039, 0x8FF8, 0x904F,
	0x9050, 0x9051, 0x9052, 0x900E, 0x9049, 0x903E, 0x9056, 0x9058,
	0x905E, 0x9068, 0x906F, 0x9076, 0x96A8, 0x9072, 0x9082, 0x907D,
	0x9081, 0x9080, 0x908A, 0x9089, 0x908F, 0x90A8, 0x90AF, 0x90B1,
	0x90B5, 0x90E2, 0x90E4, 0x6248, 0x90DB, 0x9102, 0x9112, 0x9119,
	0x9132, 0x9130, 0x914A, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169,
	0x9173, 0x9172, 0x918B, 0x9189, 0x9182, 0x91A2, 0x91AB, 0x91AF,
	0x91AA, 0x91B5, 0x91B4, 0x91BA, 0x91C0, 0x91C1, 0x91C9, 0x91CB,
	0x91D0, 0x91D6, 0x91DF, 0x91E1, 0x91DB, 0x91FC, 0x91F5, 0x91F6,
	0x921E, 0x91FF, 0x9214, 0x922C, 0x9215, 0x9211, 0x925E, 0x9257,
	0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923F, 0x924B, 0x9250,
	0x929C, 0x9296, 0x9293, 0x929B, 0x925A, 0x92CF, 0x92B9, 0x92B7,
	0x92E9, 0x930F, 0x92FA, 0x9344, 0x932E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E8 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9319, 0x9322, 0x931A, 0x9323, 0x933A, 0x9335, 0x933B, 0x935C,
	0x9360, 0x937C, 0x936E, 0x9356, 0x93B0, 0x93AC, 0x93AD, 0x9394,
	0x93B9, 0x93D6, 0x93D7, 0x93E8, 0x93E5, 0x93D8, 0x93C3, 0x93DD,
	0x93D0, 0x93C8, 0x93E4, 0x941A, 0x9414, 0x9413, 0x9403, 0x9407,
	0x9410, 0x9436, 0x942B, 0x9435, 0x9421, 0x943A, 0x9441, 0x9452,
	0x9444, 0x945B, 0x9460, 0x9462, 0x945E, 0x946A, 0x9229, 0x9470,
	0x9475, 0x9477, 0x947D, 0x945A, 0x947C, 0x947E, 0x9481, 0x947F,
	0x9582, 0x9587, 0x958A, 0x9594, 0x9596, 0x9598, 0x9599, 0xFFFE,
	0x95A0, 0x95A8, 0x95A7, 0x95AD, 0x95BC, 0x95BB, 0x95B9, 0x95BE,
	0x95CA, 0x6FF6, 0x95C3, 0x95CD, 0x95CC, 0x95D5, 0x95D4, 0x95D6,
	0x95DC, 0x95E1, 0x95E5, 0x95E2, 0x9621, 0x9628, 0x962E, 0x962F,
	0x9642, 0x964C, 0x964F, 0x964B, 0x9677, 0x965C, 0x965E, 0x965D,
	0x965F, 0x9666, 0x9672, 0x966C, 0x968D, 0x9698, 0x9695, 0x9697,
	0x96AA, 0x96A7, 0x96B1, 0x96B2, 0x96B0, 0x96B4, 0x96B6, 0x96B8,
	0x96B9, 0x96CE, 0x96CB, 0x96C9, 0x96CD, 0x894D, 0x96DC, 0x970D,
	0x96D5, 0x96F9, 0x9704, 0x9706, 0x9708, 0x9713, 0x970E, 0x9711,
	0x970F, 0x9716, 0x9719, 0x9724, 0x972A, 0x9730, 0x9739, 0x973D,
	0x973E, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749, 0x975C, 0x9760,
	0x9764, 0x9766, 0x9768, 0x52D2, 0x976B, 0x9771, 0x9779, 0x9785,
	0x977C, 0x9781, 0x977A, 0x9786, 0x978B, 0x978F, 0x9790, 0x979C,
	0x97A8, 0x97A6, 0x97A3, 0x97B3, 0x97B4, 0x97C3, 0x97C6, 0x97C8,
	0x97CB, 0x97DC, 0x97ED, 0x9F4F, 0x97F2, 0x7ADF, 0x97F6, 0x97F5,
	0x980F, 0x980C, 0x9838, 0x9824, 0x9821, 0x9837, 0x983D, 0x9846,
	0x984F, 0x984B, 0x986B, 0x986F, 0x9870, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_E9 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9871, 0x9874, 0x9873, 0x98AA, 0x98AF, 0x98B1, 0x98B6, 0x98C4,
	0x98C3, 0x98C6, 0x98E9, 0x98EB, 0x9903, 0x9909, 0x9912, 0x9914,
	0x9918, 0x9921, 0x991D, 0x991E, 0x9924, 0x9920, 0x992C, 0x992E,
	0x993D, 0x993E, 0x9942, 0x9949, 0x9945, 0x9950, 0x994B, 0x9951,
	0x9952, 0x994C, 0x9955, 0x9997, 0x9998, 0x99A5, 0x99AD, 0x99AE,
	0x99BC, 0x99DF, 0x99DB, 0x99DD, 0x99D8, 0x99D1, 0x99ED, 0x99EE,
	0x99F1, 0x99F2, 0x99FB, 0x99F8, 0x9A01, 0x9A0F, 0x9A05, 0x99E2,
	0x9A19, 0x9A2B, 0x9A37, 0x9A45, 0x9A42, 0x9A40, 0x9A43, 0xFFFE,
	0x9A3E, 0x9A55, 0x9A4D, 0x9A5B, 0x9A57, 0x9A5F, 0x9A62, 0x9A65,
	0x9A64, 0x9A69, 0x9A6B, 0x9A6A, 0x9AAD, 0x9AB0, 0x9ABC, 0x9AC0,
	0x9ACF, 0x9AD1, 0x9AD3, 0x9AD4, 0x9ADE, 0x9ADF, 0x9AE2, 0x9AE3,
	0x9AE6, 0x9AEF, 0x9AEB, 0x9AEE, 0x9AF4, 0x9AF1, 0x9AF7, 0x9AFB,
	0x9B06, 0x9B18, 0x9B1A, 0x9B1F, 0x9B22, 0x9B23, 0x9B25, 0x9B27,
	0x9B28, 0x9B29, 0x9B2A, 0x9B2E, 0x9B2F, 0x9B32, 0x9B44, 0x9B43,
	0x9B4F, 0x9B4D, 0x9B4E, 0x9B51, 0x9B58, 0x9B74, 0x9B93, 0x9B83,
	0x9B91, 0x9B96, 0x9B97, 0x9B9F, 0x9BA0, 0x9BA8, 0x9BB4, 0x9BC0,
	0x9BCA, 0x9BB9, 0x9BC6, 0x9BCF, 0x9BD1, 0x9BD2, 0x9BE3, 0x9BE2,
	0x9BE4, 0x9BD4, 0x9BE1, 0x9C3A, 0x9BF2, 0x9BF1, 0x9BF0, 0x9C15,
	0x9C14, 0x9C09, 0x9C13, 0x9C0C, 0x9C06, 0x9C08, 0x9C12, 0x9C0A,
	0x9C04, 0x9C2E, 0x9C1B, 0x9C25, 0x9C24, 0x9C21, 0x9C30, 0x9C47,
	0x9C32, 0x9C46, 0x9C3E, 0x9C5A, 0x9C60, 0x9C67, 0x9C76, 0x9C78,
	0x9CE7, 0x9CEC, 0x9CF0, 0x9D09, 0x9D08, 0x9CEB, 0x9D03, 0x9D06,
	0x9D2A, 0x9D26, 0x9DAF, 0x9D23, 0x9D1F, 0x9D44, 0x9D15, 0x9D12,
	0x9D41, 0x9D3F, 0x9D3E, 0x9D46, 0x9D48, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_EA = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9D5D, 0x9D5E, 0x9D64, 0x9D51, 0x9D50, 0x9D59, 0x9D72, 0x9D89,
	0x9D87, 0x9DAB, 0x9D6F, 0x9D7A, 0x9D9A, 0x9DA4, 0x9DA9, 0x9DB2,
	0x9DC4, 0x9DC1, 0x9DBB, 0x9DB8, 0x9DBA, 0x9DC6, 0x9DCF, 0x9DC2,
	0x9DD9, 0x9DD3, 0x9DF8, 0x9DE6, 0x9DED, 0x9DEF, 0x9DFD, 0x9E1A,
	0x9E1B, 0x9E1E, 0x9E75, 0x9E79, 0x9E7D, 0x9E81, 0x9E88, 0x9E8B,
	0x9E8C, 0x9E92, 0x9E95, 0x9E91, 0x9E9D, 0x9EA5, 0x9EA9, 0x9EB8,
	0x9EAA, 0x9EAD, 0x9761, 0x9ECC, 0x9ECE, 0x9ECF, 0x9ED0, 0x9ED4,
	0x9EDC, 0x9EDE, 0x9EDD, 0x9EE0, 0x9EE5, 0x9EE8, 0x9EEF, 0xFFFE,
	0x9EF4, 0x9EF6, 0x9EF7, 0x9EF9, 0x9EFB, 0x9EFC, 0x9EFD, 0x9F07,
	0x9F08, 0x76B7, 0x9F15, 0x9F21, 0x9F2C, 0x9F3E, 0x9F4A, 0x9F52,
	0x9F54, 0x9F63, 0x9F5F, 0x9F60, 0x9F61, 0x9F66, 0x9F67, 0x9F6C,
	0x9F6A, 0x9F77, 0x9F72, 0x9F76, 0x9F95, 0x9F9C, 0x9FA0, 0x582F,
	0x69C7, 0x9059, 0x7464, 0x51DC, 0x7199, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_EB = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3001, 0x3002, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFE3, 0xFE33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x30FC, 0xFE31, 0x2010, 0xFFFE, 0xFFFE,
	0x301C, 0x2016, 0xFF5C, 0x2026, 0xFE30, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFE35, 0xFE36, 0xFE39, 0xFE3A, 0xFF3B, 0xFF3D, 0xFE37,
	0xFE38, 0xFE3F, 0xFE40, 0xFE3D, 0xFE3E, 0xFE41, 0xFE42, 0xFE43,
	0xFE44, 0xFE3B, 0xFE3C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFF1D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_EC = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3041,
	0xFFFE, 0x3043, 0xFFFE, 0x3045, 0xFFFE, 0x3047, 0xFFFE, 0x3049,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3063, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3083, 0xFFFE, 0x3085, 0xFFFE, 0x3087, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x308E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit to_ucs_ED = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x30A1, 0xFFFE, 0x30A3, 0xFFFE, 0x30A5, 0xFFFE, 0x30A7, 0xFFFE,
	0x30A9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x30C3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x30E3, 0xFFFE, 0x30E5, 0xFFFE, 0x30E7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x30EE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x30F5, 0x30F6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_16bit to_ucs = { {
	&to_ucs_00, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, &to_ucs_81, &to_ucs_82, &to_ucs_83, &to_ucs_84, &to_ucs_85, &to_ucs_86, &to_ucs_87,
	&to_ucs_88, &to_ucs_89, &to_ucs_8A, &to_ucs_8B, &to_ucs_8C, &to_ucs_8D, &to_ucs_8E, &to_ucs_8F,
	&to_ucs_90, &to_ucs_91, &to_ucs_92, &to_ucs_93, &to_ucs_94, &to_ucs_95, &to_ucs_96, &to_ucs_97,
	&to_ucs_98, &to_ucs_99, &to_ucs_9A, &to_ucs_9B, &to_ucs_9C, &to_ucs_9D, &to_ucs_9E, &to_ucs_9F,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&to_ucs_E0, &to_ucs_E1, &to_ucs_E2, &to_ucs_E3, &to_ucs_E4, &to_ucs_E5, &to_ucs_E6, &to_ucs_E7,
	&to_ucs_E8, &to_ucs_E9, &to_ucs_EA, &to_ucs_EB, &to_ucs_EC, &to_ucs_ED, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} };

static const iconv_ccs_convtable_8bit from_ucs_00 = { {
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
	0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
	0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
	0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
	0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
	0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
	0x0058, 0x0059, 0x005A, 0x005B, 0x0080, 0x005D, 0x005E, 0x005F,
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
	0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
	0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x00A0, 0xFFFE, 0x8191, 0x8192, 0xFFFE, 0x005C, 0xFFFE, 0x8198,
	0x814E, 0x00FD, 0xFFFE, 0xFFFE, 0x81CA, 0xFFFE, 0xFFFE, 0xFFFE,
	0x818B, 0x817D, 0xFFFE, 0xFFFE, 0x814C, 0xFFFE, 0x81F7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x817E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8180,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_03 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x839F, 0x83A0, 0x83A1, 0x83A2, 0x83A3, 0x83A4, 0x83A5,
	0x83A6, 0x83A7, 0x83A8, 0x83A9, 0x83AA, 0x83AB, 0x83AC, 0x83AD,
	0x83AE, 0x83AF, 0xFFFE, 0x83B0, 0x83B1, 0x83B2, 0x83B3, 0x83B4,
	0x83B5, 0x83B6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x83BF, 0x83C0, 0x83C1, 0x83C2, 0x83C3, 0x83C4, 0x83C5,
	0x83C6, 0x83C7, 0x83C8, 0x83C9, 0x83CA, 0x83CB, 0x83CC, 0x83CD,
	0x83CE, 0x83CF, 0xFFFE, 0x83D0, 0x83D1, 0x83D2, 0x83D3, 0x83D4,
	0x83D5, 0x83D6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_04 = { {
	0xFFFE, 0x8446, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8440, 0x8441, 0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448,
	0x8449, 0x844A, 0x844B, 0x844C, 0x844D, 0x844E, 0x844F, 0x8450,
	0x8451, 0x8452, 0x8453, 0x8454, 0x8455, 0x8456, 0x8457, 0x8458,
	0x8459, 0x845A, 0x845B, 0x845C, 0x845D, 0x845E, 0x845F, 0x8460,
	0x8470, 0x8471, 0x8472, 0x8473, 0x8474, 0x8475, 0x8477, 0x8478,
	0x8479, 0x847A, 0x847B, 0x847C, 0x847D, 0x847E, 0x8480, 0x8481,
	0x8482, 0x8483, 0x8484, 0x8485, 0x8486, 0x8487, 0x8488, 0x8489,
	0x848A, 0x848B, 0x848C, 0x848D, 0x848E, 0x848F, 0x8490, 0x8491,
	0xFFFE, 0x8476, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_20 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEB5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x815C, 0xFFFE, 0xEB61, 0xFFFE,
	0x8165, 0x8166, 0xFFFE, 0xFFFE, 0x8167, 0x8168, 0xFFFE, 0xFFFE,
	0x81F5, 0x81F6, 0xFFFE, 0xFFFE, 0xFFFE, 0x8164, 0xEB63, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x81F1, 0xFFFE, 0x818C, 0x818D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x81A6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_21 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x818E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8656, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8650, 0xFFFE, 0xFFFE, 0x869B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x869D, 0x00FE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x81F0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x859F, 0x85A0, 0x85A1, 0x85A2, 0x85A3, 0x85A4, 0x85A5, 0x85A6,
	0x85A7, 0x85A8, 0x85A9, 0x85AA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x85B3, 0x85B4, 0x85B5, 0x85B6, 0x85B7, 0x85B8, 0x85B9, 0x85BA,
	0x85BB, 0x85BC, 0x85BD, 0x85BE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x81A9, 0x81AA, 0x81A8, 0x81AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x86CC, 0x86CD, 0x86CB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81CB, 0xFFFE, 0x81CC, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x86D4, 0x86D5,
	0x86D3, 0x86D6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_22 = { {
	0x81CD, 0xFFFE, 0x81DD, 0x81CE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81DE,
	0x81B8, 0xFFFE, 0xFFFE, 0x81B9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x817C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81E3, 0xFFFE, 0xFFFE, 0x81E5, 0x8187, 0x8841,
	0x81DA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81C8,
	0x81C9, 0x81BF, 0x81BE, 0x81E7, 0x81E8, 0xFFFE, 0x8840, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8188, 0x81E6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81E4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81E0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8182, 0x81DF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8185, 0x8186,
	0xFFFE, 0xFFFE, 0x81E1, 0x81E2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81BC, 0x81BD, 0xFFFE, 0xFFFE, 0x81BA, 0x81BB,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81DB, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8842,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_23 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81DC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_24 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8540, 0x8541, 0x8542, 0x8543, 0x8544, 0x8545, 0x8546, 0x8547,
	0x8548, 0x8549, 0x854A, 0x854B, 0x854C, 0x854D, 0x854E, 0x854F,
	0x8550, 0x8551, 0x8552, 0x8553, 0x855E, 0x855F, 0x8560, 0x8561,
	0x8562, 0x8563, 0x8564, 0x8565, 0x8566, 0x8567, 0x8568, 0x8569,
	0x856A, 0x856B, 0x856C, 0x856D, 0x856E, 0x856F, 0x8570, 0x8571,
	0x8592, 0x8593, 0x8594, 0x8595, 0x8596, 0x8597, 0x8598, 0x8599,
	0x859A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x85DB, 0x85DC, 0x85DD, 0x85DE,
	0x85DF, 0x85E0, 0x85E1, 0x85E2, 0x85E3, 0x85E4, 0x85E5, 0x85E6,
	0x85E7, 0x85E8, 0x85E9, 0x85EA, 0x85EB, 0x85EC, 0x85ED, 0x85EE,
	0x85EF, 0x85F0, 0x85F1, 0x85F2, 0x85F3, 0x85F4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_25 = { {
	0x849F, 0x84AA, 0x84A0, 0x84AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x84A1, 0xFFFE, 0xFFFE, 0x84AC,
	0x84A2, 0xFFFE, 0xFFFE, 0x84AD, 0x84A4, 0xFFFE, 0xFFFE, 0x84AF,
	0x84A3, 0xFFFE, 0xFFFE, 0x84AE, 0x84A5, 0x84BA, 0xFFFE, 0xFFFE,
	0x84B5, 0xFFFE, 0xFFFE, 0x84B0, 0x84A7, 0x84BC, 0xFFFE, 0xFFFE,
	0x84B7, 0xFFFE, 0xFFFE, 0x84B2, 0x84A6, 0xFFFE, 0xFFFE, 0x84B6,
	0x84BB, 0xFFFE, 0xFFFE, 0x84B1, 0x84A8, 0xFFFE, 0xFFFE, 0x84B8,
	0x84BD, 0xFFFE, 0xFFFE, 0x84B3, 0x84A9, 0xFFFE, 0xFFFE, 0x84B9,
	0xFFFE, 0xFFFE, 0x84BE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x84B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x81A1, 0x81A0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x81A3, 0x81A2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81A5, 0x81A4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x819F, 0x819E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x819B, 0xFFFE, 0xFFFE, 0x819D, 0x819C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x81FC,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_26 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x819A, 0x8199, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x86B4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x86C8, 0x86C9, 0x86C7, 0x86CA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x818A, 0xFFFE, 0x8189, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x86A3, 0x86A1, 0x86A2, 0x86A4, 0x869F, 0x86A5, 0x86A6, 0x86A0,
	0xFFFE, 0xFFFE, 0x81F4, 0xFFFE, 0xFFFE, 0x81F3, 0xFFFE, 0x81F2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_27 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x857C, 0x857D,
	0x857E, 0x8580, 0x8581, 0x8582, 0x8583, 0x8584, 0x8585, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_30 = { {
	0x8140, 0xEB41, 0xEB42, 0x8156, 0x86B5, 0x8158, 0x8159, 0x815A,
	0x8171, 0x8172, 0x8173, 0x8174, 0x8175, 0x8176, 0x8177, 0x8178,
	0x8179, 0x817A, 0x81A7, 0x81AC, 0x816B, 0x816C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEB60, 0x8854, 0xFFFE, 0x8855,
	0x86B3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEC9F, 0x82A0, 0xECA1, 0x82A2, 0xECA3, 0x82A4, 0xECA5,
	0x82A6, 0xECA7, 0x82A8, 0x82A9, 0x82AA, 0x82AB, 0x82AC, 0x82AD,
	0x82AE, 0x82AF, 0x82B0, 0x82B1, 0x82B2, 0x82B3, 0x82B4, 0x82B5,
	0x82B6, 0x82B7, 0x82B8, 0x82B9, 0x82BA, 0x82BB, 0x82BC, 0x82BD,
	0x82BE, 0x82BF, 0x82C0, 0xECC1, 0x82C2, 0x82C3, 0x82C4, 0x82C5,
	0x82C6, 0x82C7, 0x82C8, 0x82C9, 0x82CA, 0x82CB, 0x82CC, 0x82CD,
	0x82CE, 0x82CF, 0x82D0, 0x82D1, 0x82D2, 0x82D3, 0x82D4, 0x82D5,
	0x82D6, 0x82D7, 0x82D8, 0x82D9, 0x82DA, 0x82DB, 0x82DC, 0x82DD,
	0x82DE, 0x82DF, 0x82E0, 0xECE1, 0x82E2, 0xECE3, 0x82E4, 0xECE5,
	0x82E6, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EB, 0xECEC, 0x82ED,
	0x82EE, 0x82EF, 0x82F0, 0x82F1, 0x8868, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x814A, 0x814B, 0x8154, 0x8155, 0xFFFE,
	0xFFFE, 0xED40, 0x8341, 0xED42, 0x8343, 0xED44, 0x8345, 0xED46,
	0x8347, 0xED48, 0x8349, 0x834A, 0x834B, 0x834C, 0x834D, 0x834E,
	0x834F, 0x8350, 0x8351, 0x8352, 0x8353, 0x8354, 0x8355, 0x8356,
	0x8357, 0x8358, 0x8359, 0x835A, 0x835B, 0x835C, 0x835D, 0x835E,
	0x835F, 0x8360, 0x8361, 0xED62, 0x8363, 0x8364, 0x8365, 0x8366,
	0x8367, 0x8368, 0x8369, 0x836A, 0x836B, 0x836C, 0x836D, 0x836E,
	0x836F, 0x8370, 0x8371, 0x8372, 0x8373, 0x8374, 0x8375, 0x8376,
	0x8377, 0x8378, 0x8379, 0x837A, 0x837B, 0x837C, 0x837D, 0x837E,
	0x8380, 0x8381, 0x8382, 0xED83, 0x8384, 0xED85, 0x8386, 0xED87,
	0x8388, 0x8389, 0x838A, 0x838B, 0x838C, 0x838D, 0xED8E, 0x838F,
	0x8390, 0x8391, 0x8392, 0x8393, 0x8394, 0xED95, 0xED96, 0x886A,
	0x886B, 0x886C, 0x886D, 0x8145, 0xEB5B, 0x8152, 0x8153, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_32 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8741, 0x8742, 0x8743, 0x8744, 0x8745, 0x8746,
	0x8740, 0x874D, 0x8750, 0x8753, 0x874F, 0x8754, 0x8752, 0x8748,
	0x8758, 0x874B, 0x874C, 0x8751, 0x8755, 0x8756, 0x874E, 0x8757,
	0x8747, 0xFFFE, 0x8749, 0x874A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8799, 0xFFFE,
	0x879B, 0x879E, 0xFFFE, 0xFFFE, 0xFFFE, 0x879A, 0x879C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8793, 0x8794, 0x8795, 0x8796,
	0x8797, 0x8798, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_33 = { {
	0x87BD, 0xFFFE, 0xFFFE, 0x87A7, 0xFFFE, 0x87A4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x87B0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x87A2, 0x87AA, 0x87A3, 0xFFFE,
	0x87A9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x87BE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x87A0, 0x87B2, 0xFFFE, 0xFFFE, 0x87B3, 0x87AB,
	0xFFFE, 0xFFFE, 0x87BF, 0x87B5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x87C0, 0xFFFE, 0x87A5, 0xFFFE, 0xFFFE, 0x87A8, 0xFFFE,
	0xFFFE, 0x87AE, 0xFFFE, 0x87B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x87B1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x87C1,
	0xFFFE, 0x879F, 0x87AD, 0xFFFE, 0xFFFE, 0x87A1, 0x87A6, 0xFFFE,
	0xFFFE, 0x87AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x87AF,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x87E8, 0x87E7, 0x87E6, 0x87E5, 0x87FA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x865A, 0x865B, 0x865C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x864A, 0x864C,
	0x8659, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x864E, 0x864F,
	0x8651, 0xFFFE, 0xFFFE, 0xFFFE, 0x8640, 0x8642, 0x8648, 0x8641,
	0x8643, 0x8646, 0x8649, 0xFFFE, 0x8644, 0x8647, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8655, 0x8654, 0x8653, 0x8652, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x864D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8658, 0xFFFE, 0x869C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8657, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_4E = { {
	0x88EA, 0x929A, 0xFFFE, 0x8EB5, 0xFFFE, 0xFFFE, 0xFFFE, 0x969C,
	0x8FE4, 0x8E4F, 0x8FE3, 0x89BA, 0xFFFE, 0x9573, 0x975E, 0xFFFE,
	0x98A0, 0x894E, 0xFFFE, 0xFFFE, 0x8A8E, 0x98A1, 0x90A2, 0x99C0,
	0x8B75, 0x95B8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FE5, 0xFFFE,
	0xFFFE, 0x97BC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95C0, 0xFFFE,
	0xFFFE, 0xFFFE, 0x98A2, 0xFFFE, 0xFFFE, 0x9286, 0xFFFE, 0xFFFE,
	0xFFFE, 0x98A3, 0x8BF8, 0xFFFE, 0xFFFE, 0xFFFE, 0x98A4, 0xFFFE,
	0x8ADB, 0x924F, 0xFFFE, 0x8EE5, 0x98A5, 0xFFFE, 0xFFFE, 0x98A6,
	0xFFFE, 0xFFFE, 0x98A7, 0x9454, 0xFFFE, 0x8B76, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9456, 0xFFFE, 0x93E1, 0x8CC1, 0x9652,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE568, 0x98A8, 0x8FE6,
	0x98A9, 0x89B3, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BE3, 0x8CEE, 0x96E7,
	0xFFFE, 0xFFFE, 0x9BA4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9790, 0xFFFE, 0x93FB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AA3, 0xFFFE,
	0x8B54, 0xFFFE, 0x98AA, 0xFFFE, 0xFFFE, 0x98AB, 0x97B9, 0xFFFE,
	0x975C, 0x9188, 0x98AD, 0x8E96, 0x93F1, 0xFFFE, 0x98B0, 0xFFFE,
	0xFFFE, 0x895D, 0x8CDD, 0xFFFE, 0x8CDC, 0x88E4, 0xFFFE, 0xFFFE,
	0x986A, 0x9869, 0xFFFE, 0x8DB1, 0x889F, 0xFFFE, 0x98B1, 0x98B2,
	0x98B3, 0x9653, 0x98B4, 0xFFFE, 0x8CF0, 0x88E5, 0x9692, 0xFFFE,
	0x8B9C, 0xFFFE, 0xFFFE, 0x8B9D, 0x8B9E, 0x92E0, 0x97BA, 0xFFFE,
	0x98B5, 0xFFFE, 0xFFFE, 0x98B6, 0xFFFE, 0xFFFE, 0x98B7, 0xFFFE,
	0xFFFE, 0xFFFE, 0x906C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8F59, 0x906D, 0x98BC, 0xFFFE, 0x98BA, 0xFFFE, 0x98BB, 0x8B77,
	0xFFFE, 0xFFFE, 0x8DA1, 0x89EE, 0xFFFE, 0x98B9, 0x98B8, 0x95A7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E65, 0x8E64, 0x91BC, 0x98BD,
	0x9574, 0x90E5, 0xFFFE, 0xFFFE, 0xFFFE, 0x8157, 0x98BE, 0x98C0,
	0xFFFE, 0xFFFE, 0xFFFE, 0x91E3, 0x97DF, 0x88C8, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98BF, 0x89BC, 0xFFFE,
	0x8BC2, 0xFFFE, 0x9287, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C8F, 0x98C1,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9443, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_4F = { {
	0xFFFE, 0x8AE9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x98C2, 0x88C9, 0xFFFE, 0xFFFE, 0x8CDE, 0x8AEA, 0x959A,
	0x94B0, 0x8B78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x89EF, 0xFFFE, 0x98E5, 0x9360, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x948C,
	0x98C4, 0xFFFE, 0xFFFE, 0xFFFE, 0x94BA, 0xFFFE, 0x97E0, 0xFFFE,
	0x904C, 0xFFFE, 0x8E66, 0xFFFE, 0x8E97, 0x89BE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x92CF, 0xFFFE, 0xFFFE, 0x9241, 0x98C8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x88CA, 0x92E1, 0x8F5A,
	0x8DB2, 0x9743, 0xFFFE, 0x91CC, 0xFFFE, 0x89BD, 0xFFFE, 0x98C7,
	0xFFFE, 0x975D, 0x98C3, 0x98C5, 0x8DEC, 0x98C6, 0x9B43, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x98CE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98D1,
	0x98CF, 0xFFFE, 0xFFFE, 0x89C0, 0xFFFE, 0x95B9, 0x98C9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x98CD, 0x8CF1, 0xFFFE, 0xFFFE, 0x8E67,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8AA4, 0xFFFE, 0xFFFE, 0x98D2, 0xFFFE,
	0x98CA, 0xFFFE, 0xFFFE, 0x97E1, 0xFFFE, 0x8E98, 0xFFFE, 0x98CB,
	0xFFFE, 0x98D0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98D3, 0xFFFE,
	0x98CC, 0xFFFE, 0xFFFE, 0x8B9F, 0xFFFE, 0x88CB, 0xFFFE, 0xFFFE,
	0x8BA0, 0x89BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9B44, 0xFFFE, 0x9699, 0x958E, 0x8CF2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x904E, 0x97B5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95D6,
	0xFFFE, 0xFFFE, 0x8C57, 0x91A3, 0x89E2, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8F72, 0xFFFE, 0xFFFE, 0xFFFE, 0x98D7, 0xFFFE,
	0x98DC, 0x98DA, 0xFFFE, 0xFFFE, 0x98D5, 0xFFFE, 0xFFFE, 0x91AD,
	0x98D8, 0xFFFE, 0x98DB, 0x98D9, 0xFFFE, 0x95DB, 0xFFFE, 0x98D6,
	0xFFFE, 0x904D, 0xFFFE, 0x9693, 0x98DD, 0x98DE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F43, 0x98EB,
	0xFFFE, 0xFFFE, 0xFFFE, 0x946F, 0xFFFE, 0x9555, 0x98E6, 0xFFFE,
	0x95EE, 0xFFFE, 0x89B4, 0xFFFE, 0xFFFE, 0xFFFE, 0x98EA, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_50 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98E4, 0x98ED, 0xFFFE,
	0xFFFE, 0x9171, 0xFFFE, 0x8CC2, 0xFFFE, 0x947B, 0xFFFE, 0xE0C5,
	0xFFFE, 0x98EC, 0x937C, 0xFFFE, 0x98E1, 0xFFFE, 0x8CF4, 0xFFFE,
	0xFFFE, 0x8CF3, 0x98DF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8ED8,
	0xFFFE, 0x98E7, 0xFFFE, 0x95ED, 0x926C, 0x98E3, 0x8C91, 0xFFFE,
	0x98E0, 0x98E8, 0x98E2, 0x97CF, 0x98E9, 0x9860, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BE4, 0xFFFE,
	0xFFFE, 0x8C90, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x98EE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98EF,
	0x98F3, 0x88CC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95CE,
	0x98F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98F1, 0x98F5, 0xFFFE,
	0xFFFE, 0xFFFE, 0x98F4, 0xFFFE, 0x92E2, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C92, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98F6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8EC3, 0xFFFE, 0x91A4, 0x92E3, 0x8BF4, 0xFFFE,
	0x98F7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B55, 0xFFFE, 0xFFFE,
	0x98F8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x98FA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9654, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8C86, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8E50, 0x94F5, 0x98F9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DC3, 0x9762, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x98FC, 0x9942, 0x98FB, 0x8DC2, 0xFFFE, 0x8F9D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C58, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9943, 0xFFFE, 0xFFFE, 0x8BCD, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9940, 0x9941, 0xFFFE, 0xFFFE, 0x93AD, 0xFFFE, 0x919C,
	0xFFFE, 0x8BA1, 0xFFFE, 0xFFFE, 0xFFFE, 0x966C, 0x9944, 0xFFFE,
	0xFFFE, 0xFFFE, 0x97BB, 0xFFFE, 0xFFFE, 0xFFFE, 0x9945, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9948, 0xFFFE, 0x9946, 0xFFFE, 0x916D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9947, 0x9949, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x994B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x994A, 0xFFFE, 0x95C6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_51 = { {
	0x8B56, 0x994D, 0x994E, 0xFFFE, 0x89AD, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x994C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8EF2, 0xFFFE, 0x9951, 0x9950, 0x994F, 0xFFFE,
	0x98D4, 0xFFFE, 0x9952, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F9E,
	0xFFFE, 0x9953, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9744, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96D7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9955,
	0xFFFE, 0xFFFE, 0x9954, 0x9957, 0x9956, 0xFFFE, 0xFFFE, 0x9958,
	0x9959, 0x88F2, 0xFFFE, 0x8CB3, 0x8C5A, 0x8F5B, 0x929B, 0x8BA2,
	0x90E6, 0x8CF5, 0xFFFE, 0x8D8E, 0x995B, 0x96C6, 0x9365, 0xFFFE,
	0x8E99, 0xFFFE, 0x995A, 0xFFFE, 0x995C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x937D, 0xFFFE, 0x8A95, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x995D, 0xFFFE, 0xFFFE, 0x93FC, 0xFFFE, 0xFFFE,
	0x9153, 0x995F, 0x9960, 0x94AA, 0x8CF6, 0x985A, 0x9961, 0xFFFE,
	0xFFFE, 0x8BA4, 0xFFFE, 0xFFFE, 0xFFFE, 0x95BA, 0x91B4, 0x8BEF,
	0x9354, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C93, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9962, 0xFFFE, 0x9963, 0xFFFE, 0xFFFE, 0x93E0, 0x897E, 0xFFFE,
	0xFFFE, 0x9966, 0x8DFB, 0xFFFE, 0x9965, 0x8DC4, 0xFFFE, 0x9967,
	0xE3EC, 0x9968, 0x9660, 0x9969, 0xFFFE, 0x996A, 0x996B, 0x8FE7,
	0xFFFE, 0x8ECA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AA5, 0xFFFE, 0x996E, 0xFFFE, 0x996C, 0x96BB, 0x996D, 0xFFFE,
	0x9579, 0x996F, 0x9970, 0x9971, 0x937E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9975, 0x9973, 0x9974, 0x9972, 0x8DE1, 0x9976, 0x96E8, 0x97E2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9977, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90A6, 0x9978, 0x8F79, 0xFFFE,
	0xFFFE, 0x9979, 0xFFFE, 0x929C, 0x97BD, 0x9380, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99C3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x997A, 0xEAA3, 0x8BC3, 0xFFFE, 0xFFFE,
	0x997B, 0x967D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F88, 0x91FA,
	0xFFFE, 0x997D, 0x93E2, 0xFFFE, 0xFFFE, 0x997E, 0xFFFE, 0xFFFE,
	0x9980, 0x8A4D, 0xFFFE, 0xFFFE, 0xFFFE, 0x9981, 0x8BA5, 0xFFFE,
	0x93CA, 0x899A, 0x8F6F, 0xFFFE, 0xFFFE, 0x949F, 0x9982, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_52 = { {
	0x9381, 0xFFFE, 0xFFFE, 0x906E, 0x9983, 0xFFFE, 0x95AA, 0x90D8,
	0x8AA0, 0xFFFE, 0x8AA7, 0x9984, 0xFFFE, 0xFFFE, 0x9986, 0xFFFE,
	0xFFFE, 0x8C59, 0xFFFE, 0xFFFE, 0x9985, 0xFFFE, 0xFFFE, 0x97F1,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F89, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94BB, 0x95CA, 0xFFFE, 0x9987,
	0xFFFE, 0x9798, 0x9988, 0xFFFE, 0xFFFE, 0xFFFE, 0x9989, 0xFFFE,
	0x939E, 0xFFFE, 0xFFFE, 0x998A, 0xFFFE, 0xFFFE, 0x90A7, 0x8DFC,
	0x8C94, 0x998B, 0x8E68, 0x8D8F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x92E4, 0x998D, 0xFFFE, 0xFFFE, 0x91A5,
	0xFFFE, 0xFFFE, 0x8DED, 0x998E, 0x998F, 0x914F, 0xFFFE, 0x998C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9991, 0xFFFE, 0x9655, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8D84, 0xFFFE, 0xFFFE, 0x9990, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C95, 0x8DDC, 0x948D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9994, 0x9992, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x959B,
	0x8FE8, 0x999B, 0x8A84, 0x9995, 0x9993, 0x916E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9997, 0xFFFE, 0x9996,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A63, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C80,
	0x999C, 0x97AB, 0xFFFE, 0xFFFE, 0xFFFE, 0x9998, 0xFFFE, 0xFFFE,
	0xFFFE, 0x999D, 0x999A, 0xFFFE, 0x9999, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x97CD, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CF7,
	0x89C1, 0xFFFE, 0xFFFE, 0x97F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F95, 0x9377, 0x8D85, 0x99A0, 0x99A1, 0xFFFE, 0xFFFE,
	0xFFFE, 0x97E3, 0xFFFE, 0xFFFE, 0x984A, 0x99A3, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8CF8, 0xFFFE, 0xFFFE, 0x99A2, 0xFFFE, 0x8A4E, 0xFFFE,
	0xFFFE, 0x99A4, 0xFFFE, 0x9675, 0xFFFE, 0x92BA, 0xFFFE, 0x9745,
	0xFFFE, 0x95D7, 0xFFFE, 0xFFFE, 0xFFFE, 0x99A5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE8D3, 0xFFFE, 0xFFFE, 0x93AE, 0xFFFE, 0x99A6,
	0x8AA8, 0x96B1, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F9F, 0x99A7, 0x95E5,
	0x99AB, 0xFFFE, 0x90A8, 0x99A8, 0x8BCE, 0xFFFE, 0x99A9, 0x8AA9,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C4D, 0x99AC, 0xFFFE, 0x99AD, 0xFFFE, 0xFFFE,
	0x99AE, 0x99AF, 0x8ED9, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CF9, 0x96DC
} };

static const iconv_ccs_convtable_8bit from_ucs_53 = { {
	0xFFFE, 0x96E6, 0x93F5, 0xFFFE, 0xFFFE, 0x95EF, 0x99B0, 0xFFFE,
	0x99B1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99B3, 0xFFFE, 0x99B5,
	0x99B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99B6, 0x89BB, 0x966B,
	0xFFFE, 0x8DFA, 0x99B7, 0xFFFE, 0xFFFE, 0x9178, 0xFFFE, 0xFFFE,
	0x8FA0, 0x8BA7, 0xFFFE, 0x99B8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x94D9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99B9,
	0xFFFE, 0x99BA, 0xFFFE, 0x99BB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x99BC, 0x9543, 0x8BE6, 0x88E3, 0xFFFE, 0xFFFE, 0xFFFE, 0x93BD,
	0x99BD, 0x8F5C, 0xFFFE, 0x90E7, 0xFFFE, 0x99BF, 0x99BE, 0x8FA1,
	0x8CDF, 0x99C1, 0x94BC, 0xFFFE, 0xFFFE, 0x99C2, 0xFFFE, 0xFFFE,
	0xFFFE, 0x94DA, 0x91B2, 0x91EC, 0x8BA6, 0xFFFE, 0xFFFE, 0x93EC,
	0x9250, 0xFFFE, 0x948E, 0xFFFE, 0x966D, 0xFFFE, 0x99C4, 0xFFFE,
	0x90E8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C54, 0xFFFE,
	0xFFFE, 0x99C5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99C6, 0x894B,
	0x88F3, 0x8AEB, 0xFFFE, 0x91A6, 0x8B70, 0x9791, 0xFFFE, 0x99C9,
	0x89B5, 0xFFFE, 0xFFFE, 0x99C8, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BA8,
	0xFFFE, 0xFFFE, 0x99CA, 0xFFFE, 0x96EF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99CB, 0xFFFE,
	0x97D0, 0xFFFE, 0x8CFA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CB4,
	0x99CC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99CE, 0x99CD, 0xFFFE,
	0x907E, 0x8958, 0xFFFE, 0xFFFE, 0xFFFE, 0x897D, 0x99CF, 0xFFFE,
	0x99D0, 0xFFFE, 0xFFFE, 0x8CB5, 0xFFFE, 0xFFFE, 0x99D1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8B8E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8E51, 0x99D2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9694, 0x8DB3, 0x8B79, 0x9746, 0x916F, 0x94BD, 0x8EFB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F66, 0xFFFE, 0x8EE6, 0x8EF3,
	0xFFFE, 0x8F96, 0xFFFE, 0x94BE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99D5,
	0xFFFE, 0x8962, 0x9170, 0x8CFB, 0x8CC3, 0x8BE5, 0xFFFE, 0xFFFE,
	0x99D9, 0x9240, 0x91FC, 0x8BA9, 0x8FA2, 0x99DA, 0x99D8, 0x89C2,
	0x91E4, 0x8EB6, 0x8E6A, 0x8945, 0xFFFE, 0xFFFE, 0x8A90, 0x8D86,
	0x8E69, 0xFFFE, 0x99DB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_54 = { {
	0xFFFE, 0x99DC, 0xFFFE, 0x8B68, 0x8A65, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8D87, 0x8B67, 0x92DD, 0x8944, 0x93AF, 0x96BC, 0x8D40, 0x9799,
	0x9366, 0x8CFC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C4E, 0xFFFE, 0x99E5, 0xFFFE, 0x8BE1,
	0x9669, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94DB, 0xFFFE,
	0xFFFE, 0x99E4, 0xFFFE, 0x8ADC, 0x99DF, 0x99E0, 0x99E2, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99E3, 0xFFFE,
	0x8B7A, 0x9081, 0xFFFE, 0x95AB, 0x99E1, 0x99DD, 0x8CE1, 0xFFFE,
	0x99DE, 0xFFFE, 0x9843, 0xFFFE, 0xFFFE, 0xFFFE, 0x95F0, 0xFFFE,
	0x92E6, 0x8CE0, 0x8D90, 0xFFFE, 0xFFFE, 0xFFFE, 0x99E6, 0xFFFE,
	0xFFFE, 0x93DB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x99EA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8EFC, 0xFFFE, 0x8EF4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x99ED, 0x99EB, 0xFFFE, 0x96A1, 0xFFFE, 0x99E8, 0x99F1, 0x99EC,
	0xFFFE, 0xFFFE, 0xFFFE, 0x99EF, 0x8CC4, 0x96BD, 0xFFFE, 0xFFFE,
	0x99F0, 0xFFFE, 0xFFFE, 0xFFFE, 0x99F2, 0xFFFE, 0x99F4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8DEE, 0x9861, 0xFFFE, 0x99E9, 0x99E7,
	0x99F3, 0xFFFE, 0x99EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x99F6, 0xFFFE, 0x9A42, 0x99F8, 0xFFFE, 0xFFFE,
	0x99FC, 0xFFFE, 0xFFFE, 0x9A40, 0x99F9, 0xFFFE, 0xFFFE, 0x9A5D,
	0xFFFE, 0xFFFE, 0x8DE7, 0x8A50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x99F7, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A44, 0x88F4, 0x9A43, 0xFFFE,
	0x88A3, 0x9569, 0x9A41, 0xFFFE, 0x99FA, 0xFFFE, 0xFFFE, 0x99F5,
	0x99FB, 0x8DC6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x88F5, 0x9A4E, 0xFFFE, 0xFFFE, 0x9A46, 0x9A47, 0xFFFE,
	0x8FA3, 0x9689, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A4C, 0x9A4B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x934E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9A4D, 0xFFFE, 0xFFFE, 0x9A4A, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_55 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8953, 0xFFFE, 0x8DB4, 0x904F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A48,
	0x9382, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A49, 0xFFFE, 0x88A0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A53, 0x9742,
	0xFFFE, 0x8FA5, 0xFFFE, 0x9A59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A58, 0x9A4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91C1, 0xFFFE,
	0x9A50, 0xFFFE, 0xFFFE, 0xFFFE, 0x91ED, 0x9A55, 0x8FA4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A52, 0xFFFE, 0xFFFE, 0x96E2,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C5B, 0xFFFE, 0xFFFE, 0x9A56, 0x9A57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A54, 0x9A5A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9A51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9A60, 0x9A65, 0xFFFE, 0x9A61, 0xFFFE,
	0x9A5C, 0xFFFE, 0xFFFE, 0x9A66, 0x9150, 0xFFFE, 0xFFFE, 0x9A68,
	0xFFFE, 0x8D41, 0x9A5E, 0x929D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A62, 0x9A5B, 0x8AAB, 0xFFFE, 0x8AEC, 0x8A85, 0x9A63, 0x9A5F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C96,
	0x9A69, 0x9A67, 0x9172, 0x8B69, 0x8BAA, 0xFFFE, 0x9A64, 0xFFFE,
	0x8BF2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8963, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A6D, 0x9A6B, 0xFFFE, 0x9AA5,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A70, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9A6A, 0xFFFE, 0x9A6E, 0xFFFE, 0xFFFE, 0x9A6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E6B, 0x9A6F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A72,
	0xFFFE, 0x9A77, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A75, 0x9A74, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_56 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9251, 0xFFFE,
	0xFFFE, 0x89C3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A71, 0xFFFE, 0x9A73, 0x8FA6,
	0x8952, 0xFFFE, 0xFFFE, 0x9A76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89DC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A82,
	0xFFFE, 0x8FFA, 0x9A7D, 0xFFFE, 0x9A7B, 0xFFFE, 0x9A7C, 0xFFFE,
	0x9A7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x895C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9158, 0xFFFE, 0x9A78, 0xFFFE,
	0x9A79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A9A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A81, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AED, 0xFFFE, 0x9A84, 0x9A80, 0x9A83, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95AC, 0xFFFE, 0xFFFE, 0xFFFE,
	0x93D3, 0xFFFE, 0x94B6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A86, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A85, 0x8A64,
	0xFFFE, 0xFFFE, 0x9A87, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A8A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A89, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A88, 0xFFFE, 0x9458, 0xFFFE, 0xFFFE, 0x9A8B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A8C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A8E, 0xFFFE, 0x9A8D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A90, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A93, 0x9A91, 0x9A8F, 0x9A92, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A94, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A95, 0xFFFE,
	0xFFFE, 0x9A96, 0xFFFE, 0x9A97, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A98,
	0x9964, 0xFFFE, 0x8EFA, 0x8E6C, 0xFFFE, 0xFFFE, 0x89F1, 0xFFFE,
	0x88F6, 0xFFFE, 0xFFFE, 0x9263, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A99, 0xFFFE,
	0x8DA2, 0xFFFE, 0x88CD, 0x907D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9A9A, 0x8CC5, 0xFFFE, 0xFFFE, 0x8D91, 0xFFFE, 0x9A9C
} };

static const iconv_ccs_convtable_8bit from_ucs_57 = { {
	0x9A9B, 0xFFFE, 0xFFFE, 0x95DE, 0x9A9D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9A9F, 0x9A9E, 0xFFFE, 0x9AA0, 0xFFFE, 0x9AA1, 0xFFFE, 0x8C97,
	0xFFFE, 0xFFFE, 0x8980, 0x9AA2, 0xFFFE, 0xFFFE, 0x9AA4, 0xFFFE,
	0x9AA3, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AA6, 0xFFFE, 0xFFFE, 0x9379,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AA7, 0x88B3,
	0x8DDD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C5C, 0xFFFE, 0xFFFE,
	0x926E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AA8,
	0x9AA9, 0xFFFE, 0xFFFE, 0x9AAB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AAC, 0xFFFE, 0x8DE2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BCF,
	0xFFFE, 0xFFFE, 0x9656, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AAA, 0x9AAD,
	0x8DBF, 0x8D42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AB1, 0xFFFE, 0xFFFE, 0x8DA3, 0xFFFE, 0x9252, 0xFFFE,
	0xFFFE, 0x9AAE, 0x92D8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AB2,
	0xFFFE, 0xFFFE, 0x9082, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AB0, 0x9AB3, 0xFFFE, 0x8C5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9AB4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AB5, 0xFFFE, 0x8D43, 0x8A5F, 0x9AB7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9AB8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AB9, 0xFFFE, 0xFFFE, 0x9AB6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AAF, 0xFFFE, 0xFFFE, 0x9ABA, 0xFFFE, 0xFFFE, 0x9ABB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9684, 0xFFFE, 0xFFFE, 0x8FE9, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9ABD, 0x9ABE, 0x9ABC, 0xFFFE, 0x9AC0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9457, 0xFFFE, 0xFFFE, 0x88E6,
	0x9575, 0xFFFE, 0xFFFE, 0x9AC1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FFB, 0xFFFE, 0xFFFE, 0x8EB7,
	0xFFFE, 0x947C, 0x8AEE, 0xFFFE, 0x8DE9, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_58 = { {
	0x9678, 0xFFFE, 0x93B0, 0xFFFE, 0xFFFE, 0x8C98, 0x91CD, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9ABF, 0x9AC2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91C2, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AC3, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AC4, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AC6, 0xFFFE, 0xFFFE, 0x92E7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8AAC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA9F,
	0x8981, 0x95F1, 0xFFFE, 0xFFFE, 0x8FEA, 0x9367, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8DE4, 0xFFFE, 0xFFFE, 0x9ACC, 0xFFFE, 0xFFFE,
	0x95BB, 0x97DB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x89F2, 0x9AC8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9159, 0x9ACB, 0xFFFE, 0x9383, 0xFFFE, 0xFFFE, 0x9368,
	0x9384, 0x94B7, 0x92CB, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DC7, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9AC7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8996, 0xFFFE, 0x9355, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AC9, 0xFFFE, 0x9AC5, 0xFFFE, 0xFFFE, 0x906F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9ACD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F6D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8BAB, 0xFFFE, 0x9ACE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x95E6, 0xFFFE, 0xFFFE, 0xFFFE, 0x919D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92C4, 0xFFFE, 0xFFFE, 0x9AD0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x966E, 0xFFFE, 0xFFFE, 0x9AD1, 0xFFFE, 0xFFFE, 0x9AD6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x95AD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AD5, 0x9ACF, 0x9AD2, 0x9AD4, 0xFFFE, 0xFFFE, 0x8DA4, 0xFFFE,
	0xFFFE, 0x95C7, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AD7, 0xFFFE, 0x9264,
	0xFFFE, 0xFFFE, 0x89F3, 0xFFFE, 0x8FEB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9AD9, 0xFFFE, 0x9AD8, 0xFFFE, 0x8D88, 0xFFFE, 0x9ADA,
	0x9ADC, 0x9ADB, 0xFFFE, 0xFFFE, 0x9ADE, 0xFFFE, 0x9AD3, 0x9AE0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9ADF, 0x9ADD, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E6D, 0x9070, 0xFFFE, 0x9173, 0x9AE1,
	0x90BA, 0x88EB, 0x9484, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92D9,
	0xFFFE, 0x9AE3, 0x9AE2, 0x9AE4, 0x9AE5, 0x9AE6, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_59 = { {
	0xFFFE, 0xFFFE, 0x9AE7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95CF, 0x9AE8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x89C4,
	0x9AE9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x975B, 0x8A4F, 0xFFFE,
	0x99C7, 0x8F67, 0x91BD, 0x9AEA, 0x96E9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96B2, 0xFFFE, 0xFFFE, 0x9AEC, 0xFFFE, 0x91E5,
	0xFFFE, 0x9356, 0x91BE, 0x9576, 0x9AED, 0x9AEE, 0x899B, 0xFFFE,
	0xFFFE, 0x8EB8, 0x9AEF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x88CE,
	0x9AF0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AF1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8982, 0xFFFE, 0xFFFE, 0x8AEF,
	0x93DE, 0x95F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AF5, 0x9174,
	0x9AF4, 0x8C5F, 0xFFFE, 0xFFFE, 0x967A, 0x9AF3, 0xFFFE, 0x9385,
	0x9AF7, 0xFFFE, 0x9AF6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9AF9, 0xFFFE, 0x9AF8, 0xFFFE, 0xFFFE, 0x899C, 0xFFFE, 0x9AFA,
	0x8FA7, 0x9AFC, 0x9244, 0xFFFE, 0x9AFB, 0xFFFE, 0x95B1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8F97, 0x937A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8D44, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B41, 0x9440, 0x94DC, 0x96CF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9444, 0xFFFE, 0xFFFE, 0x9B4A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8B57, 0xFFFE, 0xFFFE, 0x9764, 0xFFFE,
	0xFFFE, 0x96AD, 0xFFFE, 0x9BAA, 0xFFFE, 0x9B42, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9B45, 0xFFFE, 0x91C3, 0xFFFE, 0xFFFE,
	0x9657, 0xFFFE, 0xFFFE, 0xFFFE, 0x9369, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9685, 0xFFFE, 0x8DC8, 0xFFFE, 0xFFFE, 0x8FA8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B47, 0xFFFE,
	0xFFFE, 0x8E6F, 0xFFFE, 0x8E6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x88B7, 0x8CC6, 0xFFFE, 0x90A9, 0x88CF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B4B, 0x9B4C, 0xFFFE, 0x9B49, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8957, 0x8AAD, 0xFFFE,
	0x9B48, 0xFFFE, 0x96C3, 0x9550, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x88A6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88F7, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E70
} };

static const iconv_ccs_convtable_8bit from_ucs_5A = { {
	0xFFFE, 0x88D0, 0xFFFE, 0x88A1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x96BA, 0xFFFE, 0x9B52, 0xFFFE, 0x9B50, 0xFFFE, 0xFFFE, 0x9B4E,
	0x9050, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B4D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95D8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CE2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B56, 0x9B57, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FA9, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B53, 0x984B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x946B, 0xFFFE,
	0xFFFE, 0x9B55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8DA5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B58, 0xFFFE, 0xFFFE, 0xFFFE, 0x9577, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B59, 0xFFFE, 0x9B54, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96B9,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x947D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B5A, 0x9551, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B5B, 0x9B5F, 0x9B5C, 0xFFFE,
	0xFFFE, 0x89C5, 0x9B5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8EB9, 0xFFFE, 0x9B5D, 0x8C99, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B64, 0x9B61,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9284, 0xFFFE, 0x9B60, 0xFFFE, 0xFFFE, 0x9B62, 0xFFFE,
	0xFFFE, 0x9B63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B65, 0x9B66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8AF0, 0xFFFE, 0x9B68, 0x9B67, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B69, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8FEC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9B6C, 0xFFFE, 0x92DA, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8964, 0xFFFE, 0x9B6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B6D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9B6E, 0xFFFE,
	0x9B71, 0xFFFE, 0xFFFE, 0x9B6F, 0xFFFE, 0x9B70, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8E71, 0x9B72, 0xFFFE, 0xFFFE, 0x8D45, 0x9B73, 0xFFFE, 0x8E9A,
	0x91B6, 0xFFFE, 0x9B74, 0x9B75, 0x8E79, 0x8D46, 0xFFFE, 0x96D0,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8B47, 0x8CC7, 0x9B76, 0x8A77, 0xFFFE,
	0xFFFE, 0x9B77, 0xFFFE, 0x91B7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B78, 0x9BA1, 0xFFFE, 0x9B79, 0xFFFE, 0x9B7A, 0xFFFE, 0xFFFE,
	0x9B7B, 0xFFFE, 0x9B7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B7E, 0xFFFE, 0xFFFE, 0x9B80, 0xFFFE, 0x91EE, 0xFFFE, 0x8946,
	0x8EE7, 0x88C0, 0xFFFE, 0x9176, 0x8AAE, 0x8EB3, 0xFFFE, 0x8D47,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9386, 0xFFFE, 0x8F40,
	0x8AAF, 0x9288, 0x92E8, 0x88B6, 0x8B58, 0x95F3, 0xFFFE, 0x8EC0,
	0xFFFE, 0xFFFE, 0x8B71, 0x90E9, 0x8EBA, 0x9747, 0x9B81, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B7B, 0xFFFE,
	0x8DC9, 0xFFFE, 0xFFFE, 0x8A51, 0x8983, 0x8FAA, 0x89C6, 0xFFFE,
	0x9B82, 0x9765, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F68,
	0xFFFE, 0xFFFE, 0x8EE2, 0x9B83, 0x8AF1, 0x93D0, 0x96A7, 0x9B84,
	0xFFFE, 0x9B85, 0xFFFE, 0xFFFE, 0x9578, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B87, 0xFFFE, 0x8AA6, 0x8BF5, 0x9B86, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8AB0, 0xFFFE, 0x9051, 0x9B8B, 0x8E40,
	0xFFFE, 0x89C7, 0x9B8A, 0xFFFE, 0x9B88, 0x9B8C, 0x9B89, 0x944A,
	0x9ECB, 0x9052, 0xFFFE, 0x9B8D, 0xFFFE, 0xFFFE, 0x97BE, 0xFFFE,
	0x9B8E, 0xFFFE, 0xFFFE, 0x9B90, 0xFFFE, 0x929E, 0x9B8F, 0xFFFE,
	0x90A1, 0xFFFE, 0x8E9B, 0xFFFE, 0xFFFE, 0xFFFE, 0x91CE, 0x8EF5
} };

static const iconv_ccs_convtable_8bit from_ucs_5C = { {
	0xFFFE, 0x9595, 0x90EA, 0xFFFE, 0x8ECB, 0x9B91, 0x8FAB, 0x9B92,
	0x9B93, 0x88D1, 0x91B8, 0x9071, 0xFFFE, 0x9B94, 0x93B1, 0x8FAC,
	0xFFFE, 0x8FAD, 0xFFFE, 0x9B95, 0xFFFE, 0xFFFE, 0x90EB, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8FAE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B96, 0xFFFE, 0x9B97, 0xFFFE, 0x96DE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B98, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BC4, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9B99, 0x9B9A, 0x8EDA, 0x904B, 0x93F2, 0x9073, 0x94F6, 0x9441,
	0x8BC7, 0x9B9B, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B8F, 0x9B9C, 0xFFFE,
	0x8BFC, 0xFFFE, 0x93CD, 0x89AE, 0xFFFE, 0x8E72, 0x9B9D, 0x9BA0,
	0x9B9F, 0x8BFB, 0xFFFE, 0x9B9E, 0xFFFE, 0x9357, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91AE, 0xFFFE,
	0x936A, 0x8EC6, 0xFFFE, 0xFFFE, 0x9177, 0x979A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BA2, 0xFFFE, 0x9BA3, 0x93D4,
	0xFFFE, 0x8E52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BA5, 0xFFFE,
	0xFFFE, 0x9BA6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BA7, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AF2, 0x9BA8, 0xFFFE, 0xFFFE, 0x9BA9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89AA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x915A, 0x8AE2, 0xFFFE, 0x9BAB, 0x96A6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x91D0, 0xFFFE, 0x8A78, 0xFFFE, 0xFFFE, 0x9BAD, 0x9BAF,
	0x8ADD, 0xFFFE, 0xFFFE, 0x9BAC, 0x9BAE, 0xFFFE, 0x9BB1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BB0, 0xFFFE, 0x9BB2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BB3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x93BB, 0x8BAC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x89E3, 0x9BB4, 0x9BB9, 0xFFFE, 0xFFFE, 0x9BB7, 0xFFFE, 0x95F5,
	0x95F4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9387, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9BB6, 0x8F73, 0xFFFE, 0x9BB5, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9092,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9BBA, 0xFFFE, 0xFFFE, 0x8DE8, 0xFFFE,
	0xFFFE, 0x9BC0, 0xFFFE, 0xFFFE, 0x9BC1, 0x9BBB, 0x8A52, 0x9BBC,
	0x9BC5, 0x9BC4, 0x9BC3, 0x9BBF, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BBE,
	0xFFFE, 0xFFFE, 0x9BC2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9BC9, 0x9BC6, 0xFFFE, 0x9BC8, 0xFFFE,
	0x9792, 0xFFFE, 0x9BC7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BBD, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9093, 0xFFFE, 0xFFFE, 0x9BCA, 0xFFFE, 0xFFFE, 0x8DB5,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9BCB, 0xFFFE, 0xFFFE, 0x9BCC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9BCF, 0xFFFE, 0x9BCE, 0xFFFE, 0xFFFE, 0x9BCD,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9388, 0x9BB8, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9BD5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BD1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9BD0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BD2, 0xFFFE, 0x9BD3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BD6,
	0xFFFE, 0xFFFE, 0x97E4, 0xFFFE, 0x9BD7, 0x9BD4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BD8, 0xFFFE, 0xFFFE, 0x8ADE, 0x9BD9, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9BDB, 0x9BDA, 0xFFFE, 0xFFFE, 0x9BDC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9BDD, 0xFFFE, 0x90EC, 0x8F42, 0xFFFE,
	0xFFFE, 0x8F84, 0xFFFE, 0x9183, 0xFFFE, 0x8D48, 0x8DB6, 0x8D49,
	0x8B90, 0xFFFE, 0xFFFE, 0x9BDE, 0xFFFE, 0xFFFE, 0x8DB7, 0xFFFE,
	0xFFFE, 0x8CC8, 0x9BDF, 0x96A4, 0x9462, 0x9BE0, 0xFFFE, 0x8D4A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8AAA, 0xFFFE, 0x9246, 0x8BD0, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5E = { {
	0xFFFE, 0xFFFE, 0x8E73, 0x957A, 0xFFFE, 0xFFFE, 0x94BF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9BE1, 0x8AF3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BE4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x929F, 0xFFFE,
	0xFFFE, 0x9BE3, 0x9BE2, 0x9BE5, 0xFFFE, 0x92E9, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9083, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E74, 0xFFFE, 0x90C8, 0xFFFE, 0x91D1,
	0x8B41, 0xFFFE, 0xFFFE, 0x92A0, 0xFFFE, 0xFFFE, 0x9BE6, 0x9BE7,
	0x8FED, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9658, 0xFFFE, 0xFFFE,
	0x9BEA, 0xFFFE, 0xFFFE, 0x9BE9, 0x9BE8, 0x959D, 0xFFFE, 0x9BF1,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9679, 0xFFFE, 0x9BEB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BED, 0x968B, 0xFFFE, 0x9BEC,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BEE,
	0xFFFE, 0x94A6, 0x9BEF, 0x95BC, 0x9BF0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8AB1, 0x95BD, 0x944E, 0x9BF2, 0x9BF3, 0xFFFE,
	0x8D4B, 0x8AB2, 0x9BF4, 0x8CB6, 0x9763, 0x9748, 0x8AF4, 0x9BF6,
	0xFFFE, 0x92A1, 0xFFFE, 0x8D4C, 0x8FAF, 0xFFFE, 0xFFFE, 0x94DD,
	0xFFFE, 0xFFFE, 0x8FB0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F98,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92EA, 0x95F7, 0x9358,
	0xFFFE, 0xFFFE, 0x8D4D, 0xFFFE, 0x957B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9BF7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9378, 0x8DC0,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8CC9, 0xFFFE, 0x92EB, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x88C1, 0x8F8E, 0x8D4E,
	0x9766, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9BF8, 0x9BF9, 0x9470, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9BFA, 0x97F5, 0x984C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9BFC,
	0x9BFB, 0xFFFE, 0xFFFE, 0x8A66, 0xFFFE, 0xFFFE, 0x9C40, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9C43, 0x9C44, 0xFFFE, 0x9C42, 0xFFFE, 0x955F,
	0x8FB1, 0x9C46, 0x9C45, 0x9C41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9C47, 0x9C48, 0xFFFE, 0xFFFE, 0x9C49, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9C4C, 0x9C4A, 0xFFFE, 0x9C4B, 0x9C4D, 0xFFFE, 0x8984, 0x92EC,
	0x9C4E, 0xFFFE, 0x8C9A, 0x89F4, 0x9455, 0xFFFE, 0x9C4F, 0x93F9
} };

static const iconv_ccs_convtable_8bit from_ucs_5F = { {
	0xFFFE, 0x95D9, 0xFFFE, 0x9C50, 0x984D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C51, 0x95BE, 0x9C54, 0x989F, 0x98AF, 0xFFFE, 0x8EAE,
	0x93F3, 0x9C55, 0xFFFE, 0x8B7C, 0x92A2, 0x88F8, 0x9C56, 0x95A4,
	0x8D4F, 0xFFFE, 0xFFFE, 0x926F, 0xFFFE, 0xFFFE, 0xFFFE, 0x92ED,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96ED, 0x8CB7, 0x8CCA,
	0xFFFE, 0x9C57, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C58, 0xFFFE, 0x9C5E,
	0xFFFE, 0x8EE3, 0xFFFE, 0xFFFE, 0xFFFE, 0x92A3, 0xFFFE, 0x8BAD,
	0x9C59, 0xFFFE, 0xFFFE, 0xFFFE, 0x954A, 0xFFFE, 0x9265, 0xFFFE,
	0xFFFE, 0x9C5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9C5B, 0xFFFE, 0x8BAE, 0xFFFE, 0x9C5C, 0xFFFE, 0x9C5D, 0xFFFE,
	0xFFFE, 0x9C5F, 0xFFFE, 0x9396, 0xFFFE, 0xFFFE, 0x9C60, 0x9C61,
	0xFFFE, 0x9C62, 0xFFFE, 0xFFFE, 0x9C53, 0x9C52, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C63, 0x8C60, 0xFFFE, 0xFFFE, 0xFFFE, 0x9546, 0xFFFE,
	0xFFFE, 0x8DCA, 0x9556, 0x92A4, 0x956A, 0x9C64, 0xFFFE, 0xFFFE,
	0x8FB2, 0x8965, 0xFFFE, 0x9C65, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C66,
	0xFFFE, 0x96F0, 0xFFFE, 0xFFFE, 0x94DE, 0xFFFE, 0xFFFE, 0x9C69,
	0x899D, 0x90AA, 0x9C68, 0x9C67, 0x8C61, 0x91D2, 0xFFFE, 0x9C6D,
	0x9C6B, 0xFFFE, 0x9C6A, 0x97A5, 0x8CE3, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8F99, 0x9C6C, 0x936B, 0x8F5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x93BE,
	0x9C70, 0x9C6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C6E, 0xFFFE,
	0x9C71, 0x8CE4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9C72, 0x959C, 0x8F7A, 0xFFFE, 0xFFFE, 0x9C73, 0x94F7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x93BF, 0x92A5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x934F, 0xFFFE, 0xFFFE, 0x9C74, 0x8B4A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9053, 0xFFFE, 0x954B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AF5, 0x9445, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C75, 0x8E75,
	0x9659, 0x965A, 0xFFFE, 0xFFFE, 0x899E, 0x9C7A, 0xFFFE, 0xFFFE,
	0x9289, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C77, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x89F5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9CAB, 0x9C79, 0xFFFE, 0xFFFE, 0xFFFE, 0x944F, 0xFFFE, 0xFFFE,
	0x9C78, 0xFFFE, 0xFFFE, 0x9C76, 0xFFFE, 0x8D9A, 0xFFFE, 0x9C7C
} };

static const iconv_ccs_convtable_8bit from_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C83, 0x9C89,
	0x9C81, 0xFFFE, 0x937B, 0xFFFE, 0xFFFE, 0x9C86, 0x957C, 0xFFFE,
	0xFFFE, 0x9C80, 0xFFFE, 0x9C85, 0x97E5, 0x8E76, 0xFFFE, 0xFFFE,
	0x91D3, 0x9C7D, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B7D, 0x9C88, 0x90AB,
	0x8985, 0x9C82, 0x89F6, 0x9C87, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BAF,
	0xFFFE, 0x9C84, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9C8A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C8C, 0x9C96, 0x9C94, 0xFFFE, 0xFFFE, 0x9C91, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9C90, 0x97F6, 0xFFFE, 0x9C92, 0xFFFE, 0xFFFE,
	0x8BB0, 0xFFFE, 0x8D50, 0xFFFE, 0xFFFE, 0x8F9A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C99, 0x9C8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C8F,
	0x9C7E, 0xFFFE, 0x89F8, 0x9C93, 0x9C95, 0x9270, 0xFFFE, 0xFFFE,
	0x8DA6, 0x89B6, 0x9C8D, 0x9C98, 0x9C97, 0x8BB1, 0xFFFE, 0x91A7,
	0x8A86, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C62, 0xFFFE, 0x9C8E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C9A, 0xFFFE, 0x9C9D, 0x9C9F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8EBB, 0xFFFE, 0x9CA5, 0x92EE, 0x9C9B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9CA3, 0xFFFE, 0x89F7, 0xFFFE, 0x9CA1, 0x9CA2,
	0xFFFE, 0xFFFE, 0x9C9E, 0x9CA0, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CE5,
	0x9749, 0xFFFE, 0xFFFE, 0x8AB3, 0xFFFE, 0xFFFE, 0x8978, 0x9CA4,
	0xFFFE, 0x9459, 0x88AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x94DF, 0x9C7B, 0x9CAA, 0x9CAE, 0x96E3, 0xFFFE,
	0x9CA7, 0xFFFE, 0xFFFE, 0xFFFE, 0x9389, 0x9CAC, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FEE, 0x9CAD, 0x93D5,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9866, 0xFFFE, 0x9CA9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9CAF, 0xFFFE, 0x8D9B, 0xFFFE, 0x90C9, 0xFFFE, 0xFFFE, 0x88D2,
	0x9CA8, 0x9CA6, 0xFFFE, 0x9179, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C9C,
	0x8E53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x91C4, 0x9CBB, 0xFFFE, 0x917A, 0x9CB6, 0xFFFE, 0x9CB3, 0x9CB4,
	0xFFFE, 0x8EE4, 0x9CB7, 0x9CBA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_61 = { {
	0x9CB5, 0x8F44, 0xFFFE, 0x9CB8, 0xFFFE, 0xFFFE, 0x9CB2, 0xFFFE,
	0x96FA, 0x96F9, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CBC, 0x9CBD, 0x88D3,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CB1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8BF0, 0x88A4, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AB4,
	0xFFFE, 0x9CB9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CC1,
	0x9CC0, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CC5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CC6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CC4, 0x9CC7, 0x9CBF, 0x9CC3,
	0xFFFE, 0xFFFE, 0x9CC8, 0xFFFE, 0x9CC9, 0xFFFE, 0xFFFE, 0x9CBE,
	0x8E9C, 0xFFFE, 0x9CC2, 0x91D4, 0x8D51, 0x9CB0, 0x9054, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9CD6, 0xFFFE, 0x95E7, 0xFFFE, 0xFFFE,
	0x9CCC, 0x9CCD, 0x9CCE, 0xFFFE, 0xFFFE, 0x9CD5, 0xFFFE, 0x9CD4,
	0xFFFE, 0xFFFE, 0x969D, 0x8AB5, 0xFFFE, 0x9CD2, 0xFFFE, 0x8C64,
	0x8A53, 0xFFFE, 0xFFFE, 0x9CCF, 0xFFFE, 0xFFFE, 0x97B6, 0x9CD1,
	0x88D4, 0x9CD3, 0xFFFE, 0x9CCA, 0x9CD0, 0x9CD7, 0x8C63, 0x9CCB,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x977C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x974A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9CDA,
	0xFFFE, 0xFFFE, 0x9CDE, 0xFFFE, 0xFFFE, 0xFFFE, 0x919E, 0xFFFE,
	0x97F7, 0x9CDF, 0xFFFE, 0xFFFE, 0x9CDC, 0xFFFE, 0x9CD9, 0xFFFE,
	0xFFFE, 0x9CD8, 0x9CDD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95AE, 0xFFFE, 0xFFFE, 0x93B2,
	0xFFFE, 0x8C65, 0xFFFE, 0x9CE0, 0x9CDB, 0xFFFE, 0x9CE1, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C9B, 0xFFFE, 0xFFFE, 0xFFFE, 0x89AF, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9CE9, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AB6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9CE7, 0xFFFE, 0xFFFE, 0x9CE8, 0x8DA7,
	0x9CE6, 0x9CE4, 0x9CE3, 0x9CEA, 0x9CE2, 0x9CEC, 0xFFFE, 0xFFFE,
	0x89F9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9CEE, 0xFFFE, 0xFFFE, 0x9CED, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x92A6, 0xFFFE, 0x9CF1, 0xFFFE, 0x9CEF, 0x9CE5,
	0x8C9C, 0xFFFE, 0x9CF0, 0xFFFE, 0x9CF4, 0x9CF3, 0x9CF5, 0x9CF2
} };

static const iconv_ccs_convtable_8bit from_ucs_62 = { {
	0x9CF6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9CF7, 0x9CF8, 0x95E8, 0xFFFE, 0x9CFA, 0x9CF9, 0x8F5E, 0xFFFE,
	0x90AC, 0x89E4, 0x89FA, 0xFFFE, 0x9CFB, 0xFFFE, 0x88BD, 0xFFFE,
	0xFFFE, 0xFFFE, 0x90CA, 0x9CFC, 0xFFFE, 0xE6C1, 0x9D40, 0x8C81,
	0xFFFE, 0x9D41, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90ED, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D42, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D43, 0x8B59,
	0x9D44, 0xFFFE, 0x9D45, 0x9D46, 0x91D5, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8CCB, 0xFFFE, 0xFFFE, 0x96DF, 0xFFFE, 0xFFFE, 0xFFFE, 0x965B,
	0x8F8A, 0x9D47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90EE,
	0xE7BB, 0x94E0, 0xFFFE, 0x8EE8, 0xFFFE, 0x8DCB, 0x9D48, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x91C5, 0xFFFE, 0x95A5, 0xFFFE, 0xFFFE,
	0x91EF, 0xFFFE, 0xFFFE, 0x9D4B, 0xFFFE, 0xFFFE, 0x9D49, 0xFFFE,
	0x9D4C, 0xFFFE, 0xFFFE, 0x9D4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9D4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95AF, 0xFFFE,
	0xFFFE, 0x88B5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x957D, 0xFFFE,
	0xFFFE, 0x94E1, 0xFFFE, 0xFFFE, 0x9D4E, 0xFFFE, 0x9D51, 0x8FB3,
	0x8B5A, 0xFFFE, 0x9D4F, 0x9D56, 0x8FB4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9D50, 0x9463, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x977D, 0x9D52, 0x9D53, 0x9D57, 0x938A, 0x9D54, 0x8D52,
	0x90DC, 0xFFFE, 0xFFFE, 0x9D65, 0x94B2, 0xFFFE, 0x91F0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x94E2, 0x9DAB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95F8, 0xFFFE, 0xFFFE, 0xFFFE, 0x92EF, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9695, 0xFFFE, 0x9D5A, 0x899F, 0x928A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D63, 0xFFFE, 0xFFFE, 0x9253, 0x9D5D, 0x9D64,
	0x9D5F, 0x9D66, 0x9D62, 0xFFFE, 0x9D61, 0x948F, 0xFFFE, 0x9D5B,
	0x89FB, 0x9D59, 0x8B91, 0x91F1, 0x9D55, 0xFFFE, 0xFFFE, 0x9D58,
	0x8D53, 0x90D9, 0xFFFE, 0x8FB5, 0x9D60, 0x9471, 0xFFFE, 0xFFFE,
	0x8B92, 0x8A67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A87, 0x9040, 0x9D68, 0x9D6D,
	0xFFFE, 0x9D69, 0xFFFE, 0x8C9D, 0xFFFE, 0x9D6E, 0x8E41, 0x8D89,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F45, 0x9D5C
} };

static const iconv_ccs_convtable_8bit from_ucs_63 = { {
	0xFFFE, 0x8E9D, 0x9D6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E77,
	0x9D6C, 0x88C2, 0xFFFE, 0xFFFE, 0x9D67, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x92A7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8B93, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BB2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D6A,
	0x88A5, 0xFFFE, 0xFFFE, 0x8DC1, 0xFFFE, 0xFFFE, 0xFFFE, 0x9055,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x92F0, 0xFFFE, 0xFFFE, 0x94D2, 0x9D70, 0x917D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x91A8, 0xFFFE, 0xFFFE, 0x8E4A, 0x9D71, 0xFFFE, 0x9D73,
	0x9D6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95DF, 0xFFFE, 0x92BB,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x917B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95F9,
	0x8ECC, 0x9D80, 0xFFFE, 0x9D7E, 0xFFFE, 0xFFFE, 0x9098, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C9E, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D78, 0x8FB7,
	0xFFFE, 0xFFFE, 0x93E6, 0x9450, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9D76, 0xFFFE, 0xFFFE, 0x917C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8EF6, 0x9D7B, 0xFFFE, 0xFFFE, 0x8FB6, 0xFFFE, 0x9D75, 0x9D7A,
	0xFFFE, 0xFFFE, 0x9472, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D74, 0xFFFE,
	0x8C40, 0xFFFE, 0xFFFE, 0x8A7C, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D7C,
	0x97A9, 0x8DCC, 0x9254, 0x9D79, 0xFFFE, 0x90DA, 0xFFFE, 0x8D54,
	0x9084, 0x8986, 0x915B, 0x9D77, 0x8B64, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C66, 0xFFFE, 0x92CD, 0x9D7D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x917E, 0xFFFE, 0xFFFE, 0x9D81, 0xFFFE,
	0x9D83, 0xFFFE, 0xFFFE, 0x91B5, 0x9D89, 0xFFFE, 0x9D84, 0xFFFE,
	0xFFFE, 0x9D86, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9560,
	0x92F1, 0xFFFE, 0x9D87, 0xFFFE, 0xFFFE, 0xFFFE, 0x974B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9767, 0x8AB7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x88AC, 0xFFFE, 0x9D85, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9D82, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AF6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8987, 0xFFFE, 0x9D88, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9768, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D8C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91B9, 0xFFFE, 0x9D93,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9D8D, 0xFFFE, 0xFFFE, 0x9D8A, 0x9D91,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D72, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D8E, 0xFFFE,
	0x9D92, 0xFFFE, 0xFFFE, 0xFFFE, 0x94C0, 0x938B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D8B, 0xFFFE, 0x9D8F, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C67, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DEF, 0xFFFE,
	0xFFFE, 0xFFFE, 0x90DB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D97, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9345, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D94,
	0xFFFE, 0x9680, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D95,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9D96, 0xFFFE,
	0x96CC, 0xFFFE, 0x90A0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C82, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9D9D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8E54, 0x9D9A, 0xFFFE, 0x9D99, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9451, 0xFFFE, 0xFFFE, 0xFFFE, 0x93B3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9350, 0x9D9B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9D9C, 0xFFFE, 0x958F, 0xFFFE, 0x9464, 0x8E42, 0xFFFE,
	0x90EF, 0xFFFE, 0x966F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A68, 0xFFFE, 0x9DA3, 0x9D9E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9769, 0x9DA5, 0xFFFE, 0xFFFE, 0x9DA1, 0xFFFE, 0x9DA2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9180, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9DA0, 0xFFFE, 0x9D5E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9DA4, 0xFFFE, 0x9D9F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9DA9, 0x9DAA, 0x9346, 0x9DAC, 0xFFFE, 0xFFFE, 0x8E43, 0x9DA7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B5B, 0xFFFE, 0xFFFE, 0x9DAD,
	0xFFFE, 0x9DA6, 0x9DB1, 0xFFFE, 0x9DB0, 0xFFFE, 0x9DAF, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9DB2, 0xFFFE, 0xFFFE, 0x9DB4, 0x8FEF, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_65 = { {
	0x9DB3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DB7, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9DB5, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DB6, 0x9D90, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9DB9, 0x9DB8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D98, 0x9DBA, 0x9DAE, 0xFFFE, 0xFFFE, 0x8E78,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DBB, 0x9DBC, 0x9DBE, 0x9DBD,
	0x9DBF, 0x89FC, 0xFFFE, 0x8D55, 0xFFFE, 0xFFFE, 0x95FA, 0x90AD,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CCC, 0xFFFE, 0xFFFE,
	0x9DC1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DC4, 0xFFFE, 0x9571,
	0xFFFE, 0x8B7E, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DC3, 0x9DC2, 0x9473,
	0x9DC5, 0x8BB3, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DC7, 0x9DC6, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8AB8, 0x8E55, 0xFFFE, 0xFFFE, 0x93D6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C68, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9094, 0xFFFE, 0x9DC8, 0xFFFE, 0x90AE, 0x9347, 0xFFFE, 0x957E,
	0x9DC9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9DCA, 0x9DCB, 0xFFFE, 0xFFFE, 0xFFFE, 0x95B6,
	0x9B7C, 0x90C4, 0xFFFE, 0xFFFE, 0x956B, 0xFFFE, 0x8DD6, 0xFFFE,
	0x94E3, 0x94C1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x936C,
	0xFFFE, 0x97BF, 0xFFFE, 0x9DCD, 0x8ECE, 0xFFFE, 0xFFFE, 0x9DCE,
	0xFFFE, 0x88B4, 0xFFFE, 0xFFFE, 0x8BD2, 0x90CB, 0xFFFE, 0x9580,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9DCF, 0x8E61, 0x9266, 0xFFFE, 0x8E7A,
	0x9056, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DD0,
	0xFFFE, 0x95FB, 0xFFFE, 0xFFFE, 0x8997, 0x8E7B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DD3, 0xFFFE, 0x9DD1, 0x9DD4, 0x97B7, 0x9DD2, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x90F9, 0x9DD5, 0xFFFE, 0xFFFE, 0x91B0,
	0xFFFE, 0xFFFE, 0x9DD6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AF8,
	0xFFFE, 0x9DD8, 0xFFFE, 0x9DD7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9DD9, 0x9DDA, 0x8AF9, 0xFFFE, 0xFFFE, 0x93FA, 0x9255, 0x8B8C,
	0x8E7C, 0x9181, 0xFFFE, 0xFFFE, 0x8F7B, 0x88AE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DDB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x89A0, 0x9DDF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_66 = { {
	0xFFFE, 0xFFFE, 0x8D56, 0x9DDE, 0xFFFE, 0xFFFE, 0x8DA9, 0x8FB8,
	0xFFFE, 0xFFFE, 0x9DDD, 0xFFFE, 0x8FB9, 0xFFFE, 0x96BE, 0x8DA8,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88D5, 0x90CC, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DE4, 0xFFFE, 0xFFFE, 0x90AF,
	0x8966, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F74, 0xFFFE, 0x9686,
	0x8DF0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FBA, 0xFFFE, 0x90A5,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DE3, 0x9DE1, 0x9DE2, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x928B, 0xFFFE, 0xFFFE, 0x9E45,
	0xFFFE, 0x9DE8, 0x8E9E, 0x8D57, 0x9DE6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DE7, 0xFFFE, 0x9057, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DE5,
	0xFFFE, 0xFFFE, 0x8E4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DEA, 0x9DE9, 0x9DEE,
	0xFFFE, 0xFFFE, 0x9DEF, 0xFFFE, 0x9DEB, 0xFFFE, 0x8A41, 0x9DEC,
	0x9DED, 0x94D3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9581, 0x8C69,
	0x9DF0, 0xFFFE, 0xFFFE, 0xFFFE, 0x90B0, 0xFFFE, 0x8FBB, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9271, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8BC5, 0xFFFE, 0x9DF1, 0x9DF5, 0xFFFE, 0xFFFE, 0x89C9,
	0x9DF2, 0x9DF4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DF3, 0xFFFE,
	0xFFFE, 0x8F8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9267, 0x88C3,
	0x9DF6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DF7, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x92A8, 0xFFFE, 0xFFFE, 0xFFFE, 0x97EF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E62, 0xFFFE, 0xFFFE, 0x95E9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x965C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9E41, 0x9DF9, 0xFFFE, 0xFFFE, 0x9DFC, 0xFFFE, 0x9DFB, 0xFFFE,
	0xFFFE, 0x9DF8, 0xFFFE, 0xFFFE, 0x9E40, 0xFFFE, 0xFFFE, 0x93DC,
	0xFFFE, 0x9DFA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E42, 0xFFFE,
	0xFFFE, 0x8F8C, 0x9E43, 0xFFFE, 0x976A, 0x9498, 0xFFFE, 0xFFFE,
	0x9E44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E46, 0xFFFE,
	0xFFFE, 0x9E47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9E48, 0xFFFE, 0x8BC8, 0x8967, 0x8D58, 0x9E49, 0xFFFE, 0x9E4A,
	0x8F91, 0x9182, 0xFFFE, 0xFFFE, 0x99D6, 0x915D, 0x915C, 0x91D6
} };

static const iconv_ccs_convtable_8bit from_ucs_67 = { {
	0x8DC5, 0xFFFE, 0xFFFE, 0x98F0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C8E, 0x974C, 0xFFFE, 0x95FC, 0xFFFE, 0x959E, 0xFFFE, 0x9E4B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DF1, 0x92BD, 0x9E4C, 0x984E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x965D, 0xFFFE, 0x92A9, 0x9E4D, 0x8AFA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E4E, 0x9E4F,
	0x96D8, 0xFFFE, 0x96A2, 0x9696, 0x967B, 0x8E44, 0x9E51, 0xFFFE,
	0xFFFE, 0x8EE9, 0xFFFE, 0xFFFE, 0x9670, 0xFFFE, 0x9E53, 0x9E56,
	0x9E55, 0xFFFE, 0x8AF7, 0xFFFE, 0xFFFE, 0x8B80, 0xFFFE, 0x9E52,
	0xFFFE, 0x9E54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E57, 0xFFFE,
	0xFFFE, 0x9099, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x979B, 0x88C7,
	0x8DDE, 0x91BA, 0xFFFE, 0x8EDB, 0xFFFE, 0xFFFE, 0x8FF1, 0xFFFE,
	0xFFFE, 0x9E5A, 0xFFFE, 0xFFFE, 0x936D, 0xFFFE, 0x9E58, 0x91A9,
	0x9E59, 0x8FF0, 0x96DB, 0x9E5B, 0x9E5C, 0x9788, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9E61, 0xFFFE, 0xFFFE, 0x8D59, 0xFFFE, 0x9474,
	0x9E5E, 0x938C, 0x9DDC, 0x9DE0, 0xFFFE, 0x8B6E, 0xFFFE, 0x9466,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E60, 0xFFFE, 0x8FBC, 0x94C2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E66, 0xFFFE, 0x94F8,
	0xFFFE, 0x9E5D, 0xFFFE, 0x9E63, 0x9E62, 0xFFFE, 0xFFFE, 0xFFFE,
	0x90CD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x968D, 0xFFFE, 0x97D1,
	0xFFFE, 0xFFFE, 0x9687, 0xFFFE, 0x89CA, 0x8E7D, 0xFFFE, 0xFFFE,
	0x9867, 0x9E65, 0x9095, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E64, 0xFFFE,
	0xFFFE, 0x9E5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CCD,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9E6B, 0x9E69, 0xFFFE, 0x89CB, 0x9E67,
	0x9E6D, 0x9E73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x91C6, 0xFFFE, 0xFFFE, 0x95BF, 0xFFFE, 0x9E75, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9541, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E74, 0x9490,
	0x965E, 0x8AB9, 0xFFFE, 0x90F5, 0x8F5F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x92D1, 0xFFFE, 0x974D, 0xFFFE, 0xFFFE, 0x9E70, 0x9E6F, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9E71, 0xFFFE, 0x9E6E, 0xFFFE, 0xFFFE, 0x9E76,
	0xFFFE, 0x9E6C, 0xFFFE, 0xFFFE, 0x9E6A, 0xFFFE, 0x9E72, 0x9E68,
	0xFFFE, 0x928C, 0xFFFE, 0x96F6, 0x8EC4, 0x8DF2, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8DB8, 0xFFFE, 0xFFFE, 0x968F, 0x8A60
} };

static const iconv_ccs_convtable_8bit from_ucs_68 = { {
	0xFFFE, 0xFFFE, 0x92CC, 0x93C8, 0x8968, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x90F0, 0xFFFE, 0xFFFE, 0x90B2, 0x8C49,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E78, 0xFFFE,
	0xFFFE, 0x8D5A, 0x8A9C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9E7A, 0x8A94, 0x9E81, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9E7D, 0xFFFE, 0x90F1, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8A6A, 0x8DAA, 0xFFFE, 0xFFFE, 0x8A69, 0x8DCD, 0xFFFE, 0xFFFE,
	0x9E7B, 0x8C85, 0x8C6A, 0x938D, 0xFFFE, 0xFFFE, 0x9E79, 0xFFFE,
	0x88C4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E7C, 0x9E7E, 0xFFFE,
	0x8BCB, 0x8C4B, 0xFFFE, 0x8ABA, 0x8B6A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9E82, 0xFFFE, 0xFFFE, 0x8DF7, 0x9691, 0xFFFE, 0x8E56,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9E83, 0xFFFE, 0xFFFE, 0xFFFE, 0x954F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E8F, 0xFFFE, 0x89B1, 0x9E84,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E95, 0x9E85,
	0xFFFE, 0x97C0, 0xFFFE, 0x9E8C, 0xFFFE, 0x947E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E94, 0xFFFE, 0x9E87,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88B2, 0x9E89, 0xFFFE, 0xFFFE, 0x8D5B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9E8B, 0xFFFE, 0x9E8A, 0xFFFE, 0x9E86,
	0x9E91, 0xFFFE, 0x8FBD, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AEB, 0x8CE6,
	0x979C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E88, 0xFFFE, 0x92F2,
	0x8A42, 0x8DAB, 0xFFFE, 0x9E80, 0xFFFE, 0x9E90, 0x8A81, 0xFFFE,
	0xFFFE, 0x9E8E, 0x9E92, 0xFFFE, 0x938E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AFC, 0xFFFE, 0x9EB0, 0xFFFE,
	0xFFFE, 0x96C7, 0x9E97, 0x8AFB, 0xFFFE, 0x9E9E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x965F, 0xFFFE, 0x9E9F, 0x9EA1, 0xFFFE, 0x9EA5,
	0x9E99, 0xFFFE, 0x9249, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x938F,
	0x9EA9, 0x9E9C, 0xFFFE, 0x9EA6, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EA0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9058, 0x9EAA,
	0xFFFE, 0xFFFE, 0x90B1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EA8, 0x8ABB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_69 = { {
	0x986F, 0x9E96, 0xFFFE, 0xFFFE, 0x9EA4, 0x88D6, 0xFFFE, 0xFFFE,
	0x9E98, 0xFFFE, 0xFFFE, 0x96B8, 0x9E9D, 0x9041, 0x92C5, 0x9E93,
	0xFFFE, 0xFFFE, 0x9EA3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x909A, 0x9EAD, 0x8A91, 0x8C9F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EAF, 0x9E9A, 0x9EAE, 0xFFFE, 0x9EA7, 0x9E9B, 0xFFFE,
	0x9EAB, 0xFFFE, 0x9EAC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9EBD, 0xFFFE, 0xFFFE, 0xFFFE, 0x93CC, 0xFFFE, 0x9EA2, 0xFFFE,
	0xFFFE, 0x9EB9, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EBB, 0xFFFE, 0x92D6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x976B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9596, 0x9EB6, 0x91C8, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EBC, 0x915E, 0xFFFE, 0x9EB3, 0x9EC0, 0x9EBF, 0xFFFE,
	0x93ED, 0x9EBE, 0x93E8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EC2, 0x9EB5, 0xFFFE, 0x8BC6, 0x9EB8, 0x8F7C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9480, 0x9EBA, 0x8BC9, 0xFFFE, 0x9EB2,
	0x9EB4, 0x9EB1, 0xFFFE, 0xFFFE, 0x984F, 0x8A79, 0x9EB7, 0xFFFE,
	0xFFFE, 0x9EC1, 0x8A54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8DE5, 0xFFFE, 0xFFFE, 0xFFFE, 0x897C, 0xFFFE,
	0xFFFE, 0x9ED2, 0xFFFE, 0xFFFE, 0x9850, 0x9ED5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9059, 0x9ED4, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9ED3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9ED0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EC4, 0xFFFE,
	0xFFFE, 0x9EE1, 0x9EC3, 0xFFFE, 0x9ED6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9ECE, 0xFFFE, 0xFFFE, 0x9EC9, 0x9EC6,
	0xFFFE, 0x9EC7, 0xFFFE, 0x9ECF, 0xFFFE, 0xFFFE, 0xFFFE, 0xEAA0,
	0xFFFE, 0xFFFE, 0x9ECC, 0x8D5C, 0x92C6, 0x9184, 0x9ECA, 0xFFFE,
	0x9EC5, 0xFFFE, 0xFFFE, 0x9EC8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x976C, 0x968A, 0xFFFE, 0xFFFE, 0xFFFE, 0x9ECD, 0x9ED7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EDF,
	0x9ED8, 0xFFFE, 0xFFFE, 0x9EE5, 0xFFFE, 0x9EE3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EDD, 0xFFFE, 0x92CE, 0xFFFE, 0x9185, 0xFFFE, 0x9EDB
} };

static const iconv_ccs_convtable_8bit from_ucs_6A = { {
	0xFFFE, 0xFFFE, 0x9ED9, 0xFFFE, 0xFFFE, 0x9EE0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EE6, 0x94F3, 0x9EEC, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EE7, 0x9EEA, 0x9EE4, 0xFFFE, 0xFFFE, 0x9294,
	0xFFFE, 0x9557, 0xFFFE, 0x9EDA, 0xFFFE, 0xFFFE, 0x9EE2, 0x8FBE,
	0xFFFE, 0x96CD, 0x9EF6, 0x9EE9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8CA0, 0x89A1, 0x8A7E, 0xFFFE, 0xFFFE, 0x9ED1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FBF, 0x9EEE, 0xFFFE,
	0x9EF5, 0x8EF7, 0x8A92, 0xFFFE, 0xFFFE, 0x924D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EEB, 0xFFFE, 0xFFFE, 0x9EF0,
	0x9EF4, 0xFFFE, 0xFFFE, 0x8BB4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8B6B, 0x9EF2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B40,
	0xFFFE, 0x93C9, 0x9EF1, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EF3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EED, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9EEF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A80,
	0x9268, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EFA, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EF8, 0x8CE7, 0xFFFE,
	0x9EF7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F40,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9E77, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9EF9, 0xFFFE, 0x9EFB, 0x9EFC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9F4B, 0xFFFE, 0x9F47, 0xFFFE, 0x9E8D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9F45, 0xFFFE, 0xFFFE, 0x9F42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EE8, 0x9F44, 0x9F43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9F49, 0xFFFE, 0x9845, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9F4C, 0x8BF9, 0xFFFE, 0xFFFE, 0x9F48, 0x9F4A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x94A5, 0xFFFE, 0x9F4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9F51, 0x9F4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9793, 0x9F4F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EDC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9F52, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F53, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8954, 0xFFFE, 0x9F55,
	0x8C87, 0x8E9F, 0xFFFE, 0x8BD3, 0xFFFE, 0xFFFE, 0xFFFE, 0x89A2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x977E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F57,
	0x9F56, 0x9F59, 0x8B5C, 0xFFFE, 0xFFFE, 0x8BD4, 0x8ABC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F5C, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F5B,
	0xFFFE, 0x9F5D, 0xFFFE, 0xFFFE, 0x89CC, 0xFFFE, 0x9256, 0xFFFE,
	0x9F5E, 0xFFFE, 0xFFFE, 0x8ABD, 0x9F60, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9F5F, 0xFFFE, 0x9F61, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F62,
	0xFFFE, 0x9F63, 0x8E7E, 0x90B3, 0x8D9F, 0xFFFE, 0x9590, 0xFFFE,
	0xFFFE, 0x95E0, 0x9863, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E95,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8DCE, 0x97F0, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9F64, 0x9F65, 0xFFFE, 0x8E80, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F66,
	0x9F67, 0xFFFE, 0xFFFE, 0x9F69, 0x9F68, 0xFFFE, 0x9677, 0xFFFE,
	0xFFFE, 0x8F7D, 0x8EEA, 0x8E63, 0xFFFE, 0x9F6A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F6C, 0x9042, 0xFFFE,
	0x9F6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F6D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F6E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9F6F, 0x9F70, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F71,
	0xFFFE, 0x9F73, 0x9F72, 0x9F74, 0x89A3, 0x9269, 0xFFFE, 0x9F75,
	0xFFFE, 0xFFFE, 0x8E45, 0x8A6B, 0x9F76, 0xFFFE, 0xFFFE, 0x9361,
	0x9ACA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B42, 0x9F77, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F78, 0xFFFE, 0x95EA, 0x9688, 0xFFFE,
	0xFFFE, 0xFFFE, 0x93C5, 0x9F79, 0x94E4, 0xFFFE, 0xFFFE, 0xFFFE,
	0x94F9, 0xFFFE, 0xFFFE, 0x96D1, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F7A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F7C, 0x9F7B, 0xFFFE, 0xFFFE, 0x9F7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9F81, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E81,
	0xFFFE, 0x96AF, 0xFFFE, 0x9F82, 0x9F83, 0xFFFE, 0xFFFE, 0x8B43,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F84, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F86, 0x9F85, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9085, 0xFFFE, 0xFFFE, 0x9558,
	0x8969, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94C3, 0xFFFE,
	0x92F3, 0x8F60, 0x8B81, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94C4, 0xFFFE,
	0x8EAC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9F88, 0xFFFE, 0x8ABE,
	0xFFFE, 0xFFFE, 0x8998, 0xFFFE, 0xFFFE, 0x93F0, 0x9F87, 0x8D5D,
	0x9272, 0xFFFE, 0x9F89, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9F91, 0xFFFE, 0x9F8A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x91BF, 0xFFFE, 0x8B82, 0x9F92, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C88, 0xFFFE, 0xFFFE, 0x8B44, 0x9F90, 0xFFFE,
	0xFFFE, 0x9F8E, 0x9F8B, 0x9780, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x92BE, 0xFFFE, 0xFFFE, 0xFFFE, 0x93D7, 0x9F8C, 0xFFFE, 0xFFFE,
	0x9F94, 0xFFFE, 0x9F93, 0x8C42, 0xFFFE, 0xFFFE, 0x89AB, 0xFFFE,
	0xFFFE, 0x8DB9, 0x9F8D, 0x9F8F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9676, 0x91F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9697, 0xFFFE, 0xFFFE, 0x9F9C, 0xFFFE,
	0xFFFE, 0x9F9D, 0xFFFE, 0x89CD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x95A6, 0x96FB, 0x9F9F, 0x8EA1, 0x8FC0, 0x9F98, 0x9F9E, 0x8988,
	0xFFFE, 0x8BB5, 0xFFFE, 0xFFFE, 0x9F95, 0x9F9A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x90F2, 0x9491, 0xFFFE, 0x94E5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F97, 0xFFFE, 0x9640, 0xFFFE, 0x9F99,
	0xFFFE, 0x9FA2, 0xFFFE, 0x9FA0, 0xFFFE, 0x9F9B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9641, 0x9467, 0x8B83, 0xFFFE, 0x9344, 0xFFFE, 0xFFFE,
	0x928D, 0xFFFE, 0x9FA3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FA1,
	0x91D7, 0x9F96, 0xFFFE, 0x896A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x976D, 0x9FAE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9FAD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90F4,
	0xFFFE, 0x9FAA, 0xFFFE, 0x978C, 0xFFFE, 0xFFFE, 0x93B4, 0x9FA4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92C3, 0xFFFE, 0xFFFE,
	0xFFFE, 0x896B, 0x8D5E, 0x9FA7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8F46, 0x9FAC, 0xFFFE, 0x9FAB, 0x9FA6, 0xFFFE,
	0x9FA9, 0xFFFE, 0xFFFE, 0x8A88, 0xFFFE, 0x9FA8, 0x9468, 0xFFFE,
	0xFFFE, 0x97AC, 0xFFFE, 0xFFFE, 0x8FF2, 0x90F3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9FB4, 0x9FB2, 0xFFFE, 0x956C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9FAF, 0x9FB1, 0xFFFE, 0x8959, 0xFFFE,
	0xFFFE, 0x8D5F, 0x9851, 0xFFFE, 0x8A5C, 0xFFFE, 0x9582, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9781, 0xFFFE, 0xFFFE, 0x8A43,
	0x905A, 0x9FB3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FB8, 0xFFFE, 0xFFFE,
	0x8FC1, 0xFFFE, 0xFFFE, 0xFFFE, 0x974F, 0xFFFE, 0x9FB5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9FB0, 0xFFFE, 0x9FB6, 0xFFFE, 0xFFFE,
	0xFFFE, 0x97DC, 0xFFFE, 0x9393, 0x93C0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A55,
	0xFFFE, 0xFFFE, 0x8974, 0xFFFE, 0xFFFE, 0x9FBC, 0xFFFE, 0xFFFE,
	0x9FBF, 0xFFFE, 0xFFFE, 0xFFFE, 0x97C1, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9784, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FC6, 0x9FC0, 0x9FBD,
	0xFFFE, 0xFFFE, 0xFFFE, 0x97D2, 0x9FC3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F69, 0x9FC5, 0xFFFE, 0xFFFE, 0x9FCA, 0xFFFE, 0xFFFE,
	0x9391, 0x9FC8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FC2, 0xFFFE,
	0xFFFE, 0x9257, 0xFFFE, 0xFFFE, 0x9FC9, 0xFFFE, 0x9FBE, 0xFFFE,
	0x9FC4, 0xFFFE, 0x9FCB, 0x88FA, 0x9FC1, 0xFFFE, 0x9FCC, 0xFFFE,
	0xFFFE, 0x905B, 0xFFFE, 0x8F7E, 0xFFFE, 0x95A3, 0xFFFE, 0x8DAC,
	0xFFFE, 0x9FB9, 0x9FC7, 0x9359, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90B4, 0xFFFE, 0x8A89,
	0x8DCF, 0x8FC2, 0x9FBB, 0x8F61, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C6B, 0xFFFE, 0x9FBA, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9FD0, 0x8F8D, 0x8CB8, 0xFFFE, 0x9FDF, 0xFFFE, 0x9FD9,
	0x8B94, 0x936E, 0xFFFE, 0x9FD4, 0x9FDD, 0x88AD, 0x8951, 0xFFFE,
	0xFFFE, 0x89B7, 0xFFFE, 0x9FD6, 0x91AA, 0x9FCD, 0x9FCF, 0x8D60,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9FE0, 0xFFFE, 0x9FDB, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FD3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9FDA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96A9, 0xFFFE, 0xFFFE, 0x9FD8, 0x9FDC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CCE, 0xFFFE,
	0x8FC3, 0xFFFE, 0xFFFE, 0x9258, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FD2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x974E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9FD5, 0xFFFE, 0xFFFE, 0x9FCE, 0x9392,
	0xFFFE, 0xFFFE, 0x9FD1, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FD7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9870, 0x8EBC,
	0x969E, 0xFFFE, 0x9FE1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94AC, 0xFFFE, 0xFFFE, 0x9FED,
	0x8CB9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F80, 0xFFFE,
	0x9FE3, 0xFFFE, 0xFFFE, 0xFFFE, 0x97AD, 0x8D61, 0xFFFE, 0x9FF0,
	0xFFFE, 0xFFFE, 0x88EC, 0xFFFE, 0xFFFE, 0x9FEE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9FE2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FE8,
	0xFFFE, 0xFFFE, 0x9FEA, 0xFFFE, 0xFFFE, 0xFFFE, 0x976E, 0x9FE5,
	0xFFFE, 0xFFFE, 0x934D, 0xFFFE, 0xFFFE, 0x9FE7, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9FEF, 0xFFFE, 0x9FE9, 0x96C5, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9FE4, 0xFFFE, 0x8EA0, 0x9FFC, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A8A, 0xFFFE, 0x9FE6, 0x9FEB, 0x9FEC, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91EA, 0x91D8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FF4, 0xFFFE, 0xFFFE, 0x9FFA,
	0xFFFE, 0xFFFE, 0x9FF8, 0xFFFE, 0x9348, 0xFFFE, 0xFFFE, 0xE042,
	0x9FF5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FF6, 0x9FDE
} };

static const iconv_ccs_convtable_8bit from_ucs_6F = { {
	0xFFFE, 0x8B99, 0x9559, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EBD, 0xFFFE,
	0xFFFE, 0x8D97, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9852,
	0xFFFE, 0x9FF2, 0xFFFE, 0xE041, 0x8989, 0x9186, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9499, 0xFFFE, 0x8ABF, 0x97F8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x969F, 0x92D0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9FF9, 0x9FFB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9151, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE040, 0x9FF7,
	0xFFFE, 0x9FF1, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AC1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C89, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE04E, 0xFFFE, 0xFFFE, 0xE049, 0x90F6, 0xFFFE, 0xFFFE, 0x8A83,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F81, 0xFFFE, 0xE052, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE04B, 0x92AA, 0xE048,
	0x92D7, 0xFFFE, 0xFFFE, 0xFFFE, 0xE06B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE045, 0xFFFE, 0xE044, 0xFFFE, 0xE04D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE047, 0xE046, 0xE04C, 0xFFFE, 0x909F, 0xFFFE, 0xE043, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE04F, 0xFFFE,
	0xFFFE, 0xE050, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AC0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE055, 0xFFFE, 0xE054, 0xE056, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE059, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9362, 0xFFFE, 0xE053, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE057, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C83, 0x91F7, 0xE051, 0x945A, 0xFFFE, 0xFFFE, 0xE058, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE05D, 0xE05B, 0xFFFE, 0xFFFE,
	0xE05E, 0xFFFE, 0xFFFE, 0xE061, 0xFFFE, 0xFFFE, 0xFFFE, 0xE05A,
	0x8D8A, 0x9447, 0xFFFE, 0xFFFE, 0x9FB7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9794, 0xE05C, 0xFFFE, 0xE060, 0x91F3,
	0xFFFE, 0xE05F, 0xFFFE, 0xE04A, 0xFFFE, 0xFFFE, 0xE889, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE064, 0xFFFE, 0xFFFE, 0xFFFE, 0xE068, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_70 = { {
	0xFFFE, 0xE066, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE062, 0xFFFE, 0xE063, 0xFFFE, 0xFFFE, 0xFFFE, 0xE067,
	0xFFFE, 0xE065, 0xFFFE, 0xFFFE, 0xFFFE, 0x956D, 0xFFFE, 0xFFFE,
	0xE06D, 0xFFFE, 0xE06A, 0xE069, 0xFFFE, 0xE06C, 0x93D2, 0xE06E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9295, 0x91EB,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90A3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE06F, 0xFFFE, 0xE071, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE070, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9FF3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE072, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x93E5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE073, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x89CE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9394,
	0x8A44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8B84, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EDC, 0x8DD0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9846, 0x9086, 0xFFFE, 0xFFFE, 0xFFFE, 0x898A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE075, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE074, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE078, 0x9259, 0xE07B, 0xE076,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE07A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE079, 0x935F, 0x88D7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x97F3, 0xFFFE, 0xFFFE, 0xE07D, 0xFFFE, 0xFFFE, 0xFFFE, 0x8947,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE080, 0xFFFE, 0xFFFE, 0xFFFE, 0xE07E, 0xFFFE, 0xE07C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE077, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9642, 0xFFFE, 0xFFFE, 0xFFFE, 0xE082, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_71 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE081, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x898B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE084, 0x95B0, 0xFFFE, 0xE083, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x96B3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FC5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9152, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FC4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x97F9, 0xFFFE, 0xFFFE, 0xE08A, 0xFFFE, 0x90F7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE086, 0xE08B, 0xFFFE,
	0xFFFE, 0x898C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE089, 0xFFFE, 0x9481, 0xE085, 0xE088, 0x8FC6,
	0xFFFE, 0x94CF, 0xFFFE, 0xFFFE, 0xE08C, 0xFFFE, 0x8ECF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90F8, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE08F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE087, 0xFFFE, 0x8C46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE08D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x976F, 0xE090, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEAA4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F6E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE091, 0xFFFE, 0xFFFE, 0xFFFE, 0xE092, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x944D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE094, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE095, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9452, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9395, 0xE097, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE099, 0xFFFE,
	0x97D3, 0xFFFE, 0xE096, 0xFFFE, 0xE098, 0x898D, 0xFFFE, 0xE093,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9A7A,
	0xE09A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9187, 0x8E57, 0xE09C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE09B, 0x9043, 0x99D7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE09D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE09F, 0xFFFE, 0xE08E, 0xE09E, 0xFFFE, 0xFFFE, 0xE0A0
} };

static const iconv_ccs_convtable_8bit from_ucs_72 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x949A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0A1, 0xFFFE, 0xFFFE,
	0xE0A2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE0A3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0A4, 0xFFFE, 0x92DC, 0xFFFE, 0xE0A6, 0xE0A5, 0xFFFE, 0xFFFE,
	0xE0A7, 0xFFFE, 0xE0A8, 0xFFFE, 0xFFFE, 0x8EDD, 0x9583, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96EA, 0xE0A9, 0xE0AA, 0x9175, 0x8EA2, 0xE0AB,
	0xE0AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0AD, 0x95D0,
	0x94C5, 0xFFFE, 0xFFFE, 0xE0AE, 0x9476, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x92AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0AF, 0x89E5, 0xFFFE, 0x8B8D, 0xFFFE, 0x96C4, 0xFFFE, 0x96B4,
	0xFFFE, 0x89B2, 0x9853, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9671,
	0xFFFE, 0x95A8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x90B5, 0xFFFE, 0xE0B0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x93C1, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CA1, 0xE0B1, 0xFFFE,
	0x8DD2, 0xE0B3, 0xE0B2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0B4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0B5, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0B6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8B5D, 0xFFFE, 0xE0B7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0B8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CA2, 0xFFFE, 0xFFFE, 0x94C6,
	0xFFFE, 0xFFFE, 0xE0BA, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FF3, 0xFFFE,
	0xFFFE, 0xE0B9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8BB6, 0xE0BB, 0xE0BD, 0xFFFE, 0xE0BC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0BE, 0xFFFE,
	0x8CCF, 0xFFFE, 0xE0BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BE7,
	0xFFFE, 0x915F, 0xFFFE, 0x8D9D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0C1, 0xE0C2, 0xE0C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8EEB, 0xFFFE, 0xFFFE, 0x93C6, 0x8BB7, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0C4,
	0x924B, 0xE0C3, 0xFFFE, 0xFFFE, 0x9854, 0x9482, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_73 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0C7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0C9, 0xE0C6,
	0xFFFE, 0xFFFE, 0xFFFE, 0x96D2, 0xE0C8, 0xE0CA, 0xFFFE, 0x97C2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0CE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE0CD, 0x9296, 0x944C, 0xFFFE, 0xFFFE, 0x8CA3, 0xE0CC,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0CB, 0xFFFE, 0x9750, 0x9751,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0CF, 0x898E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8D96, 0x8E82, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0D0, 0xE0D1,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0D3,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8F62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0D5, 0xFFFE, 0xE0D4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0D6, 0xFFFE, 0x8A6C, 0xFFFE, 0xFFFE, 0xE0D8, 0xFFFE, 0xFFFE,
	0xE0D7, 0xFFFE, 0xE0DA, 0xE0D9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CBA, 0xFFFE, 0xFFFE, 0x97A6,
	0xFFFE, 0x8BCA, 0xFFFE, 0x89A4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BE8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8ADF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x97E6, 0xE0DC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE0DE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0DF, 0xFFFE, 0x89CF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0DB, 0xFFFE, 0x8E58, 0xFFFE, 0xFFFE, 0x92BF, 0xE0DD, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0E2, 0xFFFE,
	0x8EEC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0E0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C5D, 0xFFFE, 0xFFFE, 0x94C7, 0xE0E1, 0xFFFE,
	0xFFFE, 0xE0FC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0E7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CBB, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_74 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x8B85, 0xFFFE, 0xE0E4, 0x979D, 0xFFFE,
	0xFFFE, 0x97AE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x91F4, 0xFFFE, 0xFFFE, 0xE0E6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0E8, 0x97D4, 0x8BD5, 0x94FA, 0x9469, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0E9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0EB,
	0xFFFE, 0xE0EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0EA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE0ED, 0x8CE8, 0x896C, 0xE0EF, 0xFFFE, 0x9090, 0xE0EC,
	0x97DA, 0xFFFE, 0xFFFE, 0xE0F2, 0xEAA2, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE0F0, 0xE0F3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0E5,
	0xE0F1, 0xFFFE, 0xFFFE, 0x8DBA, 0xFFFE, 0xFFFE, 0xE0F4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0F5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x979E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE0F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0F7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0E3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0F8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AC2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EA3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE0F9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0FA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE0FB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x895A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE140, 0xFFFE, 0x955A, 0xE141, 0xFFFE, 0xFFFE, 0x8AA2, 0xE142,
	0xFFFE, 0xE143, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE144, 0xFFFE,
	0xE146, 0xE147, 0xE145, 0xFFFE, 0xFFFE, 0xFFFE, 0x9572, 0xE149,
	0xE148, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_75 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xE14B, 0xE14A, 0xE14C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE14D, 0xE14F, 0xE14E, 0xFFFE,
	0xFFFE, 0x8D99, 0xFFFE, 0xE151, 0xFFFE, 0xE150, 0xFFFE, 0xFFFE,
	0x8AC3, 0xFFFE, 0x9072, 0xFFFE, 0x935B, 0xFFFE, 0xE152, 0x90B6,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E59, 0xFFFE, 0x8999, 0xE153, 0xFFFE,
	0x9770, 0xFFFE, 0xFFFE, 0x95E1, 0xE154, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9363, 0x9752, 0x8D62, 0x905C, 0xFFFE, 0xFFFE, 0xFFFE, 0x926A,
	0x99B2, 0xFFFE, 0x92AC, 0x89E6, 0xE155, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE156, 0xFFFE, 0xE15B, 0xFFFE,
	0xFFFE, 0xE159, 0xE158, 0x9DC0, 0x8A45, 0xE157, 0xFFFE, 0x88D8,
	0xFFFE, 0x94A8, 0xFFFE, 0xFFFE, 0x94C8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x97AF, 0xE15C, 0xE15A, 0x927B, 0x90A4, 0xFFFE, 0xFFFE,
	0x94A9, 0xFFFE, 0x954C, 0xFFFE, 0xE15E, 0x97AA, 0x8C6C, 0xE15F,
	0xFFFE, 0xE15D, 0x94D4, 0xE160, 0xFFFE, 0xE161, 0xFFFE, 0xFFFE,
	0x88D9, 0xFFFE, 0xFFFE, 0x8FF4, 0xE166, 0xFFFE, 0xE163, 0x93EB,
	0xE162, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B45,
	0xFFFE, 0xFFFE, 0xE169, 0xFFFE, 0xFFFE, 0xFFFE, 0xE164, 0xE165,
	0xFFFE, 0xE168, 0xE167, 0x9544, 0xFFFE, 0xFFFE, 0x9161, 0x9160,
	0xFFFE, 0x8B5E, 0xFFFE, 0xFFFE, 0xE16A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE16B, 0xFFFE, 0xFFFE, 0xE16C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE16E, 0xFFFE, 0xE16D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8975, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE176, 0x94E6, 0xE170, 0xFFFE, 0xE172, 0xFFFE, 0xFFFE,
	0xE174, 0x905D, 0xFFFE, 0xFFFE, 0xE175, 0xE173, 0x8EBE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE16F, 0xE171, 0xFFFE, 0x9561, 0xFFFE, 0x8FC7,
	0xFFFE, 0xFFFE, 0xE178, 0xFFFE, 0xFFFE, 0xE177, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE179, 0xFFFE, 0x8EA4, 0x8DAD, 0xFFFE, 0xFFFE,
	0x9397, 0xE17A, 0xFFFE, 0x92C9, 0xFFFE, 0xFFFE, 0xE17C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x979F, 0xE17B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9189, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE182, 0xFFFE, 0xE184, 0xE185, 0x9273, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE183, 0xFFFE, 0xE180, 0xFFFE, 0xE17D, 0xE17E
} };

static const iconv_ccs_convtable_8bit from_ucs_76 = { {
	0xFFFE, 0xE181, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE188, 0xFFFE, 0xE186, 0xFFFE, 0xE187, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE189,
	0xE18B, 0xE18C, 0xE18D, 0xFFFE, 0xE18E, 0xFFFE, 0xFFFE, 0xE18A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE190, 0xFFFE, 0xFFFE, 0xFFFE, 0xE18F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE191, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x97C3, 0xFFFE, 0xFFFE, 0xFFFE, 0xE194, 0xE192,
	0xE193, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AE0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96FC, 0xFFFE, 0xFFFE, 0xFFFE, 0x95C8, 0xFFFE,
	0xE196, 0xFFFE, 0xFFFE, 0xFFFE, 0xE195, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE197, 0xE198, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE19C,
	0xE199, 0xE19A, 0xE19B, 0xFFFE, 0xE19D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE19E, 0xFFFE, 0xE19F, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1A0, 0xFFFE,
	0xE1A1, 0xFFFE, 0x94AD, 0x936F, 0xE1A2, 0x9492, 0x9553, 0xFFFE,
	0xE1A3, 0xFFFE, 0xFFFE, 0xE1A4, 0x9349, 0xFFFE, 0x8A46, 0x8D63,
	0xE1A5, 0xFFFE, 0xFFFE, 0xE1A6, 0xFFFE, 0xFFFE, 0xE1A7, 0xFFFE,
	0x8E48, 0xFFFE, 0xFFFE, 0xE1A9, 0xFFFE, 0xFFFE, 0xE1A8, 0xFFFE,
	0xFFFE, 0xE1AA, 0xE1AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94E7, 0xFFFE,
	0xE1AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1AD, 0xFFFE, 0xFFFE, 0xEA89,
	0xE1AE, 0xE1AF, 0xE1B0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E4D,
	0xFFFE, 0xFFFE, 0xE1B1, 0x9475, 0xFFFE, 0xFFFE, 0x967E, 0xFFFE,
	0x896D, 0xFFFE, 0x8976, 0xFFFE, 0xFFFE, 0xE1B2, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE1B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1B3, 0x9390,
	0xFFFE, 0xFFFE, 0xFFFE, 0x90B7, 0x9F58, 0xFFFE, 0xE1B5, 0x96BF,
	0xFFFE, 0xE1B6, 0xFFFE, 0x8AC4, 0x94D5, 0xE1B7, 0xFFFE, 0xE1B8,
	0xFFFE, 0xFFFE, 0xE1B9, 0xFFFE, 0xFFFE, 0xFFFE, 0x96DA, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96D3, 0xFFFE, 0x92BC, 0xFFFE, 0xFFFE, 0xFFFE,
	0x918A, 0xFFFE, 0xFFFE, 0xE1BB, 0xFFFE, 0xFFFE, 0x8F82, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_77 = { {
	0xFFFE, 0x8FC8, 0xFFFE, 0xFFFE, 0xE1BE, 0xFFFE, 0xFFFE, 0xE1BD,
	0xE1BC, 0x94FB, 0xFFFE, 0x8AC5, 0x8CA7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE1C4, 0xFFFE, 0xFFFE, 0xE1C1, 0x905E,
	0x96B0, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1C0, 0xE1C2, 0xE1C3, 0xFFFE,
	0xFFFE, 0xE1BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1C5,
	0xE1C6, 0xFFFE, 0x92AD, 0xFFFE, 0x8AE1, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9285, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1C7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE1C8, 0xE1CB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9087, 0xFFFE, 0x93C2, 0xFFFE, 0xE1CC, 0x9672, 0xFFFE,
	0xE1C9, 0xFFFE, 0xFFFE, 0xE1CA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE1CF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1CE, 0xE1CD,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE1D1, 0xFFFE, 0xFFFE, 0xE1D0, 0xFFFE,
	0xFFFE, 0xE1D2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1D4, 0xFFFE,
	0xE1D3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95CB, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F75, 0x97C4, 0xFFFE, 0xFFFE,
	0xE1D5, 0xFFFE, 0xFFFE, 0x93B5, 0xFFFE, 0xFFFE, 0xE1D6, 0xFFFE,
	0xFFFE, 0xE1D7, 0xFFFE, 0xE1DB, 0xE1D9, 0xE1DA, 0xFFFE, 0xE1D8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1DC,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1DD, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1DE,
	0xFFFE, 0xFFFE, 0xE1DF, 0x96B5, 0xE1E0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96EE, 0xE1E1, 0xFFFE, 0x926D, 0xFFFE, 0x948A,
	0xFFFE, 0x8BE9, 0xFFFE, 0xFFFE, 0xFFFE, 0x925A, 0xE1E2, 0x8BB8,
	0xFFFE, 0xFFFE, 0xFFFE, 0x90CE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1E3, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_78 = { {
	0xFFFE, 0xFFFE, 0x8DBB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1E4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE1E5, 0xFFFE, 0x8CA4, 0x8DD3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE1E7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9375, 0x8DD4, 0x8B6D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9643, 0xFFFE, 0x946A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9376, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8D7B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1E9, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FC9, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x97B0, 0x8D64, 0xFFFE, 0xFFFE, 0x8CA5,
	0xFFFE, 0xFFFE, 0x94A1, 0xFFFE, 0xE1EB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1ED, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8CE9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1EC, 0x92F4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1EF, 0x8A56, 0xE1EA, 0xFFFE,
	0xFFFE, 0x94E8, 0xFFFE, 0x894F, 0xFFFE, 0x8DEA, 0xFFFE, 0x9871,
	0xFFFE, 0xFFFE, 0xE1EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE1F0, 0xFFFE, 0xFFFE, 0xFFFE, 0x95C9,
	0xFFFE, 0x90D7, 0xE1F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1F3,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1F1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8A6D, 0xFFFE, 0xE1F9, 0xFFFE, 0xE1F8, 0xFFFE,
	0xFFFE, 0x8EA5, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1FA, 0xE1F5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE1FB, 0xE1F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x94D6, 0xE1F4, 0xFFFE, 0xFFFE, 0xE1F7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE241, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE240,
	0x9681, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1FC, 0xFFFE, 0xFFFE, 0x88E9,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE243, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE242, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_79 = { {
	0xFFFE, 0x8FCA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE244,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9162, 0xFFFE,
	0xFFFE, 0xE246, 0xE245, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE247, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE1E6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE1E8, 0xE249, 0xE248, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8EA6, 0xFFFE, 0x97E7, 0xFFFE, 0x8ED0, 0xFFFE,
	0xE24A, 0x8C56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B5F,
	0x8B46, 0x8E83, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9753, 0xFFFE, 0xFFFE, 0xE250, 0xFFFE, 0xE24F, 0x9163, 0xE24C,
	0xFFFE, 0xFFFE, 0xE24E, 0xFFFE, 0xFFFE, 0x8F6A, 0x905F, 0xE24D,
	0xE24B, 0xFFFE, 0x9449, 0xFFFE, 0xFFFE, 0x8FCB, 0xFFFE, 0xFFFE,
	0x955B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DD5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9398,
	0xFFFE, 0xFFFE, 0xE251, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE252,
	0xE268, 0x8BD6, 0xFFFE, 0xFFFE, 0x985C, 0x9154, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE253, 0xFFFE, 0xFFFE, 0x89D0, 0x92F5, 0x959F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE254, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B9A, 0xE255,
	0xFFFE, 0xFFFE, 0xE257, 0xFFFE, 0xFFFE, 0xFFFE, 0xE258, 0xFFFE,
	0x9448, 0xFFFE, 0xFFFE, 0xE259, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE25A, 0xE25B, 0xFFFE, 0xFFFE, 0x8BD7, 0x89D1, 0x93C3,
	0x8F47, 0x8E84, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE25C, 0xFFFE, 0x8F48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89C8, 0x9562, 0xFFFE, 0xFFFE, 0xE25D, 0xFFFE, 0xFFFE,
	0x94E9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9164,
	0xFFFE, 0xE260, 0xFFFE, 0xE261, 0x9489, 0xFFFE, 0x9060, 0xE25E,
	0xFFFE, 0x9281, 0xFFFE, 0xFFFE, 0xE25F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FCC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88DA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7A = { {
	0x8B48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE262, 0xFFFE, 0xFFFE, 0x92F6, 0xFFFE, 0xE263, 0x90C5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96AB, 0xFFFE, 0xFFFE, 0x9542,
	0xE264, 0xE265, 0x9274, 0xFFFE, 0x97C5, 0xFFFE, 0xFFFE, 0xE267,
	0xE266, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EED, 0xFFFE,
	0xFFFE, 0xE269, 0x88EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE26C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE26A, 0x89D2, 0x8C6D, 0xE26B, 0x8D65,
	0x8D92, 0xFFFE, 0x95E4, 0xE26D, 0xFFFE, 0xFFFE, 0x9673, 0xFFFE,
	0xFFFE, 0xE26F, 0xFFFE, 0xFFFE, 0xFFFE, 0x90CF, 0x896E, 0x89B8,
	0x88AA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE26E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE270, 0xE271, 0x8FF5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE272, 0xFFFE, 0x8A6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE274, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C8A, 0xFFFE, 0x8B86, 0xFFFE,
	0xFFFE, 0xE275, 0x8BF3, 0xFFFE, 0xFFFE, 0xE276, 0xFFFE, 0x90FA,
	0xFFFE, 0x93CB, 0xFFFE, 0x90DE, 0x8DF3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE277, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9282, 0x918B, 0xFFFE, 0xE279, 0xE27B, 0xE278,
	0xE27A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C41,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE27C, 0x8C45, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B87, 0x9771,
	0xE27E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE280, 0xFFFE,
	0xFFFE, 0xFFFE, 0x894D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE283,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A96, 0xE282, 0xE281, 0xFFFE, 0xE285,
	0xE27D, 0xFFFE, 0xE286, 0x97A7, 0xFFFE, 0xE287, 0xFFFE, 0xE288,
	0xFFFE, 0xFFFE, 0x9AF2, 0xE28A, 0xFFFE, 0xE289, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE28B, 0xE28C, 0xFFFE, 0x97B3, 0xE28D, 0xFFFE, 0xE8ED,
	0x8FCD, 0xE28E, 0xE28F, 0x8F76, 0xFFFE, 0x93B6, 0xE290, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9247, 0xFFFE, 0xFFFE, 0xE291, 0xFFFE, 0x925B,
	0xE292, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BA3, 0xFFFE,
	0x995E, 0x927C, 0x8EB1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AC6
} };

static const iconv_ccs_convtable_8bit from_ucs_7B = { {
	0xFFFE, 0xFFFE, 0xE293, 0xFFFE, 0xE2A0, 0xFFFE, 0xE296, 0xFFFE,
	0x8B88, 0xFFFE, 0xE295, 0xE2A2, 0xFFFE, 0xFFFE, 0xFFFE, 0xE294,
	0xFFFE, 0x8FCE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE298, 0xE299, 0xFFFE, 0x934A, 0xFFFE, 0xFFFE, 0xE29A, 0xFFFE,
	0x8A7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9079, 0x9584, 0xFFFE,
	0xE29C, 0xFFFE, 0xFFFE, 0xFFFE, 0x91E6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE297, 0xFFFE, 0xE29B, 0xE29D, 0xFFFE,
	0xFFFE, 0x8DF9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2A4, 0x954D, 0xFFFE,
	0x94A4, 0x9399, 0xFFFE, 0x8BD8, 0xE2A3, 0xE2A1, 0xFFFE, 0x94B3,
	0xE29E, 0x927D, 0x939B, 0xFFFE, 0x939A, 0xFFFE, 0x8DF4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2B6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2A6, 0xFFFE, 0xE2A8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2AB, 0xFFFE, 0xE2AC, 0xFFFE,
	0xE2A9, 0xE2AA, 0xFFFE, 0xFFFE, 0xE2A7, 0xE2A5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE29F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95CD, 0x89D3,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE2B3, 0xFFFE, 0xE2B0, 0xFFFE, 0xE2B5,
	0xFFFE, 0xFFFE, 0xE2B4, 0xFFFE, 0x9493, 0x96A5, 0xFFFE, 0x8E5A,
	0xE2AE, 0xE2B7, 0xE2B2, 0xFFFE, 0xE2B1, 0xE2AD, 0xFFFE, 0xE2AF,
	0xFFFE, 0x8AC7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x925C, 0xFFFE, 0xFFFE, 0x90FB, 0xFFFE, 0xFFFE,
	0xFFFE, 0x94A0, 0xFFFE, 0xFFFE, 0xE2BC, 0xFFFE, 0xFFFE, 0xFFFE,
	0x94A2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x90DF, 0xE2B9, 0xFFFE, 0xFFFE, 0x94CD, 0xFFFE, 0xE2BD, 0x95D1,
	0xFFFE, 0x927A, 0xFFFE, 0xE2B8, 0xE2BA, 0xFFFE, 0xFFFE, 0xE2BB,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2BE, 0xFFFE, 0xFFFE,
	0x8EC2, 0xFFFE, 0xFFFE, 0xFFFE, 0x93C4, 0xE2C3, 0xE2C2, 0xFFFE,
	0xFFFE, 0xE2BF, 0xFFFE, 0xFFFE, 0xFFFE, 0x9855, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE2C8, 0xFFFE, 0xFFFE, 0xE2CC, 0xE2C9,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7C = { {
	0xE2C5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2C6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2CB, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE2C0, 0x99D3, 0xE2C7, 0xE2C1, 0xFFFE, 0xFFFE, 0xE2CA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2D0,
	0xFFFE, 0x8AC8, 0xFFFE, 0xE2CD, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2CE,
	0xFFFE, 0xFFFE, 0xE2CF, 0xE2D2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2D1,
	0x94F4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2D3, 0x97FA, 0x95EB,
	0xE2D8, 0xFFFE, 0xFFFE, 0xE2D5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2D4, 0x90D0, 0xFFFE, 0xE2D7,
	0xE2D9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2D6, 0xFFFE, 0xE2DD, 0xFFFE,
	0xE2DA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2DB,
	0xE2C4, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2DC, 0xE2DE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2DF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x95C4, 0xFFFE, 0xE2E0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96E0, 0xFFFE,
	0xFFFE, 0x8BCC, 0x8C48, 0xE2E1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95B2, 0xFFFE, 0x9088, 0xFFFE, 0x96AE, 0xFFFE, 0xFFFE,
	0xE2E2, 0xFFFE, 0x97B1, 0xFFFE, 0xFFFE, 0x9494, 0xFFFE, 0x9165,
	0x9453, 0xFFFE, 0xFFFE, 0x8F6C, 0xFFFE, 0xFFFE, 0xFFFE, 0x88BE,
	0xFFFE, 0xE2E7, 0xE2E5, 0xFFFE, 0xE2E3, 0x8A9F, 0xFFFE, 0x8FCF,
	0xE2E8, 0xFFFE, 0xFFFE, 0xE2E6, 0xFFFE, 0xE2E4, 0xE2EC, 0xFFFE,
	0xFFFE, 0xE2EB, 0xE2EA, 0xE2E9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE2ED, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2EE, 0x90B8, 0xFFFE,
	0xE2EF, 0xFFFE, 0xE2F1, 0xFFFE, 0xFFFE, 0xE2F0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8CD0, 0xFFFE, 0xFFFE, 0xFFFE, 0x9157, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE2F3, 0xFFFE, 0xFFFE, 0xFFFE, 0x939C, 0xFFFE,
	0xE2F2, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2F4, 0xFFFE, 0x95B3, 0x918C,
	0x8D66, 0xFFFE, 0xE2F5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97C6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE2F7,
	0xFFFE, 0xFFFE, 0xE2F8, 0xFFFE, 0xE2F9, 0xFFFE, 0xE2FA, 0xFFFE,
	0x8E85, 0xFFFE, 0xE2FB, 0x8C6E, 0xFFFE, 0xFFFE, 0x8B8A, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7D = { {
	0x8B49, 0xFFFE, 0xE340, 0xFFFE, 0x96F1, 0x8D67, 0xE2FC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE343, 0x96E4, 0xFFFE, 0x945B, 0xFFFE, 0xFFFE,
	0x9552, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F83, 0xE342, 0xFFFE, 0x8ED1,
	0x8D68, 0x8E86, 0x8B89, 0x95B4, 0xE341, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9166, 0x9661, 0x8DF5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E87, 0x92DB, 0xFFFE, 0xE346, 0x97DD,
	0x8DD7, 0xFFFE, 0xE347, 0x9061, 0xFFFE, 0xE349, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8FD0, 0x8DAE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE348,
	0xFFFE, 0xFFFE, 0x8F49, 0x8CBC, 0x9167, 0xE344, 0xE34A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE345, 0x8C6F, 0xFFFE, 0xE34D, 0xE351,
	0x8C8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE34C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE355, 0xFFFE, 0xFFFE, 0x8D69, 0xFFFE,
	0xFFFE, 0x978D, 0x88BA, 0xE352, 0xFFFE, 0xFFFE, 0x8B8B, 0xFFFE,
	0xE34F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE350, 0xFFFE,
	0xFFFE, 0x939D, 0xE34E, 0xE34B, 0xFFFE, 0x8A47, 0x90E2, 0xFFFE,
	0xFFFE, 0x8CA6, 0xFFFE, 0xFFFE, 0xFFFE, 0xE357, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE354, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE356,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE353, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8C70, 0x91B1, 0xE358, 0x918E, 0xFFFE, 0xFFFE, 0xE365,
	0xFFFE, 0xFFFE, 0xE361, 0xE35B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE35F, 0x8EF8, 0x88DB, 0xE35A, 0xE362,
	0xE366, 0x8D6A, 0x96D4, 0xFFFE, 0x92D4, 0xE35C, 0xFFFE, 0xFFFE,
	0xE364, 0xFFFE, 0xE359, 0x925D, 0xFFFE, 0xE35E, 0x88BB, 0x96C8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE35D,
	0xFFFE, 0xFFFE, 0x8BD9, 0x94EA, 0xFFFE, 0xFFFE, 0xFFFE, 0x918D,
	0xFFFE, 0x97CE, 0x8F8F, 0xFFFE, 0xFFFE, 0xE38E, 0xFFFE, 0xFFFE,
	0xE367, 0xFFFE, 0x90FC, 0xFFFE, 0xE363, 0xE368, 0xE36A, 0xFFFE,
	0x92F7, 0xE36D, 0xFFFE, 0xFFFE, 0xE369, 0xFFFE, 0xFFFE, 0xFFFE,
	0x95D2, 0x8AC9, 0xFFFE, 0xFFFE, 0x96C9, 0xFFFE, 0xFFFE, 0x88DC,
	0xFFFE, 0xFFFE, 0xE36C, 0xFFFE, 0x97FB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE36B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7E = { {
	0xFFFE, 0x898F, 0xFFFE, 0xFFFE, 0x93EA, 0xE36E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE375, 0xE36F, 0xE376, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE372, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x949B, 0xFFFE, 0xFFFE, 0x8EC8, 0xE374,
	0xFFFE, 0xE371, 0xE377, 0xE370, 0xFFFE, 0xFFFE, 0x8F63, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9644, 0xFFFE, 0xFFFE, 0x8F6B, 0xFFFE,
	0xFFFE, 0xE373, 0xE380, 0xFFFE, 0xFFFE, 0xE37B, 0xFFFE, 0xE37E,
	0xFFFE, 0xE37C, 0xE381, 0xE37A, 0xFFFE, 0xE360, 0x90D1, 0xFFFE,
	0xFFFE, 0x94C9, 0xFFFE, 0xE37D, 0xFFFE, 0xFFFE, 0xE378, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9140, 0x8C71, 0xFFFE, 0x8F4A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9044, 0x9155, 0xE384, 0xFFFE,
	0xFFFE, 0xE386, 0xE387, 0xFFFE, 0xFFFE, 0xE383, 0xE385, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE379, 0xE382,
	0xFFFE, 0xE38A, 0xE389, 0xFFFE, 0xFFFE, 0x969A, 0xFFFE, 0xFFFE,
	0x8C4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE388, 0xFFFE, 0xE38C, 0xE38B, 0xE38F, 0xFFFE, 0xE391,
	0xFFFE, 0xFFFE, 0x8E5B, 0xE38D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE392, 0xE393, 0xFFFE, 0xFFFE, 0xE394, 0xFFFE, 0xE39A, 0x935A,
	0xE396, 0xFFFE, 0xE395, 0xE397, 0xE398, 0xFFFE, 0xE399, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE39B, 0xE39C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8ACA, 0xFFFE,
	0xE39D, 0xFFFE, 0xE39E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE39F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3A0, 0xE3A1, 0xE3A2, 0xFFFE,
	0xE3A3, 0xE3A4, 0xFFFE, 0xFFFE, 0xE3A6, 0xE3A5, 0xFFFE, 0xFFFE,
	0xE3A7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3A8,
	0xE3A9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3AC,
	0xE3AA, 0xE3AB, 0x8DDF, 0x8C72, 0xFFFE, 0xFFFE, 0x9275, 0xFFFE,
	0x94B1, 0xFFFE, 0x8F90, 0xFFFE, 0xFFFE, 0x946C, 0xFFFE, 0x94EB,
	0xE3AD, 0x9CEB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE3AE, 0xE3B0, 0xFFFE, 0x9785, 0xE3AF, 0xE3B2,
	0xE3B1, 0xFFFE, 0x9772, 0xFFFE, 0xE3B3, 0xFFFE, 0x94FC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3B4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE3B7, 0xFFFE, 0xFFFE, 0xE3B6, 0xE3B5, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3B8, 0x8C51, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9141, 0x8B60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3BC, 0xE3B9,
	0xFFFE, 0xFFFE, 0xE3BA, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3BD, 0xFFFE,
	0xE3BE, 0xE3BB, 0xFFFE, 0xFFFE, 0xFFFE, 0x8948, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89A5, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3C0, 0xE3C1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE3C2, 0xFFFE, 0x9782, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8F4B, 0xFFFE, 0xE3C4, 0xE3C3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9089, 0xE3C5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3C6, 0xFFFE,
	0xFFFE, 0xE3C7, 0xFFFE, 0x8AE3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8ACB, 0xFFFE, 0xFFFE, 0xE3C8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE3C9, 0xFFFE, 0x967C, 0x9783, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_80 = { {
	0x9773, 0x9856, 0xFFFE, 0x8D6C, 0xE3CC, 0x8ED2, 0xE3CB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3CD, 0x8EA7, 0xFFFE, 0xFFFE, 0xFFFE,
	0x91CF, 0xFFFE, 0xE3CE, 0xFFFE, 0xFFFE, 0x8D6B, 0xFFFE, 0x96D5,
	0xE3CF, 0xE3D0, 0xFFFE, 0xFFFE, 0xE3D1, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE3D2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE3D3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8EA8, 0xFFFE, 0xFFFE, 0x96EB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3D5, 0xFFFE, 0x925E, 0xFFFE, 0xE3D4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3D7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE3D6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE3D8, 0xFFFE, 0xFFFE, 0xFFFE, 0x90B9, 0xFFFE,
	0xE3D9, 0xFFFE, 0xE3DA, 0xFFFE, 0xFFFE, 0xFFFE, 0x95B7, 0xE3DB,
	0xFFFE, 0x918F, 0xE3DC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE3DD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97FC,
	0xE3E0, 0xFFFE, 0xE3DF, 0xE3DE, 0x92AE, 0xFFFE, 0xE3E1, 0x9045,
	0xFFFE, 0xE3E2, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3E3, 0x9857, 0xE3E4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3E5, 0xE3E7, 0xE3E6, 0x94A3,
	0xFFFE, 0x93F7, 0xFFFE, 0x985D, 0x94A7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3E9, 0xFFFE, 0xFFFE, 0x8FD1, 0xFFFE,
	0x9549, 0xFFFE, 0xE3EA, 0xE3E8, 0xFFFE, 0x8ACC, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8CD2, 0x8E88, 0xFFFE, 0xFFFE, 0x94EC, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8CA8, 0x9662, 0xFFFE, 0xE3ED, 0xE3EB, 0xFFFE, 0x8D6D,
	0xFFFE, 0x8D6E, 0x88E7, 0xFFFE, 0x8DE6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9478, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88DD, 0xE3F2, 0xFFFE, 0x925F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9477, 0xFFFE, 0x91D9, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3F4, 0xFFFE,
	0xFFFE, 0xE3F0, 0xE3F3, 0xE3EE, 0xFFFE, 0xE3F1, 0x9645, 0xFFFE,
	0xFFFE, 0x8CD3, 0xFFFE, 0xFFFE, 0x88FB, 0xE3EF, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3F6,
	0xFFFE, 0xE3F7, 0xFFFE, 0xFFFE, 0x93B7, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8BB9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE445, 0x945C, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_81 = { {
	0xFFFE, 0xFFFE, 0x8E89, 0xFFFE, 0xFFFE, 0x8BBA, 0x90C6, 0x9865,
	0x96AC, 0xE3F5, 0x90D2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8B72, 0xE3F8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3FA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE3F9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE3FB,
	0xFFFE, 0x9245, 0xFFFE, 0x945D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x92AF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE442, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE441, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE3FC, 0xFFFE, 0xFFFE, 0x9074, 0xFFFE,
	0x9585, 0xE444, 0xFFFE, 0xE443, 0x8D6F, 0x9872, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE454,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE448, 0xE449, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8EEE, 0xFFFE, 0xFFFE, 0xE447, 0xFFFE,
	0x8D98, 0xE446, 0xFFFE, 0xFFFE, 0xE44A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x92B0, 0x95A0, 0x9142, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91DA,
	0xE44E, 0xFFFE, 0xE44F, 0xE44B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE44C, 0xFFFE, 0xE44D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8D70,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE455, 0xFFFE, 0xE451, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9586, 0xFFFE, 0x968C, 0x9547, 0xFFFE, 0xFFFE,
	0xE450, 0xFFFE, 0xFFFE, 0xE453, 0xE452, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9663, 0xE456, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE457, 0xFFFE, 0xFFFE, 0x9156, 0xFFFE, 0xE458, 0xFFFE, 0xFFFE,
	0xE45A, 0xFFFE, 0xE45E, 0xFFFE, 0xFFFE, 0xE45B, 0xE459, 0x945E,
	0xE45C, 0xFFFE, 0xE45D, 0xFFFE, 0xFFFE, 0xFFFE, 0x89B0, 0xFFFE,
	0xE464, 0xE45F, 0xFFFE, 0xFFFE, 0xFFFE, 0xE460, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE461, 0xFFFE, 0x919F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE463, 0xE462, 0xE465, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE466,
	0xE467, 0xFFFE, 0xFFFE, 0x9062, 0xFFFE, 0x89E7, 0xFFFE, 0xE468,
	0x97D5, 0xFFFE, 0x8EA9, 0xFFFE, 0xFFFE, 0x8F4C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E8A, 0x9276, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE469, 0xE46A, 0x8950, 0xFFFE, 0xE46B, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_82 = { {
	0xFFFE, 0xE46C, 0xE46D, 0xFFFE, 0xFFFE, 0xE46E, 0xFFFE, 0xE46F,
	0x8BBB, 0x9DA8, 0xE470, 0xFFFE, 0x90E3, 0xE471, 0x8EC9, 0xFFFE,
	0xE472, 0xFFFE, 0x98AE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE473, 0x95DC,
	0x8ADA, 0xFFFE, 0xFFFE, 0x9143, 0x8F77, 0xFFFE, 0x9591, 0x8F4D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE474, 0x8D71, 0xE475, 0x94CA, 0xFFFE, 0xE484, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE477, 0xFFFE, 0x91C7, 0x9495, 0x8CBD,
	0xE476, 0x9144, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE478, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92F8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE47A, 0xE479, 0xE47C, 0xFFFE, 0xFFFE, 0xE47B, 0xFFFE, 0xE47D,
	0xFFFE, 0xFFFE, 0xE480, 0xFFFE, 0xE47E, 0xFFFE, 0x8ACD, 0xFFFE,
	0xE481, 0xFFFE, 0xE482, 0xE483, 0xFFFE, 0xFFFE, 0x8DAF, 0x97C7,
	0xFFFE, 0xE485, 0x9046, 0xFFFE, 0xFFFE, 0xFFFE, 0x8990, 0xE486,
	0xE487, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE488, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x88F0, 0xFFFE, 0xE489, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE48A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9587, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EC5, 0xFFFE, 0xE48C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A48, 0x88B0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE48B, 0xE48E, 0x946D, 0xFFFE, 0x9063,
	0xFFFE, 0x89D4, 0xFFFE, 0x9646, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C7C, 0x8BDA, 0xFFFE, 0xE48D, 0xFFFE, 0x89E8, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AA1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8991, 0xE492, 0x97E8, 0x91DB, 0xFFFE, 0xFFFE, 0x9563,
	0xFFFE, 0xE49E, 0xFFFE, 0x89D5, 0xE49C, 0xFFFE, 0xE49A, 0xE491,
	0xFFFE, 0xE48F, 0xFFFE, 0xE490, 0xFFFE, 0x8EE1, 0x8BEA, 0x9297,
	0xFFFE, 0xFFFE, 0xFFFE, 0x93CF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8970, 0xFFFE, 0xE494, 0xE493, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE499, 0xE495, 0xE498, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_83 = { {
	0xFFFE, 0xFFFE, 0x96CE, 0xE497, 0x89D6, 0x8A9D, 0xE49B, 0xFFFE,
	0xFFFE, 0xE49D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C73, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4A1, 0xE4AA,
	0xE4AB, 0xFFFE, 0xFFFE, 0xFFFE, 0x88A9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4B2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x88EF, 0xFFFE, 0xFFFE, 0xE4A9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4A8,
	0xFFFE, 0xE4A3, 0xE4A2, 0xFFFE, 0xE4A0, 0xE49F, 0x9283, 0xFFFE,
	0x91F9, 0xE4A5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE4A4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4A7, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9190, 0x8C74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8960,
	0xE4A6, 0xFFFE, 0x8D72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9191, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4B8, 0xFFFE, 0xE4B9, 0xFFFE, 0x89D7,
	0xFFFE, 0xFFFE, 0xFFFE, 0x89AC, 0xE4B6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4AC, 0xFFFE, 0xE4B4,
	0xFFFE, 0xE4BB, 0xE4B5, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4B3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE496, 0xFFFE, 0xFFFE, 0xE4B1, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE4AD, 0xFFFE, 0xFFFE, 0xFFFE, 0x8ACE, 0xE4AF,
	0xE4BA, 0xFFFE, 0xE4B0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE4BC, 0xFFFE, 0xE4AE, 0x949C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9789, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4B7, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4CD, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE4C5, 0xFFFE, 0xFFFE, 0xFFFE, 0x909B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8B65, 0xFFFE, 0x8BDB, 0xFFFE, 0xE4C0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x89D9, 0xFFFE, 0xFFFE, 0x8FD2, 0xFFFE,
	0xE4C3, 0xFFFE, 0xFFFE, 0xFFFE, 0x8DD8, 0xFFFE, 0xFFFE, 0x9370,
	0xE4C8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95EC, 0xFFFE, 0xE4BF, 0xFFFE, 0xFFFE, 0xFFFE, 0x89D8,
	0x8CD4, 0x9548, 0xE4C9, 0xFFFE, 0xE4BD, 0xFFFE, 0xFFFE, 0xE4C6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4D0, 0xFFFE, 0xE4C1, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_84 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4C2, 0x93B8, 0xFFFE, 0xFFFE, 0xE4C7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4C4, 0x9647, 0xE4CA, 0x88DE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4BE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE4CC, 0xFFFE, 0xE4CB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x948B, 0xE4D2, 0xFFFE, 0xE4DD, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A9E, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4E0, 0xFFFE, 0xFFFE,
	0xE4CE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4D3, 0x978E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4DC, 0xFFFE,
	0xFFFE, 0x9774, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97A8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9298,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9592, 0xE4E2, 0x939F, 0xFFFE, 0xFFFE, 0x88AF, 0xFFFE,
	0xFFFE, 0xE4DB, 0xFFFE, 0xE4D7, 0x9192, 0xE4D1, 0xE4D9, 0xE4DE,
	0xFFFE, 0x944B, 0xFFFE, 0xFFFE, 0xFFFE, 0x88A8, 0xFFFE, 0xE4D6,
	0xFFFE, 0xE4DF, 0x9598, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE4DA, 0xFFFE, 0xE4D5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8FD3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8F4E, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EAA, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x96D6, 0xFFFE, 0xFFFE, 0x9566, 0xFFFE, 0xFFFE, 0xE4E5,
	0xFFFE, 0xE4EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4D8, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8A97, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FF6, 0xE4E3, 0xFFFE, 0xE4E8, 0x9193, 0xFFFE, 0xFFFE, 0xE4E4,
	0xFFFE, 0xE4EB, 0xFFFE, 0xFFFE, 0x927E, 0xFFFE, 0xE4EC, 0xFFFE,
	0xFFFE, 0x9775, 0xE4E1, 0x8A57, 0xFFFE, 0xE4E7, 0xFFFE, 0xFFFE,
	0xE4EA, 0x96AA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4ED, 0xFFFE,
	0xFFFE, 0xE4E6, 0xE4E9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9648, 0xFFFE, 0x9840, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4F1, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4F8, 0xFFFE, 0xFFFE, 0xE4F0
} };

static const iconv_ccs_convtable_8bit from_ucs_85 = { {
	0x8EC1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4CF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x95CC, 0xFFFE, 0x96A0, 0xE4F7, 0xE4F6, 0xFFFE, 0xE4F2,
	0xE4F3, 0xFFFE, 0x8955, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4F5,
	0xFFFE, 0xE4EF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92D3, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE4F4, 0x88FC, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91A0, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x95C1, 0xFFFE, 0xFFFE,
	0xE4F9, 0xE540, 0xFFFE, 0x94D7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE4FC, 0x8FD4, 0x8EC7, 0xE542, 0xFFFE, 0xFFFE, 0x8BBC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE543, 0xFFFE, 0x9599,
	0xE4FB, 0xFFFE, 0xE4D4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE4FA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x986E, 0x93A0, 0x9593, 0xFFFE, 0xFFFE, 0xE54A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE550,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE551, 0xFFFE,
	0xE544, 0xFFFE, 0xFFFE, 0xFFFE, 0x9496, 0xFFFE, 0xFFFE, 0xE54E,
	0xE546, 0xFFFE, 0xE548, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE552, 0xE547, 0xFFFE, 0xFFFE, 0xE54B, 0xFFFE, 0xFFFE, 0x8992,
	0xFFFE, 0x93E3, 0xFFFE, 0xE54C, 0xE54F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE545, 0xFFFE, 0x9145, 0xFFFE,
	0xE549, 0x8E46, 0x9064, 0x8C4F, 0x96F2, 0xFFFE, 0x96F7, 0x8F92,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE556, 0xE554, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x986D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE553, 0xFFFE, 0xFFFE, 0xFFFE, 0x9795, 0xFFFE, 0xE555,
	0xE557, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE558, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE55B, 0xE559, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x93A1, 0xE55A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x94CB, 0xE54D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F93,
	0xFFFE, 0xE55C, 0xE561, 0x9194, 0xFFFE, 0xFFFE, 0xE560, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_86 = { {
	0xFFFE, 0xFFFE, 0xE541, 0xFFFE, 0xFFFE, 0xFFFE, 0xE562, 0x9168,
	0xFFFE, 0xFFFE, 0xE55D, 0xE55F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE55E, 0xFFFE, 0xFFFE, 0x9F50, 0x9F41,
	0xFFFE, 0xFFFE, 0xE564, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE563, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9796, 0xFFFE, 0xE1BA,
	0xE565, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE566,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE567, 0x8CD5, 0xFFFE,
	0x8B73, 0xFFFE, 0xFFFE, 0xFFFE, 0xE569, 0x997C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8B95, 0xFFFE, 0x97B8, 0xFFFE, 0x8BF1, 0xE56A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE56B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x928E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE56C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x93F8, 0xFFFE, 0x88B8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x89E1, 0xE571, 0xE572, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE56D, 0xFFFE, 0x8E5C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE56E, 0x9461, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE56F, 0xE570, 0xE57A, 0xFFFE, 0xFFFE, 0xFFFE, 0xE574,
	0xE577, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE573, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE575, 0xFFFE, 0xE576, 0x8ED6,
	0xFFFE, 0xE578, 0xFFFE, 0x9260, 0xFFFE, 0x8C75, 0x8A61, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE57B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A5E, 0xFFFE, 0xE581, 0xFFFE, 0xFFFE, 0xE57C, 0xE580,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94B8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE57D, 0xFFFE, 0xFFFE, 0xE57E, 0x9567, 0x94D8, 0xE582,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x91FB, 0xE58C, 0xFFFE, 0xE588, 0xFFFE, 0xFFFE, 0x89E9, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_87 = { {
	0xE586, 0xFFFE, 0x9649, 0xE587, 0xFFFE, 0xFFFE, 0xE584, 0xFFFE,
	0xE585, 0xE58A, 0xE58D, 0xFFFE, 0xFFFE, 0xE58B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE589, 0xE583, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9277, 0xFFFE, 0xE594, 0xFFFE, 0x96A8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE592, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE593, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE58E, 0xFFFE, 0xFFFE, 0xE590,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE591, 0xFFFE, 0xFFFE, 0xFFFE, 0xE58F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x90E4, 0xFFFE, 0x9858, 0xE598, 0xFFFE, 0xE599, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE59F, 0xFFFE, 0x9049, 0xFFFE, 0xE59B,
	0xFFFE, 0xE59E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE596,
	0xE595, 0xFFFE, 0xFFFE, 0xE5A0, 0xFFFE, 0xFFFE, 0x89DA, 0xFFFE,
	0xE59C, 0xFFFE, 0xE5A1, 0xFFFE, 0xFFFE, 0xFFFE, 0xE59D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE59A, 0xFFFE, 0x92B1, 0xFFFE,
	0xE597, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9488,
	0xFFFE, 0xFFFE, 0xE5A5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x975A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5A4,
	0xFFFE, 0xFFFE, 0xE5A3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE5AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5A6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE5AE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9786, 0xE5B1, 0xFFFE, 0xE5A8, 0xFFFE, 0xFFFE,
	0xE5A9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5AD, 0xFFFE, 0xE5B0, 0xE5AF,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE5A7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE5AA, 0xFFFE, 0xE5BB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE5B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5B2,
	0xFFFE, 0xFFFE, 0xE5B3, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5B8, 0xE5B9,
	0xFFFE, 0x8A49, 0xFFFE, 0x8B61, 0xFFFE, 0xFFFE, 0xE5B7, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_88 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5A2, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5B6, 0xE5BA, 0xE5B5,
	0xFFFE, 0xE5BC, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5BE, 0xE5BD, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE5C0, 0xE5BF, 0xE579, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5C4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE5C1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5C2, 0xFFFE,
	0xFFFE, 0xE5C3, 0xFFFE, 0xE5C5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C8C, 0xFFFE, 0xE5C7, 0xFFFE, 0xE5C6, 0xFFFE, 0x8F4F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8D73, 0x9FA5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE5C8, 0x8F70, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A58,
	0xFFFE, 0xE5C9, 0xFFFE, 0x8971, 0xFFFE, 0x8FD5, 0xE5CA, 0xFFFE,
	0xFFFE, 0x8D74, 0xE5CB, 0x88DF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x955C, 0xFFFE, 0xFFFE, 0xE5CC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x908A, 0xFFFE, 0xE5D3, 0xFFFE, 0xFFFE, 0xE5D0, 0xFFFE, 0x928F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5D1, 0xE5CE, 0x8BDC,
	0xFFFE, 0xE5CD, 0xE5D4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C55, 0xFFFE, 0xFFFE, 0x91DC, 0xFFFE, 0xE5DA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE5D6, 0xFFFE, 0xFFFE, 0xFFFE, 0x91B3, 0xE5D5,
	0xFFFE, 0xE5D8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5CF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE5D9, 0xFFFE, 0xE5DB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x94ED, 0xFFFE, 0xFFFE, 0xE5D7, 0xFFFE,
	0xE5DC, 0xE5DE, 0xFFFE, 0xFFFE, 0x8CD1, 0xE5D2, 0xFFFE, 0x88BF,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5DD,
	0xFFFE, 0x8DD9, 0x97F4, 0xE5DF, 0xE5E0, 0x9195, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97A0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5E1, 0x9754, 0xFFFE, 0xFFFE,
	0xE5E2, 0xE5E3, 0xFFFE, 0xFFFE, 0x95E2, 0xE5E4, 0xFFFE, 0x8DBE,
	0xFFFE, 0x97A1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE5E9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE5EA, 0x8FD6, 0xE5E8, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9787, 0xE5E5, 0xFFFE, 0xFFFE, 0xE5E7, 0x90BB, 0x909E, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_89 = { {
	0xFFFE, 0xFFFE, 0xE5E6, 0xFFFE, 0xE5EB, 0xFFFE, 0xFFFE, 0x95A1,
	0xFFFE, 0xFFFE, 0xE5ED, 0xFFFE, 0xE5EC, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8A8C, 0xFFFE, 0x964A, 0xE5EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5FA, 0xE5F0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5F1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE5F2, 0xE5F3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5F7, 0xFFFE,
	0xE5F8, 0xFFFE, 0xFFFE, 0xE5F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE5F4, 0xFFFE, 0xE5EF, 0xE5F5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5F9, 0xE8B5, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x89A6, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE5FC, 0x8BDD,
	0xE5FB, 0xFFFE, 0xFFFE, 0xFFFE, 0xE641, 0xFFFE, 0xE640, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE643, 0xFFFE, 0xFFFE, 0xE642, 0xFFFE, 0xE644,
	0xFFFE, 0xFFFE, 0x8F50, 0xFFFE, 0xE645, 0xFFFE, 0xFFFE, 0xE646,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE647, 0x90BC,
	0xFFFE, 0x9776, 0xFFFE, 0xE648, 0xFFFE, 0xFFFE, 0x95A2, 0x9465,
	0xE649, 0xFFFE, 0xE64A, 0x8CA9, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B4B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE64B, 0xFFFE, 0xFFFE, 0x8E8B, 0x9460,
	0xE64C, 0xFFFE, 0x8A6F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE64D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE64F, 0x9797,
	0xFFFE, 0xE64E, 0x9065, 0xFFFE, 0xE650, 0xFFFE, 0xFFFE, 0xE651,
	0xFFFE, 0xFFFE, 0xE652, 0x8ACF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE653, 0xFFFE, 0xFFFE, 0xE654, 0xFFFE, 0xE655,
	0xE656, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8A70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE657, 0xFFFE, 0xE658, 0xE659, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x89F0, 0xFFFE, 0xFFFE, 0x9047, 0xE65A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE65B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE65C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8A = { {
	0x8CBE, 0xFFFE, 0x92F9, 0xE65D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C76, 0xFFFE, 0x9075, 0xFFFE, 0xE660, 0xFFFE, 0x93A2, 0xFFFE,
	0xE65F, 0xFFFE, 0xFFFE, 0x8C50, 0xFFFE, 0xFFFE, 0xE65E, 0x91F5,
	0x8B4C, 0xFFFE, 0xFFFE, 0xE661, 0xFFFE, 0xE662, 0xFFFE, 0x8FD7,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8C8D, 0xFFFE, 0xE663, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x964B, 0xFFFE, 0xFFFE, 0x90DD, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8B96, 0xFFFE, 0x96F3, 0x9169, 0xFFFE, 0xE664, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9066, 0x9290, 0x8FD8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE665, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE668, 0xFFFE,
	0xE669, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8DBC, 0x91C0, 0xE667, 0xFFFE, 0x8FD9, 0x955D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE666, 0xFFFE, 0xFFFE, 0x8E8C, 0xFFFE,
	0x8972, 0xFFFE, 0xE66D, 0x8C77, 0xFFFE, 0xFFFE, 0x8E8E, 0xFFFE,
	0xFFFE, 0x8E8D, 0xFFFE, 0x986C, 0xE66C, 0xE66B, 0x9146, 0xFFFE,
	0x8B6C, 0x9862, 0x8A59, 0x8FDA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE66A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE66F, 0xFFFE, 0xE670, 0xE66E, 0xFFFE, 0x8CD6,
	0xFFFE, 0x975F, 0xFFFE, 0xFFFE, 0x8E8F, 0x9446, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE673, 0xFFFE, 0x90BE, 0xFFFE, 0x9261, 0xFFFE, 0xFFFE,
	0x9755, 0xFFFE, 0xE676, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CEA, 0xFFFE,
	0x90BD, 0xE672, 0xFFFE, 0xE677, 0x8CEB, 0xE674, 0xE675, 0xFFFE,
	0xE671, 0xFFFE, 0xFFFE, 0xFFFE, 0x90E0, 0x93C7, 0xFFFE, 0xFFFE,
	0x924E, 0xFFFE, 0x89DB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x94EE, 0xFFFE, 0xFFFE, 0x8B62, 0xFFFE, 0xFFFE, 0x92B2,
	0xFFFE, 0xFFFE, 0xE67A, 0xFFFE, 0xE678, 0xFFFE, 0xFFFE, 0x926B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x90BF, 0x8AD0, 0xE679, 0xFFFE, 0x907A,
	0xFFFE, 0xFFFE, 0x97C8, 0xFFFE, 0xFFFE, 0xFFFE, 0x985F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE67B, 0xE687, 0x92B3, 0xFFFE, 0xE686, 0xFFFE,
	0xE683, 0xE68B, 0xE684, 0xFFFE, 0xE680, 0xFFFE, 0x92FA, 0xE67E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE67C, 0xFFFE, 0x9740, 0x8E90, 0xFFFE,
	0xFFFE, 0xE681, 0xFFFE, 0xE67D, 0xFFFE, 0xFFFE, 0xFFFE, 0xE685,
	0x8F94, 0xFFFE, 0x8CBF, 0xFFFE, 0xFFFE, 0xFFFE, 0x91F8, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8B = { {
	0x9664, 0x8979, 0x88E0, 0xFFFE, 0x93A3, 0xFFFE, 0xFFFE, 0xE689,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE688, 0xFFFE, 0x93E4, 0xFFFE,
	0xE68D, 0xFFFE, 0xFFFE, 0xFFFE, 0xE682, 0xFFFE, 0xE68C, 0xE68E,
	0xFFFE, 0x8CAA, 0xE68A, 0x8D75, 0xFFFE, 0x8ED3, 0xFFFE, 0xFFFE,
	0xE68F, 0x9777, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE692, 0xFFFE,
	0xE695, 0xFFFE, 0xFFFE, 0xE693, 0x9554, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE690, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8BDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE694, 0xFFFE,
	0xFFFE, 0xE696, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE69A, 0xFFFE, 0xFFFE, 0xE697, 0xFFFE, 0xE699, 0xE698,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE69B, 0xFFFE,
	0x8EAF, 0xFFFE, 0xE69D, 0xE69C, 0x9588, 0xFFFE, 0xFFFE, 0xE69F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C78, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE69E, 0xE6A0, 0xFFFE, 0xFFFE, 0xE6A1,
	0x8B63, 0xE3BF, 0x8FF7, 0xFFFE, 0xE6A2, 0xFFFE, 0xFFFE, 0x8CEC,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6A3, 0xFFFE, 0xFFFE,
	0xE6A4, 0xFFFE, 0xFFFE, 0x8E5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9DCC, 0xFFFE, 0xE6A5, 0xFFFE, 0xE6A6, 0xFFFE,
	0x8F51, 0xFFFE, 0xE6A7, 0xE6A8, 0xFFFE, 0xFFFE, 0xE6A9, 0xFFFE,
	0xFFFE, 0xE6AA, 0xE6AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x924A,
	0xFFFE, 0xFFFE, 0xE6AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6AE,
	0xFFFE, 0xE6AD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x93A4, 0xFFFE,
	0xE6AF, 0xFFFE, 0x964C, 0xFFFE, 0xE6B0, 0xFFFE, 0xE6B1, 0xFFFE,
	0xE6B2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6B3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x93D8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8FDB, 0xE6B4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8D8B, 0x98AC, 0xE6B5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE6B6, 0x955E, 0xE6B7, 0xFFFE, 0xE6BF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6B8, 0xFFFE, 0xFFFE, 0xE6BA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE6B9, 0xE6BB, 0xFFFE, 0x9665, 0xE6BC, 0xE6BD, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6BE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE6C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A4C, 0x92E5, 0xFFFE,
	0x9589, 0x8DE0, 0x8D76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x956E,
	0x89DD, 0x94CC, 0xE6C3, 0x8AD1, 0x90D3, 0xE6C2, 0xE6C7, 0x9299,
	0x96E1, 0xFFFE, 0xE6C5, 0xE6C6, 0x8B4D, 0xFFFE, 0xE6C8, 0x9483,
	0x91DD, 0xFFFE, 0xFFFE, 0x94EF, 0x935C, 0xE6C4, 0xFFFE, 0x9666,
	0x89EA, 0xE6CA, 0x9847, 0x92C0, 0x9864, 0xFFFE, 0xFFFE, 0x8E91,
	0xE6C9, 0xFFFE, 0x91AF, 0xFFFE, 0xFFFE, 0xE6DA, 0x9147, 0xFFFE,
	0xFFFE, 0x93F6, 0xFFFE, 0x956F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6CD, 0x8E5E, 0x8E92, 0xFFFE, 0x8FDC, 0xFFFE,
	0x9485, 0xFFFE, 0x8CAB, 0xE6CC, 0xE6CB, 0xFFFE, 0x958A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8EBF, 0xFFFE, 0xFFFE, 0x9371, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6CF, 0xE6D0, 0x8D77, 0xE6CE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6D1, 0xE6D2, 0xFFFE, 0xE6D4,
	0x91A1, 0xFFFE, 0xE6D3, 0x8AE4, 0xFFFE, 0xE6D6, 0xFFFE, 0xE6D5,
	0xE6D7, 0xFFFE, 0xFFFE, 0xE6D9, 0xE6DB, 0xFFFE, 0xE6DC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90D4, 0xFFFE, 0x8ECD, 0xE6DD,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A71, 0xFFFE, 0xE6DE, 0xFFFE, 0xFFFE,
	0x9196, 0xE6DF, 0xFFFE, 0xE6E0, 0x958B, 0xFFFE, 0xFFFE, 0x8B4E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE6E1, 0xFFFE, 0xFFFE, 0xFFFE, 0x92B4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x897A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE6E2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8EEF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9096, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x91AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6E5, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6E4, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6E3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE6EB, 0xE6E9, 0xFFFE, 0xFFFE, 0xE6E6,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6E8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6E7, 0xE6EA, 0xFFFE, 0x8B97, 0xFFFE, 0xE6EE,
	0xFFFE, 0x90D5, 0xFFFE, 0xE6EF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8CD7, 0xFFFE, 0xE6EC, 0xE6ED, 0xFFFE, 0xFFFE, 0xFFFE, 0x9848,
	0xFFFE, 0xFFFE, 0xFFFE, 0x92B5, 0xFFFE, 0x9148, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6F0, 0xFFFE, 0xFFFE, 0xE6F3
} };

static const iconv_ccs_convtable_8bit from_ucs_8E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE6F1, 0xE6F2, 0x9778, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x93A5,
	0xE6F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6F4, 0xE6F5, 0xE6F7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE748, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE6FA, 0xFFFE, 0xFFFE, 0xFFFE, 0xE6FB, 0xE6F9, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE6F8, 0xFFFE, 0x92FB, 0xFFFE, 0xFFFE, 0xE740,
	0xE744, 0xE741, 0xE6FC, 0xFFFE, 0xE742, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE74A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE745, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90D6,
	0xE747, 0xFFFE, 0xFFFE, 0xE749, 0xE746, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE74C, 0xFFFE, 0x8F52, 0xFFFE, 0xE74B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE74D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE74E, 0xFFFE, 0xFFFE, 0xE751, 0xE750, 0xFFFE, 0xE74F,
	0xFFFE, 0xFFFE, 0xE753, 0xE752, 0xFFFE, 0x96F4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE755, 0xFFFE, 0xE754, 0xE756, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE759, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE758, 0x9067, 0xE75A, 0xFFFE, 0xFFFE, 0x8BEB,
	0xE75B, 0xE75D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE75E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE75F, 0xE75C, 0xFFFE,
	0xE760, 0xFFFE, 0x8ED4, 0xE761, 0x8B4F, 0x8C52, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8CAC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE762, 0xFFFE, 0xFFFE, 0xFFFE, 0x93EE,
	0xFFFE, 0xFFFE, 0x935D, 0xE763, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE766, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8EB2, 0xFFFE, 0xFFFE, 0xE765, 0xE764, 0x8C79, 0xE767, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x8A72, 0xFFFE, 0xE769, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8DDA, 0xE768, 0xFFFE, 0xE771, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE76B, 0xE76D, 0x95E3, 0xE76A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE76C, 0xFFFE, 0xE770, 0xE76E, 0x8B50, 0xFFFE, 0xE76F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE772, 0xFFFE,
	0xFFFE, 0x9479, 0x97D6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F53,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE773, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9741, 0xE775, 0xFFFE, 0xE774, 0xFFFE, 0xFFFE, 0xE778, 0x9760,
	0xFFFE, 0xFFFE, 0xE777, 0xFFFE, 0x8A8D, 0xE776, 0xE77B, 0xFFFE,
	0xFFFE, 0xE77A, 0xFFFE, 0xFFFE, 0xE779, 0x9351, 0xE77C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE77D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE77E, 0xFFFE, 0xFFFE, 0x8D8C,
	0xFFFE, 0x8C44, 0xE780, 0xE781, 0xE782, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9068, 0xE783, 0xFFFE, 0x8EAB, 0xE784,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE785, 0xFFFE, 0xFFFE, 0xFFFE, 0x999F,
	0x999E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE786, 0xE390, 0xE787,
	0x9243, 0x904A, 0x945F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE788,
	0xFFFE, 0xFFFE, 0x95D3, 0x92D2, 0x8D9E, 0xFFFE, 0xFFFE, 0x9248,
	0xFFFE, 0xFFFE, 0x8949, 0xFFFE, 0x9698, 0x9076, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C7D, 0xFFFE,
	0xFFFE, 0x8BDF, 0xFFFE, 0xFFFE, 0x95D4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE789, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE78B, 0xFFFE, 0xFFFE, 0xE78A, 0x89DE, 0xFFFE,
	0xFFFE, 0x93F4, 0xE78C, 0x9497, 0xFFFE, 0x9352, 0xFFFE, 0xE78D,
	0x8F71, 0xFFFE, 0xFFFE, 0xFFFE, 0xE78F, 0xFFFE, 0xFFFE, 0x96C0,
	0xE79E, 0xE791, 0xE792, 0xFFFE, 0xFFFE, 0x92C7, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_90 = { {
	0x91DE, 0x9197, 0xFFFE, 0x93A6, 0xFFFE, 0xE790, 0x8B74, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE799, 0xFFFE, 0xE796, 0xE7A3, 0x93A7,
	0x9280, 0xE793, 0xFFFE, 0x92FC, 0x9372, 0xE794, 0xE798, 0x9080,
	0xFFFE, 0x9487, 0x92CA, 0xFFFE, 0xFFFE, 0x90C0, 0xE797, 0x91AC,
	0x91A2, 0xE795, 0x88A7, 0x9841, 0xFFFE, 0xFFFE, 0xFFFE, 0xE79A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x91DF, 0xFFFE,
	0xFFFE, 0x8F54, 0x9069, 0xFFFE, 0xFFFE, 0xE79C, 0xE79B, 0xFFFE,
	0x88ED, 0xE79D, 0xFFFE, 0xFFFE, 0x954E, 0xFFFE, 0xE7A5, 0xFFFE,
	0xFFFE, 0x93D9, 0x908B, 0xFFFE, 0xFFFE, 0x9278, 0xFFFE, 0x8BF6,
	0xFFFE, 0xE7A4, 0x9756, 0x895E, 0xFFFE, 0x95D5, 0x89DF, 0xE79F,
	0xE7A0, 0xE7A1, 0xE7A2, 0x93B9, 0x9242, 0x88E1, 0xE7A6, 0xFFFE,
	0xE7A7, 0xEAA1, 0xFFFE, 0xFFFE, 0x91BB, 0xFFFE, 0xE7A8, 0xFFFE,
	0x8993, 0x916B, 0xFFFE, 0x8CAD, 0xFFFE, 0x9779, 0xFFFE, 0xFFFE,
	0xE7A9, 0x934B, 0xFFFE, 0xFFFE, 0xFFFE, 0x9198, 0x8ED5, 0xE7AA,
	0xFFFE, 0xFFFE, 0xE7AD, 0xFFFE, 0xFFFE, 0x8F85, 0xE7AB, 0x914A,
	0x9149, 0xFFFE, 0x88E2, 0xFFFE, 0x97C9, 0xE7AF, 0xFFFE, 0x94F0,
	0xE7B1, 0xE7B0, 0xE7AE, 0xE284, 0x8AD2, 0xFFFE, 0xFFFE, 0xE78E,
	0xFFFE, 0xE7B3, 0xE7B2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7B4,
	0xFFFE, 0x9757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x93DF, 0xFFFE, 0xFFFE, 0x964D, 0xFFFE,
	0xE7B5, 0xFFFE, 0x8ED7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7B6,
	0xFFFE, 0xE7B7, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7B8, 0xFFFE, 0xFFFE,
	0x9340, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x88E8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8D78, 0xFFFE, 0xFFFE, 0xFFFE, 0x9859, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE7BC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8C53, 0xE7B9, 0xFFFE, 0xE7BA, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9594, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A73, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9758, 0xFFFE, 0x8BBD,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9373, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_91 = { {
	0xFFFE, 0xFFFE, 0xE7BD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE7BE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE7BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9341, 0xFFFE, 0xFFFE,
	0xE7C1, 0xFFFE, 0xE7C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x93D1, 0xE7C2, 0x8F55, 0x8EDE, 0x947A, 0x9291, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8EF0, 0xFFFE, 0x908C, 0xFFFE, 0xE7C3, 0xFFFE,
	0xE7C4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x907C, 0xE7C5, 0xFFFE, 0xE7C6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE7C7, 0x978F, 0xFFFE, 0x8F56, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE7C9, 0xE7C8, 0xFFFE, 0x8D79, 0xFFFE, 0x8D93,
	0x8E5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE7CC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F86,
	0xFFFE, 0xE7CB, 0xFFFE, 0xE7CA, 0xFFFE, 0x91E7, 0xFFFE, 0xFFFE,
	0x8CED, 0xFFFE, 0x90C1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94AE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F58, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE7CD, 0xFFFE, 0x8FDD, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE7D0, 0xE7CE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7CF,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7D2, 0xE7D1, 0xFFFE, 0xFFFE,
	0x8FF8, 0xFFFE, 0xE7D3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE7D4, 0xE7D5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x94CE, 0x8DD1,
	0x8EDF, 0xE7D6, 0xFFFE, 0xE7D7, 0x97A2, 0x8F64, 0x96EC, 0x97CA,
	0xE7D8, 0x8BE0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7D9, 0xFFFE,
	0x9342, 0xFFFE, 0xFFFE, 0xE7DC, 0x8A98, 0x906A, 0xFFFE, 0xE7DA,
	0xFFFE, 0xE7DB, 0xFFFE, 0x92DE, 0xFFFE, 0xFFFE, 0x9674, 0x8BFA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7DE, 0xE7DF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7DD, 0xFFFE, 0xFFFE, 0xE7E1
} };

static const iconv_ccs_convtable_8bit from_ucs_92 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x93DD, 0x8A62, 0xFFFE,
	0xFFFE, 0xE7E5, 0xFFFE, 0xFFFE, 0xE7E2, 0xE7E4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7E0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE86E, 0xFFFE, 0xFFFE, 0xE7E3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97E9, 0xFFFE, 0xFFFE, 0x8CD8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7ED,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9353, 0xE7E8, 0xFFFE, 0xFFFE,
	0xE7EB, 0xE7E9, 0xFFFE, 0xE7EE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE7EF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7E7,
	0xFFFE, 0xFFFE, 0xE7F4, 0x8994, 0xFFFE, 0xFFFE, 0xE7E6, 0xFFFE,
	0xFFFE, 0xFFFE, 0x94AB, 0xFFFE, 0xE7EA, 0xFFFE, 0x8FDE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8D7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9667, 0xFFFE,
	0x8BE2, 0xFFFE, 0xFFFE, 0x8F65, 0xFFFE, 0x93BA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x914C, 0xFFFE, 0xE7F2, 0xFFFE, 0xE7EC, 0xE7F1, 0xFFFE,
	0x96C1, 0xFFFE, 0x92B6, 0xE7F3, 0xE7F0, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x914B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7F7,
	0xFFFE, 0xE7F6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7F5,
	0xFFFE, 0xFFFE, 0x964E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F9B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE7F8, 0x95DD, 0xFFFE, 0xFFFE, 0x8973, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9565, 0x9292, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8B98, 0xFFFE, 0xE7FA, 0xFFFE, 0x8D7C, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_93 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E4B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7F9,
	0x908D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x908E, 0xE840, 0xE842, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FF9, 0xFFFE, 0xE841, 0xE843, 0xFFFE, 0xFFFE, 0x8BD1, 0xFFFE,
	0x9564, 0xFFFE, 0xFFFE, 0x8EE0, 0x9842, 0xFFFE, 0xE7FC, 0x8DF6,
	0xFFFE, 0xFFFE, 0x985E, 0xFFFE, 0xFFFE, 0xE845, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE844, 0xE846, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE7FB, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x93E7, 0xFFFE, 0x9374, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92D5, 0xFFFE, 0xE84B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9262, 0xE847, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE848, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C4C, 0xFFFE, 0xE84A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CAE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE849, 0xFFFE, 0x8FDF, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A99, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE84F, 0xFFFE, 0x8DBD, 0x9199,
	0xFFFE, 0xFFFE, 0x92C8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A5A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE84D, 0xE84E, 0x92C1, 0xFFFE,
	0xE84C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE850, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE856, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE859, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE858, 0x934C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE851, 0xE852,
	0xE855, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE857, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8BBE, 0xFFFE, 0xFFFE, 0xE85A, 0xE854, 0xFFFE, 0xFFFE,
	0xE853, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_94 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xE85E, 0xFFFE, 0xFFFE, 0xFFFE, 0xE85F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE860, 0xFFFE, 0xFFFE, 0xE85D, 0xE85C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FE0, 0x93A8, 0xE85B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE864, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE862, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE863, 0xE861, 0xFFFE,
	0x91F6, 0xFFFE, 0xE865, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE866, 0xFFFE, 0xFFFE, 0xE868, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8AD3, 0xE867, 0x96F8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE873, 0xE869, 0xFFFE, 0xFFFE, 0xE86C, 0xFFFE,
	0xE86A, 0xFFFE, 0xE86B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE86D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE86F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE870, 0xFFFE, 0xE871,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE874, 0xE872, 0xE875, 0xE877,
	0xFFFE, 0xE876, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_95 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92B7,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x96E5, 0xFFFE, 0xE878, 0x914D, 0xFFFE, 0xFFFE, 0xFFFE, 0xE879,
	0xFFFE, 0x95C2, 0xE87A, 0x8A4A, 0xFFFE, 0xFFFE, 0xFFFE, 0x895B,
	0xFFFE, 0x8AD5, 0xFFFE, 0x8AD4, 0xE87B, 0xFFFE, 0xE87C, 0xFFFE,
	0xE87D, 0xE87E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE880, 0xFFFE, 0x8AD6, 0x8A74, 0x8D7D, 0x94B4, 0xFFFE, 0xE882,
	0xE881, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE883, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x897B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE886, 0xFFFE, 0xE885, 0xE884, 0xFFFE, 0xE887, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE88A, 0xFFFE, 0xFFFE, 0xFFFE, 0x88C5,
	0xFFFE, 0xFFFE, 0xE888, 0xFFFE, 0xE88C, 0xE88B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE88E, 0xE88D, 0xE88F, 0xFFFE,
	0x93AC, 0xFFFE, 0xFFFE, 0xFFFE, 0xE890, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE891, 0xE893, 0xFFFE, 0xFFFE, 0xE892, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_96 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x958C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE894, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE895, 0xFFFE, 0x8DE3, 0xFFFE, 0xFFFE, 0xFFFE, 0xE896, 0xE897,
	0xFFFE, 0xFFFE, 0x9668, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x916A, 0xFFFE, 0xFFFE, 0xFFFE, 0x88A2,
	0x91C9, 0xFFFE, 0xE898, 0xFFFE, 0x958D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE89B, 0xE899, 0x8D7E, 0xFFFE, 0xE89A,
	0x8CC0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x95C3, 0xE89D, 0xE89F, 0xE89E, 0xE8A0,
	0xFFFE, 0xFFFE, 0x8940, 0x9077, 0x8F9C, 0x8AD7, 0xE8A1, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9486, 0xFFFE, 0xE8A3, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8941, 0xFFFE, 0xE8A2, 0x92C2, 0xFFFE, 0x97CB, 0x93A9, 0xE89C,
	0x97A4, 0xFFFE, 0x8CAF, 0xFFFE, 0xFFFE, 0x977A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BF7, 0x97B2, 0xFFFE,
	0x8C47, 0xFFFE, 0x91E0, 0xE440, 0xFFFE, 0xE8A4, 0x8A4B, 0x908F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A75, 0xE8A6, 0xFFFE, 0xE8A7,
	0xE8A5, 0x8C84, 0xFFFE, 0x8DDB, 0x8FE1, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8942, 0xFFFE, 0xFFFE, 0x97D7, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8A9,
	0xE7AC, 0xFFFE, 0xE8A8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE8AC, 0xE8AA, 0xE8AB, 0xFFFE, 0xE8AD, 0xFFFE, 0xE8AE, 0x97EA,
	0xE8AF, 0xE8B0, 0xFFFE, 0x90C7, 0x94B9, 0xFFFE, 0xFFFE, 0xFFFE,
	0x909D, 0x8AE5, 0xFFFE, 0xFFFE, 0x9759, 0x89EB, 0x8F57, 0x8CD9,
	0xFFFE, 0xE8B3, 0xFFFE, 0xE8B2, 0x8E93, 0xE8B4, 0xE8B1, 0xFFFE,
	0xFFFE, 0x8E47, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8B8, 0xE5AB, 0xFFFE,
	0xFFFE, 0x99D4, 0xFFFE, 0x9097, 0xE8B6, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x97A3, 0x93EF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x894A, 0xFFFE, 0x90E1, 0x8EB4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x95B5, 0xFFFE, 0x895F, 0xFFFE, 0xFFFE, 0xFFFE, 0x97EB, 0x978B,
	0xFFFE, 0xE8B9, 0xFFFE, 0x9364, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_97 = { {
	0x8EF9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8BA, 0xFFFE, 0xE8BB, 0x906B,
	0xE8BC, 0xFFFE, 0x97EC, 0xFFFE, 0xFFFE, 0xE8B7, 0xE8BE, 0xE8C0,
	0xFFFE, 0xE8BF, 0xFFFE, 0xE8BD, 0xFFFE, 0xFFFE, 0xE8C1, 0xFFFE,
	0xFFFE, 0xE8C2, 0xFFFE, 0xFFFE, 0x919A, 0xFFFE, 0x89E0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8C3, 0xFFFE, 0xFFFE, 0x96B6,
	0xFFFE, 0xFFFE, 0xE8C4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE8C5, 0xFFFE, 0x9849, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9E50, 0xE8C6, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8C7, 0xE8C8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE8CC, 0xFFFE, 0xE8C9, 0xFFFE, 0xE8CA, 0xFFFE,
	0xE8CB, 0xE8CD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x90C2, 0xFFFE, 0xFFFE, 0xFFFE, 0x96F5, 0xFFFE,
	0xFFFE, 0x90C3, 0xFFFE, 0xFFFE, 0xE8CE, 0xFFFE, 0x94F1, 0xFFFE,
	0xE8CF, 0xEA72, 0x96CA, 0xFFFE, 0xE8D0, 0xFFFE, 0xE8D1, 0xFFFE,
	0xE8D2, 0x8A76, 0xFFFE, 0xE8D4, 0xFFFE, 0x9078, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE8D5, 0xFFFE, 0xFFFE, 0x8C43, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE8D6, 0xE8DA, 0xFFFE, 0xE8D8, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE8D9, 0xFFFE, 0xFFFE, 0x8A93, 0xE8D7, 0xE8DB, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE8DC, 0xFFFE, 0x88C6, 0xFFFE, 0xE8DD,
	0xE8DE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FE2, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8DF, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8B66, 0xFFFE, 0xFFFE, 0xE8E2, 0xFFFE, 0xFFFE, 0xE8E1, 0xFFFE,
	0xE8E0, 0xFFFE, 0xFFFE, 0xE691, 0xFFFE, 0x95DA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE8E3, 0xE8E4, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE8E5, 0xFFFE, 0xFFFE, 0xE8E6, 0xFFFE,
	0xE8E7, 0xFFFE, 0xFFFE, 0xE8E8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8AD8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8E9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8EA, 0x9442, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE8EC, 0x89B9, 0xFFFE, 0xE8EF, 0xE8EE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8943, 0xFFFE, 0xFFFE, 0xFFFE, 0x8BBF
} };

static const iconv_ccs_convtable_8bit from_ucs_98 = { {
	0xFFFE, 0x95C5, 0x92B8, 0x8DA0, 0xFFFE, 0x8D80, 0x8F87, 0xFFFE,
	0x907B, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8F1, 0xFFFE, 0xFFFE, 0xE8F0,
	0x9761, 0x8AE6, 0x94D0, 0x93DA, 0xFFFE, 0xFFFE, 0xFFFE, 0x909C,
	0x97CC, 0xFFFE, 0x8C7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE8F4, 0xFFFE, 0xFFFE, 0xE8F3, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x966A, 0x93AA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x896F, 0xFFFE, 0xFFFE, 0xE8F5,
	0xE8F2, 0xFFFE, 0xFFFE, 0x9570, 0x978A, 0xE8F6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8F7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE8F9, 0x91E8, 0x8A7A, 0x8A7B, 0xE8F8,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8AE7, 0x8CB0, 0xFFFE, 0xFFFE,
	0x8AE8, 0xFFFE, 0xFFFE, 0x935E, 0xFFFE, 0xFFFE, 0x97DE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8CDA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE8FA, 0xFFFE, 0xFFFE, 0xFFFE, 0xE8FB,
	0xE8FC, 0xE940, 0xFFFE, 0xE942, 0xE941, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9597, 0xFFFE, 0xE943, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE944,
	0xFFFE, 0xE945, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE946, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE948, 0xE947, 0xFFFE, 0xE949, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x94F2, 0xE3CA, 0xFFFE, 0xFFFE, 0x9048,
	0xFFFE, 0xFFFE, 0x8B51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE94A, 0xFFFE, 0xE94B, 0xFFFE, 0x99AA, 0x9F5A, 0x94D1,
	0xFFFE, 0xFFFE, 0x88F9, 0xFFFE, 0x88B9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8E94, 0x964F, 0x8FFC, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_99 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xE94C, 0xFFFE, 0x96DD, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE94D, 0x977B, 0xFFFE, 0x8961, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8E60, 0xFFFE, 0xE94E, 0x89EC, 0xE94F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE950, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE952, 0xE953, 0xFFFE,
	0xE955, 0xE951, 0xFFFE, 0xFFFE, 0xE954, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8AD9, 0xFFFE, 0xFFFE, 0xFFFE, 0xE956, 0xFFFE, 0xE957, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE958, 0xE959, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE95A, 0xFFFE, 0xFFFE, 0xE95C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE95B, 0xFFFE, 0xE95E, 0xE961, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE95D, 0xE95F, 0xE960, 0xFFFE, 0xFFFE, 0xE962, 0xFFFE, 0x8BC0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EF1, 0xE963,
	0xE964, 0x8D81, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE965, 0xFFFE, 0xFFFE,
	0x8A5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x946E, 0xE966, 0xE967, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9279, 0x93E9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE968, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x949D, 0xFFFE, 0xFFFE, 0x91CA, 0x8977, 0x8BEC, 0xFFFE,
	0x8BED, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x9293, 0xE96D, 0x8BEE, 0xFFFE, 0xFFFE, 0x89ED, 0xFFFE, 0xFFFE,
	0xE96C, 0xFFFE, 0xFFFE, 0xE96A, 0xFFFE, 0xE96B, 0xFFFE, 0xE969,
	0xFFFE, 0xFFFE, 0xE977, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE96E, 0xE96F, 0xFFFE,
	0xFFFE, 0xE970, 0xE971, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE973, 0xFFFE, 0xFFFE, 0xE972, 0xFFFE, 0xFFFE, 0xFFFE, 0x8F78
} };

static const iconv_ccs_convtable_8bit from_ucs_9A = { {
	0xFFFE, 0xE974, 0xFFFE, 0xFFFE, 0xFFFE, 0xE976, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8B52, 0xE975,
	0xFFFE, 0xFFFE, 0x919B, 0x8CB1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE978, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x91CB, 0xFFFE, 0xFFFE, 0xE979, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x93AB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE97A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE980, 0xFFFE,
	0xE97D, 0xFFFE, 0xE97C, 0xE97E, 0xFFFE, 0xE97B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE982, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE981, 0xFFFE, 0xE984,
	0xFFFE, 0xFFFE, 0x8BC1, 0xE983, 0xFFFE, 0xFFFE, 0xFFFE, 0xE985,
	0xFFFE, 0xFFFE, 0xE986, 0xFFFE, 0xE988, 0xE987, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE989, 0xE98B, 0xE98A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8D9C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE98C, 0xFFFE, 0xFFFE,
	0xE98D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8A5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xE98E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE98F, 0xFFFE, 0xFFFE, 0xFFFE, 0x9091, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE990,
	0xFFFE, 0xE991, 0xFFFE, 0xE992, 0xE993, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8D82, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE994, 0xE995,
	0xFFFE, 0xFFFE, 0xE996, 0xE997, 0xFFFE, 0xFFFE, 0xE998, 0xFFFE,
	0xFFFE, 0xFFFE, 0x94AF, 0xE99A, 0xFFFE, 0x9545, 0xE99B, 0xE999,
	0xFFFE, 0xE99D, 0xFFFE, 0xFFFE, 0xE99C, 0xFFFE, 0xFFFE, 0xE99E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE99F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9A0, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9A1, 0xFFFE, 0xE9A2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9A3,
	0xFFFE, 0xFFFE, 0xE9A4, 0xE9A5, 0xFFFE, 0xE9A6, 0xFFFE, 0xE9A7,
	0xE9A8, 0xE9A9, 0xE9AA, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9AB, 0xE9AC,
	0xFFFE, 0x9F54, 0xE9AD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE2F6, 0x8B53, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A40, 0x8DB0, 0xE9AF, 0xE9AE, 0x96A3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9B1, 0xE9B2, 0xE9B0,
	0xFFFE, 0xE9B3, 0xFFFE, 0xFFFE, 0x9682, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9B4, 0xFFFE, 0x8B9B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9844,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9B5, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE9B7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x88BC, 0xFFFE,
	0xFFFE, 0xE9B8, 0x95A9, 0xE9B6, 0xFFFE, 0xFFFE, 0xE9B9, 0xE9BA,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9BB,
	0xE9BC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9BD, 0xFFFE, 0x968E, 0x8E4C, 0xFFFE, 0x8DF8, 0x914E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9BE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE9C1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9BF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9C2, 0xFFFE,
	0xFFFE, 0x8CEF, 0xE9C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9C3,
	0xFFFE, 0xE9C4, 0xE9C5, 0xFFFE, 0xE9C9, 0xFFFE, 0x8E49, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x91E2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE9CA, 0xE9C7, 0xE9C6, 0xE9C8, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8C7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9CE, 0xE9CD, 0xE9CC, 0xFFFE, 0xFFFE, 0x88B1, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9D8, 0xFFFE, 0xE9D4, 0xFFFE,
	0xE9D5, 0xE9D1, 0xE9D7, 0xFFFE, 0xE9D3, 0x8A82, 0xFFFE, 0xFFFE,
	0x986B, 0xFFFE, 0xE9D6, 0xE9D2, 0xE9D0, 0xE9CF, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE9DA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xE9DD, 0xFFFE, 0xFFFE, 0xE9DC, 0xE9DB, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9568, 0xE9D9, 0x88F1,
	0xE9DE, 0xFFFE, 0xE9E0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A8F, 0xE9CB, 0x8956, 0xFFFE, 0xFFFE, 0xE9E2, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9E1, 0xE9DF,
	0x924C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9690, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97D8,
	0xFFFE, 0xFFFE, 0xE9E3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9E4, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9E5,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9E6, 0xFFFE,
	0xE9E7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x92B9, 0xFFFE, 0xE9E8,
	0xFFFE, 0x94B5, 0xFFFE, 0xE9ED, 0xE9E9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE9EA, 0xFFFE, 0xFFFE, 0x9650, 0x96C2, 0xFFFE, 0x93CE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xE9EE, 0xFFFE, 0xFFFE, 0xE9EF, 0x93BC,
	0xE9EC, 0xE9EB, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x89A8, 0xFFFE,
	0xFFFE, 0xFFFE, 0xE9F7, 0xFFFE, 0xFFFE, 0xE9F6, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8995, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9F4,
	0xFFFE, 0xFFFE, 0xFFFE, 0xE9F3, 0xFFFE, 0xFFFE, 0xE9F1, 0xFFFE,
	0x8A9B, 0xFFFE, 0xE9F0, 0x8EB0, 0x89A7, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8D83, 0xFFFE, 0xFFFE, 0xE9FA, 0xE9F9,
	0xFFFE, 0xE9F8, 0xFFFE, 0xFFFE, 0xE9F5, 0xFFFE, 0xE9FB, 0xFFFE,
	0xE9FC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEA44, 0xEA43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEA45, 0xFFFE, 0xFFFE, 0x894C, 0xEA40, 0xEA41, 0xFFFE,
	0x8D94, 0x96B7, 0xFFFE, 0xFFFE, 0xEA42, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9651, 0xFFFE, 0xFFFE, 0xEA4A,
	0xFFFE, 0xFFFE, 0xEA46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xEA4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA48,
	0xFFFE, 0xEA47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8C7B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xEA4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA4D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEA4E, 0xFFFE, 0xEA49, 0xFFFE, 0xFFFE, 0xFFFE, 0xE9F2,
	0xFFFE, 0xFFFE, 0xEA4F, 0xFFFE, 0x92DF, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEA53, 0xFFFE, 0xEA54, 0xEA52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEA51, 0xEA57, 0xFFFE, 0xEA50, 0xFFFE, 0xEA55, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA56,
	0xFFFE, 0xFFFE, 0xFFFE, 0xEA59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEA58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA5B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA5C, 0xFFFE, 0xEA5D,
	0xFFFE, 0xFFFE, 0x9868, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEA5A, 0x91E9, 0x8DEB, 0xFFFE, 0xFFFE, 0xEA5E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xEA5F, 0xEA60, 0xFFFE, 0xFFFE, 0xEA61, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA62, 0xFFFE, 0xFFFE,
	0x8CB2, 0xEA63, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA64, 0xFFFE, 0x8EAD,
	0xFFFE, 0xEA65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEA66, 0xFFFE, 0xFFFE, 0xEA67, 0xEA68, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xEA6B, 0xEA69, 0x985B, 0xFFFE, 0xEA6A, 0xFFFE, 0x97ED,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA6C, 0xFFFE, 0x97D9,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA6D, 0x949E, 0xFFFE,
	0xFFFE, 0xEA6E, 0xEA70, 0xFFFE, 0xFFFE, 0xEA71, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEA6F, 0x8D8D, 0x96CB, 0x9683, 0x9BF5, 0xFFFE, 0x9F80, 0x969B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x89A9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA73, 0x8B6F, 0xEA74, 0xEA75,
	0xEA76, 0xFFFE, 0x8D95, 0xFFFE, 0xEA77, 0xFFFE, 0xFFFE, 0xFFFE,
	0xE0D2, 0x96D9, 0xFFFE, 0x91E1, 0xEA78, 0xEA7A, 0xEA79, 0xFFFE,
	0xEA7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA7C, 0xFFFE, 0xFFFE,
	0xEA7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA80, 0xFFFE, 0xEA81, 0xEA82,
	0xFFFE, 0xEA83, 0xFFFE, 0xEA84, 0xEA85, 0xEA86, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA87,
	0xEA88, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9343, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8CDB, 0xFFFE, 0xEA8A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x916C, 0xEA8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA8C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9540, 0xFFFE, 0xFFFE, 0xEA8D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xEA8E, 0xE256, 0xFFFE, 0xFFFE, 0xE6D8, 0xE8EB,
	0xFFFE, 0xFFFE, 0xEA8F, 0xFFFE, 0xEA90, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA92,
	0xEA93, 0xEA94, 0x97EE, 0xEA91, 0xFFFE, 0xFFFE, 0xEA95, 0xEA96,
	0xFFFE, 0xFFFE, 0xEA98, 0xFFFE, 0xEA97, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xEA9A, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA9B, 0xEA99,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97B4, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA9C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEA9D, 0xE273, 0xFFFE, 0xFFFE,
	0xEA9E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_F8 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x86CE, 0x869E, 0x87FC, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_FE = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xEB64, 0xEB5C, 0xFFFE, 0xEB51, 0xFFFE, 0xEB69, 0xEB6A, 0xEB6F,
	0xEB70, 0xEB6B, 0xEB6C, 0xEB79, 0xEB7A, 0xEB73, 0xEB74, 0xEB71,
	0xEB72, 0xEB75, 0xEB76, 0xEB77, 0xEB78, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_FF = { {
	0xFFFE, 0x8149, 0xFFFE, 0x8194, 0x8190, 0x8193, 0x8195, 0xFFFE,
	0x8169, 0x816A, 0x8196, 0x817B, 0x8143, 0xFFFE, 0x8144, 0x815E,
	0x824F, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255, 0x8256,
	0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0xEB81, 0x8184, 0x8148,
	0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266,
	0x8267, 0x8268, 0x8269, 0x826A, 0x826B, 0x826C, 0x826D, 0x826E,
	0x826F, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274, 0x8275, 0x8276,
	0x8277, 0x8278, 0x8279, 0xEB6D, 0x815F, 0xEB6E, 0x814F, 0x8151,
	0x814D, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286, 0x864B,
	0x8288, 0x8289, 0x828A, 0x828B, 0x828C, 0x8645, 0x828E, 0x828F,
	0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296, 0x8297,
	0x8298, 0x8299, 0x829A, 0x816F, 0xEB62, 0x8170, 0xFFFE, 0xFFFE,
	0xFFFE, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
	0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
	0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
	0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
	0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
	0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
	0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
	0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xEB50, 0xFFFE, 0x818F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_16bit from_ucs = { {
	&from_ucs_00, NULL, NULL, &from_ucs_03, &from_ucs_04, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&from_ucs_20, &from_ucs_21, &from_ucs_22, &from_ucs_23, &from_ucs_24, &from_ucs_25, &from_ucs_26, &from_ucs_27,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&from_ucs_30, NULL, &from_ucs_32, &from_ucs_33, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, &from_ucs_4E, &from_ucs_4F,
	&from_ucs_50, &from_ucs_51, &from_ucs_52, &from_ucs_53, &from_ucs_54, &from_ucs_55, &from_ucs_56, &from_ucs_57,
	&from_ucs_58, &from_ucs_59, &from_ucs_5A, &from_ucs_5B, &from_ucs_5C, &from_ucs_5D, &from_ucs_5E, &from_ucs_5F,
	&from_ucs_60, &from_ucs_61, &from_ucs_62, &from_ucs_63, &from_ucs_64, &from_ucs_65, &from_ucs_66, &from_ucs_67,
	&from_ucs_68, &from_ucs_69, &from_ucs_6A, &from_ucs_6B, &from_ucs_6C, &from_ucs_6D, &from_ucs_6E, &from_ucs_6F,
	&from_ucs_70, &from_ucs_71, &from_ucs_72, &from_ucs_73, &from_ucs_74, &from_ucs_75, &from_ucs_76, &from_ucs_77,
	&from_ucs_78, &from_ucs_79, &from_ucs_7A, &from_ucs_7B, &from_ucs_7C, &from_ucs_7D, &from_ucs_7E, &from_ucs_7F,
	&from_ucs_80, &from_ucs_81, &from_ucs_82, &from_ucs_83, &from_ucs_84, &from_ucs_85, &from_ucs_86, &from_ucs_87,
	&from_ucs_88, &from_ucs_89, &from_ucs_8A, &from_ucs_8B, &from_ucs_8C, &from_ucs_8D, &from_ucs_8E, &from_ucs_8F,
	&from_ucs_90, &from_ucs_91, &from_ucs_92, &from_ucs_93, &from_ucs_94, &from_ucs_95, &from_ucs_96, &from_ucs_97,
	&from_ucs_98, &from_ucs_99, &from_ucs_9A, &from_ucs_9B, &from_ucs_9C, &from_ucs_9D, &from_ucs_9E, &from_ucs_9F,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	&from_ucs_F8, NULL, NULL, NULL, NULL, NULL, &from_ucs_FE, &from_ucs_FF
} };

#define NBITS 16

static ucs2_t convert_from_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_16bit((const iconv_ccs_convtable *)&from_ucs, ch);
}

static ucs2_t convert_to_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_16bit((const iconv_ccs_convtable *)&to_ucs, ch);
}

static const char * const names[] = {
	"mac-japan", NULL
};

static const struct iconv_ccs_desc iconv_ccs_desc = {
	names, NBITS,
	(const iconv_ccs_convtable *)&from_ucs,
	(const iconv_ccs_convtable *)&to_ucs,
	convert_from_ucs, convert_to_ucs,
};

struct iconv_module_desc iconv_module = {
	ICMOD_UC_CCS,
	apr_iconv_mod_noevent,
	NULL,
	&iconv_ccs_desc
};
