/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aws.ivy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.springframework.aws.ivy.S3RepositoryException;
import org.springframework.aws.ivy.S3Resource;
import org.springframework.aws.ivy.S3Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Repository
extends AbstractRepository {
    private String accessKey;
    private String secretKey;
    private S3Service service;
    private Map<String, S3Resource> resourceCache = new HashMap<String, S3Resource>();

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void get(String source, File destination) throws IOException {
        Resource resource = this.getResource(source);
        try {
            try {
                this.fireTransferInitiated(resource, 5);
                RepositoryCopyProgressListener progressListener = new RepositoryCopyProgressListener((AbstractRepository)this);
                progressListener.setTotalLength(Long.valueOf(resource.getContentLength()));
                FileUtil.copy((InputStream)resource.openStream(), (OutputStream)new FileOutputStream(destination), (CopyProgressListener)progressListener);
            }
            catch (IOException e) {
                this.fireTransferError(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.fireTransferError(e);
                throw e;
            }
        }
        finally {
            this.fireTransferCompleted(resource.getContentLength());
        }
    }

    public Resource getResource(String source) throws IOException {
        if (!this.resourceCache.containsKey(source)) {
            this.resourceCache.put(source, new S3Resource(this.getService(), source));
        }
        return this.resourceCache.get(source);
    }

    public List<String> list(String parent) throws IOException {
        S3Bucket bucket = S3Utils.getBucket(parent);
        String key = S3Utils.getKey(parent);
        try {
            S3Object[] objects = this.getService().listObjects(bucket, key, "");
            ArrayList<String> keys = new ArrayList<String>(objects.length);
            S3Object[] s3ObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                S3Object object = s3ObjectArray[n2];
                keys.add(object.getKey());
                ++n2;
            }
            return keys;
        }
        catch (S3ServiceException e) {
            throw new S3RepositoryException(e);
        }
    }

    protected void put(File source, String destination, boolean overwrite) throws IOException {
        S3Bucket bucket = S3Utils.getBucket(destination);
        String key = S3Utils.getKey(destination);
        this.buildDestinationPath(bucket, this.getDestinationPath(key));
        S3Object object = new S3Object(bucket, key);
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setDataInputFile(source);
        object.setContentLength(source.length());
        try {
            this.getService().putObject(bucket, object);
        }
        catch (S3ServiceException e) {
            throw new S3RepositoryException(e);
        }
    }

    private S3Service getService() {
        if (this.service == null) {
            try {
                this.service = new RestS3Service(this.getCredentials());
            }
            catch (S3ServiceException e) {
                throw new S3RepositoryException(e);
            }
        }
        return this.service;
    }

    private AWSCredentials getCredentials() {
        if (this.accessKey.length() > 0 && this.secretKey.length() > 0) {
            return new AWSCredentials(this.accessKey, this.secretKey);
        }
        return null;
    }

    private void buildDestinationPath(S3Bucket bucket, String destination) {
        S3Object object = new S3Object(bucket, String.valueOf(destination) + "/");
        object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        object.setContentLength(0L);
        try {
            this.getService().putObject(bucket, object);
        }
        catch (S3ServiceException e) {
            throw new S3RepositoryException(e);
        }
        int index = destination.lastIndexOf(47);
        if (index != -1) {
            this.buildDestinationPath(bucket, destination.substring(0, index));
        }
    }

    private String getDestinationPath(String destination) {
        return destination.substring(0, destination.lastIndexOf(47));
    }
}

