/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.protocols;

import java.util.Collections;
import java.util.List;

public class Input {
    private final List<String> included;
    private final List<String> excluded;
    private final String packageWithoutWildCards;
    private final boolean recursive;
    private final String packageDirName;
    private final String packageName;

    private Input(Builder builder) {
        this.included = Collections.unmodifiableList(builder.included);
        this.excluded = Collections.unmodifiableList(builder.excluded);
        this.packageWithoutWildCards = builder.packageWithoutWildCards;
        this.recursive = builder.recursive;
        this.packageName = builder.packageName;
        this.packageDirName = builder.packageDirName;
    }

    public List<String> getIncluded() {
        return this.included;
    }

    public List<String> getExcluded() {
        return this.excluded;
    }

    public String getPackageWithoutWildCards() {
        return this.packageWithoutWildCards;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public String getPackageDirName() {
        return this.packageDirName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static final class Builder {
        private List<String> included;
        private List<String> excluded;
        private String packageWithoutWildCards;
        private boolean recursive;
        private String packageDirName;
        private String packageName;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder include(List<String> val) {
            this.included = val;
            return this;
        }

        public Builder exclude(List<String> val) {
            this.excluded = val;
            return this;
        }

        public Builder forPackageWithoutWildCards(String val) {
            this.packageWithoutWildCards = val;
            return this;
        }

        public Builder withRecursive(boolean val) {
            this.recursive = val;
            return this;
        }

        public Builder forPackageDirectory(String val) {
            this.packageDirName = val;
            return this;
        }

        public Builder withPackageName(String val) {
            this.packageName = val;
            return this;
        }

        public Input build() {
            return new Input(this);
        }
    }
}

