/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.IntConsumer;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.NodeUpdateComparator;
import org.basex.query.up.NodeUpdates;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.up.primitives.db.Put;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.NodeType;
import org.basex.util.Strings;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;

final class DataUpdates {
    private final Data data;
    private final boolean writeback;
    private final IntObjectMap<NodeUpdates> nodeUpdates = new IntObjectMap();
    private final List<DBUpdate> dbUpdates = new LinkedList<DBUpdate>();
    private final IntObjectMap<Put> puts = new IntObjectMap();
    private IntList nodes = new IntList(0L);
    private AtomicUpdateCache auc;
    private int size;

    DataUpdates(Data data, QueryContext qc) {
        this.data = data;
        this.writeback = qc.context.options.get(MainOptions.WRITEBACK);
    }

    void add(DataUpdate up, MemData tmp) throws QueryException {
        if (up instanceof NodeUpdate) {
            for (NodeUpdate nodeUp : ((NodeUpdate)up).substitute(tmp)) {
                this.nodeUpdates.computeIfAbsent(nodeUp.pre, NodeUpdates::new).add(nodeUp);
            }
        } else if (up instanceof Put) {
            Put p = (Put)up;
            int id = p.id;
            Put old = this.puts.get(id);
            if (old == null) {
                this.puts.put(id, p);
            } else {
                old.merge(p);
            }
        } else {
            DBUpdate dbUp = (DBUpdate)up;
            for (DBUpdate o : this.dbUpdates) {
                if (o.type != dbUp.type) continue;
                o.merge(dbUp);
                return;
            }
            this.dbUpdates.add(dbUp);
        }
    }

    void prepare(MemData memData, QueryContext qc) throws QueryException {
        int pre;
        int i;
        for (DBUpdate update : this.dbUpdates) {
            update.prepare();
        }
        int sz = this.nodeUpdates.size();
        this.nodes = new IntList(sz);
        for (i = 1; i <= sz; ++i) {
            this.nodes.add(this.nodeUpdates.key(i));
        }
        this.nodes.sort();
        for (i = 0; i < sz; ++i) {
            NodeUpdates updates = this.nodeUpdates.get(this.nodes.get(i));
            for (NodeUpdate update : updates.updates) {
                update.prepare(memData, qc);
            }
        }
        int p = this.nodes.size() - 1;
        int par = -1;
        while (p >= 0 && (par != this.nodes.get(p) || --p >= 0) && (pre = this.nodes.get(p)) != -1) {
            int k = this.data.kind(pre);
            if (k == 3) {
                par = this.data.parent(pre, 3);
                IntList il = new IntList();
                while (p >= 0 && (pre = this.nodes.get(p)) > par) {
                    il.add(pre);
                    --p;
                }
                if (par != -1) {
                    il.add(par);
                }
                this.checkNames(il.finish());
                continue;
            }
            if (k == 1) {
                this.checkNames(pre);
            }
            --p;
        }
        this.auc = this.createAtomicUpdates(this.preparePrimitives());
    }

    Data data() {
        return this.data;
    }

    void apply(QueryContext qc) throws QueryException {
        Collections.sort(this.dbUpdates);
        this.applyDbUpdates(true);
        this.auc.execute(true);
        this.auc = null;
        this.applyDbUpdates(false);
        for (Put put : this.puts.values()) {
            put.apply();
        }
        try {
            Optimize.finish(this.data);
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(null, ex);
        }
        String original = this.data.meta.original;
        if (!original.isEmpty() && !Strings.startsWith(original, '~') && this.data.inMemory()) {
            if (this.writeback) {
                try {
                    Export.export(this.data, original, qc.context.options, null);
                }
                catch (IOException ex) {
                    throw QueryError.UPDBERROR_X.get(null, ex);
                }
            } else {
                qc.trace("", () -> original + ": Updates are not written back.");
            }
        }
    }

    private void applyDbUpdates(boolean before) throws QueryException {
        int pos = UpdateType._NODE_UPDATES_.ordinal();
        ListIterator<DBUpdate> iter = this.dbUpdates.listIterator();
        while (iter.hasNext()) {
            DBUpdate up = iter.next();
            int ord = up.type.ordinal();
            if (!(before ? ord < pos : ord > pos)) continue;
            up.apply();
            iter.remove();
        }
    }

    private List<NodeUpdate> preparePrimitives() {
        ArrayList<NodeUpdate> upd = new ArrayList<NodeUpdate>();
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            int pre = this.nodes.get(i);
            for (NodeUpdate up : this.nodeUpdates.get(pre).finish()) {
                upd.add(up);
                this.size += up.size();
            }
        }
        this.nodes = null;
        for (DBUpdate up : this.dbUpdates) {
            this.size += up.size();
        }
        upd.sort(new NodeUpdateComparator());
        return upd;
    }

    private AtomicUpdateCache createAtomicUpdates(List<NodeUpdate> l) {
        AtomicUpdateCache ac = new AtomicUpdateCache(this.data);
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            NodeUpdate u = l.get(i);
            u.addAtomics(ac);
            l.set(i, null);
        }
        return ac;
    }

    int size() {
        return this.size;
    }

    private void checkNames(int ... pres) throws QueryException {
        NamePool names = new NamePool();
        for (int pre : pres) {
            NodeUpdates ups = this.nodeUpdates.get(pre);
            if (ups == null) continue;
            for (NodeUpdate up : ups.updates) {
                up.update(names);
            }
        }
        byte[][] ns = names.nsOK();
        if (ns != null) {
            throw QueryError.UPNSCONFL2_X_X.get(null, ns[0], ns[1]);
        }
        IntSet set = new IntSet();
        IntConsumer addAttribute = p -> {
            byte[][] qname = this.data.qname(p, 3);
            names.add(new QNm(qname[0], qname[1]), NodeType.ATTRIBUTE);
        };
        for (int pre : pres) {
            if (this.data.kind(pre) == 3) {
                addAttribute.accept(pre);
                set.add(pre);
                continue;
            }
            int ps = pre + this.data.attSize(pre, 1);
            for (int p2 = pre + 1; p2 < ps; ++p2) {
                if (set.contains(p2)) continue;
                addAttribute.accept(p2);
            }
        }
        QNm dup = names.duplicate();
        if (dup != null) {
            throw QueryError.UPATTDUPL_X.get(null, dup);
        }
    }
}

