/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.fn.NumericFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class FnSum
extends NumericFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.sum(false, qc);
        return item != null ? item : (this.defined(1) ? this.arg(1).atomItem(qc, this.info) : Itr.ZERO);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.opt(false);
        if (expr != null) {
            return expr;
        }
        Expr values = this.arg(0);
        Expr zero = this.arg(1);
        SeqType st = values.seqType();
        SeqType stZero = zero.seqType();
        if (zero == Empty.UNDEFINED) {
            SeqType ost;
            if (st.zero()) {
                return cc.voidAndReturn(values, Itr.ZERO, this.info);
            }
            if (!st.mayBeArray() && (ost = FnSum.optType(values, false)) != null) {
                this.exprType.assign(ost);
            }
        } else if (st.zero()) {
            if (zero == Empty.VALUE || stZero.instanceOf(SeqType.ANY_ATOMIC_TYPE_ZO)) {
                return cc.voidAndReturn(values, zero, this.info);
            }
        } else if (!st.mayBeArray() && !stZero.mayBeArray()) {
            if (st.oneOrMore()) {
                return cc.function(Function.SUM, this.info, values);
            }
            SeqType ost = FnSum.optType(values, false);
            SeqType zst = FnSum.optType(zero, false);
            AtomType type = ost != null && zst != null ? ost.type.union(zst.type) : AtomType.ANY_ATOMIC_TYPE;
            Occ occ = stZero.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE;
            this.exprType.assign(type, occ);
        }
        return this;
    }

    final Expr opt(boolean avg) throws QueryException {
        Path path;
        ArrayList<Stats> list;
        Expr values = this.arg(0);
        if (values instanceof RangeSeq) {
            RangeSeq rs = (RangeSeq)values;
            return this.range(rs, avg);
        }
        if (values instanceof SingletonSeq) {
            SingletonSeq ss = (SingletonSeq)values;
            if (ss.singleItem()) {
                Item item = ss.itemAt(0L);
                Type type = item.type;
                if (type.isUntyped()) {
                    item = Dbl.get(item.dbl(this.info));
                }
                if (type.isNumber()) {
                    return avg ? item : Calc.MULTIPLY.eval(item, Itr.get(ss.size()), this.info);
                }
            }
        } else if (values instanceof Path && (list = (path = (Path)values).pathStats()) != null) {
            double sum = 0.0;
            long count = 0L;
            for (Stats stats : list) {
                if (!StatsType.isNumeric(stats.type) || !StatsType.isCategory(stats.type)) {
                    return this;
                }
                for (byte[] value : stats.values) {
                    if (value.length == 0) {
                        return null;
                    }
                    long c = stats.values.get(value);
                    sum += (double)c * Token.toDouble(value);
                    count += c;
                }
            }
            return Dbl.get(avg ? sum / (double)count : sum);
        }
        return null;
    }

    @Override
    protected final void simplifyArgs(CompileContext cc) throws QueryException {
        super.simplifyArgs(cc);
        if (this.arg((int)0).seqType().type.isNumberOrUntyped()) {
            this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.NUMBER, cc));
        }
    }

    private Item range(Value value, boolean avg) throws QueryException {
        long l;
        BigInteger be;
        if (value.isEmpty()) {
            return null;
        }
        long min = value.itemAt(0L).itr(this.info);
        long max = value.itemAt(value.size() - 1L).itr(this.info);
        if (avg) {
            BigDecimal bs = BigDecimal.valueOf(min);
            BigDecimal be2 = BigDecimal.valueOf(max);
            return Dec.get(bs.add(be2).divide(Dec.BD_2, MathContext.DECIMAL64));
        }
        if (min > max) {
            long t = max;
            max = min;
            min = t;
        }
        if (max < 3037000500L) {
            return Itr.get((min + max) * (max - min + 1L) / 2L);
        }
        BigInteger bs = BigInteger.valueOf(min);
        BigInteger bi = bs.add(be = BigInteger.valueOf(max)).multiply(be.subtract(bs).add(BigInteger.ONE)).divide(BigInteger.valueOf(2L));
        if (bi.equals(BigInteger.valueOf(l = bi.longValue()))) {
            return Itr.get(l);
        }
        throw QueryError.RANGE_X.get(this.info, bi);
    }

    final Item sum(boolean avg, QueryContext qc) throws QueryException {
        Item it;
        boolean ymd;
        Expr values = this.arg(0);
        if (values instanceof Range) {
            return this.range(values.value(qc), avg);
        }
        Iter iter = values.atomIter(qc, this.info);
        Item item = iter.next();
        if (item == null) {
            return null;
        }
        Item result = item.type.isUntyped() ? Dbl.get(item.dbl(this.info)) : item;
        Type type = result.type;
        boolean num = result instanceof ANum;
        boolean dtd = type == AtomType.DAY_TIME_DURATION;
        boolean bl = ymd = type == AtomType.YEAR_MONTH_DURATION;
        if (!(num || dtd || ymd)) {
            throw QueryError.NUMDUR_X_X.get(this.info, type, result);
        }
        int c = 1;
        while ((it = qc.next(iter)) != null) {
            Type tp = it.type;
            AtomType t = null;
            if (tp.isNumberOrUntyped()) {
                if (!num) {
                    t = AtomType.DURATION;
                }
            } else if (num) {
                t = AtomType.NUMERIC;
            } else if (dtd && tp != AtomType.DAY_TIME_DURATION || ymd && tp != AtomType.YEAR_MONTH_DURATION) {
                t = AtomType.DURATION;
            }
            if (t != null) {
                throw QueryError.ARGTYPE_X_X_X.get(this.info, t, tp, it);
            }
            result = Calc.ADD.eval(result, it, this.info);
            ++c;
        }
        return avg ? Calc.DIVIDE.eval(result, Itr.get(c), this.info) : result;
    }
}

