/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ViewUtil {
    public static final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final boolean useDefaultBackground = Boolean.getBoolean("nb.explorerview.aqua.defaultbackground");
    private static final RequestProcessor RP = new RequestProcessor("Explorer Views");

    private ViewUtil() {
    }

    static RequestProcessor uiProcessor() {
        return RP;
    }

    static void adjustBackground(JComponent jComponent) {
        if (!isAquaLaF || useDefaultBackground) {
            return;
        }
        if (!ViewUtil.isInTabbedContainer(jComponent)) {
            return;
        }
        Color color = jComponent.getBackground();
        if (color instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private static boolean isInTabbedContainer(Component component) {
        for (Container container = component.getParent(); null != container; container = container.getParent()) {
            if (!(container instanceof JComponent) || !"TabbedContainerUI".equals(((JComponent)container).getUIClassID())) continue;
            return true;
        }
        return false;
    }

    static void nodeRename(final Node node, final String string) {
        if (node.getName().equals(string)) {
            return;
        }
        if (EventQueue.isDispatchThread() && Boolean.TRUE.equals(node.getValue("slowRename"))) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ViewUtil.nodeRename(node, string);
                }
            });
            return;
        }
        try {
            node.setName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl;
            boolean bl2 = bl = Exceptions.findLocalizedMessage((Throwable)illegalArgumentException) == null;
            if (bl) {
                String string2 = NbBundle.getMessage(TreeViewCellEditor.class, (String)"RenameFailed", (Object)node.getName(), (Object)string);
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string2);
            }
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
    }
}

