/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.Iterator;
import java.util.List;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class TestNamesMatcher {
    private final List<XmlSuite> cloneSuites = Lists.newArrayList();
    private final List<String> matchedTestNames = Lists.newArrayList();
    private final List<XmlTest> matchedTests = Lists.newArrayList();
    private final List<String> testNames;

    public TestNamesMatcher(XmlSuite xmlSuite, List<String> list) {
        this.testNames = list;
        this.cloneIfContainsTestsWithNamesMatchingAny(xmlSuite, this.testNames);
    }

    private void cloneIfContainsTestsWithNamesMatchingAny(XmlSuite xmlSuite, List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new TestNGException("Please provide a valid list of names to check.");
        }
        this.addIfNotNull(this.cloneIfSuiteContainTestsWithNamesMatchingAny(xmlSuite));
        for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
            this.cloneIfContainsTestsWithNamesMatchingAny(xmlSuite2, list);
        }
    }

    public List<XmlSuite> getSuitesMatchingTestNames() {
        return this.cloneSuites;
    }

    public List<String> getMissMatchedTestNames() {
        List<String> list = Lists.newArrayList();
        list.addAll(this.testNames);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.matchedTestNames.contains(string)) continue;
            iterator.remove();
        }
        return list;
    }

    public List<XmlTest> getMatchedTests() {
        return this.matchedTests;
    }

    private void addIfNotNull(XmlSuite xmlSuite) {
        if (xmlSuite != null) {
            this.cloneSuites.add(xmlSuite);
        }
    }

    private XmlSuite cloneIfSuiteContainTestsWithNamesMatchingAny(XmlSuite xmlSuite) {
        List<XmlTest> list = Lists.newLinkedList();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            if (!xmlTest.nameMatchesAny(this.testNames)) continue;
            list.add(xmlTest);
            this.matchedTestNames.add(xmlTest.getName());
            this.matchedTests.add(xmlTest);
        }
        if (list.isEmpty()) {
            return null;
        }
        return TestNamesMatcher.cleanClone(xmlSuite, list);
    }

    private static XmlSuite cleanClone(XmlSuite xmlSuite, List<XmlTest> list) {
        XmlSuite xmlSuite2 = (XmlSuite)xmlSuite.clone();
        xmlSuite2.getTests().clear();
        xmlSuite2.getTests().addAll(list);
        return xmlSuite2;
    }
}

