/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ComboFieldEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String IGNORE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.ignore";
    public static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    public static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    public static final String REUSE_EDITOR = "org.eclipse.search.reuseEditor";
    public static final String DEFAULT_PERSPECTIVE = "org.eclipse.search.defaultPerspective";
    private static final String NO_DEFAULT_PERSPECTIVE = "org.eclipse.search.defaultPerspective.none";
    public static final String BRING_VIEW_TO_FRONT = "org.eclipse.search.bringToFront";
    public static final String LIMIT_TABLE_TO = "org.eclipse.search.limitTableTo";
    public static final String LIMIT_TABLE = "org.eclipse.search.limitTable";
    private ColorFieldEditor fColorEditor;
    private BooleanFieldEditor fEmphasizedCheckbox;
    private BooleanFieldEditor fIgnorePotentialMatchesCheckbox;
    private Button fLimitTable;
    private Text fLimitTableValue;

    public SearchPreferencePage() {
        super(1);
        this.setPreferenceStore(SearchPlugin.getDefault().getPreferenceStore());
    }

    public static void initDefaults(IPreferenceStore store) {
        RGB gray = new RGB(85, 85, 85);
        store.setDefault(EMPHASIZE_POTENTIAL_MATCHES, true);
        store.setDefault(IGNORE_POTENTIAL_MATCHES, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)POTENTIAL_MATCH_FG_COLOR, (RGB)gray);
        store.setDefault(REUSE_EDITOR, false);
        store.setDefault(BRING_VIEW_TO_FRONT, true);
        store.setDefault(DEFAULT_PERSPECTIVE, NO_DEFAULT_PERSPECTIVE);
        store.setDefault(LIMIT_TABLE_TO, 200);
        store.setDefault(LIMIT_TABLE, false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.search.search_preference_page_context");
    }

    protected void createFieldEditors() {
        BooleanFieldEditor boolEditor = new BooleanFieldEditor(REUSE_EDITOR, SearchMessages.getString("SearchPreferencePage.reuseEditor"), this.getFieldEditorParent());
        this.addField((FieldEditor)boolEditor);
        boolEditor = new BooleanFieldEditor(BRING_VIEW_TO_FRONT, SearchMessages.getString("SearchPreferencePage.bringToFront"), this.getFieldEditorParent());
        this.addField((FieldEditor)boolEditor);
        this.fIgnorePotentialMatchesCheckbox = new BooleanFieldEditor(IGNORE_POTENTIAL_MATCHES, SearchMessages.getString("SearchPreferencePage.ignorePotentialMatches"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fIgnorePotentialMatchesCheckbox);
        this.fEmphasizedCheckbox = new BooleanFieldEditor(EMPHASIZE_POTENTIAL_MATCHES, SearchMessages.getString("SearchPreferencePage.emphasizePotentialMatches"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fEmphasizedCheckbox);
        this.fColorEditor = new ColorFieldEditor(POTENTIAL_MATCH_FG_COLOR, SearchMessages.getString("SearchPreferencePage.potentialMatchFgColor"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fColorEditor);
        this.createTableLimit();
        this.fEmphasizedCheckbox.setEnabled(!SearchPreferencePage.arePotentialMatchesIgnored(), this.getFieldEditorParent());
        this.fColorEditor.setEnabled(!SearchPreferencePage.arePotentialMatchesIgnored() && SearchPreferencePage.arePotentialMatchesEmphasized(), this.getFieldEditorParent());
        SearchPreferencePage.handleDeletedPerspectives();
        String[][] perspectiveNamesAndIds = this.getPerspectiveNamesAndIds();
        ComboFieldEditor comboEditor = new ComboFieldEditor(DEFAULT_PERSPECTIVE, SearchMessages.getString("SearchPreferencePage.defaultPerspective"), perspectiveNamesAndIds, this.getFieldEditorParent());
        this.addField(comboEditor);
    }

    private void createTableLimit() {
        Composite parent = new Composite(this.getFieldEditorParent(), 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        parent.setLayoutData((Object)gd);
        this.fLimitTable = new Button(parent, 32);
        this.fLimitTable.setText(SearchMessages.getString("SearchPreferencePage.limit.label"));
        this.fLimitTable.setLayoutData((Object)new GridData());
        this.fLimitTableValue = new Text(parent, 2048);
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(6);
        this.fLimitTableValue.setLayoutData((Object)gd);
        this.applyDialogFont(parent);
        this.fLimitTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPreferencePage.this.updateLimitValueEnablement();
            }
        });
        this.fLimitTableValue.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SearchPreferencePage.this.validateText();
            }
        });
        this.initLimit();
    }

    protected void validateText() {
        String text = this.fLimitTableValue.getText();
        int value = -1;
        try {
            value = Integer.valueOf(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.fLimitTable.getSelection() && value <= 0) {
            this.setErrorMessage(SearchMessages.getString("SearchPreferencePage.limit.error"));
        } else {
            this.setErrorMessage(null);
        }
    }

    public void setVisible(boolean state) {
        SearchPreferencePage.handleDeletedPerspectives();
        super.setVisible(state);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFieldEnablement();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore != null) {
            boolean limit = preferenceStore.getDefaultBoolean(LIMIT_TABLE);
            int count = preferenceStore.getDefaultInt(LIMIT_TABLE_TO);
            this.fLimitTable.setSelection(limit);
            this.fLimitTableValue.setText(String.valueOf(count));
        }
        this.updateFieldEnablement();
    }

    private void initLimit() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore != null) {
            boolean limit = preferenceStore.getBoolean(LIMIT_TABLE);
            int count = preferenceStore.getInt(LIMIT_TABLE_TO);
            this.fLimitTable.setSelection(limit);
            this.fLimitTableValue.setText(String.valueOf(count));
        }
        this.updateLimitValueEnablement();
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = SearchPlugin.getDefault().getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.setValue(LIMIT_TABLE, this.fLimitTable.getSelection());
            preferenceStore.setValue(LIMIT_TABLE_TO, Integer.valueOf(this.fLimitTableValue.getText()).intValue());
        }
        return super.performOk();
    }

    private void updateFieldEnablement() {
        boolean arePotentialMatchesIgnored = this.fIgnorePotentialMatchesCheckbox.getBooleanValue();
        this.fEmphasizedCheckbox.setEnabled(!arePotentialMatchesIgnored, this.getFieldEditorParent());
        this.fColorEditor.setEnabled(!arePotentialMatchesIgnored && this.fEmphasizedCheckbox.getBooleanValue(), this.getFieldEditorParent());
        this.updateLimitValueEnablement();
        this.validateText();
    }

    private void updateLimitValueEnablement() {
        this.fLimitTableValue.setEnabled(this.fLimitTable.getSelection());
    }

    private String[][] getPerspectiveNamesAndIds() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectiveDescriptors = registry.getPerspectives();
        Arrays.sort(perspectiveDescriptors, new PerspectiveDescriptorComparator());
        String[][] table = new String[perspectiveDescriptors.length + 1][2];
        table[0][0] = SearchMessages.getString("SearchPreferencePage.defaultPerspective.none");
        table[0][1] = NO_DEFAULT_PERSPECTIVE;
        for (int i = 0; i < perspectiveDescriptors.length; ++i) {
            table[i + 1][0] = perspectiveDescriptors[i].getLabel();
            table[i + 1][1] = perspectiveDescriptors[i].getId();
        }
        return table;
    }

    private static void handleDeletedPerspectives() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        String id = store.getString(DEFAULT_PERSPECTIVE);
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue(DEFAULT_PERSPECTIVE, NO_DEFAULT_PERSPECTIVE);
        }
    }

    public static String getDefaultPerspectiveId() {
        SearchPreferencePage.handleDeletedPerspectives();
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        String id = store.getString(DEFAULT_PERSPECTIVE);
        if (id == null || id.length() == 0 || id.equals(NO_DEFAULT_PERSPECTIVE)) {
            return null;
        }
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue(DEFAULT_PERSPECTIVE, id);
            return null;
        }
        return id;
    }

    public static int getTableLimit() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getInt(LIMIT_TABLE_TO);
    }

    public static boolean isTableLimited() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(LIMIT_TABLE);
    }

    public static boolean isEditorReused() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(REUSE_EDITOR);
    }

    public static boolean isViewBroughtToFront() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(BRING_VIEW_TO_FRONT);
    }

    public static boolean arePotentialMatchesIgnored() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(IGNORE_POTENTIAL_MATCHES);
    }

    public static boolean arePotentialMatchesEmphasized() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    public static RGB getPotentialMatchForegroundColor() {
        IPreferenceStore store = SearchPlugin.getDefault().getPreferenceStore();
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)POTENTIAL_MATCH_FG_COLOR);
    }

    private static class PerspectiveDescriptorComparator
    implements Comparator {
        private PerspectiveDescriptorComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IPerspectiveDescriptor && o2 instanceof IPerspectiveDescriptor) {
                String id1 = ((IPerspectiveDescriptor)o1).getLabel();
                String id2 = ((IPerspectiveDescriptor)o2).getLabel();
                return Collator.getInstance().compare(id1, id2);
            }
            return 0;
        }
    }
}

