/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;

public class GenerateDiffFileOperation
implements IRunnableWithProgress {
    private File outputFile;
    private IResource resource;
    private Shell shell;
    private Command.LocalOption[] options;
    private boolean toClipboard;

    GenerateDiffFileOperation(IResource resource, File file, boolean toClipboard, Command.LocalOption[] options, Shell shell) {
        this.resource = resource;
        this.outputFile = file;
        this.shell = shell;
        this.options = options;
        this.toClipboard = toClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("", 500);
            monitor.setTaskName(Policy.bind("GenerateCVSDiff.working"));
            OutputStream os = this.toClipboard ? new ByteArrayOutputStream() : new FileOutputStream(this.outputFile);
            try {
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)CVSProviderPlugin.getTypeId());
                provider.diff(this.resource, this.options, new PrintStream(os), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            finally {
                os.close();
            }
            boolean emptyDiff = false;
            if (this.toClipboard) {
                final ByteArrayOutputStream baos = (ByteArrayOutputStream)os;
                if (baos.size() == 0) {
                    emptyDiff = true;
                } else {
                    this.shell.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            TextTransfer plainTextTransfer = TextTransfer.getInstance();
                            Clipboard clipboard = new Clipboard(GenerateDiffFileOperation.this.shell.getDisplay());
                            clipboard.setContents((Object[])new String[]{baos.toString()}, new Transfer[]{plainTextTransfer});
                            clipboard.dispose();
                        }
                    });
                }
            } else if (this.outputFile.length() == 0L) {
                emptyDiff = true;
                this.outputFile.delete();
            }
            if (emptyDiff) {
                CVSUIPlugin.openDialog(this.shell, new CVSUIPlugin.IOpenableInShell(){

                    public void open(Shell shell) {
                        MessageDialog.openInformation((Shell)shell, (String)Policy.bind("GenerateCVSDiff.noDiffsFoundTitle"), (String)Policy.bind("GenerateCVSDiff.noDiffsFoundMsg"));
                    }
                }, 1);
            }
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }
}

