/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.RemoteFileEditorInput;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenLogEntryAction
extends CVSAction {
    static /* synthetic */ Class class$org$eclipse$team$internal$ccvs$core$ILogEntry;

    protected ILogEntry[] getSelectedLogEntries() {
        ArrayList<Object> entries = null;
        if (!this.selection.isEmpty()) {
            entries = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                IAdaptable a;
                Object adapter;
                Object next = elements.next();
                if (next instanceof ILogEntry) {
                    entries.add((ILogEntry)next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(class$org$eclipse$team$internal$ccvs$core$ILogEntry == null ? OpenLogEntryAction.class$("org.eclipse.team.internal.ccvs.core.ILogEntry") : class$org$eclipse$team$internal$ccvs$core$ILogEntry)) instanceof ILogEntry)) continue;
                entries.add(adapter);
            }
        }
        if (entries != null && !entries.isEmpty()) {
            ILogEntry[] result = new ILogEntry[entries.size()];
            entries.toArray(result);
            return result;
        }
        return new ILogEntry[0];
    }

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IWorkbench workbench = CVSUIPlugin.getPlugin().getWorkbench();
                IEditorRegistry registry = workbench.getEditorRegistry();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                ILogEntry[] entries = OpenLogEntryAction.this.getSelectedLogEntries();
                for (int i = 0; i < entries.length; ++i) {
                    if (entries[i].isDeletion()) {
                        MessageDialog.openError((Shell)OpenLogEntryAction.this.getShell(), (String)Policy.bind("OpenLogEntryAction.deletedTitle"), (String)Policy.bind("OpenLogEntryAction.deleted"));
                        continue;
                    }
                    ICVSRemoteFile file = entries[i].getRemoteFile();
                    String filename = file.getName();
                    IEditorDescriptor descriptor = registry.getDefaultEditor(filename);
                    String id = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
                    try {
                        try {
                            page.openEditor((IEditorInput)new RemoteFileEditorInput(file, monitor), id);
                        }
                        catch (PartInitException e) {
                            if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                                throw e;
                            }
                            page.openEditor((IEditorInput)new RemoteFileEditorInput(file, monitor), "org.eclipse.ui.DefaultTextEditor");
                        }
                        continue;
                    }
                    catch (PartInitException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ILogEntry[] entries = this.getSelectedLogEntries();
        return entries.length != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

