/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.extension.NewSchemaFileMainPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewSchemaFileWizard
extends Wizard
implements INewWizard {
    private NewSchemaFileMainPage mainPage;
    private IContainer container;
    private IPluginExtensionPoint point;
    private boolean isPluginIdFinal;
    public static final String KEY_WTITLE = "NewSchemaFileWizard.wtitle";

    public NewSchemaFileWizard() {
        this(null, null, false);
    }

    public NewSchemaFileWizard(IProject project, IPluginExtensionPoint point, boolean isFinalPluginId) {
        this.initialize();
        this.container = project;
        this.point = point;
        this.isPluginIdFinal = isFinalPluginId;
    }

    public void initialize() {
        this.setDialogSettings(this.getSettingsSection());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_EXT_POINT_SCHEMA_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new NewSchemaFileMainPage(this.container, this.point, this.isPluginIdFinal);
        this.addPage((IWizardPage)this.mainPage);
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings root = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection("newExtensionPointWizard");
        if (section == null) {
            section = root.addNewSection("newExtensionPointWizard");
        }
        return section;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IJavaProject) {
            this.container = ((IJavaProject)sel).getProject();
        } else if (sel instanceof IContainer) {
            this.container = (IContainer)sel;
        }
    }

    public boolean performFinish() {
        return this.mainPage.finish();
    }
}

