/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInWorkspaceAction
extends Action {
    private String viewId;
    private ISelectionProvider provider;

    public ShowInWorkspaceAction(String viewId, ISelectionProvider provider) {
        this.viewId = viewId;
        this.provider = provider;
    }

    protected ShowInWorkspaceAction(String text) {
        super(text);
    }

    public boolean isApplicable() {
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ModelEntry)) {
                return false;
            }
            ModelEntry entry = (ModelEntry)obj;
            IPluginModelBase model = entry.getActiveModel();
            if (model.getUnderlyingResource() != null) continue;
            return false;
        }
        return true;
    }

    public void run() {
        List v = this.collectResources();
        IWorkbenchPage page = PDEPlugin.getActivePage();
        try {
            IViewPart view = page.showView(this.viewId);
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection(v);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private List collectResources() {
        ArrayList<IResource> list = new ArrayList<IResource>();
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (selection.isEmpty()) {
            return list;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            ModelEntry entry;
            IPluginModelBase model;
            IResource resource;
            Object obj = iter.next();
            if (!(obj instanceof ModelEntry) || (resource = (model = (entry = (ModelEntry)obj).getActiveModel()).getUnderlyingResource()) == null) continue;
            list.add(resource);
        }
        return list;
    }
}

