/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.TextUtil;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InfoSection
extends PDESection {
    private static final String KEY_APPLY = "Actions.apply.flabel";
    private static final String KEY_RESET = "Actions.reset.flabel";
    private static final String SECTION_DESC = "FeatureEditor.InfoSection.desc";
    private static final String KEY_URL = "FeatureEditor.InfoSection.url";
    private static final String KEY_TEXT = "FeatureEditor.InfoSection.text";
    private static final String KEY_INFO_DESCRIPTION = "FeatureEditor.info.description";
    private static final String KEY_INFO_LICENSE = "FeatureEditor.info.license";
    private static final String KEY_INFO_COPYRIGHT = "FeatureEditor.info.copyright";
    private IDocument document;
    private IDocumentPartitioner partitioner;
    private SourceViewerConfiguration sourceConfiguration;
    private SourceViewer sourceViewer;
    private CTabFolder tabFolder;
    private Text urlText;
    private Button applyButton;
    private Button resetButton;
    private Object element;
    private int elementIndex;
    private boolean ignoreChange;

    public InfoSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 4224, false);
        String description = PDEPlugin.getResourceString(SECTION_DESC);
        this.getSection().setDescription(description);
        this.sourceConfiguration = new XMLConfiguration(colorManager);
        this.document = new Document();
        this.partitioner = new DefaultPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.partitioner.connect(this.document);
        this.document.setDocumentPartitioner(this.partitioner);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.resetButton.setEnabled(false);
        }
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 5;
        layout.verticalSpacing = 8;
        container.setLayout((Layout)layout);
        toolkit.createLabel(container, null);
        this.tabFolder = new CTabFolder(container, 0x800080);
        toolkit.adapt((Control)this.tabFolder, true, true);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.tabFolder.setLayoutData((Object)gd);
        gd.heightHint = 2;
        toolkit.getColors().initializeSectionToolBarColors();
        Color selectedColor1 = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color selectedColor2 = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_GBG");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor1, selectedColor2, toolkit.getColors().getBackground()}, new int[]{50, 100}, true);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.updateTabSelection();
            }
        });
        Label label = toolkit.createLabel(container, PDEPlugin.getResourceString(KEY_URL));
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.urlText = toolkit.createText(container, null, 4);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfoSection.this.infoModified();
            }
        });
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        toolkit.createLabel(container, null);
        label = toolkit.createLabel(container, PDEPlugin.getResourceString(KEY_TEXT));
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        int styles = 834;
        this.sourceViewer = new SourceViewer(container, null, styles);
        this.sourceViewer.configure(this.sourceConfiguration);
        this.sourceViewer.setDocument(this.document);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InfoSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        gd.widthHint = 50;
        gd.heightHint = 50;
        control.setLayoutData((Object)gd);
        Composite buttonContainer = toolkit.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        this.applyButton.setEnabled(false);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.handleApply();
            }
        });
        this.resetButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        this.resetButton.setEnabled(false);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.handleReset();
            }
        });
        this.createTabs();
        section.setClient((Control)container);
        this.initialize();
        if (this.tabFolder.getItemCount() > 0) {
            this.tabFolder.setSelection(0);
            this.updateTabSelection();
        }
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.sourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.sourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.sourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.sourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.sourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.sourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            int index = info.getIndex();
            if (index != -1) {
                this.tabFolder.setSelection(index);
            }
            this.updateEditorInput(input, false);
            return true;
        }
        return false;
    }

    private void handleApply() {
        this.handleApply(null, this.tabFolder.getSelectionIndex());
    }

    private void handleApply(IFeatureInfo info, int index) {
        String urlName = this.urlText.getText();
        String text = this.document.get();
        this.updateInfoText(info, urlName, text, index);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.updateTabImage(this.tabFolder.getSelection());
    }

    private void updateInfoText(IFeatureInfo targetInfo, String urlText, String text, int index) {
        String url = null;
        if (urlText.length() > 0) {
            url = urlText;
        }
        try {
            IFeatureModel model = (IFeatureModel)this.getPage().getModel();
            IFeature feature = model.getFeature();
            IFeatureInfo info = targetInfo;
            if (info == null) {
                info = feature.getFeatureInfo(index);
            }
            if (targetInfo == null && info == null) {
                info = model.getFactory().createInfo(index);
                feature.setFeatureInfo(info, index);
            }
            info.setURL(url);
            info.setDescription(text);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleReset() {
        this.updateEditorInput(this.element, false);
        this.updateTabImage(this.tabFolder.getSelection());
    }

    public void initialize() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                InfoSection.this.infoModified();
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.urlText.setEditable(featureModel.isEditable());
        this.sourceViewer.getTextWidget().setEditable(featureModel.isEditable());
        featureModel.addModelChangedListener((IModelChangedListener)this);
        this.updateEditorInput(featureModel.getFeature().getFeatureInfo(0), false);
    }

    public void dispose() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        featureModel.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void infoModified() {
        IFeatureModel featureModel = (IFeatureModel)this.getPage().getModel();
        if (!this.ignoreChange && featureModel instanceof IEditable) {
            this.markDirty();
        }
        this.applyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        int index = this.tabFolder.getSelectionIndex();
        IFeatureInfo info = model.getFeature().getFeatureInfo(index);
        this.element = null;
        this.elementIndex = -1;
        this.updateEditorInput(info, false);
        super.refresh();
    }

    private void createTabs() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.addTab(PDEPlugin.getResourceString(KEY_INFO_DESCRIPTION), feature.getFeatureInfo(0));
        this.addTab(PDEPlugin.getResourceString(KEY_INFO_COPYRIGHT), feature.getFeatureInfo(1));
        this.addTab(PDEPlugin.getResourceString(KEY_INFO_LICENSE), feature.getFeatureInfo(2));
    }

    private void addTab(String label, IFeatureInfo info) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(label);
        item.setData((Object)info);
        this.updateTabImage(item);
    }

    private void updateTabImage(CTabItem item) {
        if (item == null) {
            return;
        }
        IFeatureInfo info = (IFeatureInfo)item.getData();
        if (info == null) {
            return;
        }
        item.setImage(PDEPlugin.getDefault().getLabelProvider().getImage(info));
    }

    private void updateTabSelection() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        int index = this.tabFolder.getSelectionIndex();
        IFeatureInfo info = feature.getFeatureInfo(index);
        this.updateEditorInput(info, true);
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
        this.updateSelection(this.sourceViewer.getSelection());
    }

    private void commitPrevious() {
        IFeatureInfo previous = (IFeatureInfo)this.element;
        this.handleApply(previous, this.elementIndex);
    }

    public void updateEditorInput(Object input, boolean commitPrevious) {
        if (this.isDirty() && commitPrevious) {
            this.commitPrevious();
        }
        this.ignoreChange = true;
        String text = "";
        String url = null;
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            text = info.getDescription();
            url = info.getURL();
        }
        text = text == null ? "" : TextUtil.createMultiLine(text, 60, false);
        this.document.set(text);
        if (url == null) {
            this.urlText.setText("");
        } else {
            this.urlText.setText(url.toString());
        }
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.element = input;
        this.elementIndex = this.tabFolder.getSelectionIndex();
        this.ignoreChange = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.sourceViewer.canDoOperation(5);
    }
}

