/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public abstract class AbstractMarkerAnnotationModel
extends AnnotationModel
implements IPersistableAnnotationModel {
    private List fDeletedAnnotations = new ArrayList(2);
    private List fInstantiatedMarkerUpdaters = null;
    private List fMarkerUpdaterSpecifications = null;

    protected abstract IMarker[] retrieveMarkers() throws CoreException;

    protected abstract void deleteMarkers(IMarker[] var1) throws CoreException;

    protected abstract void listenToMarkerChanges(boolean var1);

    protected abstract boolean isAcceptable(IMarker var1);

    protected AbstractMarkerAnnotationModel() {
    }

    protected void addMarkerUpdater(IMarkerUpdater markerUpdater) {
        if (!this.fInstantiatedMarkerUpdaters.contains(markerUpdater)) {
            this.fInstantiatedMarkerUpdaters.add(markerUpdater);
        }
    }

    protected void removeMarkerUpdater(IMarkerUpdater markerUpdater) {
        this.fInstantiatedMarkerUpdaters.remove(markerUpdater);
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new MarkerAnnotation(marker);
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = Platform.getLog((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected Position createPositionFromMarker(IMarker marker) {
        int line;
        int end;
        int start = MarkerUtilities.getCharStart(marker);
        if (start > (end = MarkerUtilities.getCharEnd(marker))) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber(marker)) > 0 && this.fDocument != null) {
            try {
                end = start = this.fDocument.getLineOffset(line - 1);
            }
            catch (BadLocationException x) {
                // empty catch block
            }
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    protected final void addMarkerAnnotation(IMarker marker) {
        Position p;
        if (this.isAcceptable(marker) && (p = this.createPositionFromMarker(marker)) != null) {
            try {
                MarkerAnnotation annotation = this.createMarkerAnnotation(marker);
                if (annotation != null) {
                    this.addAnnotation(annotation, p, false);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void connected() {
        block2: {
            this.listenToMarkerChanges(true);
            try {
                this.catchupWithMarkers();
            }
            catch (CoreException x) {
                if (x.getStatus().getCode() == 368) break block2;
                this.handleCoreException(x, TextEditorMessages.getString("AbstractMarkerAnnotationModel.connected"));
            }
        }
        this.fireModelChanged();
    }

    private void installMarkerUpdaters() {
        this.fMarkerUpdaterSpecifications = new ArrayList(2);
        this.fInstantiatedMarkerUpdaters = new ArrayList(2);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerUpdaters");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            for (int i = 0; i < elements.length; ++i) {
                this.fMarkerUpdaterSpecifications.add(elements[i]);
            }
        }
    }

    private void uninstallMarkerUpdaters() {
        if (this.fInstantiatedMarkerUpdaters != null) {
            this.fInstantiatedMarkerUpdaters.clear();
            this.fInstantiatedMarkerUpdaters = null;
        }
        if (this.fMarkerUpdaterSpecifications != null) {
            this.fMarkerUpdaterSpecifications.clear();
            this.fMarkerUpdaterSpecifications = null;
        }
    }

    protected void disconnected() {
        this.listenToMarkerChanges(false);
        this.uninstallMarkerUpdaters();
    }

    public Position getMarkerPosition(IMarker marker) {
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null) {
            return (Position)this.getAnnotationMap().get((Object)a);
        }
        return null;
    }

    protected void modifyMarkerAnnotation(IMarker marker) {
        Position p;
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null && (p = this.createPositionFromMarker(marker)) != null) {
            a.update();
            this.modifyAnnotationPosition(a, p, false);
        }
    }

    protected void removeAnnotations(List annotations, boolean fireModelChanged, boolean modelInitiated) {
        if (annotations != null && annotations.size() > 0) {
            ArrayList<Annotation> markerAnnotations = new ArrayList<Annotation>();
            Iterator e = annotations.iterator();
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                if (a instanceof MarkerAnnotation) {
                    markerAnnotations.add(a);
                }
                this.removeAnnotation(a, false);
            }
            if (markerAnnotations.size() > 0) {
                if (modelInitiated) {
                    this.listenToMarkerChanges(false);
                    try {
                        IMarker[] m = new IMarker[markerAnnotations.size()];
                        for (int i = 0; i < m.length; ++i) {
                            MarkerAnnotation ma = (MarkerAnnotation)((Object)markerAnnotations.get(i));
                            m[i] = ma.getMarker();
                        }
                        this.deleteMarkers(m);
                    }
                    catch (CoreException x) {
                        this.handleCoreException(x, TextEditorMessages.getString("AbstractMarkerAnnotationModel.removeAnnotations"));
                    }
                    this.listenToMarkerChanges(true);
                } else {
                    this.fDeletedAnnotations.addAll(markerAnnotations);
                }
            }
            if (fireModelChanged) {
                this.fireModelChanged();
            }
        }
    }

    protected final void removeMarkerAnnotation(IMarker marker) {
        MarkerAnnotation a = this.getMarkerAnnotation(marker);
        if (a != null) {
            this.removeAnnotation(a, false);
        }
    }

    private void catchupWithMarkers() throws CoreException {
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            if (!(a instanceof MarkerAnnotation)) continue;
            this.removeAnnotation(a, false);
        }
        IMarker[] markers = this.retrieveMarkers();
        if (markers != null) {
            for (int i = 0; i < markers.length; ++i) {
                this.addMarkerAnnotation(markers[i]);
            }
        }
    }

    public final MarkerAnnotation getMarkerAnnotation(IMarker marker) {
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            MarkerAnnotation a;
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation) || !marker.equals((a = (MarkerAnnotation)((Object)o)).getMarker())) continue;
            return a;
        }
        return null;
    }

    private IMarkerUpdater createMarkerUpdater(IConfigurationElement element) {
        try {
            return (IMarkerUpdater)element.createExecutableExtension("class");
        }
        catch (CoreException x) {
            this.handleCoreException(x, TextEditorMessages.getString("AbstractMarkerAnnotationModel.createMarkerUpdater"));
            return null;
        }
    }

    private void checkMarkerUpdaters(IMarker marker) {
        int i;
        ArrayList<IConfigurationElement> toBeDeleted = new ArrayList<IConfigurationElement>();
        for (i = 0; i < this.fMarkerUpdaterSpecifications.size(); ++i) {
            IConfigurationElement spec = (IConfigurationElement)this.fMarkerUpdaterSpecifications.get(i);
            String markerType = spec.getAttribute("markerType");
            if (markerType != null && !MarkerUtilities.isMarkerType(marker, markerType)) continue;
            toBeDeleted.add(spec);
            IMarkerUpdater updater = this.createMarkerUpdater(spec);
            if (updater == null) continue;
            this.addMarkerUpdater(updater);
        }
        for (i = 0; i < toBeDeleted.size(); ++i) {
            this.fMarkerUpdaterSpecifications.remove(toBeDeleted.get(i));
        }
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) throws CoreException {
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        if (!this.fMarkerUpdaterSpecifications.isEmpty()) {
            this.checkMarkerUpdaters(marker);
        }
        boolean isOK = true;
        for (int i = 0; i < this.fInstantiatedMarkerUpdaters.size(); ++i) {
            IMarkerUpdater updater = (IMarkerUpdater)this.fInstantiatedMarkerUpdaters.get(i);
            String markerType = updater.getMarkerType();
            if (markerType != null && !MarkerUtilities.isMarkerType(marker, markerType)) continue;
            if (position == null) {
                position = this.createPositionFromMarker(marker);
            }
            isOK = isOK && updater.updateMarker(marker, document, position);
        }
        return isOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMarker(IDocument document, IMarker marker, Position position) throws CoreException {
        this.listenToMarkerChanges(false);
        try {
            boolean bl = this.updateMarker(marker, document, position);
            return bl;
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMarkers(IDocument document) throws CoreException {
        Assert.isTrue((this.fDocument == document ? 1 : 0) != 0);
        IAnnotationMap annotationMap = this.getAnnotationMap();
        if (annotationMap.size() == 0 && this.fDeletedAnnotations.size() == 0) {
            return;
        }
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        this.listenToMarkerChanges(false);
        try {
            Iterator e = this.getAnnotationIterator(false);
            while (e.hasNext()) {
                Position position;
                MarkerAnnotation a;
                IMarker marker;
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation) || this.updateMarker(marker = (a = (MarkerAnnotation)((Object)o)).getMarker(), document, position = (Position)annotationMap.get((Object)a)) || this.fDeletedAnnotations.contains((Object)a)) continue;
                this.fDeletedAnnotations.add(a);
            }
            if (!this.fDeletedAnnotations.isEmpty()) {
                this.removeAnnotations(this.fDeletedAnnotations, true, true);
                this.fDeletedAnnotations.clear();
            }
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    public void resetMarkers() {
        MarkerAnnotation a;
        Position p;
        Object o;
        Iterator e = this.getAnnotationIterator(false);
        while (e.hasNext()) {
            o = e.next();
            if (!(o instanceof MarkerAnnotation) || (p = this.createPositionFromMarker((a = (MarkerAnnotation)((Object)o)).getMarker())) == null) continue;
            this.removeAnnotation(a, false);
            try {
                this.addAnnotation(a, p, false);
            }
            catch (BadLocationException e1) {}
        }
        e = this.fDeletedAnnotations.iterator();
        while (e.hasNext()) {
            o = e.next();
            if (!(o instanceof MarkerAnnotation) || (p = this.createPositionFromMarker((a = (MarkerAnnotation)((Object)o)).getMarker())) == null) continue;
            try {
                this.addAnnotation(a, p, false);
            }
            catch (BadLocationException e1) {}
        }
        this.fDeletedAnnotations.clear();
        this.fireModelChanged();
    }

    public void commit(IDocument document) throws CoreException {
        this.updateMarkers(document);
    }

    public void revert(IDocument document) {
        this.resetMarkers();
    }

    public void reinitialize(IDocument document) {
        this.resetMarkers();
    }
}

