/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class ContributionContextTypeRegistry
extends ContextTypeRegistry {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String CONTEXT_TYPE = "contextType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String RESOLVER = "resolver";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    static /* synthetic */ Class class$org$eclipse$jface$text$templates$TemplateContextType;
    static /* synthetic */ Class class$org$eclipse$jface$text$templates$TemplateVariableResolver;

    public void addContextType(String id) {
        Assert.isNotNull((Object)id);
        if (this.getContextType(id) != null) {
            return;
        }
        TemplateContextType type = ContributionContextTypeRegistry.createContextType(id);
        if (type != null) {
            this.addContextType(type);
        }
    }

    public static TemplateContextType createContextType(String id) {
        TemplateContextType type;
        Assert.isNotNull((Object)id);
        IConfigurationElement[] extensions = ContributionContextTypeRegistry.getTemplateExtensions();
        try {
            type = ContributionContextTypeRegistry.createContextType(extensions, id);
            if (type != null) {
                TemplateVariableResolver[] resolvers = ContributionContextTypeRegistry.createResolvers(extensions, id);
                for (int i = 0; i < resolvers.length; ++i) {
                    type.addResolver(resolvers[i]);
                }
            }
        }
        catch (CoreException e) {
            EditorsPlugin.log(e);
            type = null;
        }
        return type;
    }

    private static TemplateContextType createContextType(IConfigurationElement[] extensions, String contextTypeId) throws CoreException {
        for (int i = 0; i < extensions.length; ++i) {
            String id;
            if (!extensions[i].getName().equals(CONTEXT_TYPE) || !contextTypeId.equals(id = extensions[i].getAttributeAsIs(ID))) continue;
            return ContributionContextTypeRegistry.createContextType(extensions[i]);
        }
        return null;
    }

    private static TemplateVariableResolver[] createResolvers(IConfigurationElement[] extensions, String contextTypeId) {
        ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
        for (int i = 0; i < extensions.length; ++i) {
            String declaredId;
            if (!extensions[i].getName().equals(RESOLVER) || !contextTypeId.equals(declaredId = extensions[i].getAttributeAsIs(CONTEXT_TYPE_ID))) continue;
            try {
                TemplateVariableResolver resolver = ContributionContextTypeRegistry.createResolver(extensions[i]);
                if (resolver == null) continue;
                resolvers.add(resolver);
                continue;
            }
            catch (CoreException e) {
                EditorsPlugin.log(e);
            }
        }
        return resolvers.toArray(new TemplateVariableResolver[resolvers.size()]);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private static TemplateContextType createContextType(IConfigurationElement element) throws CoreException {
        String id = element.getAttributeAsIs(ID);
        try {
            TemplateContextType contextType = (TemplateContextType)element.createExecutableExtension(CLASS);
            String name = element.getAttribute(NAME);
            if (name == null) {
                name = id;
            }
            contextType.setId(id);
            contextType.setName(name);
            return contextType;
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + (class$org$eclipse$jface$text$templates$TemplateContextType == null ? (class$org$eclipse$jface$text$templates$TemplateContextType = ContributionContextTypeRegistry.class$("org.eclipse.jface.text.templates.TemplateContextType")) : class$org$eclipse$jface$text$templates$TemplateContextType).getName(), (Throwable)e));
        }
    }

    private static TemplateVariableResolver createResolver(IConfigurationElement element) throws CoreException {
        try {
            String type = element.getAttributeAsIs(TYPE);
            if (type != null) {
                TemplateVariableResolver resolver = (TemplateVariableResolver)element.createExecutableExtension(CLASS);
                resolver.setType(type);
                String desc = element.getAttribute(DESCRIPTION);
                if (desc == null) {
                    desc = new String();
                }
                resolver.setDescription(desc);
                return resolver;
            }
        }
        catch (ClassCastException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + (class$org$eclipse$jface$text$templates$TemplateVariableResolver == null ? (class$org$eclipse$jface$text$templates$TemplateVariableResolver = ContributionContextTypeRegistry.class$("org.eclipse.jface.text.templates.TemplateVariableResolver")) : class$org$eclipse$jface$text$templates$TemplateVariableResolver).getName(), (Throwable)e));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

