/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;

public class OrLocator
extends PatternLocator {
    protected PatternLocator[] patternLocators;

    public OrLocator(OrPattern pattern) {
        super(pattern);
        SearchPattern[] patterns = pattern.patterns;
        int length = patterns.length;
        this.patternLocators = new PatternLocator[length];
        for (int i = 0; i < length; ++i) {
            this.patternLocators[i] = PatternLocator.patternLocator(patterns[i]);
        }
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            this.patternLocators[i].initializePolymorphicSearch(locator);
        }
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    protected int matchContainer() {
        int result = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            result |= this.patternLocators[i].matchContainer();
        }
        return result;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        PatternLocator closestPattern = null;
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel;
            PatternLocator patternLocator = this.patternLocators[i];
            int n = newLevel = patternLocator.referenceType() == 0 ? 0 : patternLocator.resolveLevel(binding);
            if (newLevel <= level) continue;
            closestPattern = patternLocator;
            if (newLevel == 3) break;
            level = newLevel;
        }
        if (closestPattern != null) {
            closestPattern.matchLevelAndReportImportRef(importRef, binding, locator);
        }
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        PatternLocator closestPattern = null;
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].matchLevel(importRef);
            if (newLevel <= level) continue;
            closestPattern = this.patternLocators[i];
            if (newLevel == 3) break;
            level = newLevel;
        }
        if (closestPattern != null) {
            closestPattern.matchReportImportRef(importRef, binding, element, accuracy, locator);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        PatternLocator closestPattern = null;
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel;
            PatternLocator patternLocator = this.patternLocators[i];
            int n = newLevel = patternLocator.referenceType() == 0 ? 0 : patternLocator.resolveLevel(reference);
            if (newLevel <= level) continue;
            closestPattern = patternLocator;
            if (newLevel == 3) break;
            level = newLevel;
        }
        if (closestPattern != null) {
            closestPattern.matchReportReference(reference, element, accuracy, locator);
        }
    }

    public int resolveLevel(ASTNode node) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].resolveLevel(node);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }

    public int resolveLevel(Binding binding) {
        int level = 0;
        int length = this.patternLocators.length;
        for (int i = 0; i < length; ++i) {
            int newLevel = this.patternLocators[i].resolveLevel(binding);
            if (newLevel <= level) continue;
            if (newLevel == 3) {
                return 3;
            }
            level = newLevel;
        }
        return level;
    }
}

