/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.RewriteEvent;
import org.eclipse.text.edits.TextEditGroup;

public final class RewriteEventStore {
    public static final int NEW = 1;
    public static final int ORIGINAL = 2;
    public static final int BOTH = 3;
    final List events = new ArrayList();
    private EventHolder lastEvent = null;
    private Map editGroups = null;
    List nodeCopySources = null;
    List rangeCopySources;
    Map trackedNodes = null;
    private Set insertBoundToPrevious = null;
    private INodePropertyMapper nodePropertyMapper = null;

    public void setNodePropertyMapper(INodePropertyMapper nodePropertyMapper) {
        this.nodePropertyMapper = nodePropertyMapper;
    }

    public void clear() {
        this.events.clear();
        this.lastEvent = null;
        this.trackedNodes = null;
        this.editGroups = null;
        this.insertBoundToPrevious = null;
        this.nodeCopySources = null;
    }

    public void addEvent(ASTNode parent, StructuralPropertyDescriptor childProperty, RewriteEvent event) {
        this.validateHasChildProperty(parent, childProperty);
        if (event.isListRewrite()) {
            this.validateIsListProperty(childProperty);
        }
        EventHolder holder = new EventHolder(parent, childProperty, event);
        for (int i = 0; i < this.events.size(); ++i) {
            EventHolder curr = (EventHolder)this.events.get(i);
            if (curr.parent != parent || curr.childProperty != childProperty) continue;
            this.events.set(i, holder);
            this.lastEvent = null;
            return;
        }
        this.events.add(holder);
    }

    public RewriteEvent getEvent(ASTNode parent, StructuralPropertyDescriptor property) {
        this.validateHasChildProperty(parent, property);
        if (this.lastEvent != null && this.lastEvent.parent == parent && this.lastEvent.childProperty == property) {
            return this.lastEvent.event;
        }
        for (int i = 0; i < this.events.size(); ++i) {
            EventHolder holder = (EventHolder)this.events.get(i);
            if (holder.parent != parent || holder.childProperty != property) continue;
            this.lastEvent = holder;
            return holder.event;
        }
        return null;
    }

    public NodeRewriteEvent getNodeEvent(ASTNode parent, StructuralPropertyDescriptor childProperty, boolean forceCreation) {
        this.validateIsNodeProperty(childProperty);
        NodeRewriteEvent event = (NodeRewriteEvent)this.getEvent(parent, childProperty);
        if (event == null && forceCreation) {
            Object originalValue = this.accessOriginalValue(parent, childProperty);
            event = new NodeRewriteEvent(originalValue, originalValue);
            this.addEvent(parent, childProperty, event);
        }
        return event;
    }

    public ListRewriteEvent getListEvent(ASTNode parent, StructuralPropertyDescriptor childProperty, boolean forceCreation) {
        this.validateIsListProperty(childProperty);
        ListRewriteEvent event = (ListRewriteEvent)this.getEvent(parent, childProperty);
        if (event == null && forceCreation) {
            List originalValue = (List)this.accessOriginalValue(parent, childProperty);
            event = new ListRewriteEvent(originalValue);
            this.addEvent(parent, childProperty, event);
        }
        return event;
    }

    public Iterator getChangeRootIterator() {
        return new ParentIterator();
    }

    public boolean hasChangedProperties(ASTNode parent) {
        for (int i = 0; i < this.events.size(); ++i) {
            EventHolder holder = (EventHolder)this.events.get(i);
            if (holder.parent != parent || holder.event.getChangeKind() == 0) continue;
            return true;
        }
        return false;
    }

    public PropertyLocation getPropertyLocation(Object value, int kind) {
        for (int i = 0; i < this.events.size(); ++i) {
            EventHolder holder = (EventHolder)this.events.get(i);
            RewriteEvent event = holder.event;
            if (this.isNodeInEvent(event, value, kind)) {
                return new PropertyLocation(holder.parent, holder.childProperty);
            }
            if (!event.isListRewrite()) continue;
            RewriteEvent[] children = event.getChildren();
            for (int k = 0; k < children.length; ++k) {
                if (!this.isNodeInEvent(children[k], value, kind)) continue;
                return new PropertyLocation(holder.parent, holder.childProperty);
            }
        }
        if (value instanceof ASTNode) {
            ASTNode node = (ASTNode)value;
            return new PropertyLocation(node.getParent(), node.getLocationInParent());
        }
        return null;
    }

    public RewriteEvent findEvent(Object value, int kind) {
        for (int i = 0; i < this.events.size(); ++i) {
            RewriteEvent event = ((EventHolder)this.events.get((int)i)).event;
            if (this.isNodeInEvent(event, value, kind)) {
                return event;
            }
            if (!event.isListRewrite()) continue;
            RewriteEvent[] children = event.getChildren();
            for (int k = 0; k < children.length; ++k) {
                if (!this.isNodeInEvent(children[k], value, kind)) continue;
                return children[k];
            }
        }
        return null;
    }

    private boolean isNodeInEvent(RewriteEvent event, Object value, int kind) {
        if ((kind & 1) != 0 && event.getNewValue() == value) {
            return true;
        }
        return (kind & 2) != 0 && event.getOriginalValue() == value;
    }

    public Object getOriginalValue(ASTNode parent, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return event.getOriginalValue();
        }
        return this.accessOriginalValue(parent, property);
    }

    public Object getNewValue(ASTNode parent, StructuralPropertyDescriptor property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return event.getNewValue();
        }
        return this.accessOriginalValue(parent, property);
    }

    public int getChangeKind(ASTNode node) {
        RewriteEvent event = this.findEvent(node, 2);
        if (event != null) {
            return event.getChangeKind();
        }
        return 0;
    }

    private Object accessOriginalValue(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        if (this.nodePropertyMapper != null) {
            return this.nodePropertyMapper.getOriginalValue(parent, childProperty);
        }
        return parent.getStructuralProperty(childProperty);
    }

    public TextEditGroup getEventEditGroup(RewriteEvent event) {
        if (this.editGroups == null) {
            return null;
        }
        return (TextEditGroup)this.editGroups.get(event);
    }

    public void setEventEditGroup(RewriteEvent event, TextEditGroup editGroup) {
        if (this.editGroups == null) {
            this.editGroups = new IdentityHashMap(5);
        }
        this.editGroups.put(event, editGroup);
    }

    public final TextEditGroup getTrackedNodeData(ASTNode node) {
        if (this.trackedNodes != null) {
            return (TextEditGroup)this.trackedNodes.get(node);
        }
        return null;
    }

    public void setTrackedNodeData(ASTNode node, TextEditGroup editGroup) {
        if (this.trackedNodes == null) {
            this.trackedNodes = new IdentityHashMap();
        }
        this.trackedNodes.put(node, editGroup);
    }

    public final void markAsTracked(ASTNode node, TextEditGroup editGroup) {
        if (this.getTrackedNodeData(node) != null) {
            throw new IllegalArgumentException("Node is already marked as tracked");
        }
        this.setTrackedNodeData(node, editGroup);
    }

    public final CopySourceInfo markAsCopySource(ASTNode parent, StructuralPropertyDescriptor property, ASTNode node, boolean isMove) {
        CopySourceInfo copySource = new CopySourceInfo(parent, property, node, node, isMove);
        if (this.nodeCopySources == null) {
            this.nodeCopySources = new ArrayList();
        }
        this.nodeCopySources.add(copySource);
        return copySource;
    }

    public final CopySourceInfo markAsRangeCopySource(ASTNode parent, StructuralPropertyDescriptor property, ASTNode first, ASTNode last, boolean isMove) {
        CopySourceInfo copySource = new CopySourceInfo(parent, property, first, last, isMove);
        this.assertNoOverlap(copySource);
        if (this.rangeCopySources == null) {
            this.rangeCopySources = new ArrayList();
        }
        this.rangeCopySources.add(copySource);
        return copySource;
    }

    public CopySourceInfo[] getNodeCopySources(ASTNode node) {
        if (this.nodeCopySources == null) {
            return null;
        }
        return this.internalGetCopySources(this.nodeCopySources, node);
    }

    public CopySourceInfo[] getRangeCopySources(ASTNode node) {
        if (this.rangeCopySources == null) {
            return null;
        }
        return this.internalGetCopySources(this.rangeCopySources, node);
    }

    public boolean hasRangeCopySources(ASTNode parent, StructuralPropertyDescriptor property) {
        if (this.rangeCopySources == null) {
            return false;
        }
        for (int i = 0; i < this.rangeCopySources.size(); ++i) {
            CopySourceInfo curr = (CopySourceInfo)this.rangeCopySources.get(i);
            if (curr.parent != parent || curr.childProperty != property) continue;
            return true;
        }
        return false;
    }

    public CopySourceInfo[] internalGetCopySources(List copySources, ASTNode node) {
        ArrayList<CopySourceInfo> res = new ArrayList<CopySourceInfo>(3);
        for (int i = 0; i < copySources.size(); ++i) {
            CopySourceInfo curr = (CopySourceInfo)copySources.get(i);
            if (curr.getStartNode() != node) continue;
            res.add(curr);
        }
        if (res.isEmpty()) {
            return null;
        }
        CopySourceInfo[] arr = res.toArray(new CopySourceInfo[res.size()]);
        if (arr.length > 1) {
            Arrays.sort(arr, new CopySourceInfoSorter());
        }
        return arr;
    }

    private void assertNoOverlap(CopySourceInfo copySource) {
    }

    public void markMovedNodesRemoved() {
        if (this.nodeCopySources == null) {
            return;
        }
        for (int i = 0; i < this.nodeCopySources.size(); ++i) {
            CopySourceInfo curr = (CopySourceInfo)this.nodeCopySources.get(i);
            if (!curr.isMove) continue;
            this.doMarkMovedAsRemoved(curr);
        }
    }

    private void doMarkMovedAsRemoved(CopySourceInfo curr) {
        if (curr.childProperty.isChildListProperty()) {
            ListRewriteEvent event = this.getListEvent(curr.parent, curr.childProperty, true);
            int index = event.getIndex(curr.getStartNode(), 2);
            if (index != -1 && event.getChangeKind(index) == 0) {
                event.setNewValue(null, index);
            }
        } else {
            NodeRewriteEvent event = this.getNodeEvent(curr.parent, curr.childProperty, true);
            if (event.getChangeKind() == 0) {
                event.setNewValue(null);
            }
        }
    }

    public boolean isInsertBoundToPrevious(ASTNode node) {
        if (this.insertBoundToPrevious != null) {
            return this.insertBoundToPrevious.contains(node);
        }
        return false;
    }

    public void setInsertBoundToPrevious(ASTNode node) {
        if (this.insertBoundToPrevious == null) {
            this.insertBoundToPrevious = new HashSet();
        }
        this.insertBoundToPrevious.add(node);
    }

    private void validateIsListProperty(StructuralPropertyDescriptor property) {
        if (!property.isChildListProperty()) {
            String message = property.getId() + " is not a list property";
            throw new IllegalArgumentException(message);
        }
    }

    private void validateHasChildProperty(ASTNode parent, StructuralPropertyDescriptor property) {
        if (!parent.structuralPropertiesForType().contains(property)) {
            String message = Signature.getSimpleName(parent.getClass().getName()) + " has no property " + property.getId();
            throw new IllegalArgumentException(message);
        }
    }

    private void validateIsNodeProperty(StructuralPropertyDescriptor property) {
        if (property.isChildListProperty()) {
            String message = property.getId() + " is not a node property";
            throw new IllegalArgumentException(message);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.events.size(); ++i) {
            buf.append(this.events.get(i).toString()).append('\n');
        }
        return buf.toString();
    }

    public static boolean isNewNode(ASTNode node) {
        return (node.getFlags() & 2) == 0;
    }

    private class ParentIterator
    implements Iterator {
        private Iterator eventIter;
        private Iterator sourceNodeIter;
        private Iterator rangeNodeIter;
        private Iterator trackedNodeIter;

        public ParentIterator() {
            this.eventIter = RewriteEventStore.this.events.iterator();
            this.sourceNodeIter = RewriteEventStore.this.nodeCopySources != null ? RewriteEventStore.this.nodeCopySources.iterator() : Collections.EMPTY_LIST.iterator();
            this.rangeNodeIter = RewriteEventStore.this.rangeCopySources != null ? RewriteEventStore.this.rangeCopySources.iterator() : Collections.EMPTY_LIST.iterator();
            this.trackedNodeIter = RewriteEventStore.this.trackedNodes != null ? RewriteEventStore.this.trackedNodes.keySet().iterator() : Collections.EMPTY_LIST.iterator();
        }

        public boolean hasNext() {
            return this.eventIter.hasNext() || this.sourceNodeIter.hasNext() || this.rangeNodeIter.hasNext() || this.trackedNodeIter.hasNext();
        }

        public Object next() {
            if (this.eventIter.hasNext()) {
                return ((EventHolder)this.eventIter.next()).parent;
            }
            if (this.sourceNodeIter.hasNext()) {
                return ((CopySourceInfo)this.sourceNodeIter.next()).getStartNode();
            }
            if (this.rangeNodeIter.hasNext()) {
                return ((CopySourceInfo)this.rangeNodeIter.next()).parent;
            }
            return this.trackedNodeIter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CopySourceInfoSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            CopySourceInfo e1 = (CopySourceInfo)o1;
            CopySourceInfo e2 = (CopySourceInfo)o2;
            if (e1.isMove) {
                return -1;
            }
            if (e2.isMove) {
                return 1;
            }
            return e2.getEndNode().getStartPosition() - e1.getEndNode().getStartPosition();
        }
    }

    public static class CopySourceInfo {
        public final ASTNode parent;
        public final StructuralPropertyDescriptor childProperty;
        private final ASTNode first;
        private final ASTNode last;
        public final boolean isMove;

        public CopySourceInfo(ASTNode parent, StructuralPropertyDescriptor childProperty, ASTNode first, ASTNode last, boolean isMove) {
            this.parent = parent;
            this.childProperty = childProperty;
            this.first = first;
            this.last = last;
            this.isMove = isMove;
        }

        public ASTNode getStartNode() {
            return this.first;
        }

        public ASTNode getEndNode() {
            return this.last;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.first != this.last) {
                buf.append("range ");
            }
            if (this.isMove) {
                buf.append("move source: ");
            } else {
                buf.append("copy source: ");
            }
            buf.append(this.first);
            if (this.first != this.last) {
                buf.append(" - ");
                buf.append(this.last);
            }
            return buf.toString();
        }
    }

    private static class EventHolder {
        public final ASTNode parent;
        public final StructuralPropertyDescriptor childProperty;
        public final RewriteEvent event;

        public EventHolder(ASTNode parent, StructuralPropertyDescriptor childProperty, RewriteEvent change) {
            this.parent = parent;
            this.childProperty = childProperty;
            this.event = change;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.parent).append(" - ");
            buf.append(this.childProperty.getId()).append(": ");
            buf.append(this.event).append('\n');
            return buf.toString();
        }
    }

    public static interface INodePropertyMapper {
        public Object getOriginalValue(ASTNode var1, StructuralPropertyDescriptor var2);
    }

    public final class PropertyLocation {
        private ASTNode parent;
        private StructuralPropertyDescriptor property;

        public PropertyLocation(ASTNode parent, StructuralPropertyDescriptor property) {
            this.parent = parent;
            this.property = property;
        }

        public ASTNode getParent() {
            return this.parent;
        }

        public StructuralPropertyDescriptor getProperty() {
            return this.property;
        }
    }
}

