/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private IPackageFragmentRoot fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IPackageFragmentRoot;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaProject;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaModel;

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(NewWizardMessages.getString("NewContainerWizardPage.container.label"));
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.getString("NewContainerWizardPage.container.button"));
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected void initContainerPage(IJavaElement elem) {
        IJavaProject jproject;
        IPackageFragmentRoot initRoot = null;
        if (elem != null && ((initRoot = JavaModelUtil.getPackageFragmentRoot(elem)) == null || initRoot.isArchive()) && (jproject = elem.getJavaProject()) != null) {
            block5: {
                try {
                    initRoot = null;
                    if (!jproject.exists()) break block5;
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    for (int i = 0; i < roots.length; ++i) {
                        if (roots[i].getKind() != 1) continue;
                        initRoot = roots[i];
                        break;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            if (initRoot == null) {
                initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
            }
        }
        this.setPackageFragmentRoot(initRoot, true);
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IJavaProject jelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = NewContainerWizardPage.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) == null && (resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = NewContainerWizardPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? NewContainerWizardPage.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = JavaPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return jelem;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if ((root = this.chooseSourceContainer((IJavaElement)root)) != null) {
            this.setPackageFragmentRoot(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getPackageFragmentRootText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.getString("NewContainerWizardPage.error.EnterContainerName"));
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.ProjectClosed", proj.getFullPath().toString()));
                    return status;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                this.fCurrRoot = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.getString("NewContainerWizardPage.warning.NotAJavaProject"));
                            } else {
                                status.setWarning(NewWizardMessages.getString("NewContainerWizardPage.warning.NotInAJavaProject"));
                            }
                            return status;
                        }
                    }
                    catch (CoreException e) {
                        status.setWarning(NewWizardMessages.getString("NewContainerWizardPage.warning.NotAJavaProject"));
                    }
                    if (!jproject.isOnClasspath((IJavaElement)this.fCurrRoot)) {
                        status.setWarning(NewWizardMessages.getFormattedString("NewContainerWizardPage.warning.NotOnClassPath", str));
                    }
                    if (this.fCurrRoot.isArchive()) {
                        status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.ContainerIsBinary", str));
                        return status;
                    }
                }
                return status;
            }
            status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.NotAFolder", str));
            return status;
        }
        status.setError(NewWizardMessages.getFormattedString("NewContainerWizardPage.error.ContainerDoesNotExist", str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    public String getPackageFragmentRootText() {
        return this.fContainerDialogField.getText();
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root, boolean canBeModified) {
        this.fCurrRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    private IPackageFragmentRoot chooseSourceContainer(IJavaElement initElement) {
        Class[] acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = NewContainerWizardPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = NewContainerWizardPage.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{class$org$eclipse$jdt$core$IJavaModel == null ? (class$org$eclipse$jdt$core$IJavaModel = NewContainerWizardPage.class$("org.eclipse.jdt.core.IJavaModel")) : class$org$eclipse$jdt$core$IJavaModel, class$org$eclipse$jdt$core$IPackageFragmentRoot == null ? (class$org$eclipse$jdt$core$IPackageFragmentRoot = NewContainerWizardPage.class$("org.eclipse.jdt.core.IPackageFragmentRoot")) : class$org$eclipse$jdt$core$IPackageFragmentRoot, class$org$eclipse$jdt$core$IJavaProject == null ? (class$org$eclipse$jdt$core$IJavaProject = NewContainerWizardPage.class$("org.eclipse.jdt.core.IJavaProject")) : class$org$eclipse$jdt$core$IJavaProject};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(NewWizardMessages.getString("NewContainerWizardPage.ChooseSourceContainerDialog.title"));
        dialog.setMessage(NewWizardMessages.getString("NewContainerWizardPage.ChooseSourceContainerDialog.description"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

