/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.ExtractConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractConstantAction
extends SelectionDispatchAction {
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("ExtractConstantAction.extract_constant");
    private final CompilationUnitEditor fEditor;

    public ExtractConstantAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("ExtractConstantAction.label"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.extract_constant_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(JavaTextSelection selection) {
        return (selection.resolveInInitializer() || selection.resolveInMethodBody()) && ExtractConstantRefactoring.isAvailable(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            ExtractConstantRefactoring refactoring = ExtractConstantAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, ExtractConstantAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private static ExtractConstantRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return ExtractConstantRefactoring.create(cunit, selection.getOffset(), selection.getLength(), JavaPreferencesSettings.getCodeGenerationSettings());
    }

    private static RefactoringWizard createWizard(ExtractConstantRefactoring refactoring) {
        return new ExtractConstantWizard(refactoring);
    }
}

