/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariableBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ClasspathVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage";
    private VariableBlock fVariableBlock;
    private String fStoredSettings;

    public ClasspathVariablesPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fVariableBlock = new VariableBlock(true, null);
        this.fStoredSettings = null;
        this.setTitle(PreferencesMessages.getString("ClasspathVariablesPreferencePage.title"));
        this.setDescription(PreferencesMessages.getString("ClasspathVariablesPreferencePage.description"));
        this.noDefaultAndApplyButton();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.cp_variables_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Control result = this.fVariableBlock.createContents(parent);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.fVariableBlock.performDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        JavaPlugin.getDefault().savePluginPreferences();
        return this.fVariableBlock.performOk();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fStoredSettings != null && !this.fStoredSettings.equals(this.getCurrentSettings())) {
                this.fVariableBlock.refresh(null);
            }
        } else {
            if (this.fVariableBlock.hasChanges()) {
                String title = PreferencesMessages.getString("ClasspathVariablesPreferencePage.savechanges.title");
                String message = PreferencesMessages.getString("ClasspathVariablesPreferencePage.savechanges.message");
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                    this.performOk();
                }
                this.fVariableBlock.setChanges(false);
            }
            this.fStoredSettings = this.getCurrentSettings();
        }
        super.setVisible(visible);
    }

    private String getCurrentSettings() {
        StringBuffer buf = new StringBuffer();
        String[] names = JavaCore.getClasspathVariableNames();
        for (int i = 0; i < names.length; ++i) {
            String curr = names[i];
            buf.append(curr).append('\u0000');
            IPath val = JavaCore.getClasspathVariable((String)curr);
            if (val != null) {
                buf.append(val.toString());
            }
            buf.append('\u0000');
        }
        return buf.toString();
    }
}

