/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaDetailFormattersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String DETAIL_FORMATTER_IS_ENABLED = "1";
    public static final String DETAIL_FORMATTER_IS_DISABLED = "0";
    private CheckboxTableViewer fFormatterListViewer;
    private Button fAddFormatterButton;
    private Button fRemoveFormatterButton;
    private Button fEditFormatterButton;
    private SourceViewer fCodeViewer;
    private Label fTableLabel;
    private FormatterListViewerContentProvider fFormatViewerContentProvider;

    public JavaDetailFormattersPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Override_default___toString()___for_Variables_and_Expressions_view_details._1"));
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.JAVA_DETAIL_FORMATTER_PREFERENCE_PAGE);
        return this.createDetailFormatsPreferences(parent);
    }

    public void init(IWorkbench workbench) {
    }

    private Control createDetailFormatsPreferences(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        container.setFont(font);
        this.fTableLabel = new Label(container, 0);
        this.fTableLabel.setText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.&Types_with_detail_formatters__2"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        this.fTableLabel.setFont(font);
        this.fFormatterListViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67618);
        Table table = (Table)this.fFormatterListViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(font);
        this.fFormatViewerContentProvider = new FormatterListViewerContentProvider(this.fFormatterListViewer);
        this.fFormatterListViewer.setContentProvider((IContentProvider)this.fFormatViewerContentProvider);
        this.fFormatterListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DetailFormatter) {
                    return ((DetailFormatter)element).getTypeName();
                }
                return null;
            }
        });
        this.fFormatterListViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((DetailFormatter)event.getElement()).setEnabled(event.getChecked());
            }
        });
        this.fFormatterListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)event.getSelection());
            }
        });
        this.fFormatterListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    JavaDetailFormattersPreferencePage.this.editType();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    JavaDetailFormattersPreferencePage.this.removeTypes();
                }
            }
        });
        this.fFormatterListViewer.setInput((Object)this);
        this.createDetailFormatsButtons(container);
        Label label = new Label(container, 0);
        label.setText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Detail_formatter_code_snippet_defined_for_selected_type__3"));
        label.setFont(font);
        this.createSourceViewer(container);
        this.fFormatViewerContentProvider.refreshViewer();
        return container;
    }

    private void createDetailFormatsButtons(Composite container) {
        Font font = container.getFont();
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFormatterButton = new Button(buttonContainer, 8);
        this.fAddFormatterButton.setText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Add_&Formatter..._5"));
        this.fAddFormatterButton.setToolTipText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Allow_you_to_create_a_new_detail_formatter_6"));
        this.fAddFormatterButton.setLayoutData((Object)gd);
        this.fAddFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fAddFormatterButton);
        this.fAddFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.addType();
            }
        });
        this.fEditFormatterButton = new Button(buttonContainer, 8);
        this.fEditFormatterButton.setText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.&Edit..._9"));
        this.fEditFormatterButton.setToolTipText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Edit_the_selected_detail_formatter_10"));
        this.fEditFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fEditFormatterButton);
        this.fEditFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.editType();
            }
        });
        this.fEditFormatterButton.setEnabled(false);
        this.fRemoveFormatterButton = new Button(buttonContainer, 8);
        this.fRemoveFormatterButton.setText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.&Remove_7"));
        this.fRemoveFormatterButton.setToolTipText(DebugUIMessages.getString("JavaDetailFormattersPreferencePage.Remove_all_selected_detail_formatters_8"));
        this.fRemoveFormatterButton.setFont(font);
        this.setButtonLayoutData(this.fRemoveFormatterButton);
        this.fRemoveFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JavaDetailFormattersPreferencePage.this.removeTypes();
            }
        });
        this.fRemoveFormatterButton.setEnabled(false);
    }

    public void createSourceViewer(Composite container) {
        this.fCodeViewer = new SourceViewer(container, null, 2816);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fCodeViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools, null));
        this.fCodeViewer.setEditable(false);
        this.fCodeViewer.setDocument((IDocument)document);
        this.fCodeViewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.fCodeViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fCodeViewer.getControl();
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)gd);
    }

    private void updatePage(IStructuredSelection selection) {
        this.fRemoveFormatterButton.setEnabled(!selection.isEmpty());
        this.fEditFormatterButton.setEnabled(selection.size() == 1);
        this.updateFormatViewer(selection);
    }

    private void updateFormatViewer(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this.fCodeViewer.getDocument().set(((DetailFormatter)selection.getFirstElement()).getSnippet());
        } else {
            this.fCodeViewer.getDocument().set("");
        }
    }

    public void addType() {
        DetailFormatter detailFormat = new DetailFormatter("", "", true);
        if (new DetailFormatterDialog(this.getShell(), detailFormat, this.fFormatViewerContentProvider.getDefinedTypes(), false).open() == 0) {
            this.fFormatViewerContentProvider.addDetailFormatter(detailFormat);
        }
    }

    public void removeTypes() {
        Object[] all = this.fFormatViewerContentProvider.getElements(null);
        IStructuredSelection selection = (IStructuredSelection)this.fFormatterListViewer.getSelection();
        Object first = selection.getFirstElement();
        int index = -1;
        for (int i = 0; i < all.length; ++i) {
            Object object = all[i];
            if (!object.equals(first)) continue;
            index = i;
            break;
        }
        this.fFormatViewerContentProvider.removeDetailFormatters(selection.toArray());
        all = this.fFormatViewerContentProvider.getElements(null);
        if (index > all.length - 1) {
            index = all.length - 1;
        }
        if (index >= 0) {
            this.fFormatterListViewer.setSelection((ISelection)new StructuredSelection(all[index]));
        }
    }

    public void editType() {
        IStructuredSelection selection = (IStructuredSelection)this.fFormatterListViewer.getSelection();
        if (new DetailFormatterDialog(this.getShell(), (DetailFormatter)selection.getFirstElement(), null, true, true).open() == 0) {
            this.fFormatterListViewer.refresh();
            this.fFormatViewerContentProvider.refreshViewer();
            this.updatePage(selection);
        }
    }

    public boolean performOk() {
        this.fFormatViewerContentProvider.saveDetailFormatters();
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    class FormatterListViewerContentProvider
    implements IStructuredContentProvider {
        private Set fDetailFormattersSet;
        private List fDefinedTypes;
        private CheckboxTableViewer fViewer;

        public FormatterListViewerContentProvider(CheckboxTableViewer viewer) {
            this.fViewer = viewer;
            String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
            this.fDetailFormattersSet = new TreeSet();
            this.fDefinedTypes = new ArrayList(detailFormattersList.length / 3);
            int i = 0;
            int length = detailFormattersList.length;
            while (i < length) {
                String typeName = detailFormattersList[i++];
                String snippet = detailFormattersList[i++].replace('\u0000', ',');
                boolean enabled = !JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_DISABLED.equals(detailFormattersList[i++]);
                DetailFormatter detailFormatter = new DetailFormatter(typeName, snippet, enabled);
                this.fDetailFormattersSet.add(detailFormatter);
                this.fDefinedTypes.add(typeName);
            }
        }

        public void saveDetailFormatters() {
            String[] values = new String[this.fDetailFormattersSet.size() * 3];
            int i = 0;
            Iterator iter = this.fDetailFormattersSet.iterator();
            while (iter.hasNext()) {
                DetailFormatter detailFormatter = (DetailFormatter)iter.next();
                values[i++] = detailFormatter.getTypeName();
                values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
                values[i++] = detailFormatter.isEnabled() ? JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_ENABLED : JavaDetailFormattersPreferencePage.DETAIL_FORMATTER_IS_DISABLED;
            }
            String pref = JavaDebugOptionsManager.serializeList(values);
            JavaDetailFormattersPreferencePage.this.getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        }

        public void addDetailFormatter(DetailFormatter detailFormatter) {
            this.fDetailFormattersSet.add(detailFormatter);
            this.fDefinedTypes.add(detailFormatter.getTypeName());
            this.fViewer.refresh();
            this.refreshViewer();
            StructuredSelection selection = new StructuredSelection((Object)detailFormatter);
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        public void removeDetailFormatter(DetailFormatter detailFormatter) {
            this.fDetailFormattersSet.remove(detailFormatter);
            this.fDefinedTypes.remove(detailFormatter.getTypeName());
            this.fViewer.refresh();
            StructuredSelection selection = new StructuredSelection();
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        public void removeDetailFormatters(Object[] detailFormatters) {
            int length = detailFormatters.length;
            for (int i = 0; i < length; ++i) {
                this.fDetailFormattersSet.remove(detailFormatters[i]);
                this.fDefinedTypes.remove(((DetailFormatter)detailFormatters[i]).getTypeName());
            }
            this.fViewer.refresh();
            StructuredSelection selection = new StructuredSelection();
            this.fViewer.setSelection((ISelection)selection);
            JavaDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)selection);
        }

        private void refreshViewer() {
            DetailFormatter[] checkedElementsTmp = new DetailFormatter[this.fDetailFormattersSet.size()];
            int i = 0;
            Iterator iter = this.fDetailFormattersSet.iterator();
            while (iter.hasNext()) {
                DetailFormatter detailFormatter = (DetailFormatter)iter.next();
                if (!detailFormatter.isEnabled()) continue;
                checkedElementsTmp[i++] = detailFormatter;
            }
            Object[] checkedElements = new DetailFormatter[i];
            System.arraycopy(checkedElementsTmp, 0, checkedElements, 0, i);
            this.fViewer.setAllChecked(false);
            this.fViewer.setCheckedElements(checkedElements);
        }

        public Object[] getElements(Object inputElement) {
            return this.fDetailFormattersSet.toArray();
        }

        public List getDefinedTypes() {
            return this.fDefinedTypes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

