/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.osgi.framework.BundleException;

public class UserState
extends StateImpl {
    private List added = new ArrayList();
    private List removed = new ArrayList();
    private List updated = new ArrayList();

    public synchronized boolean addBundle(BundleDescription description) {
        if (!super.addBundle(description)) {
            return false;
        }
        this.added.add(description.getLocation());
        return true;
    }

    public synchronized boolean removeBundle(BundleDescription description) {
        if (!super.removeBundle(description)) {
            return false;
        }
        this.removed.add(description.getLocation());
        return true;
    }

    public boolean updateBundle(BundleDescription newDescription) {
        if (!super.updateBundle(newDescription)) {
            return false;
        }
        this.updated.add(newDescription.getLocation());
        return true;
    }

    public String[] getAllAdded() {
        return this.added.toArray(new String[this.added.size()]);
    }

    public String[] getAllRemoved() {
        return this.removed.toArray(new String[this.removed.size()]);
    }

    public String[] getAllUpdated() {
        return this.updated.toArray(new String[this.updated.size()]);
    }

    public StateDelta compare(State baseState) throws BundleException {
        BundleDescription[] current = this.getBundles();
        StateDeltaImpl delta = new StateDeltaImpl(this);
        for (int i = 0; i < current.length; ++i) {
            BundleDescription existing = baseState.getBundleByLocation(current[i].getLocation());
            if (existing == null) {
                delta.recordBundleAdded((BundleDescriptionImpl)current[i]);
                continue;
            }
            if (!this.updated.contains(current[i].getLocation())) continue;
            delta.recordBundleUpdated((BundleDescriptionImpl)current[i]);
        }
        BundleDescription[] existing = baseState.getBundles();
        for (int i = 0; i < existing.length; ++i) {
            BundleDescription local = this.getBundleByLocation(existing[i].getLocation());
            if (local != null) continue;
            delta.recordBundleRemoved((BundleDescriptionImpl)existing[i]);
        }
        return delta;
    }
}

