/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryAction;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractTableViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.IFixedLengthOutputRenderer;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CopyViewTabToClipboardAction
extends AbstractMemoryAction {
    private final String PREFIX = "CopyViewToClipboardAction.";
    private final String TITLE = "CopyViewToClipboardAction.title";
    private final String TOOLTIP = "CopyViewToClipboardAction.tooltip";
    private final String COLUMN_SEPERATOR = "  ";

    public CopyViewTabToClipboardAction() {
        this.setText(DebugUIMessages.getString("CopyViewToClipboardAction.title"));
        this.setToolTipText(DebugUIMessages.getString("CopyViewToClipboardAction.tooltip"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
    }

    private String concatenateTableAsString(TableItem[] itemList) {
        AbstractMemoryRenderer renderer;
        if (itemList.length == 0) {
            return null;
        }
        StringBuffer tableContents = new StringBuffer();
        TableViewer viewer = ((MemoryViewTab)this.getViewTab()).getTableViewer();
        Table table = viewer.getTable();
        int numColumns = table.getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)viewer.getLabelProvider();
        TableColumn[] columns = table.getColumns();
        String tabLabel = this.getViewTab().getTabLabel();
        tableContents.append(tabLabel);
        tableContents.append(System.getProperty("line.separator"));
        tableContents.append("  ");
        int charPerByte = 4;
        if (labelProvider instanceof AbstractTableViewTabLabelProvider && (renderer = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer()) instanceof IFixedLengthOutputRenderer) {
            charPerByte = ((IFixedLengthOutputRenderer)((Object)renderer)).getNumCharPerByte();
        }
        for (int k = 0; k < numColumns; ++k) {
            StringBuffer columnLabel = new StringBuffer(columns[k].getText());
            int numBytes = 0;
            int numChars = 0;
            if (k > 0) {
                if (!(this.getViewTab() instanceof ITableMemoryViewTab)) {
                    return "";
                }
                numBytes = ((ITableMemoryViewTab)this.getViewTab()).getColumnSize();
                numChars = numBytes * charPerByte;
            } else {
                IMemoryBlock memBlock = this.getViewTab().getMemoryBlock();
                if (memBlock instanceof IExtendedMemoryBlock) {
                    numBytes = ((IExtendedMemoryBlock)memBlock).getAddressSize();
                    if (numBytes <= 0) {
                        numBytes = 4;
                    }
                } else {
                    numBytes = 4;
                }
                numChars = numBytes * 2;
            }
            while (columnLabel.length() < numChars) {
                columnLabel.append(" ");
            }
            tableContents.append(columnLabel);
            tableContents.append("  ");
        }
        tableContents.append(System.getProperty("line.separator"));
        for (int i = 0; i < itemList.length; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                tableContents.append("  ");
                StringBuffer temp = new StringBuffer(labelProvider.getColumnText(itemList[i].getData(), j));
                if (j > 0) {
                    if (!(this.getViewTab() instanceof ITableMemoryViewTab)) {
                        return "";
                    }
                    int numBytes = ((ITableMemoryViewTab)this.getViewTab()).getColumnSize();
                    int numChars = numBytes * charPerByte;
                    while (temp.length() < numChars) {
                        temp.append(" ");
                    }
                }
                tableContents.append(temp);
            }
            tableContents.append(System.getProperty("line.separator"));
        }
        return tableContents.toString();
    }

    public void run() {
        if (this.getViewTab() == null) {
            return;
        }
        TableViewer viewer = ((MemoryViewTab)this.getViewTab()).getTableViewer();
        if (viewer == null) {
            return;
        }
        Table table = viewer.getTable();
        if (table == null) {
            return;
        }
        Clipboard clip = new Clipboard(table.getDisplay());
        TableItem[] tableItems = table.getItems();
        String tableAsString = new String();
        tableAsString = this.concatenateTableAsString(tableItems);
        if (!tableAsString.equals("")) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{tableAsString}, new Transfer[]{plainTextTransfer});
        }
    }

    IMemoryViewTab getViewTab() {
        return this.getTopViewTabFromView("org.eclipse.debug.ui.MemoryView");
    }
}

