/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;

public class CVSProjectSetCapability
extends ProjectSetCapability {
    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] result = new String[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            result[i] = this.asReference(projects[i]);
        }
        return result;
    }

    private String asReference(IProject project) throws TeamException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("1.0,");
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project);
        CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString(root.getRemoteLocation().getLocation());
        location.setUserMuteable(true);
        String repoLocation = location.getLocation();
        buffer.append(repoLocation);
        buffer.append(",");
        ICVSFolder folder = root.getLocalRoot();
        FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
        String module = syncInfo.getRepository();
        buffer.append(module);
        buffer.append(",");
        String projectName = folder.getName();
        buffer.append(projectName);
        CVSEntryLineTag tag = syncInfo.getTag();
        if (tag != null && ((CVSTag)tag).getType() != 3) {
            buffer.append(",");
            String tagName = ((CVSTag)tag).getName();
            buffer.append(tagName);
        }
        return buffer.toString();
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        Policy.checkCanceled(monitor);
        HashMap infoMap = new HashMap(referenceStrings.length);
        IProject[] projects = this.asProjects(referenceStrings, infoMap);
        projects = this.confirmOverwrite(context, projects);
        if (projects == null) {
            return new IProject[0];
        }
        return this.checkout(projects, infoMap, monitor);
    }

    private IProject[] asProjects(String[] referenceStrings, Map infoMap) throws CVSException {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (int i = 0; i < referenceStrings.length; ++i) {
            StringTokenizer tokenizer = new StringTokenizer(referenceStrings[i], ",");
            String version = tokenizer.nextToken();
            if (!version.equals("1.0")) continue;
            LoadInfo info = new LoadInfo(tokenizer);
            IProject proj = info.getProject();
            result.add(proj);
            infoMap.put(proj, info);
        }
        return result.toArray(new IProject[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject[] checkout(IProject[] projects, Map infoMap, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask("", 1000 * projects.length);
        ArrayList<IProject> result = new ArrayList<IProject>();
        try {
            for (int i = 0; i < projects.length; ++i) {
                if (monitor.isCanceled()) {
                    break;
                }
                IProject project = projects[i];
                LoadInfo info = (LoadInfo)infoMap.get(project);
                if (info == null || !info.checkout((IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                result.add(project);
            }
        }
        finally {
            monitor.done();
        }
        return result.toArray(new IProject[result.size()]);
    }

    private static ICVSRepositoryLocation getRepositoryLocationFromString(String repo) throws CVSException {
        CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString(repo);
        if (newLocation.getUsername() == null || newLocation.getUsername().length() == 0) {
            ICVSRepositoryLocation[] locations = CVSProviderPlugin.getPlugin().getKnownRepositories();
            for (int i = 0; i < locations.length; ++i) {
                ICVSRepositoryLocation location = locations[i];
                if (location.getMethod() != newLocation.getMethod() || !location.getHost().equals(newLocation.getHost()) || location.getPort() != newLocation.getPort() || !location.getRootDirectory().equals(newLocation.getRootDirectory())) continue;
                return location;
            }
        }
        return newLocation;
    }

    public static void checkout(ICVSRepositoryLocation repository, IProject project, String sourceModule, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        if (sourceModule == null) {
            sourceModule = project.getName();
        }
        CVSProjectSetCapability.checkout(new ICVSRemoteFolder[]{new RemoteFolder(null, repository, sourceModule, tag)}, new IProject[]{project}, monitor);
    }

    public static void checkout(final ICVSRemoteFolder[] resources, final IProject[] projects, IProgressMonitor monitor) throws TeamException {
        final TeamException[] eHolder = new TeamException[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        pm.beginTask(null, 1000 * resources.length);
                        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                        for (int i = 0; i < resources.length; ++i) {
                            IProject project = null;
                            RemoteFolder resource = (RemoteFolder)resources[i];
                            if (projects != null) {
                                project = projects[i];
                            }
                            String moduleName = resource instanceof RemoteModule ? ((RemoteModule)resource).getName() : resource.getRepositoryRelativePath();
                            ICVSRepositoryLocation repository = resource.getRepository();
                            Session session = new Session(repository, root);
                            try {
                                CVSTag tag;
                                session.open(Policy.subMonitorFor(pm, 50), false);
                                HashSet<IProject> targetProjects = new HashSet<IProject>();
                                if (project == null) {
                                    IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, Policy.subMonitorFor(pm, 50));
                                    if (status.getCode() == -10) {
                                        throw new CVSServerException(status);
                                    }
                                    String[] expansions = session.getModuleExpansions();
                                    for (int j = 0; j < expansions.length; ++j) {
                                        targetProjects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(expansions[j]).segment(0)));
                                    }
                                } else {
                                    targetProjects.add(project);
                                }
                                root.run(new ICVSRunnable(this, targetProjects){
                                    private final /* synthetic */ Set val$targetProjects;
                                    private final /* synthetic */ 1 this$0;
                                    {
                                        this.this$0 = this$0;
                                        this.val$targetProjects = val$targetProjects;
                                    }

                                    public void run(IProgressMonitor monitor) throws CVSException {
                                        CVSProjectSetCapability.scrubProjects(this.val$targetProjects.toArray(new IProject[this.val$targetProjects.size()]), monitor);
                                    }
                                }, Policy.subMonitorFor(pm, 100));
                                ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                                if (project != null) {
                                    localOptions.add(Checkout.makeDirectoryNameOption(project.getName()));
                                }
                                if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                                    localOptions.add(Checkout.PRUNE_EMPTY_DIRECTORIES);
                                }
                                if ((tag = resource.getTag()) == null) {
                                    tag = CVSTag.DEFAULT;
                                }
                                localOptions.add(Update.makeTagOption(tag));
                                IStatus status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{moduleName}, null, Policy.subMonitorFor(pm, 800));
                                if (status.getCode() == -10) {
                                    throw new CVSServerException(status);
                                }
                                CVSProjectSetCapability.refreshProjects(targetProjects.toArray(new IProject[targetProjects.size()]), Policy.subMonitorFor(pm, 100));
                                continue;
                            }
                            finally {
                                session.close();
                            }
                        }
                    }
                    catch (TeamException e) {
                        eHolder[0] = e;
                    }
                    finally {
                        pm.done();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)new MultiRule((ISchedulingRule[])projects), 0, monitor);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        finally {
            monitor.done();
        }
        if (eHolder[0] != null) {
            throw eHolder[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException, TeamException {
        monitor.beginTask(Policy.bind("CVSProvider.Creating_projects_2"), projects.length * 100);
        try {
            for (int i = 0; i < projects.length; ++i) {
                IProject project = projects[i];
                RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void scrubProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        if (projects == null) {
            monitor.done();
            return;
        }
        monitor.beginTask(Policy.bind("CVSProvider.Scrubbing_projects_1"), projects.length * 100);
        try {
            for (int i = 0; i < projects.length; ++i) {
                File location;
                IProject project = projects[i];
                if (project != null && project.exists()) {
                    if (!project.isOpen()) {
                        project.open(Policy.subMonitorFor(monitor, 10));
                    }
                    monitor.subTask(Policy.bind("CVSProvider.Scrubbing_local_project_1"));
                    if (RepositoryProvider.getProvider((IProject)project) != null) {
                        RepositoryProvider.unmap((IProject)project);
                    }
                    IResource[] children = project.members(2);
                    IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 80);
                    subMonitor.beginTask(null, children.length * 100);
                    try {
                        for (int j = 0; j < children.length; ++j) {
                            if (children[j].getName().equals(".project")) continue;
                            children[j].delete(true, Policy.subMonitorFor(subMonitor, 100));
                        }
                        continue;
                    }
                    finally {
                        subMonitor.done();
                    }
                }
                if (project == null || !(location = new File(project.getParent().getLocation().toFile(), project.getName())).exists()) continue;
                CVSProjectSetCapability.deepDelete(location);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }

    private static void deepDelete(File resource) {
        if (resource.isDirectory()) {
            File[] fileList = resource.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                CVSProjectSetCapability.deepDelete(fileList[i]);
            }
        }
        resource.delete();
    }

    class LoadInfo {
        private final ICVSRepositoryLocation repositoryLocation;
        private final String module;
        private final IProject project;
        private final CVSTag tag;

        LoadInfo(StringTokenizer tokenizer) throws CVSException {
            String repo = tokenizer.nextToken();
            this.repositoryLocation = CVSProjectSetCapability.getRepositoryLocationFromString(repo);
            this.module = tokenizer.nextToken();
            String projectName = tokenizer.nextToken();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (tokenizer.hasMoreTokens()) {
                String tagName = tokenizer.nextToken();
                this.tag = new CVSTag(tagName, 1);
            } else {
                this.tag = null;
            }
        }

        private IProject getProject() {
            return this.project;
        }

        boolean checkout(IProgressMonitor monitor) throws TeamException {
            if (this.repositoryLocation == null) {
                return false;
            }
            CVSProjectSetCapability.checkout(this.repositoryLocation, this.project, this.module, this.tag, monitor);
            return true;
        }
    }
}

