/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.text.edits.UndoEdit;

public class TextFileChange
extends TextChange {
    public static final int KEEP_SAVE_STATE = 1;
    public static final int FORCE_SAVE = 2;
    public static final int LEAVE_DIRTY = 4;
    private IFile fFile;
    private int fSaveMode = 1;
    private int fAquireCount;
    private ITextFileBuffer fBuffer;
    private boolean fDirty;
    private BufferValidationState fValidationState;
    private ContentStamp fContentStamp;

    public TextFileChange(String name, IFile file) {
        super(name);
        Assert.isNotNull(file);
        this.fFile = file;
    }

    public void setSaveMode(int saveMode) {
        this.fSaveMode = saveMode;
    }

    public int getSaveMode() {
        return this.fSaveMode;
    }

    public IFile getFile() {
        return this.fFile;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        return new UndoTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.fSaveMode);
    }

    public Object getModifiedElement() {
        return this.fFile;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        pm.beginTask("", 1);
        this.fValidationState = BufferValidationState.create(this.fFile);
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath());
        this.fDirty = buffer != null && buffer.isDirty();
        pm.worked(1);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        RefactoringStatus result = this.fValidationState.isValid();
        if (this.needsSaving()) {
            result.merge(Changes.validateModifiesFiles(new IFile[]{this.fFile}));
        }
        pm.worked(1);
        return result;
    }

    public void dispose() {
        this.fValidationState.dispose();
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        if (this.fAquireCount > 0) {
            return this.fBuffer.getDocument();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fFile.getFullPath();
        manager.connect(path, pm);
        ++this.fAquireCount;
        this.fBuffer = manager.getTextFileBuffer(path);
        this.fContentStamp = ContentStamps.get(this.fFile, true);
        return this.fBuffer.getDocument();
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.needsSaving()) {
            this.fBuffer.commit(pm, false);
            ContentStamps.increment(this.fFile);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        Assert.isTrue(this.fAquireCount > 0);
        if (this.fAquireCount == 1) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            manager.disconnect(this.fFile.getFullPath(), pm);
        }
        --this.fAquireCount;
    }

    protected final Change createUndoChange(UndoEdit edit) {
        return this.createUndoChange(edit, this.fContentStamp);
    }

    private boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }
}

