/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import org.eclipse.team.internal.core.Policy;

public final class Assert {
    private Assert() {
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static void isNotNull(Object object) {
        if (object == null) {
            throw new AssertionFailedException("null argument");
        }
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            throw new AssertionFailedException("null argument:" + message);
        }
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertionFailedException("assert failed:" + message);
        }
        return expression;
    }

    public static void notYetImplemented() {
    }

    public static class AssertionFailedException
    extends RuntimeException {
        public AssertionFailedException() {
        }

        public AssertionFailedException(String detail) {
            super(Policy.bind("Assert.assertionFailed", detail));
        }
    }
}

