/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.views.AntProjectContentProvider;
import org.eclipse.ant.internal.ui.views.AntViewDropAdapter;
import org.eclipse.ant.internal.ui.views.AntViewLabelProvider;
import org.eclipse.ant.internal.ui.views.AntViewMessages;
import org.eclipse.ant.internal.ui.views.actions.AddBuildFilesAction;
import org.eclipse.ant.internal.ui.views.actions.AntOpenWithMenu;
import org.eclipse.ant.internal.ui.views.actions.FilterInternalTargetsAction;
import org.eclipse.ant.internal.ui.views.actions.RefreshBuildFilesAction;
import org.eclipse.ant.internal.ui.views.actions.RemoveAllAction;
import org.eclipse.ant.internal.ui.views.actions.RemoveProjectAction;
import org.eclipse.ant.internal.ui.views.actions.RunTargetAction;
import org.eclipse.ant.internal.ui.views.actions.SearchForBuildFilesAction;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.ant.internal.ui.views.elements.RootNode;
import org.eclipse.ant.internal.ui.views.elements.TargetNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

public class AntView
extends ViewPart
implements IResourceChangeListener,
IShowInSource {
    private RootNode restoredRoot = null;
    private boolean restoredFilterInternalTargets = false;
    private static IMemento tempMemento = null;
    private static final String TAG_PROJECT = "project";
    private static final String KEY_ERROR = "error";
    private static final String KEY_PATH = "path";
    private static final String KEY_NAME = "name";
    private static final String KEY_DEFAULT = "default";
    private static final String TAG_FILTER_INTERNAL_TARGETS = "filterInternalTargets";
    private static final String KEY_VALUE = "value";
    private TreeViewer projectViewer;
    private AntProjectContentProvider projectContentProvider;
    private List updateProjectActions;
    private AddBuildFilesAction addBuildFileAction;
    private SearchForBuildFilesAction searchForBuildFilesAction;
    private RefreshBuildFilesAction refreshBuildFilesAction;
    private RunTargetAction runTargetAction;
    private RemoveProjectAction removeProjectAction;
    private RemoveAllAction removeAllAction;
    private FilterInternalTargetsAction filterInternalTargetsAction;
    private AntOpenWithMenu openWithMenu;
    private RunTargetAction editConfigAction;

    private void handleBuildFileChanged(ProjectNode project) {
        project.parseBuildFile();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AntView.this.projectViewer.refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.initializeActions();
        this.createProjectViewer(parent);
        this.initializeDragAndDrop();
        this.fillMainToolBar();
        if (this.getProjects().length > 0) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ant.ui.ant_view_context");
        this.updateProjectActions();
    }

    private void initializeDragAndDrop() {
        int ops = 19;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        TreeViewer viewer = this.getProjectViewer();
        AntViewDropAdapter adapter = new AntViewDropAdapter(this);
        viewer.addDropSupport(ops, transfers, (DropTargetListener)adapter);
    }

    private void createContextMenu(final Viewer viewer) {
        Control menuControl = viewer.getControl();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AntView.this.fillContextMenu(viewer, mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(Viewer viewer, IMenuManager menu) {
        if (viewer == this.projectViewer) {
            menu.add((IAction)this.runTargetAction);
            menu.add((IAction)this.editConfigAction);
            menu.add((IContributionItem)new Separator());
            this.addOpenWithMenu(menu);
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.addBuildFileAction);
            menu.add((IAction)this.removeProjectAction);
            menu.add((IAction)this.removeAllAction);
            menu.add((IAction)this.refreshBuildFilesAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IFile buildFile = this.getSelectionBuildFile();
        if (buildFile != null && buildFile.exists()) {
            menu.add((IContributionItem)new Separator("group.open"));
            MenuManager submenu = new MenuManager(AntViewMessages.getString("AntView.Open_With_3"));
            this.openWithMenu.setFile((IAdaptable)buildFile);
            submenu.add((IContributionItem)this.openWithMenu);
            menu.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    private void initializeActions() {
        this.updateProjectActions = new ArrayList(5);
        this.addBuildFileAction = new AddBuildFilesAction(this);
        this.removeProjectAction = new RemoveProjectAction(this);
        this.updateProjectActions.add(this.removeProjectAction);
        this.removeAllAction = new RemoveAllAction(this);
        this.updateProjectActions.add(this.removeAllAction);
        this.runTargetAction = new RunTargetAction(this, false);
        this.updateProjectActions.add(this.runTargetAction);
        this.searchForBuildFilesAction = new SearchForBuildFilesAction(this);
        this.refreshBuildFilesAction = new RefreshBuildFilesAction(this);
        this.updateProjectActions.add(this.refreshBuildFilesAction);
        this.openWithMenu = new AntOpenWithMenu(this.getViewSite().getPage());
        this.editConfigAction = new RunTargetAction(this, true);
        this.updateProjectActions.add(this.editConfigAction);
        this.filterInternalTargetsAction = new FilterInternalTargetsAction(this);
    }

    private void updateProjectActions() {
        Iterator iter = this.updateProjectActions.iterator();
        while (iter.hasNext()) {
            ((IUpdate)iter.next()).update();
        }
    }

    private void createProjectViewer(Composite parent) {
        this.projectViewer = new TreeViewer(parent, 768);
        this.projectContentProvider = new AntProjectContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)this.projectContentProvider);
        this.projectContentProvider.setFilterInternalTargets(this.restoredFilterInternalTargets);
        this.filterInternalTargetsAction.setChecked(this.restoredFilterInternalTargets);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new AntViewLabelProvider());
        if (tempMemento != null) {
            this.restoreRoot(tempMemento);
        }
        this.projectViewer.setInput((Object)this.restoredRoot);
        this.projectViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1.toString().compareToIgnoreCase(e2.toString());
            }
        });
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntView.this.handleSelectionChanged(event);
            }
        });
        this.projectViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    AntView.this.handleProjectViewerDoubleClick(event);
                }
            }
        });
        this.projectViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                AntView.this.handleProjectViewerKeyPress(event);
            }
        });
        this.createContextMenu((Viewer)this.projectViewer);
    }

    private void handleProjectViewerKeyPress(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.removeProjectAction.isEnabled()) {
                this.removeProjectAction.run();
            }
        } else if (event.keyCode == 0x100000E && event.stateMask == 0 && this.refreshBuildFilesAction.isEnabled()) {
            this.refreshBuildFilesAction.run();
        }
    }

    private void handleProjectViewerDoubleClick(DoubleClickEvent event) {
        block8: {
            ISelection s = event.getSelection();
            if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                return;
            }
            Object selection = ((IStructuredSelection)s).getFirstElement();
            if (selection instanceof ProjectNode) {
                ProjectNode project = (ProjectNode)selection;
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                IFile file = AntUtil.getFile(project.getBuildFileName());
                IEditorDescriptor editor = IDE.getDefaultEditor((IFile)file);
                if (editor == null) {
                    editor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
                }
                try {
                    if (editor == null) {
                        this.getViewSite().getPage().openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.systemExternalEditor");
                        break block8;
                    }
                    this.getViewSite().getPage().openEditor((IEditorInput)new FileEditorInput(file), editor.getId());
                }
                catch (PartInitException e) {
                    AntUIPlugin.log(e);
                }
            } else if (selection instanceof TargetNode) {
                this.runTargetAction.run();
            }
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        this.updateProjectActions();
        Iterator selectionIter = ((IStructuredSelection)event.getSelection()).iterator();
        Object selection = null;
        if (selectionIter.hasNext()) {
            selection = selectionIter.next();
        }
        String messageString = null;
        if (!selectionIter.hasNext()) {
            messageString = AntView.getStatusLineText(selection);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(messageString);
    }

    private static String getStatusLineText(Object node) {
        if (node instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)node;
            StringBuffer message = new StringBuffer(project.getBuildFileName());
            String description = project.getDescription();
            if (description != null) {
                message.append(": ");
                message.append(description);
            }
            return message.toString();
        }
        if (node instanceof TargetNode) {
            String description;
            TargetNode target = (TargetNode)node;
            StringBuffer message = new StringBuffer(AntViewMessages.getString("AntView.Name___1"));
            message.append(target.getName());
            message.append('\"');
            String[] depends = target.getDependencies();
            if (depends.length > 0) {
                message.append(AntViewMessages.getString("AntView._Depends___2"));
                message.append(depends[0]);
                for (int i = 1; i < depends.length; ++i) {
                    message.append(',').append(depends[i]);
                }
                message.append('\"');
            }
            if ((description = target.getDescription()) != null && description.length() != 0) {
                message.append(AntViewMessages.getString("AntView._Description___4"));
                message.append(description);
                message.append('\"');
            }
            return message.toString();
        }
        return null;
    }

    public TreeViewer getProjectViewer() {
        return this.projectViewer;
    }

    public ProjectNode[] getProjects() {
        return this.projectContentProvider.getRootNode().getProjects();
    }

    public void addProject(ProjectNode project) {
        this.projectContentProvider.addProject(project);
        this.projectViewer.refresh();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.updateProjectActions();
    }

    private void removeProject(ProjectNode project) {
        this.removeProjectFromContentProviders(project);
        this.projectViewer.refresh();
        if (this.getProjects().length == 0) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.setProjectViewerSelectionAfterDeletion();
    }

    private void setProjectViewerSelectionAfterDeletion() {
        Object[] children = this.projectContentProvider.getChildren(this.projectContentProvider.getRootNode());
        if (children.length > 0) {
            ViewerSorter sorter = this.projectViewer.getSorter();
            sorter.sort((Viewer)this.projectViewer, children);
            this.projectViewer.setSelection((ISelection)new StructuredSelection(children[0]));
        }
    }

    public void removeProjects(List projectNodes) {
        Iterator iter = projectNodes.iterator();
        while (iter.hasNext()) {
            ProjectNode project = (ProjectNode)iter.next();
            this.removeProjectFromContentProviders(project);
        }
        this.projectViewer.refresh();
        this.setProjectViewerSelectionAfterDeletion();
    }

    private void removeProjectFromContentProviders(ProjectNode project) {
        this.projectContentProvider.getRootNode().removeProject(project);
        if (!this.projectContentProvider.getRootNode().hasProjects()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void removeAllProjects() {
        this.projectContentProvider.getRootNode().removeAllProjects();
        this.projectViewer.refresh();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.updateProjectActions();
    }

    public void setFocus() {
        if (this.getProjectViewer() != null) {
            this.getProjectViewer().getControl().setFocus();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        IMemento child;
        this.init(site);
        this.restoreRoot(memento);
        if (memento != null && (child = memento.getChild(TAG_FILTER_INTERNAL_TARGETS)) != null) {
            this.restoredFilterInternalTargets = Boolean.valueOf(child.getString(KEY_VALUE));
        }
    }

    private void restoreRoot(IMemento memento) {
        if (memento == null) {
            this.restoredRoot = new RootNode();
            return;
        }
        IMemento[] projects = memento.getChildren(TAG_PROJECT);
        if (projects.length < 1) {
            this.restoredRoot = new RootNode();
            return;
        }
        ArrayList<ProjectNode> projectNodes = new ArrayList<ProjectNode>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            IMemento projectMemento = projects[i];
            String pathString = projectMemento.getString(KEY_PATH);
            if (!ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathString)).exists()) continue;
            String nameString = projectMemento.getString(KEY_NAME);
            String defaultTarget = projectMemento.getString(KEY_DEFAULT);
            String errorString = projectMemento.getString(KEY_ERROR);
            ProjectNode project = null;
            if (nameString == null) {
                nameString = "";
            }
            project = new ProjectNode(nameString, pathString);
            if (errorString != null && Boolean.valueOf(errorString).booleanValue()) {
                project.setIsErrorNode(true);
            }
            if (defaultTarget != null) {
                project.setDefaultTargetName(defaultTarget);
            }
            projectNodes.add(project);
        }
        this.restoredRoot = new RootNode(projectNodes.toArray(new ProjectNode[projectNodes.size()]));
    }

    public void saveState(IMemento memento) {
        ProjectNode[] projects = this.projectContentProvider.getRootNode().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            ProjectNode project = projects[i];
            IMemento projectMemento = memento.createChild(TAG_PROJECT);
            projectMemento.putString(KEY_PATH, project.getBuildFileName());
            projectMemento.putString(KEY_NAME, project.getName());
            String defaultTarget = project.getDefaultTargetName();
            if (project.isErrorNode()) {
                projectMemento.putString(KEY_ERROR, String.valueOf(true));
                continue;
            }
            if (defaultTarget != null) {
                projectMemento.putString(KEY_DEFAULT, defaultTarget);
            }
            projectMemento.putString(KEY_ERROR, String.valueOf(false));
        }
        IMemento filterTargets = memento.createChild(TAG_FILTER_INTERNAL_TARGETS);
        filterTargets.putString(KEY_VALUE, this.isFilterInternalTargets() ? String.valueOf(true) : String.valueOf(false));
    }

    public void dispose() {
        tempMemento = XMLMemento.createWriteRoot((String)"AntViewMemento");
        this.saveState(tempMemento);
        super.dispose();
        if (this.openWithMenu != null) {
            this.openWithMenu.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            ProjectNode[] projects = this.projectContentProvider.getRootNode().getProjects();
            for (int i = 0; i < projects.length; ++i) {
                Path buildFilePath = new Path(projects[i].getBuildFileName());
                IResourceDelta change = delta.findMember((IPath)buildFilePath);
                if (change == null) continue;
                this.handleChangeDelta(change, projects[i]);
            }
        }
    }

    private void handleChangeDelta(IResourceDelta delta, final ProjectNode project) {
        IResource resource = delta.getResource();
        if (resource.getType() != 1) {
            return;
        }
        if (delta.getKind() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AntView.this.removeProject(project);
                }
            });
        } else if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
            this.handleBuildFileChanged(project);
        }
    }

    private void fillMainToolBar() {
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.removeAll();
        toolBarMgr.add((IAction)this.addBuildFileAction);
        toolBarMgr.add((IAction)this.searchForBuildFilesAction);
        toolBarMgr.add((IAction)this.filterInternalTargetsAction);
        toolBarMgr.add((IAction)this.runTargetAction);
        toolBarMgr.add((IAction)this.removeProjectAction);
        toolBarMgr.add((IAction)this.removeAllAction);
        toolBarMgr.update(false);
    }

    private IFile getSelectionBuildFile() {
        IStructuredSelection selection = (IStructuredSelection)this.getProjectViewer().getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            ProjectNode projectNode = null;
            if (element instanceof ProjectNode) {
                projectNode = (ProjectNode)element;
            } else if (element instanceof TargetNode) {
                projectNode = ((TargetNode)element).getProject();
            }
            if (projectNode != null) {
                return AntUtil.getFile(projectNode.getBuildFileName());
            }
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IFile buildFile = this.getSelectionBuildFile();
        if (buildFile != null && buildFile.exists()) {
            StructuredSelection selection = new StructuredSelection((Object)buildFile);
            return new ShowInContext(null, (ISelection)selection);
        }
        return null;
    }

    public boolean isFilterInternalTargets() {
        if (this.projectContentProvider != null) {
            return this.projectContentProvider.isFilterInternalTargets();
        }
        return false;
    }

    public void setFilterInternalTargets(boolean filter) {
        if (this.projectContentProvider != null) {
            this.projectContentProvider.setFilterInternalTargets(filter);
            this.projectViewer.refresh();
        }
    }
}

