/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ColorEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor fBuildFileNames;
    private List fConsoleColorList;
    private ColorEditor fConsoleColorEditor;
    private BooleanFieldEditor toolsWarningEditor = null;
    private final String[][] fAppearanceColorListModel = new String[][]{{AntPreferencesMessages.getString("AntPreferencePage.&Error__2"), "org.eclipse.ant.ui.errorColor", null}, {AntPreferencesMessages.getString("AntPreferencePage.&Warning__3"), "org.eclipse.ant.ui.warningColor", null}, {AntPreferencesMessages.getString("AntPreferencePage.I&nformation__4"), "org.eclipse.ant.ui.informationColor", null}, {AntPreferencesMessages.getString("AntPreferencePage.Ve&rbose__5"), "org.eclipse.ant.ui.verboseColor", null}, {AntPreferencesMessages.getString("AntPreferencePage.Deb&ug__6"), "org.eclipse.ant.ui.debugColor", null}};

    public AntPreferencePage() {
        super(1);
        this.setDescription(AntPreferencesMessages.getString("AntPreferencePage.General"));
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.storeAppliedValues();
        Font font = this.getFieldEditorParent().getFont();
        Label label = new Label(this.getFieldEditorParent(), 0);
        label.setText(AntPreferencesMessages.getString("AntPreferencePage.Enter"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fBuildFileNames = new StringFieldEditor("ant.findBuildFileNames", AntPreferencesMessages.getString("AntPreferencePage.&Names__3"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fBuildFileNames);
        new Label(this.getFieldEditorParent(), 0);
        if (!AntUIPlugin.isMacOS()) {
            this.toolsWarningEditor = new BooleanFieldEditor("toolsJAR", AntPreferencesMessages.getString("AntPreferencePage.10"), this.getFieldEditorParent());
            this.addField((FieldEditor)this.toolsWarningEditor);
        }
        this.addField((FieldEditor)new BooleanFieldEditor("errorDialog", AntPreferencesMessages.getString("AntPreferencePage.12"), this.getFieldEditorParent()));
        new Label(this.getFieldEditorParent(), 0);
        this.createColorComposite();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void storeAppliedValues() {
        IPreferenceStore store = this.getPreferenceStore();
        for (int i = 0; i < this.fAppearanceColorListModel.length; ++i) {
            String preference = this.fAppearanceColorListModel[i][1];
            this.fAppearanceColorListModel[i][2] = store.getString(preference);
        }
    }

    private void createColorComposite() {
        Font font = this.getFieldEditorParent().getFont();
        Label label = new Label(this.getFieldEditorParent(), 16384);
        label.setText(AntPreferencesMessages.getString("AntPreferencePage.Ant_Color_Options__6"));
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setFont(font);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fConsoleColorList = new List(editorComposite, 2820);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fConsoleColorList.setLayoutData((Object)gd);
        this.fConsoleColorList.setFont(font);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        stylesComposite.setFont(font);
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntPreferencePage.Color__7"));
        label.setFont(font);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fConsoleColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fConsoleColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        foregroundColorButton.setFont(font);
        this.fConsoleColorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = AntPreferencePage.this.fConsoleColorList.getSelectionIndex();
                String key = AntPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntPreferencePage.this.getPreferenceStore(), (String)key, (RGB)AntPreferencePage.this.fConsoleColorEditor.getColorValue());
            }
        });
    }

    public boolean performCancel() {
        for (int i = 0; i < this.fAppearanceColorListModel.length; ++i) {
            String preference = this.fAppearanceColorListModel[i][1];
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)preference, (RGB)StringConverter.asRGB((String)this.fAppearanceColorListModel[i][2]));
        }
        return super.performCancel();
    }

    public boolean performOk() {
        this.storeAppliedValues();
        return super.performOk();
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fConsoleColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)key);
        this.fConsoleColorEditor.setColorValue(rgb);
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ant.ui.ant_preference_page_context");
        return super.createContents(parent);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        for (int i = 0; i < this.fAppearanceColorListModel.length; ++i) {
            this.fConsoleColorList.add(this.fAppearanceColorListModel[i][0]);
        }
        this.fConsoleColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntPreferencePage.this.fConsoleColorList != null && !AntPreferencePage.this.fConsoleColorList.isDisposed()) {
                    AntPreferencePage.this.fConsoleColorList.select(0);
                    AntPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    protected void performDefaults() {
        for (int i = 0; i < this.fAppearanceColorListModel.length; ++i) {
            String key = this.fAppearanceColorListModel[i][1];
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)key, (RGB)PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)key));
        }
        this.handleAppearanceColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("toolsJAR")) {
            if (this.toolsWarningEditor != null) {
                this.toolsWarningEditor.load();
            }
        } else {
            super.propertyChange(event);
        }
    }
}

