/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AntConsoleColorProvider
extends ConsoleColorProvider
implements IPropertyChangeListener {
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Widget;

    public Color getColor(String streamIdentifer) {
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM)) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.informationColor");
        }
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_ERROR_STREAM)) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.errorColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_DEBUG_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.debugColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_VERBOSE_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.verboseColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_WARNING_STREAM")) {
            return AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.warningColor");
        }
        return super.getColor(streamIdentifer);
    }

    public void connect(IProcess process, IConsole console) {
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (process instanceof AntProcess) {
            ((AntProcess)process).setConsole(console);
        }
        if (proxy != null) {
            console.connect(proxy.getDebugStreamMonitor(), "org.eclipse.ant.ui.ANT_DEBUG_STREAM");
            console.connect(proxy.getWarningStreamMonitor(), "org.eclipse.ant.ui.ANT_WARNING_STREAM");
            console.connect(proxy.getVerboseStreamMonitor(), "org.eclipse.ant.ui.ANT_VERBOSE_STREAM");
        }
        AntUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        super.connect(process, console);
    }

    public boolean isReadOnly() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.affectsAntConsole(event.getProperty())) {
            AntUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    Widget textWidget;
                    IViewPart part;
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.ui.console.ConsoleView")) != null && (textWidget = (Widget)part.getAdapter(class$org$eclipse$swt$widgets$Widget == null ? (class$org$eclipse$swt$widgets$Widget = AntConsoleColorProvider.class$("org.eclipse.swt.widgets.Widget")) : class$org$eclipse$swt$widgets$Widget)) instanceof StyledText) {
                        ((StyledText)textWidget).redraw();
                    }
                }
            });
        }
    }

    private boolean affectsAntConsole(String property) {
        if ("org.eclipse.ant.ui.debugColor".equals(property)) {
            return true;
        }
        if ("org.eclipse.ant.ui.errorColor".equals(property)) {
            return true;
        }
        if ("org.eclipse.ant.ui.informationColor".equals(property)) {
            return true;
        }
        if ("org.eclipse.ant.ui.verboseColor".equals(property)) {
            return true;
        }
        return "org.eclipse.ant.ui.warningColor".equals(property);
    }

    public void disconnect() {
        AntUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.disconnect();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

