/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class InstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private URL remoteSiteURL;
    private String featureId;
    private String version;

    public InstallCommand(String featureId, String version, String fromSite, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            this.featureId = featureId;
            this.version = version;
            this.remoteSiteURL = new URL(URLDecoder.decode(fromSite, "UTF-8"));
            IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();
            if (toSite != null) {
                URL toSiteURL;
                ISite site;
                File sitePath = new File(toSite);
                if (!sitePath.exists()) {
                    sitePath.mkdirs();
                }
                if ((site = SiteManager.getSite(toSiteURL = sitePath.toURL(), null)) == null) {
                    throw new Exception(Policy.bind("Standalone.noSite") + toSite);
                }
                this.targetSite = site.getCurrentConfiguredSite();
                if (this.targetSite == null) {
                    this.targetSite = this.getConfiguration().createConfiguredSite(sitePath);
                    IStatus status = this.targetSite.verifyUpdatableStatus();
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                    this.getConfiguration().addConfiguredSite(this.targetSite);
                    sites = this.getConfiguration().getConfiguredSites();
                }
            }
            if (this.targetSite == null) {
                for (int i = 0; i < sites.length; ++i) {
                    if (!sites[i].isProductSite()) continue;
                    this.targetSite = sites[i];
                    break;
                }
            }
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            VersionedIdentifier vid = new VersionedIdentifier(featureId, version);
            this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{vid}));
            this.searchRequest.addFilter(new EnvironmentFilter());
            this.searchRequest.addFilter(new BackLevelFilter());
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Policy.bind("Standalone.installing"), 4);
            this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IInstallFeatureOperation[] operations = this.collector.getOperations();
            if (operations == null || operations.length == 0) {
                throw Utilities.newCoreException(Policy.bind("Standalone.feature") + this.featureId + " " + this.version + Policy.bind("Standalone.notFound") + this.remoteSiteURL + Policy.bind("Standalone.newerInstalled"), null);
            }
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(operations, this.getConfiguration());
            if (conflicts != null) {
                throw Utilities.newCoreException(Policy.bind("Standalone.duplicate"), null);
            }
            if (this.isVerifyOnly()) {
                if (operations == null || operations.length == 0) {
                    boolean bl = false;
                    return bl;
                }
                IStatus status = OperationsManager.getValidator().validatePendingChanges(operations);
                if (status != null && status.getCode() == 4) {
                    throw new CoreException(status);
                }
                boolean bl = true;
                return bl;
            }
            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
            try {
                installOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 3), this);
                System.out.println(Policy.bind("Standalone.feature") + this.featureId + " " + this.version + Policy.bind("Standalone.installed"));
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                try {
                    throw Utilities.newCoreException(Policy.bind("Standalone.cannotInstall") + this.featureId + " " + this.version, e);
                }
                catch (CoreException ce) {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(ce);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            if (feature.getVersionedIdentifier().getIdentifier().equals(InstallCommand.this.featureId) && feature.getVersionedIdentifier().getVersion().toString().equals(InstallCommand.this.version)) {
                this.operations.add(OperationsManager.getOperationFactory().createInstallOperation(InstallCommand.this.targetSite, feature, null, null, null));
            }
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

