/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class StandardVMDebugger
extends StandardVMRunner {
    public StandardVMDebugger(IVMInstall vmInstance) {
        super(vmInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.getString("StandardVMDebugger.Launching_VM..._1"), 4);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Finding_free_socket..._2"));
        port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Could_not_find_a_free_socket_for_the_debugger_1"), null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Constructing_command_line..._3"));
        program = this.constructProgramString(config);
        arguments = new ArrayList<String>(12);
        arguments.add(program);
        allVMArgs = this.combineVmArgs(config, this.fVMInstance);
        this.addArguments(allVMArgs, arguments);
        this.addBootClassPathArguments(arguments, config);
        cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClassPath(cp));
        }
        arguments.add("-Xdebug");
        arguments.add("-Xnoagent");
        version = this.getJavaVersion();
        if (version < 1.4) {
            arguments.add("-Djava.compiler=NONE");
        }
        arguments.add("-Xrunjdwp:transport=dt_socket,suspend=y,address=localhost:" + port);
        arguments.add(config.getClassToLaunch());
        this.addArguments(config.getProgramArguments(), arguments);
        cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        envp = config.getEnvironment();
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Starting_virtual_machine..._4"));
        connector = this.getConnector();
        if (connector == null) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_find_an_appropriate_debug_connector_2"), null, 119);
        }
        map = connector.defaultArguments();
        this.specifyArguments(map, port);
        p = null;
        try {
            if (!monitor.isCanceled()) ** GOTO lbl-1000
            ** GOTO lbl60
            {
                catch (Throwable var24_29) {
                    block34: {
                        connector.stopListening(map);
                        throw var24_29;
lbl60:
                        // 1 sources

                        connector.stopListening(map);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            connector.startListening(map);
                            workingDir = this.getWorkingDir(config);
                            p = this.exec(cmdLine, workingDir, envp);
                            if (p != null) ** GOTO lbl-1000
                        }
                        connector.stopListening(map);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            if (!monitor.isCanceled()) break block34;
                            p.destroy();
                        }
                        connector.stopListening(map);
                        return;
                    }
                    process = this.newProcess(launch, p, StandardVMDebugger.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
                    process.setAttribute(IProcess.ATTR_CMDLINE, StandardVMDebugger.renderCommandLine(cmdLine));
                    subMonitor.worked(1);
                    subMonitor.subTask(LaunchingMessages.getString("StandardVMDebugger.Establishing_debug_connection..._5"));
                    retry = false;
                    while (true) {
                        try {
                            runnable = new ConnectRunnable(connector, map);
                            connectThread = new Thread((Runnable)runnable, "Listening Connector");
                            connectThread.start();
                            while (connectThread.isAlive()) {
                                if (monitor.isCanceled()) {
                                    connector.stopListening(map);
                                    p.destroy();
                                    connector.stopListening(map);
                                    return;
                                }
                                try {
                                    p.exitValue();
                                    try {
                                        connector.stopListening(map);
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    this.checkErrorMessage(process);
                                }
                                catch (IllegalThreadStateException e) {
                                    // empty catch block
                                }
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {}
                            }
                            ex = runnable.getException();
                            if (ex instanceof IllegalConnectorArgumentsException) {
                                throw (IllegalConnectorArgumentsException)ex;
                            }
                            if (ex instanceof InterruptedIOException) {
                                throw (InterruptedIOException)ex;
                            }
                            if (ex instanceof IOException) {
                                throw (IOException)ex;
                            }
                            vm = runnable.getVirtualMachine();
                            if (vm != null) {
                                JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)this.renderDebugTarget(config.getClassToLaunch(), port), (IProcess)process, (boolean)true, (boolean)false, (boolean)config.isResumeOnStartup());
                                subMonitor.worked(1);
                                subMonitor.done();
                            }
                            connector.stopListening(map);
                            return;
                        }
                        catch (InterruptedIOException e) {}
                        {
                            this.checkErrorMessage(process);
                            status = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 117, "", (Throwable)e);
                            handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                            retry = false;
                            if (handler == null) {
                                throw new CoreException((IStatus)status);
                            }
                            result = handler.handleStatus((IStatus)status, (Object)this);
                            if (!(result instanceof Boolean)) continue;
                            retry = (Boolean)result;
                            if (retry) continue;
                        }
                        break;
                    }
                    connector.stopListening(map);
                }
            }
        }
        catch (IOException e) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_connect_to_VM_4"), e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(LaunchingMessages.getString("StandardVMDebugger.Couldn__t_connect_to_VM_5"), e, 120);
        }
        if (p != null) {
            p.destroy();
        }
    }

    private double getJavaVersion() {
        LibraryInfo libInfo = LaunchingPlugin.getLibraryInfo(this.fVMInstance.getInstallLocation().getAbsolutePath());
        String version = libInfo.getVersion();
        int index = version.indexOf(".");
        int nextIndex = version.indexOf(".", index + 1);
        try {
            if (index > 0 && nextIndex > index) {
                return Double.parseDouble(version.substring(0, nextIndex));
            }
            return Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    protected void specifyArguments(Map map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected ListeningConnector getConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            ListeningConnector c = connectors.get(i);
            if (!"com.sun.jdi.SocketListen".equals(c.name())) continue;
            return c;
        }
        return null;
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

